/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="decommission", description="Decommission the *node I am connecting to*")
public class Decommission
extends NodeTool.NodeToolCmd {
    @Option(title="force", name={"-f", "--force"}, description="Force decommission of this node even when it reduces the number of replicas to below configured RF")
    private boolean force = false;

    @Override
    public void execute(NodeProbe probe) {
        try {
            probe.decommission(this.force);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error decommissioning node", e);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("Unsupported operation: " + e.getMessage(), e);
        }
    }
}

