/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DataRateSpec;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderOptions {
    private static final Logger logger = LoggerFactory.getLogger(LoaderOptions.class);
    public static final String HELP_OPTION = "help";
    public static final String VERBOSE_OPTION = "verbose";
    public static final String NOPROGRESS_OPTION = "no-progress";
    public static final String NATIVE_PORT_OPTION = "port";
    public static final String STORAGE_PORT_OPTION = "storage-port";
    @Deprecated
    public static final String SSL_STORAGE_PORT_OPTION = "ssl-storage-port";
    public static final String USER_OPTION = "username";
    public static final String PASSWD_OPTION = "password";
    public static final String AUTH_PROVIDER_OPTION = "auth-provider";
    public static final String INITIAL_HOST_ADDRESS_OPTION = "nodes";
    public static final String IGNORE_NODES_OPTION = "ignore";
    public static final String CONNECTIONS_PER_HOST = "connections-per-host";
    public static final String CONFIG_PATH = "conf-path";
    @Deprecated
    public static final String THROTTLE_MBITS = "throttle";
    public static final String THROTTLE_MEBIBYTES = "throttle-mib";
    @Deprecated
    public static final String INTER_DC_THROTTLE_MBITS = "inter-dc-throttle";
    public static final String INTER_DC_THROTTLE_MEBIBYTES = "inter-dc-throttle-mib";
    public static final String ENTIRE_SSTABLE_THROTTLE_MEBIBYTES = "entire-sstable-throttle-mib";
    public static final String ENTIRE_SSTABLE_INTER_DC_THROTTLE_MEBIBYTES = "entire-sstable-inter-dc-throttle-mib";
    public static final String TOOL_NAME = "sstableloader";
    public static final String TARGET_KEYSPACE = "target-keyspace";
    public static final String SSL_TRUSTSTORE = "truststore";
    public static final String SSL_TRUSTSTORE_PW = "truststore-password";
    public static final String SSL_KEYSTORE = "keystore";
    public static final String SSL_KEYSTORE_PW = "keystore-password";
    public static final String SSL_PROTOCOL = "ssl-protocol";
    public static final String SSL_ALGORITHM = "ssl-alg";
    public static final String SSL_STORE_TYPE = "store-type";
    public static final String SSL_CIPHER_SUITES = "ssl-ciphers";
    public final File directory;
    public final boolean debug;
    public final boolean verbose;
    public final boolean noProgress;
    public final int nativePort;
    public final String user;
    public final String passwd;
    public final AuthProvider authProvider;
    public final long throttleBytes;
    public final long interDcThrottleBytes;
    public final int entireSSTableThrottleMebibytes;
    public final int entireSSTableInterDcThrottleMebibytes;
    public final int storagePort;
    public final int sslStoragePort;
    public final EncryptionOptions clientEncOptions;
    public final int connectionsPerHost;
    public final EncryptionOptions.ServerEncryptionOptions serverEncOptions;
    public final Set<InetSocketAddress> hosts;
    public final Set<InetAddressAndPort> ignores;
    public final String targetKeyspace;

    LoaderOptions(Builder builder) {
        this.directory = builder.directory;
        this.debug = builder.debug;
        this.verbose = builder.verbose;
        this.noProgress = builder.noProgress;
        this.nativePort = builder.nativePort;
        this.user = builder.user;
        this.passwd = builder.passwd;
        this.authProvider = builder.authProvider;
        this.throttleBytes = builder.throttleBytes;
        this.interDcThrottleBytes = builder.interDcThrottleBytes;
        this.entireSSTableThrottleMebibytes = builder.entireSSTableThrottleMebibytes;
        this.entireSSTableInterDcThrottleMebibytes = builder.entireSSTableInterDcThrottleMebibytes;
        this.storagePort = builder.storagePort;
        this.sslStoragePort = builder.sslStoragePort;
        this.clientEncOptions = builder.clientEncOptions;
        this.connectionsPerHost = builder.connectionsPerHost;
        this.serverEncOptions = builder.serverEncOptions;
        this.hosts = builder.hosts;
        this.ignores = builder.ignores;
        this.targetKeyspace = builder.targetKeyspace;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
        System.err.println(msg);
        LoaderOptions.printUsage(options);
        System.exit(1);
    }

    private static BulkLoader.CmdLineOptions getCmdLineOptions() {
        BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
        options.addOption("v", VERBOSE_OPTION, "verbose output");
        options.addOption("h", HELP_OPTION, "display this help message");
        options.addOption(null, NOPROGRESS_OPTION, "don't display progress");
        options.addOption("i", IGNORE_NODES_OPTION, "NODES", "don't stream to this (comma separated) list of nodes");
        options.addOption("d", INITIAL_HOST_ADDRESS_OPTION, "initial hosts", "Required. try to connect to these hosts (comma separated) initially for ring information");
        options.addOption("p", NATIVE_PORT_OPTION, "native transport port", "port used for native connection (default 9042)");
        options.addOption("sp", STORAGE_PORT_OPTION, "storage port", "port used for internode communication (default 7000)");
        options.addOption("ssp", SSL_STORAGE_PORT_OPTION, "ssl storage port", "port used for TLS internode communication (default 7001), this option is deprecated, all communication goes through storage port which handles encrypted communication as well");
        options.addOption("t", THROTTLE_MBITS, THROTTLE_MBITS, "throttle speed in Mbps (default 0 for unlimited), this option is deprecated, use \"throttle-mib\" instead");
        options.addOption(null, THROTTLE_MEBIBYTES, THROTTLE_MEBIBYTES, "throttle speed in MiB/s (default 0 for unlimited)");
        options.addOption("idct", INTER_DC_THROTTLE_MBITS, INTER_DC_THROTTLE_MBITS, "inter-datacenter throttle speed in Mbps (default 0 for unlimited), this option is deprecated, use \"inter-dc-throttle-mib\" instead");
        options.addOption(null, INTER_DC_THROTTLE_MEBIBYTES, INTER_DC_THROTTLE_MEBIBYTES, "inter-datacenter throttle speed in MiB/s (default 0 for unlimited)");
        options.addOption(null, ENTIRE_SSTABLE_THROTTLE_MEBIBYTES, ENTIRE_SSTABLE_THROTTLE_MEBIBYTES, "entire SSTable throttle speed in MiB/s (default 0 for unlimited)");
        options.addOption(null, ENTIRE_SSTABLE_INTER_DC_THROTTLE_MEBIBYTES, ENTIRE_SSTABLE_INTER_DC_THROTTLE_MEBIBYTES, "entire SSTable inter-datacenter throttle speed in MiB/s (default 0 for unlimited)");
        options.addOption("u", USER_OPTION, USER_OPTION, "username for cassandra authentication");
        options.addOption("pw", PASSWD_OPTION, PASSWD_OPTION, "password for cassandra authentication");
        options.addOption("ap", AUTH_PROVIDER_OPTION, "auth provider", "custom AuthProvider class name for cassandra authentication");
        options.addOption("cph", CONNECTIONS_PER_HOST, "connectionsPerHost", "number of concurrent connections-per-host.");
        options.addOption("ts", SSL_TRUSTSTORE, "TRUSTSTORE", "Client SSL: full path to truststore");
        options.addOption("tspw", SSL_TRUSTSTORE_PW, "TRUSTSTORE-PASSWORD", "Client SSL: password of the truststore");
        options.addOption("ks", SSL_KEYSTORE, "KEYSTORE", "Client SSL: full path to keystore");
        options.addOption("kspw", SSL_KEYSTORE_PW, "KEYSTORE-PASSWORD", "Client SSL: password of the keystore");
        options.addOption("prtcl", SSL_PROTOCOL, "PROTOCOL", "Client SSL: connections protocol to use (default: TLS)");
        options.addOption("alg", SSL_ALGORITHM, "ALGORITHM", "Client SSL: algorithm");
        options.addOption("st", SSL_STORE_TYPE, "STORE-TYPE", "Client SSL: type of store");
        options.addOption("ciphers", SSL_CIPHER_SUITES, "CIPHER-SUITES", "Client SSL: comma-separated list of encryption suites to use");
        options.addOption("f", CONFIG_PATH, "path to config file", "cassandra.yaml file path for streaming throughput and client/server SSL.");
        options.addOption("k", TARGET_KEYSPACE, "target keyspace name", "target keyspace name");
        return options;
    }

    public static void printUsage(Options options) {
        String usage = String.format("%s [options] <dir_path>", TOOL_NAME);
        String header = System.lineSeparator() + "Bulk load the sstables found in the directory <dir_path> to the configured cluster.The parent directories of <dir_path> are used as the target keyspace/table name. So for instance, to load an sstable named Standard1-g-1-Data.db into Keyspace1/Standard1, you will need to have the files Standard1-g-1-Data.db and Standard1-g-1-Index.db into a directory /path/to/Keyspace1/Standard1/.";
        String footer = System.lineSeparator() + "You can provide cassandra.yaml file with -f command line option to set up streaming throughput, client and server encryption options. Only stream_throughput_outbound, server_encryption_options and client_encryption_options are read from yaml. You can override options read from cassandra.yaml with corresponding command line options.";
        new HelpFormatter().printHelp(usage, header, options, footer);
    }

    static class Builder {
        File directory;
        boolean debug;
        boolean verbose;
        boolean noProgress;
        int nativePort = 9042;
        String user;
        String passwd;
        String authProviderName;
        AuthProvider authProvider;
        long throttleBytes = 0L;
        long interDcThrottleBytes = 0L;
        int entireSSTableThrottleMebibytes = 0;
        int entireSSTableInterDcThrottleMebibytes = 0;
        int storagePort;
        int sslStoragePort;
        EncryptionOptions clientEncOptions = new EncryptionOptions();
        int connectionsPerHost = 1;
        EncryptionOptions.ServerEncryptionOptions serverEncOptions = new EncryptionOptions.ServerEncryptionOptions();
        Set<InetAddress> hostsArg = new HashSet<InetAddress>();
        Set<InetAddress> ignoresArg = new HashSet<InetAddress>();
        Set<InetSocketAddress> hosts = new HashSet<InetSocketAddress>();
        Set<InetAddressAndPort> ignores = new HashSet<InetAddressAndPort>();
        String targetKeyspace;

        Builder() {
        }

        public LoaderOptions build() {
            this.constructAuthProvider();
            try {
                for (InetAddress host : this.hostsArg) {
                    this.hosts.add(new InetSocketAddress(host, this.nativePort));
                }
                for (InetAddress host : this.ignoresArg) {
                    this.ignores.add(InetAddressAndPort.getByNameOverrideDefaults(host.getHostAddress(), this.storagePort));
                }
            }
            catch (UnknownHostException e) {
                Throwables.propagate((Throwable)e);
            }
            return new LoaderOptions(this);
        }

        public Builder directory(File directory) {
            this.directory = directory;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder noProgress(boolean noProgress) {
            this.noProgress = noProgress;
            return this;
        }

        public Builder nativePort(int nativePort) {
            this.nativePort = nativePort;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder authProvider(AuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder throttleMebibytes(int throttleMebibytes) {
            this.throttleBytes = (long)DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND.toBytesPerSecond(throttleMebibytes);
            return this;
        }

        @Deprecated
        public Builder throttle(int throttleMegabits) {
            this.throttleBytes = (long)DataRateSpec.LongBytesPerSecondBound.megabitsPerSecondInBytesPerSecond(throttleMegabits).toBytesPerSecond();
            return this;
        }

        public Builder interDcThrottleMebibytes(int interDcThrottleMebibytes) {
            this.interDcThrottleBytes = (long)DataRateSpec.DataRateUnit.MEBIBYTES_PER_SECOND.toBytesPerSecond(interDcThrottleMebibytes);
            return this;
        }

        public Builder interDcThrottleMegabits(int interDcThrottleMegabits) {
            this.interDcThrottleBytes = (long)DataRateSpec.LongBytesPerSecondBound.megabitsPerSecondInBytesPerSecond(interDcThrottleMegabits).toBytesPerSecond();
            return this;
        }

        @Deprecated
        public Builder interDcThrottle(int interDcThrottle) {
            return this.interDcThrottleMegabits(interDcThrottle);
        }

        public Builder entireSSTableThrottleMebibytes(int entireSSTableThrottleMebibytes) {
            this.entireSSTableThrottleMebibytes = entireSSTableThrottleMebibytes;
            return this;
        }

        @Deprecated
        public Builder entireSSTableThrottle(int entireSSTableThrottle) {
            this.entireSSTableThrottleMebibytes = entireSSTableThrottle;
            return this;
        }

        public Builder entireSSTableInterDcThrottleMebibytes(int entireSSTableInterDcThrottleMebibytes) {
            this.entireSSTableInterDcThrottleMebibytes = entireSSTableInterDcThrottleMebibytes;
            return this;
        }

        @Deprecated
        public Builder entireSSTableInterDcThrottle(int entireSSTableInterDcThrottle) {
            this.entireSSTableInterDcThrottleMebibytes = entireSSTableInterDcThrottle;
            return this;
        }

        public Builder storagePort(int storagePort) {
            this.storagePort = storagePort;
            return this;
        }

        @Deprecated
        public Builder sslStoragePort(int sslStoragePort) {
            this.sslStoragePort = this.storagePort;
            return this;
        }

        public Builder encOptions(EncryptionOptions encOptions) {
            this.clientEncOptions = encOptions;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            this.connectionsPerHost = connectionsPerHost;
            return this;
        }

        public Builder serverEncOptions(EncryptionOptions.ServerEncryptionOptions serverEncOptions) {
            this.serverEncOptions = serverEncOptions;
            return this;
        }

        @Deprecated
        public Builder hosts(Set<InetAddress> hosts) {
            this.hostsArg.addAll(hosts);
            return this;
        }

        public Builder hostsAndNativePort(Set<InetSocketAddress> hosts) {
            this.hosts.addAll(hosts);
            return this;
        }

        public Builder host(InetAddress host) {
            this.hostsArg.add(host);
            return this;
        }

        public Builder hostAndNativePort(InetSocketAddress host) {
            this.hosts.add(host);
            return this;
        }

        public Builder ignore(Set<InetAddress> ignores) {
            this.ignoresArg.addAll(ignores);
            return this;
        }

        public Builder ignoresAndInternalPorts(Set<InetAddressAndPort> ignores) {
            this.ignores.addAll(ignores);
            return this;
        }

        public Builder ignore(InetAddress ignore) {
            this.ignoresArg.add(ignore);
            return this;
        }

        public Builder ignoreAndInternalPorts(InetAddressAndPort ignore) {
            this.ignores.add(ignore);
            return this;
        }

        public Builder parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = LoaderOptions.getCmdLineOptions();
            try {
                String[] nodes;
                Config config;
                String dirname;
                File dir;
                String[] args;
                CommandLine cmd = parser.parse((Options)options, cmdArgs, false);
                if (cmd.hasOption(LoaderOptions.HELP_OPTION)) {
                    LoaderOptions.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length == 0) {
                    System.err.println("Missing sstable directory argument");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (args.length > 1) {
                    System.err.println("Too many arguments");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (!(dir = new File(dirname = args[0])).exists()) {
                    LoaderOptions.errorMsg("Unknown directory: " + dirname, options);
                }
                if (!dir.isDirectory()) {
                    LoaderOptions.errorMsg(dirname + " is not a directory", options);
                }
                this.directory = dir;
                this.verbose = cmd.hasOption(LoaderOptions.VERBOSE_OPTION);
                this.noProgress = cmd.hasOption(LoaderOptions.NOPROGRESS_OPTION);
                if (cmd.hasOption(LoaderOptions.USER_OPTION)) {
                    this.user = cmd.getOptionValue(LoaderOptions.USER_OPTION);
                }
                if (cmd.hasOption(LoaderOptions.PASSWD_OPTION)) {
                    this.passwd = cmd.getOptionValue(LoaderOptions.PASSWD_OPTION);
                }
                if (cmd.hasOption(LoaderOptions.AUTH_PROVIDER_OPTION)) {
                    this.authProviderName = cmd.getOptionValue(LoaderOptions.AUTH_PROVIDER_OPTION);
                }
                if (cmd.hasOption(LoaderOptions.CONFIG_PATH)) {
                    File configFile = new File(cmd.getOptionValue(LoaderOptions.CONFIG_PATH));
                    if (!configFile.exists()) {
                        LoaderOptions.errorMsg("Config file not found", options);
                    }
                    config = new YamlConfigurationLoader().loadConfig(configFile.toPath().toUri().toURL());
                    if (config.stream_throughput_outbound.toMegabitsPerSecond() >= 2.147483647E9) {
                        throw new ConfigurationException("stream_throughput_outbound: " + config.stream_throughput_outbound.toString() + " is too large", false);
                    }
                    if (config.inter_dc_stream_throughput_outbound.toMegabitsPerSecond() >= 2.147483647E9) {
                        throw new ConfigurationException("inter_dc_stream_throughput_outbound: " + config.inter_dc_stream_throughput_outbound.toString() + " is too large", false);
                    }
                    if (config.entire_sstable_stream_throughput_outbound.toMebibytesPerSecond() >= 2.147483647E9) {
                        throw new ConfigurationException("entire_sstable_stream_throughput_outbound: " + config.entire_sstable_stream_throughput_outbound.toString() + " is too large", false);
                    }
                    if (config.entire_sstable_inter_dc_stream_throughput_outbound.toMebibytesPerSecond() >= 2.147483647E9) {
                        throw new ConfigurationException("entire_sstable_inter_dc_stream_throughput_outbound: " + config.entire_sstable_inter_dc_stream_throughput_outbound.toString() + " is too large", false);
                    }
                } else {
                    config = new Config();
                    config.stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(0L);
                    config.inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(0L);
                    config.entire_sstable_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(0L);
                    config.entire_sstable_inter_dc_stream_throughput_outbound = new DataRateSpec.LongBytesPerSecondBound(0L);
                }
                this.storagePort = cmd.hasOption(LoaderOptions.STORAGE_PORT_OPTION) ? Integer.parseInt(cmd.getOptionValue(LoaderOptions.STORAGE_PORT_OPTION)) : config.storage_port;
                if (cmd.hasOption(LoaderOptions.IGNORE_NODES_OPTION)) {
                    nodes = cmd.getOptionValue(LoaderOptions.IGNORE_NODES_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            this.ignores.add(InetAddressAndPort.getByNameOverrideDefaults(node.trim(), this.storagePort));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                }
                if (cmd.hasOption(LoaderOptions.CONNECTIONS_PER_HOST)) {
                    this.connectionsPerHost = Integer.parseInt(cmd.getOptionValue(LoaderOptions.CONNECTIONS_PER_HOST));
                }
                this.throttleBytes = config.stream_throughput_outbound.toBytesPerSecondAsInt();
                if (cmd.hasOption(LoaderOptions.SSL_STORAGE_PORT_OPTION)) {
                    logger.info("ssl storage port is deprecated and not used, all communication goes though storage port which is able to handle encrypted communication too.");
                }
                this.clientEncOptions = config.client_encryption_options.applyConfig();
                this.serverEncOptions = config.server_encryption_options;
                this.serverEncOptions.applyConfig();
                this.nativePort = cmd.hasOption(LoaderOptions.NATIVE_PORT_OPTION) ? Integer.parseInt(cmd.getOptionValue(LoaderOptions.NATIVE_PORT_OPTION)) : (config.native_transport_port_ssl != null && (config.client_encryption_options.getEnabled() != false || this.clientEncOptions.getEnabled() != false) ? config.native_transport_port_ssl : config.native_transport_port);
                if (cmd.hasOption(LoaderOptions.INITIAL_HOST_ADDRESS_OPTION)) {
                    nodes = cmd.getOptionValue(LoaderOptions.INITIAL_HOST_ADDRESS_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            HostAndPort hap = HostAndPort.fromString((String)node);
                            this.hosts.add(new InetSocketAddress(InetAddress.getByName(hap.getHost()), hap.getPortOrDefault(this.nativePort)));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg("Unknown host: " + e.getMessage(), options);
                    }
                } else {
                    System.err.println("Initial hosts must be specified (-d)");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (cmd.hasOption(LoaderOptions.THROTTLE_MBITS) && cmd.hasOption(LoaderOptions.THROTTLE_MEBIBYTES)) {
                    LoaderOptions.errorMsg(String.format("Both '%s' and '%s' were provided. Please only provide one of the two options", LoaderOptions.THROTTLE_MBITS, LoaderOptions.THROTTLE_MEBIBYTES), options);
                }
                if (cmd.hasOption(LoaderOptions.INTER_DC_THROTTLE_MBITS) && cmd.hasOption(LoaderOptions.INTER_DC_THROTTLE_MEBIBYTES)) {
                    LoaderOptions.errorMsg(String.format("Both '%s' and '%s' were provided. Please only provide one of the two options", LoaderOptions.INTER_DC_THROTTLE_MBITS, LoaderOptions.INTER_DC_THROTTLE_MEBIBYTES), options);
                }
                if (cmd.hasOption(LoaderOptions.THROTTLE_MBITS)) {
                    this.throttle(Integer.parseInt(cmd.getOptionValue(LoaderOptions.THROTTLE_MBITS)));
                }
                if (cmd.hasOption(LoaderOptions.THROTTLE_MEBIBYTES)) {
                    this.throttleMebibytes(Integer.parseInt(cmd.getOptionValue(LoaderOptions.THROTTLE_MEBIBYTES)));
                }
                if (cmd.hasOption(LoaderOptions.INTER_DC_THROTTLE_MBITS)) {
                    this.interDcThrottleMegabits(Integer.parseInt(cmd.getOptionValue(LoaderOptions.INTER_DC_THROTTLE_MBITS)));
                }
                if (cmd.hasOption(LoaderOptions.INTER_DC_THROTTLE_MEBIBYTES)) {
                    this.interDcThrottleMebibytes(Integer.parseInt(cmd.getOptionValue(LoaderOptions.INTER_DC_THROTTLE_MEBIBYTES)));
                }
                if (cmd.hasOption(LoaderOptions.ENTIRE_SSTABLE_THROTTLE_MEBIBYTES)) {
                    this.entireSSTableThrottleMebibytes(Integer.parseInt(cmd.getOptionValue(LoaderOptions.ENTIRE_SSTABLE_THROTTLE_MEBIBYTES)));
                }
                if (cmd.hasOption(LoaderOptions.ENTIRE_SSTABLE_INTER_DC_THROTTLE_MEBIBYTES)) {
                    this.entireSSTableInterDcThrottleMebibytes(Integer.parseInt(cmd.getOptionValue(LoaderOptions.ENTIRE_SSTABLE_INTER_DC_THROTTLE_MEBIBYTES)));
                }
                if (cmd.hasOption(LoaderOptions.SSL_TRUSTSTORE) || cmd.hasOption(LoaderOptions.SSL_TRUSTSTORE_PW) || cmd.hasOption(LoaderOptions.SSL_KEYSTORE) || cmd.hasOption(LoaderOptions.SSL_KEYSTORE_PW)) {
                    this.clientEncOptions = this.clientEncOptions.withEnabled(true);
                }
                if (cmd.hasOption(LoaderOptions.SSL_TRUSTSTORE)) {
                    this.clientEncOptions = this.clientEncOptions.withTrustStore(cmd.getOptionValue(LoaderOptions.SSL_TRUSTSTORE));
                }
                if (cmd.hasOption(LoaderOptions.SSL_TRUSTSTORE_PW)) {
                    this.clientEncOptions = this.clientEncOptions.withTrustStorePassword(cmd.getOptionValue(LoaderOptions.SSL_TRUSTSTORE_PW));
                }
                if (cmd.hasOption(LoaderOptions.SSL_KEYSTORE)) {
                    this.clientEncOptions = this.clientEncOptions.withKeyStore(cmd.getOptionValue(LoaderOptions.SSL_KEYSTORE)).withRequireClientAuth(true);
                }
                if (cmd.hasOption(LoaderOptions.SSL_KEYSTORE_PW)) {
                    this.clientEncOptions = this.clientEncOptions.withKeyStorePassword(cmd.getOptionValue(LoaderOptions.SSL_KEYSTORE_PW));
                }
                if (cmd.hasOption(LoaderOptions.SSL_PROTOCOL)) {
                    this.clientEncOptions = this.clientEncOptions.withProtocol(cmd.getOptionValue(LoaderOptions.SSL_PROTOCOL));
                }
                if (cmd.hasOption(LoaderOptions.SSL_ALGORITHM)) {
                    this.clientEncOptions = this.clientEncOptions.withAlgorithm(cmd.getOptionValue(LoaderOptions.SSL_ALGORITHM));
                }
                if (cmd.hasOption(LoaderOptions.SSL_STORE_TYPE)) {
                    this.clientEncOptions = this.clientEncOptions.withStoreType(cmd.getOptionValue(LoaderOptions.SSL_STORE_TYPE));
                }
                if (cmd.hasOption(LoaderOptions.SSL_CIPHER_SUITES)) {
                    this.clientEncOptions = this.clientEncOptions.withCipherSuites(cmd.getOptionValue(LoaderOptions.SSL_CIPHER_SUITES).split(","));
                }
                if (cmd.hasOption(LoaderOptions.TARGET_KEYSPACE)) {
                    this.targetKeyspace = cmd.getOptionValue(LoaderOptions.TARGET_KEYSPACE);
                    if (StringUtils.isBlank((CharSequence)this.targetKeyspace)) {
                        LoaderOptions.errorMsg("Empty keyspace is not supported.", options);
                    }
                }
                return this;
            }
            catch (MalformedURLException | ConfigurationException | ParseException e) {
                LoaderOptions.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private void constructAuthProvider() {
            if (this.user != null != (this.passwd != null)) {
                LoaderOptions.errorMsg("Username and password must both be provided", LoaderOptions.getCmdLineOptions());
            }
            if (this.user != null) {
                if (this.authProviderName != null) {
                    try {
                        Class<?> authProviderClass = Class.forName(this.authProviderName);
                        Constructor<?> constructor = authProviderClass.getConstructor(String.class, String.class);
                        this.authProvider = (AuthProvider)constructor.newInstance(this.user, this.passwd);
                    }
                    catch (ClassNotFoundException e) {
                        LoaderOptions.errorMsg("Unknown auth provider: " + e.getMessage(), LoaderOptions.getCmdLineOptions());
                    }
                    catch (NoSuchMethodException e) {
                        LoaderOptions.errorMsg("Auth provider does not support plain text credentials: " + e.getMessage(), LoaderOptions.getCmdLineOptions());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        LoaderOptions.errorMsg("Could not create auth provider with plain text credentials: " + e.getMessage(), LoaderOptions.getCmdLineOptions());
                    }
                } else {
                    this.authProvider = new PlainTextAuthProvider(this.user, this.passwd);
                }
            } else if (this.authProviderName != null) {
                try {
                    this.authProvider = (AuthProvider)Class.forName(this.authProviderName).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LoaderOptions.errorMsg("Unknown auth provider: " + e.getMessage(), LoaderOptions.getCmdLineOptions());
                }
            }
        }
    }
}

