/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.async;

import com.mongodb.internal.connection.tlschannel.NeedsReadException;
import com.mongodb.internal.connection.tlschannel.NeedsTaskException;
import com.mongodb.internal.connection.tlschannel.NeedsWriteException;
import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import com.mongodb.internal.connection.tlschannel.util.Util;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritePendingException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public class AsynchronousTlsChannelGroup {
    private static final Logger LOGGER = Loggers.getLogger("connection.tls");
    private static final int queueLengthMultiplier = 32;
    private static final AtomicInteger globalGroupCount = new AtomicInteger();
    private final int id = globalGroupCount.getAndIncrement();
    private final AtomicBoolean loggedTaskWarning = new AtomicBoolean();
    private final Selector selector;
    private final ExecutorService executor;
    private final ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1, runnable -> new Thread(runnable, String.format("async-channel-group-%d-timeout-thread", this.id)));
    private final Thread selectorThread = new Thread(this::loop, String.format("async-channel-group-%d-selector", this.id));
    private final ConcurrentLinkedQueue<RegisteredSocket> pendingRegistrations = new ConcurrentLinkedQueue();
    private volatile Shutdown shutdown = Shutdown.No;
    private final LongAdder selectionCount = new LongAdder();
    private final LongAdder startedReads = new LongAdder();
    private final LongAdder startedWrites = new LongAdder();
    private final LongAdder successfulReads = new LongAdder();
    private final LongAdder successfulWrites = new LongAdder();
    private final LongAdder failedReads = new LongAdder();
    private final LongAdder failedWrites = new LongAdder();
    private final LongAdder cancelledReads = new LongAdder();
    private final LongAdder cancelledWrites = new LongAdder();
    private final ConcurrentHashMap<RegisteredSocket, Boolean> registrations = new ConcurrentHashMap();
    private final LongAdder currentReads = new LongAdder();
    private final LongAdder currentWrites = new LongAdder();

    public AsynchronousTlsChannelGroup(@Nullable ExecutorService executorService) {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.timeoutExecutor.setRemoveOnCancelPolicy(true);
        if (executorService != null) {
            this.executor = executorService;
        } else {
            int nThreads = Runtime.getRuntime().availableProcessors();
            this.executor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nThreads * 32), runnable -> new Thread(runnable, String.format("async-channel-group-%d-handler-executor", this.id)), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        this.selectorThread.start();
    }

    void submit(Runnable r) {
        this.executor.submit(r);
    }

    RegisteredSocket registerSocket(TlsChannel reader, SocketChannel socketChannel) {
        if (this.shutdown != Shutdown.No) {
            throw new ShutdownChannelGroupException();
        }
        RegisteredSocket socket = new RegisteredSocket(reader, socketChannel);
        this.pendingRegistrations.add(socket);
        this.selector.wakeup();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancelRead(RegisteredSocket socket, ReadOperation op) {
        socket.readLock.lock();
        try {
            if (op != socket.readOperation) {
                boolean bl = false;
                return bl;
            }
            socket.readOperation = null;
            this.cancelledReads.increment();
            this.currentReads.decrement();
            boolean bl = true;
            return bl;
        }
        finally {
            socket.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doCancelWrite(RegisteredSocket socket, WriteOperation op) {
        socket.writeLock.lock();
        try {
            if (op != socket.writeOperation) {
                boolean bl = false;
                return bl;
            }
            socket.writeOperation = null;
            this.cancelledWrites.increment();
            this.currentWrites.decrement();
            boolean bl = true;
            return bl;
        }
        finally {
            socket.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReadOperation startRead(RegisteredSocket socket, ByteBufferSet buffer, long timeout, TimeUnit unit, LongConsumer onSuccess, Consumer<Throwable> onFailure) throws ReadPendingException {
        this.checkTerminated();
        Util.assertTrue(buffer.hasRemaining());
        this.waitForSocketRegistration(socket);
        socket.readLock.lock();
        try {
            if (socket.readOperation != null) {
                throw new ReadPendingException();
            }
            ReadOperation op = new ReadOperation(buffer, onSuccess, onFailure);
            this.startedReads.increment();
            this.currentReads.increment();
            if (!this.registrations.containsKey(socket)) {
                op.onFailure.accept(new ClosedChannelException());
                this.failedReads.increment();
                this.currentReads.decrement();
                ReadOperation readOperation = op;
                return readOperation;
            }
            socket.pendingOps.set(5);
            if (timeout != 0L) {
                op.timeoutFuture = this.timeoutExecutor.schedule(() -> {
                    boolean success = this.doCancelRead(socket, op);
                    if (success) {
                        op.onFailure.accept(new InterruptedByTimeoutException());
                    }
                }, timeout, unit);
            }
            socket.readOperation = op;
        }
        finally {
            socket.readLock.unlock();
        }
        this.selector.wakeup();
        return socket.readOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteOperation startWrite(RegisteredSocket socket, ByteBufferSet buffer, long timeout, TimeUnit unit, LongConsumer onSuccess, Consumer<Throwable> onFailure) throws WritePendingException {
        this.checkTerminated();
        Util.assertTrue(buffer.hasRemaining());
        this.waitForSocketRegistration(socket);
        socket.writeLock.lock();
        try {
            if (socket.writeOperation != null) {
                throw new WritePendingException();
            }
            WriteOperation op = new WriteOperation(buffer, onSuccess, onFailure);
            this.startedWrites.increment();
            this.currentWrites.increment();
            if (!this.registrations.containsKey(socket)) {
                op.onFailure.accept(new ClosedChannelException());
                this.failedWrites.increment();
                this.currentWrites.decrement();
                WriteOperation writeOperation = op;
                return writeOperation;
            }
            socket.pendingOps.set(5);
            if (timeout != 0L) {
                op.timeoutFuture = this.timeoutExecutor.schedule(() -> {
                    boolean success = this.doCancelWrite(socket, op);
                    if (success) {
                        op.onFailure.accept(new InterruptedByTimeoutException());
                    }
                }, timeout, unit);
            }
            socket.writeOperation = op;
        }
        finally {
            socket.writeLock.unlock();
        }
        this.selector.wakeup();
        return socket.writeOperation;
    }

    private void checkTerminated() {
        if (this.isTerminated()) {
            throw new ShutdownChannelGroupException();
        }
    }

    private void waitForSocketRegistration(RegisteredSocket socket) {
        try {
            socket.registered.await();
        }
        catch (InterruptedException e) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        try {
            while (this.shutdown == Shutdown.No || this.shutdown == Shutdown.Wait && (!this.pendingRegistrations.isEmpty() || !this.registrations.isEmpty())) {
                int c = this.selector.select(100L);
                this.selectionCount.increment();
                if (c > 0) {
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        it.remove();
                        try {
                            key.interestOps(0);
                        }
                        catch (CancelledKeyException e) {
                            continue;
                        }
                        RegisteredSocket socket = (RegisteredSocket)key.attachment();
                        this.processRead(socket);
                        this.processWrite(socket);
                    }
                }
                this.registerPendingSockets();
                this.processPendingInterests();
                this.checkClosings();
            }
        }
        catch (Throwable e) {
            LOGGER.error("error in selector loop", e);
        }
        finally {
            this.executor.shutdown();
            this.timeoutExecutor.shutdownNow();
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOGGER.warn("error closing selector: " + e.getMessage());
            }
            this.checkClosings();
        }
    }

    private void processPendingInterests() {
        for (SelectionKey key : this.selector.keys()) {
            RegisteredSocket socket = (RegisteredSocket)key.attachment();
            int pending = socket.pendingOps.getAndSet(0);
            if (pending == 0) continue;
            try {
                key.interestOps(key.interestOps() | pending);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void processWrite(RegisteredSocket socket) {
        socket.writeLock.lock();
        try {
            WriteOperation op = socket.writeOperation;
            if (op != null) {
                this.executor.execute(() -> {
                    try {
                        this.doWrite(socket, op);
                    }
                    catch (Throwable e) {
                        LOGGER.error("error in operation", e);
                    }
                });
            }
        }
        finally {
            socket.writeLock.unlock();
        }
    }

    private void processRead(RegisteredSocket socket) {
        socket.readLock.lock();
        try {
            ReadOperation op = socket.readOperation;
            if (op != null) {
                this.executor.execute(() -> {
                    try {
                        this.doRead(socket, op);
                    }
                    catch (Throwable e) {
                        LOGGER.error("error in operation", e);
                    }
                });
            }
        }
        finally {
            socket.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(RegisteredSocket socket, WriteOperation op) {
        socket.writeLock.lock();
        try {
            if (socket.writeOperation != op) {
                return;
            }
            try {
                long c;
                long before = op.bufferSet.remaining();
                try {
                    this.writeHandlingTasks(socket, op);
                    c = before - op.bufferSet.remaining();
                    Util.assertTrue(c >= 0L);
                }
                catch (Throwable throwable) {
                    long c2 = before - op.bufferSet.remaining();
                    Util.assertTrue(c2 >= 0L);
                    op.consumesBytes += c2;
                    throw throwable;
                }
                op.consumesBytes += c;
                socket.writeOperation = null;
                if (op.timeoutFuture != null) {
                    op.timeoutFuture.cancel(false);
                }
                op.onSuccess.accept(op.consumesBytes);
                this.successfulWrites.increment();
                this.currentWrites.decrement();
            }
            catch (NeedsReadException e) {
                socket.pendingOps.accumulateAndGet(1, (a, b) -> a | b);
                this.selector.wakeup();
            }
            catch (NeedsWriteException e) {
                socket.pendingOps.accumulateAndGet(4, (a, b) -> a | b);
                this.selector.wakeup();
            }
            catch (IOException e) {
                if (socket.writeOperation == op) {
                    socket.writeOperation = null;
                }
                if (op.timeoutFuture != null) {
                    op.timeoutFuture.cancel(false);
                }
                op.onFailure.accept(e);
                this.failedWrites.increment();
                this.currentWrites.decrement();
            }
        }
        finally {
            socket.writeLock.unlock();
        }
    }

    private void writeHandlingTasks(RegisteredSocket socket, WriteOperation op) throws IOException {
        while (true) {
            try {
                socket.tlsChannel.write(op.bufferSet.array, op.bufferSet.offset, op.bufferSet.length);
                return;
            }
            catch (NeedsTaskException e) {
                this.warnAboutNeedTask();
                e.getTask().run();
                continue;
            }
            break;
        }
    }

    private void warnAboutNeedTask() {
        if (!this.loggedTaskWarning.getAndSet(true)) {
            LOGGER.warn(String.format("caught %s; channels used in asynchronous groups should run tasks themselves; although task is being dealt with anyway, consider configuring channels properly", NeedsTaskException.class.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(RegisteredSocket socket, ReadOperation op) {
        socket.readLock.lock();
        try {
            if (socket.readOperation != op) {
                return;
            }
            try {
                Util.assertTrue(op.bufferSet.hasRemaining());
                long c = this.readHandlingTasks(socket, op);
                Util.assertTrue(c > 0L || c == -1L);
                socket.readOperation = null;
                if (op.timeoutFuture != null) {
                    op.timeoutFuture.cancel(false);
                }
                op.onSuccess.accept(c);
                this.successfulReads.increment();
                this.currentReads.decrement();
            }
            catch (NeedsReadException e) {
                socket.pendingOps.accumulateAndGet(1, (a, b) -> a | b);
                this.selector.wakeup();
            }
            catch (NeedsWriteException e) {
                socket.pendingOps.accumulateAndGet(4, (a, b) -> a | b);
                this.selector.wakeup();
            }
            catch (IOException e) {
                if (socket.readOperation == op) {
                    socket.readOperation = null;
                }
                if (op.timeoutFuture != null) {
                    op.timeoutFuture.cancel(false);
                }
                op.onFailure.accept(e);
                this.failedReads.increment();
                this.currentReads.decrement();
            }
        }
        finally {
            socket.readLock.unlock();
        }
    }

    private long readHandlingTasks(RegisteredSocket socket, ReadOperation op) throws IOException {
        while (true) {
            try {
                return socket.tlsChannel.read(op.bufferSet.array, op.bufferSet.offset, op.bufferSet.length);
            }
            catch (NeedsTaskException e) {
                this.warnAboutNeedTask();
                e.getTask().run();
                continue;
            }
            break;
        }
    }

    private void registerPendingSockets() {
        RegisteredSocket socket;
        while ((socket = this.pendingRegistrations.poll()) != null) {
            try {
                socket.key = socket.socketChannel.register(this.selector, 0, socket);
                this.registrations.put(socket, true);
            }
            catch (ClosedChannelException closedChannelException) {}
            continue;
            finally {
                socket.registered.countDown();
            }
        }
    }

    private void checkClosings() {
        for (RegisteredSocket socket : this.registrations.keySet()) {
            if (socket.key.isValid() && this.shutdown != Shutdown.Immediate) continue;
            this.registrations.remove(socket);
            this.failCurrentRead(socket);
            this.failCurrentWrite(socket);
        }
    }

    private void failCurrentRead(RegisteredSocket socket) {
        socket.readLock.lock();
        try {
            if (socket.readOperation != null) {
                socket.readOperation.onFailure.accept(new ClosedChannelException());
                if (socket.readOperation.timeoutFuture != null) {
                    socket.readOperation.timeoutFuture.cancel(false);
                }
                socket.readOperation = null;
                this.failedReads.increment();
                this.currentReads.decrement();
            }
        }
        finally {
            socket.readLock.unlock();
        }
    }

    private void failCurrentWrite(RegisteredSocket socket) {
        socket.writeLock.lock();
        try {
            if (socket.writeOperation != null) {
                socket.writeOperation.onFailure.accept(new ClosedChannelException());
                if (socket.writeOperation.timeoutFuture != null) {
                    socket.writeOperation.timeoutFuture.cancel(false);
                }
                socket.writeOperation = null;
                this.failedWrites.increment();
                this.currentWrites.decrement();
            }
        }
        finally {
            socket.writeLock.unlock();
        }
    }

    public boolean isShutdown() {
        return this.shutdown != Shutdown.No;
    }

    public void shutdown() {
        this.shutdown = Shutdown.Wait;
        this.selector.wakeup();
    }

    public void shutdownNow() {
        this.shutdown = Shutdown.Immediate;
        this.selector.wakeup();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    long getSelectionCount() {
        return this.selectionCount.longValue();
    }

    public long getStartedReadCount() {
        return this.startedReads.longValue();
    }

    public long getStartedWriteCount() {
        return this.startedWrites.longValue();
    }

    public long getSuccessfulReadCount() {
        return this.successfulReads.longValue();
    }

    public long getSuccessfulWriteCount() {
        return this.successfulWrites.longValue();
    }

    public long getFailedReadCount() {
        return this.failedReads.longValue();
    }

    public long getFailedWriteCount() {
        return this.failedWrites.longValue();
    }

    public long getCancelledReadCount() {
        return this.cancelledReads.longValue();
    }

    public long getCancelledWriteCount() {
        return this.cancelledWrites.longValue();
    }

    public long getCurrentReadCount() {
        return this.currentReads.longValue();
    }

    public long getCurrentWriteCount() {
        return this.currentWrites.longValue();
    }

    public long getCurrentRegistrationCount() {
        return this.registrations.mappingCount();
    }

    public ScheduledThreadPoolExecutor getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    private static enum Shutdown {
        No,
        Wait,
        Immediate;

    }

    class RegisteredSocket {
        final TlsChannel tlsChannel;
        final SocketChannel socketChannel;
        final CountDownLatch registered = new CountDownLatch(1);
        SelectionKey key;
        final Lock readLock = new ReentrantLock();
        final Lock writeLock = new ReentrantLock();
        ReadOperation readOperation;
        WriteOperation writeOperation;
        final AtomicInteger pendingOps = new AtomicInteger();

        RegisteredSocket(TlsChannel tlsChannel, SocketChannel socketChannel) {
            this.tlsChannel = tlsChannel;
            this.socketChannel = socketChannel;
        }

        public void close() {
            if (this.key != null) {
                this.key.cancel();
            }
            AsynchronousTlsChannelGroup.this.selector.wakeup();
        }
    }

    static final class ReadOperation
    extends Operation {
        ReadOperation(ByteBufferSet bufferSet, LongConsumer onSuccess, Consumer<Throwable> onFailure) {
            super(bufferSet, onSuccess, onFailure);
        }
    }

    static final class WriteOperation
    extends Operation {
        long consumesBytes = 0L;

        WriteOperation(ByteBufferSet bufferSet, LongConsumer onSuccess, Consumer<Throwable> onFailure) {
            super(bufferSet, onSuccess, onFailure);
        }
    }

    private static abstract class Operation {
        final ByteBufferSet bufferSet;
        final LongConsumer onSuccess;
        final Consumer<Throwable> onFailure;
        Future<?> timeoutFuture;

        Operation(ByteBufferSet bufferSet, LongConsumer onSuccess, Consumer<Throwable> onFailure) {
            this.bufferSet = bufferSet;
            this.onSuccess = onSuccess;
            this.onFailure = onFailure;
        }
    }
}

