/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.List;
import java.util.Objects;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ModType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ValueCaptureType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class DataChangeRecord
implements ChangeStreamRecord {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1138762498767540898L;
    private @UnknownKeyFor @NonNull @Initialized String partitionToken;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp commitTimestamp;
    private @UnknownKeyFor @NonNull @Initialized String serverTransactionId;
    private @UnknownKeyFor @NonNull @Initialized boolean isLastRecordInTransactionInPartition;
    private @UnknownKeyFor @NonNull @Initialized String recordSequence;
    private @UnknownKeyFor @NonNull @Initialized String tableName;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ColumnType> rowType;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mod> mods;
    private @UnknownKeyFor @NonNull @Initialized ModType modType;
    private @UnknownKeyFor @NonNull @Initialized ValueCaptureType valueCaptureType;
    private @UnknownKeyFor @NonNull @Initialized long numberOfRecordsInTransaction;
    private @UnknownKeyFor @NonNull @Initialized long numberOfPartitionsInTransaction;
    private @UnknownKeyFor @NonNull @Initialized String transactionTag;
    private @UnknownKeyFor @NonNull @Initialized boolean isSystemTransaction;
    @Nullable
    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata;

    private DataChangeRecord() {
    }

    public DataChangeRecord(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp commitTimestamp, @UnknownKeyFor @NonNull @Initialized String serverTransactionId, @UnknownKeyFor @NonNull @Initialized boolean isLastRecordInTransactionInPartition, @UnknownKeyFor @NonNull @Initialized String recordSequence, @UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ColumnType> rowType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mod> mods, @UnknownKeyFor @NonNull @Initialized ModType modType, @UnknownKeyFor @NonNull @Initialized ValueCaptureType valueCaptureType, @UnknownKeyFor @NonNull @Initialized long numberOfRecordsInTransaction, @UnknownKeyFor @NonNull @Initialized long numberOfPartitionsInTransaction, @UnknownKeyFor @NonNull @Initialized String transactionTag, @UnknownKeyFor @NonNull @Initialized boolean isSystemTransaction, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata) {
        this.commitTimestamp = commitTimestamp;
        this.partitionToken = partitionToken;
        this.serverTransactionId = serverTransactionId;
        this.isLastRecordInTransactionInPartition = isLastRecordInTransactionInPartition;
        this.recordSequence = recordSequence;
        this.tableName = tableName;
        this.rowType = rowType;
        this.mods = mods;
        this.modType = modType;
        this.valueCaptureType = valueCaptureType;
        this.numberOfRecordsInTransaction = numberOfRecordsInTransaction;
        this.numberOfPartitionsInTransaction = numberOfPartitionsInTransaction;
        this.transactionTag = transactionTag;
        this.isSystemTransaction = isSystemTransaction;
        this.metadata = metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.commitTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPartitionToken() {
        return this.partitionToken;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getServerTransactionId() {
        return this.serverTransactionId;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isLastRecordInTransactionInPartition() {
        return this.isLastRecordInTransactionInPartition;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRecordSequence() {
        return this.recordSequence;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableName() {
        return this.tableName;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ColumnType> getRowType() {
        return this.rowType;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mod> getMods() {
        return this.mods;
    }

    public @UnknownKeyFor @NonNull @Initialized ModType getModType() {
        return this.modType;
    }

    public @UnknownKeyFor @NonNull @Initialized ValueCaptureType getValueCaptureType() {
        return this.valueCaptureType;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNumberOfRecordsInTransaction() {
        return this.numberOfRecordsInTransaction;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNumberOfPartitionsInTransaction() {
        return this.numberOfPartitionsInTransaction;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTransactionTag() {
        return this.transactionTag;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSystemTransaction() {
        return this.isSystemTransaction;
    }

    public @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata getMetadata() {
        return this.metadata;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@javax.annotation.Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeRecord)) {
            return false;
        }
        DataChangeRecord that = (DataChangeRecord)o;
        return this.isLastRecordInTransactionInPartition == that.isLastRecordInTransactionInPartition && this.numberOfRecordsInTransaction == that.numberOfRecordsInTransaction && this.numberOfPartitionsInTransaction == that.numberOfPartitionsInTransaction && Objects.equals(this.transactionTag, that.transactionTag) && this.isSystemTransaction == that.isSystemTransaction && Objects.equals(this.partitionToken, that.partitionToken) && Objects.equals(this.commitTimestamp, that.commitTimestamp) && Objects.equals(this.serverTransactionId, that.serverTransactionId) && Objects.equals(this.recordSequence, that.recordSequence) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.rowType, that.rowType) && Objects.equals(this.mods, that.mods) && this.modType == that.modType && this.valueCaptureType == that.valueCaptureType;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(new Object[]{this.partitionToken, this.commitTimestamp, this.serverTransactionId, this.isLastRecordInTransactionInPartition, this.recordSequence, this.tableName, this.rowType, this.mods, this.modType, this.valueCaptureType, this.numberOfRecordsInTransaction, this.numberOfPartitionsInTransaction, this.transactionTag, this.isSystemTransaction});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "DataChangeRecord{partitionToken='" + this.partitionToken + '\'' + ", commitTimestamp=" + this.commitTimestamp + ", serverTransactionId='" + this.serverTransactionId + '\'' + ", isLastRecordInTransactionInPartition=" + this.isLastRecordInTransactionInPartition + ", recordSequence='" + this.recordSequence + '\'' + ", tableName='" + this.tableName + '\'' + ", rowType=" + this.rowType + ", mods=" + this.mods + ", modType=" + (Object)((Object)this.modType) + ", valueCaptureType=" + (Object)((Object)this.valueCaptureType) + ", numberOfRecordsInTransaction=" + this.numberOfRecordsInTransaction + ", numberOfPartitionsInTransaction=" + this.numberOfPartitionsInTransaction + ", transactionTag='" + this.transactionTag + '\'' + ", isSystemTransaction=" + this.isSystemTransaction + ", metadata=" + this.metadata + '}';
    }
}

