/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.metrics.CounterCell;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class LateDataUtils {
    private LateDataUtils() {
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized Instant garbageCollectionTime(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy) {
        return LateDataUtils.garbageCollectionTime(window, windowingStrategy.getAllowedLateness());
    }

    @Pure
    public static @UnknownKeyFor @NonNull @Initialized Instant garbageCollectionTime(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
        if (GlobalWindow.INSTANCE.maxTimestamp().minus((ReadableDuration)allowedLateness).isBefore((ReadableInstant)window.maxTimestamp())) {
            return GlobalWindow.INSTANCE.maxTimestamp();
        }
        return window.maxTimestamp().plus((ReadableDuration)allowedLateness);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> dropExpiredWindows(K key, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>> elements, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized CounterCell droppedDueToLateness) {
        return FluentIterable.from(elements).transformAndConcat(input -> {
            if (input == null) {
                return null;
            }
            return input.explodeWindows();
        }).filter(input -> {
            if (input == null) {
                return false;
            }
            BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement(input.getWindows());
            boolean expired = window.maxTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)timerInternals.currentInputWatermarkTime());
            if (expired) {
                droppedDueToLateness.inc();
                WindowTracing.debug("GroupAlsoByWindow: Dropping element at {} for key: {}; window: {} since it is too far behind inputWatermark: {}", input.getTimestamp(), key, window, timerInternals.currentInputWatermarkTime());
            }
            return !expired;
        });
    }
}

