/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.shared.VariableValue;
import org.apache.hop.beam.core.transform.TransformBaseFn;
import org.apache.hop.beam.core.transform.TransformTransform;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.apache.hop.beam.engines.HopPipelineExecutionOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;

public class TransformBatchTransform
extends TransformTransform {
    public TransformBatchTransform() {
    }

    public TransformBatchTransform(List<VariableValue> variableValues, String metastoreJson, int batchSize, int flushIntervalMs, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons, List<PCollectionView<List<HopRow>>> infoCollectionViews, String runConfigName, String dataSamplersJson, String parentLogChannelId) {
        super(variableValues, metastoreJson, batchSize, flushIntervalMs, transformName, transformPluginId, transformMetaInterfaceXml, inputRowMetaJson, inputTransform, targetTransforms, infoTransforms, infoRowMetaJsons, infoCollectionViews, runConfigName, dataSamplersJson, parentLogChannelId);
    }

    @Override
    public PCollectionTuple expand(PCollection<HopRow> input) {
        try {
            BeamHop.init();
            TupleTag<HopRow> mainOutputTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
            ArrayList<2> targetTupleTags = new ArrayList<2>();
            TupleTagList targetTupleTagList = null;
            for (String targetTransform : this.targetTransforms) {
                String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
                TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
                targetTupleTags.add(tupleTag);
                if (targetTupleTagList == null) {
                    targetTupleTagList = TupleTagList.of((TupleTag)tupleTag);
                    continue;
                }
                targetTupleTagList = targetTupleTagList.and((TupleTag)tupleTag);
            }
            if (targetTupleTagList == null) {
                targetTupleTagList = TupleTagList.empty();
            }
            TransformBatchFn transformBatchFn = new TransformBatchFn(this.variableValues, this.metastoreJson, this.transformName, this.transformPluginId, this.transformMetaInterfaceXml, this.inputRowMetaJson, this.inputTransform, this.targetTransforms, this.infoTransforms, this.infoRowMetaJsons, this.parentLogChannelId, this.runConfigName, this.dataSamplersJson);
            ParDo.SingleOutput parDoTransformFn = ParDo.of((DoFn)transformBatchFn);
            if (!this.infoCollectionViews.isEmpty()) {
                parDoTransformFn = parDoTransformFn.withSideInputs((Iterable)this.infoCollectionViews);
            }
            ParDo.MultiOutput multiOutput = parDoTransformFn.withOutputTags((TupleTag)mainOutputTupleTag, targetTupleTagList);
            return (PCollectionTuple)input.apply((PTransform)multiOutput);
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error transforming data in transform '" + this.transformName + "'", (Throwable)e);
            throw new RuntimeException("Error transforming data in transform", e);
        }
    }

    private class TransformBatchFn
    extends TransformBaseFn {
        private static final long serialVersionUID = 95700000000000002L;
        public static final String INJECTOR_TRANSFORM_NAME = "_INJECTOR_";
        protected List<VariableValue> variableValues;
        protected String metastoreJson;
        protected String transformPluginId;
        protected String transformMetaInterfaceXml;
        protected String inputRowMetaJson;
        protected List<String> targetTransforms;
        protected List<String> infoTransforms;
        protected List<String> infoRowMetaJsons;
        protected boolean inputTransform;
        protected boolean initialize;
        protected List<PCollection<HopRow>> infoCollections;
        private final Counter numErrors;
        private transient PipelineMeta pipelineMeta;
        private transient TransformMeta transformMeta;
        private transient IRowMeta inputRowMeta;
        private transient IRowMeta outputRowMeta;
        private transient List<TransformMetaDataCombi> transformCombis;
        private transient LocalPipelineEngine pipeline;
        private transient RowProducer rowProducer;
        private transient IRowListener rowListener;
        private transient List<Object[]> resultRows;
        private transient List<List<Object[]>> targetResultRowsList;
        private transient List<IRowMeta> targetRowMetas;
        private transient List<IRowMeta> infoRowMetas;
        private transient List<RowProducer> infoRowProducers;
        private transient TupleTag<HopRow> mainTupleTag;
        private transient List<TupleTag<HopRow>> tupleTagList;
        private transient Counter initCounter;
        private transient Counter readCounter;
        private transient Counter writtenCounter;
        private transient Counter flushBufferCounter;
        private transient SingleThreadedPipelineExecutor executor;
        private transient Queue<HopRow> rowBuffer;
        private transient AtomicLong lastTimerCheck;
        private transient Timer timer;
        private transient ExecutionInfoLocation executionInfoLocation;
        private transient List<IExecutionDataSampler> dataSamplers;
        private transient List<IExecutionDataSamplerStore> dataSamplerStores;
        private transient Timer executionInfoTimer;
        private transient int maxInputBufferSize;
        private transient int minInputBufferSize;

        public TransformBatchFn() {
            super(null, null, null);
            this.numErrors = Metrics.counter((String)"main", (String)"TransformProcessErrors");
            this.maxInputBufferSize = 0;
            this.minInputBufferSize = Integer.MAX_VALUE;
        }

        public TransformBatchFn(List<VariableValue> variableValues, String metastoreJson, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons, String parentLogChannelId, String runConfigName, String dataSamplersJson) {
            super(parentLogChannelId, runConfigName, dataSamplersJson);
            this.numErrors = Metrics.counter((String)"main", (String)"TransformProcessErrors");
            this.maxInputBufferSize = 0;
            this.minInputBufferSize = Integer.MAX_VALUE;
            this.variableValues = variableValues;
            this.metastoreJson = metastoreJson;
            this.transformName = transformName;
            this.transformPluginId = transformPluginId;
            this.transformMetaInterfaceXml = transformMetaInterfaceXml;
            this.inputRowMetaJson = inputRowMetaJson;
            this.inputTransform = inputTransform;
            this.targetTransforms = targetTransforms;
            this.infoTransforms = infoTransforms;
            this.infoRowMetaJsons = infoRowMetaJsons;
            this.initialize = true;
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.StartBundleContext startBundleContext) {
            Metrics.counter((String)"startBundle", (String)this.transformName).inc();
            if ("ScriptValueMod".equals(this.transformPluginId) && this.pipeline != null) {
                this.initialize = true;
            }
        }

        @DoFn.Setup
        public void setup() {
            try {
                this.rowBuffer = new ConcurrentLinkedQueue<HopRow>();
            }
            catch (Exception e) {
                this.numErrors.inc();
                LOG.info("Transform '" + this.transformName + "' : setup error :" + e.getMessage());
                throw new RuntimeException("Unable to set up transform " + this.transformName, e);
            }
        }

        @DoFn.Teardown
        public void tearDown() {
            ExecutorUtil.cleanup((Timer)this.timer);
            try {
                if (this.executor != null) {
                    this.executor.dispose();
                    if (this.executionInfoLocation != null) {
                        ExecutorUtil.cleanup((Timer)this.executionInfoTimer);
                        this.sendSamplesToLocation(true);
                        this.executionInfoLocation.getExecutionInfoLocation().close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error cleaning up single threaded pipeline executor in Beam transform " + this.transformName, e);
            }
        }

        @Override
        protected void sendSamplesToLocation(boolean finished) throws HopException {
            ExecutionDataBuilder dataBuilder = ExecutionDataBuilder.of().withOwnerId(this.executor.getPipeline().getLogChannelId()).withParentId(this.parentLogChannelId).withCollectionDate(new Date()).withFinished(finished).withExecutionType(ExecutionType.Transform);
            for (IExecutionDataSamplerStore store : this.dataSamplerStores) {
                dataBuilder = dataBuilder.addDataSets(store.getSamples()).addSetMeta(store.getSamplesMetadata());
            }
            this.executionInfoLocation.getExecutionInfoLocation().registerData(dataBuilder.build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @DoFn.ProcessElement
        public void processElement(final DoFn.ProcessContext context, BoundedWindow window) {
            try {
                if (this.initialize) {
                    void var13_27;
                    RowProducer infoRowProducer;
                    this.initialize = false;
                    BeamHop.init();
                    SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(this.metastoreJson);
                    Variables variables = new Variables();
                    for (VariableValue variableValue : this.variableValues) {
                        if (!StringUtils.isNotEmpty((String)variableValue.getVariable())) continue;
                        variables.setVariable(variableValue.getVariable(), variableValue.getValue());
                    }
                    this.pipelineMeta = new PipelineMeta();
                    this.pipelineMeta.setName(this.transformName);
                    this.pipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
                    this.pipelineMeta.setMetadataProvider((IHopMetadataProvider)metadataProvider);
                    this.lastTimerCheck = new AtomicLong(-1L);
                    this.inputRowMeta = JsonRowMeta.fromJson((String)this.inputRowMetaJson);
                    this.infoRowMetas = new ArrayList<IRowMeta>();
                    for (String infoRowMetaJson : this.infoRowMetaJsons) {
                        IRowMeta infoRowMeta = JsonRowMeta.fromJson((String)infoRowMetaJson);
                        this.infoRowMetas.add(infoRowMeta);
                    }
                    TransformMeta mainInjectorTransformMeta = null;
                    if (!this.inputTransform) {
                        mainInjectorTransformMeta = this.createInjectorTransform(this.pipelineMeta, INJECTOR_TRANSFORM_NAME, this.inputRowMeta, 200, 200);
                    }
                    int targetLocationY = 200;
                    ArrayList<TransformMeta> targetTransformMetas = new ArrayList<TransformMeta>();
                    for (String targetTransform : this.targetTransforms) {
                        DummyMeta dummyMeta = new DummyMeta();
                        TransformMeta targetTransformMeta = new TransformMeta(targetTransform, (ITransformMeta)dummyMeta);
                        targetTransformMeta.setLocation(600, targetLocationY);
                        targetLocationY += 150;
                        targetTransformMetas.add(targetTransformMeta);
                        this.pipelineMeta.addTransform(targetTransformMeta);
                    }
                    ArrayList<List> infoDataSets = new ArrayList<List>();
                    ArrayList<TransformMeta> infoTransformMetas = new ArrayList<TransformMeta>();
                    for (int i = 0; i < this.infoTransforms.size(); ++i) {
                        String infoTransform = this.infoTransforms.get(i);
                        PCollectionView cv = (PCollectionView)TransformBatchTransform.this.infoCollectionViews.get(i);
                        List list = (List)context.sideInput(cv);
                        infoDataSets.add(list);
                        IRowMeta infoRowMeta = this.infoRowMetas.get(i);
                        TransformMeta infoTransformMeta = this.createInjectorTransform(this.pipelineMeta, infoTransform, infoRowMeta, 200, 350 + 150 * i);
                        infoTransformMetas.add(infoTransformMeta);
                    }
                    this.transformCombis = new ArrayList<TransformMetaDataCombi>();
                    PluginRegistry registry = PluginRegistry.getInstance();
                    ITransformMeta iTransformMeta = (ITransformMeta)registry.loadClass(TransformPluginType.class, this.transformPluginId, ITransformMeta.class);
                    if (iTransformMeta == null) {
                        throw new HopException("Unable to load transform plugin with ID " + this.transformPluginId + ", this plugin isn't in the plugin registry or classpath");
                    }
                    HopBeamUtil.loadTransformMetadataFromXml(this.transformName, iTransformMeta, this.transformMetaInterfaceXml, this.pipelineMeta.getMetadataProvider());
                    this.transformMeta = new TransformMeta(this.transformName, iTransformMeta);
                    this.transformMeta.setTransformPluginId(this.transformPluginId);
                    this.transformMeta.setLocation(400, 200);
                    this.pipelineMeta.addTransform(this.transformMeta);
                    if (!this.inputTransform) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(mainInjectorTransformMeta, this.transformMeta));
                    }
                    for (TransformMeta transformMeta : targetTransformMetas) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(this.transformMeta, transformMeta));
                    }
                    for (TransformMeta transformMeta : infoTransformMetas) {
                        this.pipelineMeta.addPipelineHop(new PipelineHopMeta(transformMeta, this.transformMeta));
                    }
                    this.lookupExecutionInformation((IVariables)variables, (IHopMetadataProvider)metadataProvider);
                    iTransformMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
                    this.pipeline = new LocalPipelineEngine(this.pipelineMeta, (IVariables)variables, (ILoggingObject)new LoggingObject((Object)"apache-beam-transform"));
                    this.pipeline.setLogLevel(((HopPipelineExecutionOptions)context.getPipelineOptions().as(HopPipelineExecutionOptions.class)).getLogLevel());
                    this.pipeline.setMetadataProvider(this.pipelineMeta.getMetadataProvider());
                    this.pipeline.getPipelineRunConfiguration().setName("beam-batch-transform-local (" + this.transformName + ")");
                    this.pipeline.prepareExecution();
                    this.rowProducer = null;
                    if (!this.inputTransform) {
                        this.rowProducer = this.pipeline.addRowProducer(INJECTOR_TRANSFORM_NAME, 0);
                    }
                    this.infoRowProducers = new ArrayList<RowProducer>();
                    for (String string : this.infoTransforms) {
                        infoRowProducer = this.pipeline.addRowProducer(string, 0);
                        this.infoRowProducers.add(infoRowProducer);
                    }
                    if (!this.inputTransform) {
                        TransformMetaDataCombi injectorCombi = this.findCombi((Pipeline)this.pipeline, INJECTOR_TRANSFORM_NAME);
                        this.transformCombis.add(injectorCombi);
                    }
                    TransformMetaDataCombi transformCombi = this.findCombi((Pipeline)this.pipeline, this.transformName);
                    this.transformCombis.add(transformCombi);
                    this.outputRowMeta = this.pipelineMeta.getTransformFields((IVariables)this.pipeline, this.transformName);
                    if (this.targetTransforms.isEmpty()) {
                        this.rowListener = new RowAdapter(){

                            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) {
                                TransformBatchFn.this.resultRows.add(row);
                            }
                        };
                        transformCombi.transform.addRowListener(this.rowListener);
                    }
                    this.mainTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
                    this.tupleTagList = new ArrayList<TupleTag<HopRow>>();
                    this.targetRowMetas = new ArrayList<IRowMeta>();
                    this.targetResultRowsList = new ArrayList<List<Object[]>>();
                    for (String targetTransform : this.targetTransforms) {
                        TransformMetaDataCombi targetCombi = this.findCombi((Pipeline)this.pipeline, targetTransform);
                        this.transformCombis.add(targetCombi);
                        this.targetRowMetas.add(this.pipelineMeta.getTransformFields((IVariables)this.pipeline, transformCombi.transformName));
                        String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
                        TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
                        this.tupleTagList.add(tupleTag);
                        final ArrayList targetResultRows = new ArrayList();
                        this.targetResultRowsList.add(targetResultRows);
                        targetCombi.transform.addRowListener((IRowListener)new RowAdapter(){

                            public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                                targetResultRows.add(row);
                            }
                        });
                    }
                    this.attachExecutionSamplersToOutput((IVariables)variables, this.transformName, this.pipeline.getLogChannelId(), this.inputRowMeta, this.outputRowMeta, this.pipeline.getTransform(this.transformName, 0));
                    this.executor = new SingleThreadedPipelineExecutor((Pipeline)this.pipeline);
                    this.executor.init();
                    this.initCounter = Metrics.counter((String)"init", (String)this.transformName);
                    this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
                    this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                    this.flushBufferCounter = Metrics.counter((String)"flush_buffer", (String)this.transformName);
                    this.initCounter.inc();
                    this.pipeline.setLogLevel(LogLevel.NOTHING);
                    this.pipeline.startThreads();
                    this.pipeline.setLogLevel(LogLevel.BASIC);
                    this.resultRows = new ArrayList<Object[]>();
                    boolean bl = false;
                    while (var13_27 < this.infoTransforms.size()) {
                        infoRowProducer = this.infoRowProducers.get((int)var13_27);
                        List infoDataSet = (List)infoDataSets.get((int)var13_27);
                        TransformMetaDataCombi combi = this.findCombi((Pipeline)this.pipeline, this.infoTransforms.get((int)var13_27));
                        IRowMeta infoRowMeta = this.infoRowMetas.get((int)var13_27);
                        for (HopRow infoRowData : infoDataSet) {
                            infoRowProducer.putRow(infoRowMeta, infoRowData.getRow());
                            combi.transform.processRow();
                        }
                        infoRowProducer.finished();
                        combi.transform.processRow();
                        ++var13_27;
                    }
                    if (TransformBatchTransform.this.flushIntervalMs > 0) {
                        TimerTask timerTask = new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Queue<HopRow> queue = TransformBatchFn.this.rowBuffer;
                                synchronized (queue) {
                                    long difference = System.currentTimeMillis() - TransformBatchFn.this.lastTimerCheck.get();
                                    if (TransformBatchFn.this.lastTimerCheck.get() <= 0L || difference > (long)TransformBatchTransform.this.flushIntervalMs) {
                                        try {
                                            TransformBatchFn.this.emptyRowBuffer(new TransformBaseFn.TransformProcessContext(context));
                                        }
                                        catch (Exception e) {
                                            throw new RuntimeException("Unable to flush row buffer when it got stale after " + difference + " ms", e);
                                        }
                                        TransformBatchFn.this.lastTimerCheck.set(System.currentTimeMillis());
                                    }
                                }
                            }
                        };
                        this.timer = new Timer("Flush timer of transform " + this.transformName);
                        this.timer.schedule(timerTask, 100L, 100L);
                    }
                }
                HopRow originalInputRow = (HopRow)context.element();
                HopRow inputRow = HopBeamUtil.copyHopRow(originalInputRow, this.inputRowMeta);
                this.readCounter.inc();
                if (TransformBatchTransform.this.flushIntervalMs > 0 && this.rowBuffer.isEmpty()) {
                    this.lastTimerCheck.set(System.currentTimeMillis());
                }
                Iterator<String> iterator = this.rowBuffer;
                synchronized (iterator) {
                    this.rowBuffer.add(inputRow);
                    this.batchWindow = window;
                    Queue<HopRow> queue = this.rowBuffer;
                    synchronized (queue) {
                        if (this.rowBuffer.size() >= TransformBatchTransform.this.batchSize) {
                            this.emptyRowBuffer(new TransformBaseFn.TransformProcessContext(context));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.numErrors.inc();
                LOG.info("Transform execution error :" + e.getMessage());
                throw new RuntimeException("Error executing TransformBatchFn", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext context) {
            try {
                Queue<HopRow> queue = this.rowBuffer;
                synchronized (queue) {
                    if (!this.rowBuffer.isEmpty()) {
                        this.emptyRowBuffer(new TransformBaseFn.TransformFinishBundleContext(context, this.batchWindow));
                    }
                }
            }
            catch (Exception e) {
                this.numErrors.inc();
                LOG.info("Transform finishing bundle error :" + e.getMessage());
                throw new RuntimeException("Error finalizing bundle of transform '" + this.transformName + "'", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void emptyRowBuffer(TransformBaseFn.TupleOutputContext<HopRow> context) throws HopException {
            Queue<HopRow> queue = this.rowBuffer;
            synchronized (queue) {
                ArrayList<HopRow> buffer = new ArrayList<HopRow>();
                int size = this.rowBuffer.size();
                for (int i = 0; i < size; ++i) {
                    HopRow hopRow = this.rowBuffer.poll();
                    buffer.add(hopRow);
                }
                if (buffer.isEmpty()) {
                    return;
                }
                if (!this.rowBuffer.isEmpty()) {
                    LOG.error("Async action detected on rowBuffer");
                }
                this.resultRows.clear();
                for (int t = 0; t < this.targetTransforms.size(); ++t) {
                    this.targetResultRowsList.get(t).clear();
                }
                if (!this.inputTransform) {
                    int bufferSize = buffer.size();
                    if (this.maxInputBufferSize < bufferSize) {
                        Metrics.counter((String)"maxInputSize", (String)this.transformName).inc((long)(bufferSize - this.maxInputBufferSize));
                        this.maxInputBufferSize = bufferSize;
                    }
                    if (this.minInputBufferSize > bufferSize) {
                        if (this.minInputBufferSize == Integer.MAX_VALUE) {
                            Metrics.counter((String)"minInputSize", (String)this.transformName).inc((long)bufferSize);
                        } else {
                            Metrics.counter((String)"minInputSize", (String)this.transformName).dec((long)(bufferSize - this.minInputBufferSize));
                        }
                        this.minInputBufferSize = bufferSize;
                    }
                    for (HopRow inputRow : buffer) {
                        this.rowProducer.putRow(this.inputRowMeta, inputRow.getRow());
                    }
                }
                this.executor.oneIteration();
                for (Object[] resultRow : this.resultRows) {
                    context.output(this.mainTupleTag, new HopRow(resultRow));
                    this.writtenCounter.inc();
                }
                for (int t = 0; t < this.targetResultRowsList.size(); ++t) {
                    List<Object[]> targetRowsList = this.targetResultRowsList.get(t);
                    TupleTag<HopRow> tupleTag = this.tupleTagList.get(t);
                    for (Object[] targetRow : targetRowsList) {
                        context.output(tupleTag, new HopRow(targetRow));
                    }
                }
                this.flushBufferCounter.inc();
                buffer.clear();
                this.lastTimerCheck.set(System.currentTimeMillis());
            }
        }

        private TransformMeta createInjectorTransform(PipelineMeta pipelineMeta, String injectorTransformName, IRowMeta injectorRowMeta, int x, int y) {
            InjectorMeta injectorMeta = new InjectorMeta();
            for (IValueMeta valueMeta : injectorRowMeta.getValueMetaList()) {
                injectorMeta.getInjectorFields().add(new InjectorField(valueMeta.getName(), valueMeta.getTypeDesc(), Integer.toString(valueMeta.getLength()), Integer.toString(valueMeta.getPrecision())));
            }
            TransformMeta injectorTransformMeta = new TransformMeta(injectorTransformName, (ITransformMeta)injectorMeta);
            injectorTransformMeta.setLocation(x, y);
            pipelineMeta.addTransform(injectorTransformMeta);
            return injectorTransformMeta;
        }

        private TransformMetaDataCombi findCombi(Pipeline pipeline, String transformName) {
            for (TransformMetaDataCombi combi : pipeline.getTransforms()) {
                if (!combi.transformName.equals(transformName)) continue;
                return combi;
            }
            throw new RuntimeException("Configuration error, transform '" + transformName + "' not found in transformation");
        }
    }
}

