/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodboutput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodb.MongoDbMeta;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutput;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputData;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputDialog;
import org.w3c.dom.Node;

@Transform(id="MongoDbOutput", image="mongodb-output.svg", name="i18n::MongoDbOutput.Name", description="i18n::MongoDbOutput.Description", documentationUrl="/pipeline/transforms/mongodboutput.html", keywords={"i18n::MongoDbOutputMeta.keyword"}, categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output")
public class MongoDbOutputMeta
extends MongoDbMeta<MongoDbOutput, MongoDbOutputData> {
    private static final Class<?> PKG = MongoDbOutputMeta.class;
    @HopMetadataProperty(key="truncate", injectionKey="TRUNCATE")
    protected boolean truncate;
    @HopMetadataProperty(key="update", injectionKey="UPDATE")
    protected boolean update;
    @HopMetadataProperty(key="upsert", injectionKey="UPSERT")
    protected boolean upsert;
    @HopMetadataProperty(key="multi", injectionKey="MULTI")
    protected boolean multi;
    @HopMetadataProperty(key="modifier_update", injectionKey="MODIFIER_UPDATE")
    protected boolean modifierUpdate;
    @HopMetadataProperty(key="batch_insert_size", injectionKey="BATCH_INSERT_SIZE")
    protected String batchInsertSize = "100";
    @HopMetadataProperty(groupKey="mongo_fields", key="mongo_field", injectionKey="FIELDS", injectionGroupKey="FIELD")
    protected List<MongoField> mongoFields;
    @HopMetadataProperty(groupKey="mongo_indexes", key="mongo_index", injectionKey="INDEXES", injectionGroupKey="INDEX")
    protected List<MongoIndex> mongoIndexes;
    public static final int RETRIES = 5;
    public static final int RETRY_DELAY = 10;
    @HopMetadataProperty(key="write_retries", injectionKey="RETRY_NUMBER")
    private String writeRetries = "5";
    @HopMetadataProperty(key="write_retry_delay", injectionKey="RETRY_DELAY")
    private String writeRetryDelay = "10";

    public void setDefault() {
        this.setCollection("");
        this.upsert = false;
        this.modifierUpdate = true;
        this.truncate = false;
        this.batchInsertSize = "100";
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        String tempCollection = XmlHandler.getTagValue((Node)transformNode, (String)"mongo_collection");
        if (!Utils.isEmpty((CharSequence)tempCollection)) {
            this.setCollection(tempCollection);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingFields", (Object[])new Object[]{prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getDialogClassName() {
        return MongoDbOutputDialog.class.getCanonicalName();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @Generated
    public boolean isTruncate() {
        return this.truncate;
    }

    @Generated
    public boolean isUpdate() {
        return this.update;
    }

    @Generated
    public boolean isUpsert() {
        return this.upsert;
    }

    @Generated
    public boolean isMulti() {
        return this.multi;
    }

    @Generated
    public boolean isModifierUpdate() {
        return this.modifierUpdate;
    }

    @Generated
    public String getBatchInsertSize() {
        return this.batchInsertSize;
    }

    @Generated
    public List<MongoField> getMongoFields() {
        return this.mongoFields;
    }

    @Generated
    public List<MongoIndex> getMongoIndexes() {
        return this.mongoIndexes;
    }

    @Generated
    public String getWriteRetries() {
        return this.writeRetries;
    }

    @Generated
    public String getWriteRetryDelay() {
        return this.writeRetryDelay;
    }

    @Generated
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    @Generated
    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Generated
    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    @Generated
    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @Generated
    public void setModifierUpdate(boolean modifierUpdate) {
        this.modifierUpdate = modifierUpdate;
    }

    @Generated
    public void setBatchInsertSize(String batchInsertSize) {
        this.batchInsertSize = batchInsertSize;
    }

    @Generated
    public void setMongoFields(List<MongoField> mongoFields) {
        this.mongoFields = mongoFields;
    }

    @Generated
    public void setMongoIndexes(List<MongoIndex> mongoIndexes) {
        this.mongoIndexes = mongoIndexes;
    }

    @Generated
    public void setWriteRetries(String writeRetries) {
        this.writeRetries = writeRetries;
    }

    @Generated
    public void setWriteRetryDelay(String writeRetryDelay) {
        this.writeRetryDelay = writeRetryDelay;
    }

    public static class MongoIndex {
        @HopMetadataProperty(key="path_to_fields", injectionKey="INDEX_FIELD")
        public String pathToFields = "";
        @HopMetadataProperty(key="drop", injectionKey="DROP")
        public boolean drop;
        @HopMetadataProperty(key="unique", injectionKey="UNIQUE")
        public boolean unique;
        @HopMetadataProperty(key="sparse", injectionKey="SPARSE")
        public boolean sparse;

        public String toString() {
            return this.pathToFields + " (unique = " + this.unique + " sparse = " + this.sparse + ")";
        }

        @Generated
        public String getPathToFields() {
            return this.pathToFields;
        }

        @Generated
        public boolean isDrop() {
            return this.drop;
        }

        @Generated
        public boolean isUnique() {
            return this.unique;
        }

        @Generated
        public boolean isSparse() {
            return this.sparse;
        }

        @Generated
        public void setPathToFields(String pathToFields) {
            this.pathToFields = pathToFields;
        }

        @Generated
        public void setDrop(boolean drop) {
            this.drop = drop;
        }

        @Generated
        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        @Generated
        public void setSparse(boolean sparse) {
            this.sparse = sparse;
        }
    }

    public static class MongoField {
        @HopMetadataProperty(key="incoming_field_name", injectionKey="INCOMING_FIELD_NAME")
        public String incomingFieldName = "";
        String environUpdatedFieldName = "";
        @HopMetadataProperty(key="mongo_doc_path", injectionKey="MONGO_DOCUMENT_PATH")
        public String mongoDocPath = "";
        String environUpdateMongoDocPath = "";
        protected List<String> pathList;
        protected List<String> tempPathList;
        @HopMetadataProperty(key="use_incoming_field_name_as_mongo_field_name", injectionKey="INCOMING_AS_MONGO")
        public boolean useIncomingFieldNameAsMongoFieldName;
        @HopMetadataProperty(key="update_match_field", injectionKey="UPDATE_MATCH_FIELD")
        public boolean updateMatchField;
        @HopMetadataProperty(key="modifier_update_operation", injectionKey="MODIFIER_OPERATION")
        public String modifierUpdateOperation = "N/A";
        String environUpdateModifierOperation = "";
        @HopMetadataProperty(key="modifier_policy", injectionKey="MODIFIER_POLICY")
        public String modifierOperationApplyPolicy = "Insert&Update";
        @HopMetadataProperty(key="allow_null", injectionKey="INSERT_NULL")
        public boolean insertNull = false;
        @HopMetadataProperty(key="json_field", injectionKey="JSON")
        public boolean inputJson = false;

        public MongoField copy() {
            MongoField mongoField = new MongoField();
            mongoField.incomingFieldName = this.incomingFieldName;
            mongoField.environUpdatedFieldName = this.environUpdatedFieldName;
            mongoField.mongoDocPath = this.mongoDocPath;
            mongoField.environUpdateMongoDocPath = this.environUpdateMongoDocPath;
            mongoField.useIncomingFieldNameAsMongoFieldName = this.useIncomingFieldNameAsMongoFieldName;
            mongoField.updateMatchField = this.updateMatchField;
            mongoField.modifierUpdateOperation = this.modifierUpdateOperation;
            mongoField.environUpdateModifierOperation = this.environUpdateModifierOperation;
            mongoField.modifierOperationApplyPolicy = this.modifierOperationApplyPolicy;
            mongoField.inputJson = this.inputJson;
            mongoField.insertNull = this.insertNull;
            return mongoField;
        }

        public void init(IVariables variables) {
            this.init(variables, true);
        }

        public void init(IVariables variables, boolean updateFromEnv) {
            if (updateFromEnv) {
                this.environUpdatedFieldName = variables.resolve(this.incomingFieldName);
                this.environUpdateMongoDocPath = variables.resolve(this.mongoDocPath);
                this.environUpdateModifierOperation = variables.resolve(this.modifierUpdateOperation);
            }
            this.pathList = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.environUpdateMongoDocPath)) {
                String[] parts = this.environUpdateMongoDocPath.split("\\.");
                Collections.addAll(this.pathList, parts);
            }
            this.tempPathList = new ArrayList<String>(this.pathList);
        }

        public void reset() {
            if (!Utils.isEmpty(this.tempPathList)) {
                this.tempPathList.clear();
            }
            if (this.tempPathList != null) {
                this.tempPathList.addAll(this.pathList);
            }
        }

        @Generated
        public String getIncomingFieldName() {
            return this.incomingFieldName;
        }

        @Generated
        public String getEnvironUpdatedFieldName() {
            return this.environUpdatedFieldName;
        }

        @Generated
        public String getMongoDocPath() {
            return this.mongoDocPath;
        }

        @Generated
        public String getEnvironUpdateMongoDocPath() {
            return this.environUpdateMongoDocPath;
        }

        @Generated
        public List<String> getPathList() {
            return this.pathList;
        }

        @Generated
        public List<String> getTempPathList() {
            return this.tempPathList;
        }

        @Generated
        public boolean isUseIncomingFieldNameAsMongoFieldName() {
            return this.useIncomingFieldNameAsMongoFieldName;
        }

        @Generated
        public boolean isUpdateMatchField() {
            return this.updateMatchField;
        }

        @Generated
        public String getModifierUpdateOperation() {
            return this.modifierUpdateOperation;
        }

        @Generated
        public String getEnvironUpdateModifierOperation() {
            return this.environUpdateModifierOperation;
        }

        @Generated
        public String getModifierOperationApplyPolicy() {
            return this.modifierOperationApplyPolicy;
        }

        @Generated
        public boolean isInsertNull() {
            return this.insertNull;
        }

        @Generated
        public boolean isInputJson() {
            return this.inputJson;
        }

        @Generated
        public void setIncomingFieldName(String incomingFieldName) {
            this.incomingFieldName = incomingFieldName;
        }

        @Generated
        public void setEnvironUpdatedFieldName(String environUpdatedFieldName) {
            this.environUpdatedFieldName = environUpdatedFieldName;
        }

        @Generated
        public void setMongoDocPath(String mongoDocPath) {
            this.mongoDocPath = mongoDocPath;
        }

        @Generated
        public void setEnvironUpdateMongoDocPath(String environUpdateMongoDocPath) {
            this.environUpdateMongoDocPath = environUpdateMongoDocPath;
        }

        @Generated
        public void setPathList(List<String> pathList) {
            this.pathList = pathList;
        }

        @Generated
        public void setTempPathList(List<String> tempPathList) {
            this.tempPathList = tempPathList;
        }

        @Generated
        public void setUseIncomingFieldNameAsMongoFieldName(boolean useIncomingFieldNameAsMongoFieldName) {
            this.useIncomingFieldNameAsMongoFieldName = useIncomingFieldNameAsMongoFieldName;
        }

        @Generated
        public void setUpdateMatchField(boolean updateMatchField) {
            this.updateMatchField = updateMatchField;
        }

        @Generated
        public void setModifierUpdateOperation(String modifierUpdateOperation) {
            this.modifierUpdateOperation = modifierUpdateOperation;
        }

        @Generated
        public void setEnvironUpdateModifierOperation(String environUpdateModifierOperation) {
            this.environUpdateModifierOperation = environUpdateModifierOperation;
        }

        @Generated
        public void setModifierOperationApplyPolicy(String modifierOperationApplyPolicy) {
            this.modifierOperationApplyPolicy = modifierOperationApplyPolicy;
        }

        @Generated
        public void setInsertNull(boolean insertNull) {
            this.insertNull = insertNull;
        }

        @Generated
        public void setInputJson(boolean inputJson) {
            this.inputJson = inputJson;
        }
    }
}

