/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.io.support;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ClassicHttpRequest;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpEntity;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpException;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpResponse;
import com.clickhouse.client.internal.org.apache.hc.core5.http.io.HttpFilterChain;
import com.clickhouse.client.internal.org.apache.hc.core5.http.io.HttpFilterHandler;
import com.clickhouse.client.internal.org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.org.apache.hc.core5.http.support.ExpectSupport;
import com.clickhouse.client.internal.org.apache.hc.core5.http.support.Expectation;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class HttpServerExpectationFilter
implements HttpFilterHandler {
    protected boolean verify(ClassicHttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected HttpEntity generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        Expectation expectation = ExpectSupport.parse(request, request.getEntity());
        if (expectation == Expectation.CONTINUE) {
            boolean verified = this.verify(request, context);
            if (!verified) {
                BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
                HttpEntity responseContent = this.generateResponseContent(expectationFailed);
                expectationFailed.setEntity(responseContent);
                responseTrigger.submitResponse(expectationFailed);
                return;
            }
            responseTrigger.sendInformation(new BasicClassicHttpResponse(100));
        } else if (expectation == Expectation.UNKNOWN) {
            BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
            HttpEntity responseContent = this.generateResponseContent(expectationFailed);
            expectationFailed.setEntity(responseContent);
            responseTrigger.submitResponse(expectationFailed);
            return;
        }
        chain.proceed(request, responseTrigger, context);
    }
}

