/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

public class TinyBuilder
extends Builder {
    public static final int PARENT_POINTER_INTERVAL = 10;
    private TinyTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private int[] sizeParameters;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];
    private boolean isIDElement = false;

    public void setSizeParameters(int[] nArray) {
        this.sizeParameters = nArray;
    }

    public int[] getSizeParameters() {
        int[] nArray = new int[]{this.tree.numberOfNodes, this.tree.numberOfAttributes, this.tree.numberOfNamespaces, this.tree.getCharacterBuffer().length()};
        return nArray;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public void open() throws XPathException {
        if (this.started) {
            return;
        }
        if (this.tree == null) {
            this.tree = this.sizeParameters == null ? new TinyTree() : new TinyTree(this.sizeParameters[0], this.sizeParameters[1], this.sizeParameters[2], this.sizeParameters[3]);
            this.tree.setConfiguration(this.config);
            this.currentDepth = 0;
            if (this.lineNumbering) {
                this.tree.setLineNumbering();
            }
        }
        super.open();
    }

    public void startDocument(int n) throws XPathException {
        if (this.started && !this.ended || this.currentDepth > 0) {
            return;
        }
        this.started = true;
        this.currentRoot = new TinyDocumentImpl(this.tree);
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentRoot;
        tinyDocumentImpl.setSystemId(this.getSystemId());
        tinyDocumentImpl.setConfiguration(this.config);
        this.currentDepth = 0;
        this.tree.addDocumentNode((TinyDocumentImpl)this.currentRoot);
        this.prevAtDepth[0] = 0;
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        this.tree.next[0] = -1;
        ++this.currentDepth;
        super.startDocument(0);
    }

    public void endDocument() throws XPathException {
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
    }

    public void close() throws XPathException {
        this.tree.addNode((short)11, 0, 0, 0, 0);
        this.tree.condense();
        super.close();
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        int n5;
        if (this.siblingsAtDepth[this.currentDepth] > 10) {
            this.nodeNr = this.tree.addNode((short)12, this.currentDepth, this.prevAtDepth[this.currentDepth - 1], 0, 0);
            n5 = this.prevAtDepth[this.currentDepth];
            if (n5 > 0) {
                this.tree.next[n5] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        this.nodeNr = this.tree.addNode((short)1, this.currentDepth, -1, -1, n);
        this.isIDElement = false;
        if (n2 != 641 && n2 != -1) {
            this.tree.setElementAnnotation(this.nodeNr, n2);
            if (this.tree.isIDCode(n2)) {
                this.isIDElement = true;
            }
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = this.tree.getNode(this.nodeNr);
        } else {
            n5 = this.prevAtDepth[this.currentDepth];
            if (n5 > 0) {
                this.tree.next[n5] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n6 = this.currentDepth;
            this.siblingsAtDepth[n6] = this.siblingsAtDepth[n6] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] nArray = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, nArray, 0, this.currentDepth);
            this.prevAtDepth = nArray;
            nArray = new int[this.currentDepth * 2];
            System.arraycopy(this.siblingsAtDepth, 0, nArray, 0, this.currentDepth);
            this.siblingsAtDepth = nArray;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        LocationProvider locationProvider = this.pipe.getLocationProvider();
        if (locationProvider != null) {
            this.tree.setSystemId(this.nodeNr, locationProvider.getSystemId(n3));
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locationProvider.getLineNumber(n3));
            }
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        this.tree.addNamespace(this.nodeNr, n);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        this.tree.addAttribute(this.currentRoot, this.nodeNr, n, n2, charSequence);
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws XPathException {
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
        if (this.isIDElement) {
            this.tree.indexIDElement(this.currentRoot, this.prevAtDepth[this.currentDepth], this.config.getNameChecker());
            this.isIDElement = false;
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (charSequence instanceof CompressedWhitespace && (n2 & 0x400) != 0) {
            long l = ((CompressedWhitespace)charSequence).getCompressedValue();
            this.nodeNr = this.tree.addNode((short)4, this.currentDepth, (int)(l >> 32), (int)(l & 0xFFFFFFFFFFFFFFFFL), -1);
            int n3 = this.prevAtDepth[this.currentDepth];
            if (n3 > 0) {
                this.tree.next[n3] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n4 = this.currentDepth;
            this.siblingsAtDepth[n4] = this.siblingsAtDepth[n4] + 1;
            return;
        }
        int n5 = charSequence.length();
        if (n5 > 0) {
            int n6 = this.tree.getCharacterBuffer().length();
            this.tree.appendChars(charSequence);
            int n7 = this.tree.numberOfNodes - 1;
            if (this.tree.nodeKind[n7] == 3 && this.tree.depth[n7] == this.currentDepth) {
                int n8 = n7;
                this.tree.beta[n8] = this.tree.beta[n8] + n5;
            } else {
                this.nodeNr = this.tree.addNode((short)3, this.currentDepth, n6, n5, -1);
                int n9 = this.prevAtDepth[this.currentDepth];
                if (n9 > 0) {
                    this.tree.next[n9] = this.nodeNr;
                }
                this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
                this.prevAtDepth[this.currentDepth] = this.nodeNr;
                int n10 = this.currentDepth;
                this.siblingsAtDepth[n10] = this.siblingsAtDepth[n10] + 1;
            }
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.tree.commentBuffer == null) {
            this.tree.commentBuffer = new FastStringBuffer(200);
        }
        int n3 = this.tree.commentBuffer.length();
        this.tree.commentBuffer.append(((Object)charSequence).toString());
        int n4 = this.namePool.allocate("", "", string);
        this.nodeNr = this.tree.addNode((short)7, this.currentDepth, n3, charSequence.length(), n4);
        int n5 = this.prevAtDepth[this.currentDepth];
        if (n5 > 0) {
            this.tree.next[n5] = this.nodeNr;
        }
        this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n6 = this.currentDepth;
        this.siblingsAtDepth[n6] = this.siblingsAtDepth[n6] + 1;
        LocationProvider locationProvider = this.pipe.getLocationProvider();
        if (locationProvider != null) {
            this.tree.setSystemId(this.nodeNr, locationProvider.getSystemId(n));
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locationProvider.getLineNumber(n));
            }
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.tree.commentBuffer == null) {
            this.tree.commentBuffer = new FastStringBuffer(200);
        }
        int n3 = this.tree.commentBuffer.length();
        this.tree.commentBuffer.append(((Object)charSequence).toString());
        this.nodeNr = this.tree.addNode((short)8, this.currentDepth, n3, charSequence.length(), -1);
        int n4 = this.prevAtDepth[this.currentDepth];
        if (n4 > 0) {
            this.tree.next[n4] = this.nodeNr;
        }
        this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n5 = this.currentDepth;
        this.siblingsAtDepth[n5] = this.siblingsAtDepth[n5] + 1;
    }

    public void setUnparsedEntity(String string, String string2, String string3) {
        ((TinyDocumentImpl)this.currentRoot).setUnparsedEntity(string, string2, string3);
    }
}

