/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.GroupInfo;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.dropbox.core.v2.sharing.MembershipInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupMembershipInfo
extends MembershipInfo {
    @Nonnull
    protected final GroupInfo group;

    public GroupMembershipInfo(@Nonnull AccessLevel accessType, @Nonnull GroupInfo group, @Nullable List<MemberPermission> permissions, @Nullable String initials, boolean isInherited) {
        super(accessType, permissions, initials, isInherited);
        if (group == null) {
            throw new IllegalArgumentException("Required value for 'group' is null");
        }
        this.group = group;
    }

    public GroupMembershipInfo(@Nonnull AccessLevel accessType, @Nonnull GroupInfo group) {
        this(accessType, group, null, null, false);
    }

    @Override
    @Nonnull
    public AccessLevel getAccessType() {
        return this.accessType;
    }

    @Nonnull
    public GroupInfo getGroup() {
        return this.group;
    }

    @Override
    @Nullable
    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Nullable
    public String getInitials() {
        return this.initials;
    }

    @Override
    public boolean getIsInherited() {
        return this.isInherited;
    }

    public static Builder newBuilder(AccessLevel accessType, GroupInfo group) {
        return new Builder(accessType, group);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.group});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupMembershipInfo other = (GroupMembershipInfo)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.group != other.group && !this.group.equals(other.group) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.initials != other.initials && (this.initials == null || !this.initials.equals(other.initials)) || this.isInherited != other.isInherited);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupMembershipInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembershipInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g);
            g.writeFieldName("group");
            GroupInfo.Serializer.INSTANCE.serialize(value.group, g);
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).serialize((List<MemberPermission>)value.permissions, g);
            }
            if (value.initials != null) {
                g.writeFieldName("initials");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.initials, g);
            }
            g.writeFieldName("is_inherited");
            StoneSerializers.boolean_().serialize((Boolean)value.isInherited, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupMembershipInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isInherited;
            String f_initials;
            List<MemberPermission> f_permissions;
            GroupInfo f_group;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_group = null;
                f_permissions = null;
                f_initials = null;
                f_isInherited = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("group".equals(field)) {
                        f_group = (GroupInfo)GroupInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("initials".equals(field)) {
                        f_initials = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_inherited".equals(field)) {
                        f_isInherited = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_group == null) {
                    throw new JsonParseException(p, "Required field \"group\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupMembershipInfo value = new GroupMembershipInfo(f_accessType, f_group, f_permissions, f_initials, f_isInherited);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends MembershipInfo.Builder {
        protected final GroupInfo group;

        protected Builder(AccessLevel accessType, GroupInfo group) {
            super(accessType);
            if (group == null) {
                throw new IllegalArgumentException("Required value for 'group' is null");
            }
            this.group = group;
        }

        @Override
        public Builder withPermissions(List<MemberPermission> permissions) {
            super.withPermissions(permissions);
            return this;
        }

        @Override
        public Builder withInitials(String initials) {
            super.withInitials(initials);
            return this;
        }

        @Override
        public Builder withIsInherited(Boolean isInherited) {
            super.withIsInherited(isInherited);
            return this;
        }

        @Override
        public GroupMembershipInfo build() {
            return new GroupMembershipInfo(this.accessType, this.group, this.permissions, this.initials, this.isInherited);
        }
    }
}

