/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class KafkaSourceDescriptor
implements Serializable {
    private @Nullable @UnknownKeyFor @Initialized TopicPartition topicPartition = null;

    @SchemaFieldName(value="topic")
    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

    @SchemaFieldName(value="partition")
    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized Integer getPartition();

    @SchemaFieldName(value="start_read_offset")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Long getStartReadOffset();

    @SchemaFieldName(value="start_read_time")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Instant getStartReadTime();

    @SchemaFieldName(value="stop_read_offset")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Long getStopReadOffset();

    @SchemaFieldName(value="stop_read_time")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Instant getStopReadTime();

    @SchemaFieldName(value="bootstrap_servers")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getBootStrapServers();

    @SchemaIgnore
    @Deterministic
    public @UnknownKeyFor @NonNull @Initialized TopicPartition getTopicPartition() {
        if (this.topicPartition == null) {
            this.topicPartition = new TopicPartition(this.getTopic(), this.getPartition().intValue());
        }
        return this.topicPartition;
    }

    public static @UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor of(@UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition, @Nullable @UnknownKeyFor @Initialized Long startReadOffset, @Nullable @UnknownKeyFor @Initialized Instant startReadTime, @Nullable @UnknownKeyFor @Initialized Long stopReadOffset, @Nullable @UnknownKeyFor @Initialized Instant stopReadTime, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bootstrapServers) {
        KafkaSourceDescriptor.checkArguments(startReadOffset, startReadTime, stopReadOffset, stopReadTime);
        return new AutoValue_KafkaSourceDescriptor(topicPartition.topic(), topicPartition.partition(), startReadOffset, startReadTime, stopReadOffset, stopReadTime, bootstrapServers);
    }

    private static void checkArguments(@Nullable @UnknownKeyFor @Initialized Long startReadOffset, @Nullable @UnknownKeyFor @Initialized Instant startReadTime, @Nullable @UnknownKeyFor @Initialized Long stopReadOffset, @Nullable @UnknownKeyFor @Initialized Instant stopReadTime) {
        Preconditions.checkArgument((startReadOffset == null || startReadTime == null ? 1 : 0) != 0, (Object)"startReadOffset and startReadTime are optional but mutually exclusive. Please set only one of them.");
        Preconditions.checkArgument((stopReadOffset == null || stopReadTime == null ? 1 : 0) != 0, (Object)"stopReadOffset and stopReadTime are optional but mutually exclusive. Please set only one of them.");
    }

    @SchemaCreate
    static @UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor create(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized Integer partition, @UnknownKeyFor @NonNull @Initialized Long start_read_offset, @UnknownKeyFor @NonNull @Initialized Instant start_read_time, @UnknownKeyFor @NonNull @Initialized Long stop_read_offset, @UnknownKeyFor @NonNull @Initialized Instant stop_read_time, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bootstrap_servers) {
        KafkaSourceDescriptor.checkArguments(start_read_offset, start_read_time, stop_read_offset, stop_read_time);
        return new AutoValue_KafkaSourceDescriptor(topic, partition, start_read_offset, start_read_time, stop_read_offset, stop_read_time, bootstrap_servers);
    }
}

