/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.List;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

final class AutoValue_KafkaSourceDescriptor
extends KafkaSourceDescriptor {
    private final String topic;
    private final Integer partition;
    private final @Nullable Long startReadOffset;
    private final @Nullable Instant startReadTime;
    private final @Nullable Long stopReadOffset;
    private final @Nullable Instant stopReadTime;
    private final @Nullable List<String> bootStrapServers;

    AutoValue_KafkaSourceDescriptor(String topic, Integer partition, @Nullable Long startReadOffset, @Nullable Instant startReadTime, @Nullable Long stopReadOffset, @Nullable Instant stopReadTime, @Nullable List<String> bootStrapServers) {
        if (topic == null) {
            throw new NullPointerException("Null topic");
        }
        this.topic = topic;
        if (partition == null) {
            throw new NullPointerException("Null partition");
        }
        this.partition = partition;
        this.startReadOffset = startReadOffset;
        this.startReadTime = startReadTime;
        this.stopReadOffset = stopReadOffset;
        this.stopReadTime = stopReadTime;
        this.bootStrapServers = bootStrapServers;
    }

    @Override
    @SchemaFieldName(value="topic")
    @Pure
    String getTopic() {
        return this.topic;
    }

    @Override
    @SchemaFieldName(value="partition")
    @Pure
    Integer getPartition() {
        return this.partition;
    }

    @Override
    @SchemaFieldName(value="start_read_offset")
    @Pure
    @Nullable Long getStartReadOffset() {
        return this.startReadOffset;
    }

    @Override
    @SchemaFieldName(value="start_read_time")
    @Pure
    @Nullable Instant getStartReadTime() {
        return this.startReadTime;
    }

    @Override
    @SchemaFieldName(value="stop_read_offset")
    @Pure
    @Nullable Long getStopReadOffset() {
        return this.stopReadOffset;
    }

    @Override
    @SchemaFieldName(value="stop_read_time")
    @Pure
    @Nullable Instant getStopReadTime() {
        return this.stopReadTime;
    }

    @Override
    @SchemaFieldName(value="bootstrap_servers")
    @Pure
    @Nullable List<String> getBootStrapServers() {
        return this.bootStrapServers;
    }

    public String toString() {
        return "KafkaSourceDescriptor{topic=" + this.topic + ", partition=" + this.partition + ", startReadOffset=" + this.startReadOffset + ", startReadTime=" + this.startReadTime + ", stopReadOffset=" + this.stopReadOffset + ", stopReadTime=" + this.stopReadTime + ", bootStrapServers=" + this.bootStrapServers + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaSourceDescriptor) {
            KafkaSourceDescriptor that = (KafkaSourceDescriptor)o;
            return this.topic.equals(that.getTopic()) && this.partition.equals(that.getPartition()) && (this.startReadOffset == null ? that.getStartReadOffset() == null : this.startReadOffset.equals(that.getStartReadOffset())) && (this.startReadTime == null ? that.getStartReadTime() == null : this.startReadTime.equals((Object)that.getStartReadTime())) && (this.stopReadOffset == null ? that.getStopReadOffset() == null : this.stopReadOffset.equals(that.getStopReadOffset())) && (this.stopReadTime == null ? that.getStopReadTime() == null : this.stopReadTime.equals((Object)that.getStopReadTime())) && (this.bootStrapServers == null ? that.getBootStrapServers() == null : this.bootStrapServers.equals(that.getBootStrapServers()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadOffset == null ? 0 : this.startReadOffset.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadTime == null ? 0 : this.startReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopReadOffset == null ? 0 : this.stopReadOffset.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopReadTime == null ? 0 : this.stopReadTime.hashCode();
        h$ *= 1000003;
        return h$ ^= this.bootStrapServers == null ? 0 : this.bootStrapServers.hashCode();
    }
}

