/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

final class PartiallyAppliedScalarFunction
extends NativeScalarFunction
implements PartialScalarFunction {
    private final ScalarFunction function;
    private final List<ByteBuffer> partialParameters;

    PartiallyAppliedScalarFunction(ScalarFunction function, List<ByteBuffer> partialParameters, int unresolvedCount) {
        super("__partial_application__", function.returnType(), PartiallyAppliedScalarFunction.computeArgTypes(function, partialParameters, unresolvedCount));
        this.function = function;
        this.partialParameters = partialParameters;
    }

    @Override
    public boolean isMonotonic() {
        return this.function.isNative() ? ((NativeScalarFunction)this.function).isPartialApplicationMonotonic(this.partialParameters) : this.function.isMonotonic();
    }

    @Override
    public boolean isPure() {
        return this.function.isPure();
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public List<ByteBuffer> getPartialParameters() {
        return this.partialParameters;
    }

    private static AbstractType<?>[] computeArgTypes(ScalarFunction function, List<ByteBuffer> partialParameters, int unresolvedCount) {
        AbstractType[] argTypes = new AbstractType[unresolvedCount];
        int arg = 0;
        for (int i = 0; i < partialParameters.size(); ++i) {
            if (partialParameters.get(i) != UNRESOLVED) continue;
            argTypes[arg++] = function.argTypes().get(i);
        }
        return argTypes;
    }

    @Override
    public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        ArrayList<ByteBuffer> fullParameters = new ArrayList<ByteBuffer>(this.partialParameters);
        int arg = 0;
        for (int i = 0; i < fullParameters.size(); ++i) {
            if (fullParameters.get(i) != UNRESOLVED) continue;
            fullParameters.set(i, parameters.get(arg++));
        }
        return this.function.execute(protocolVersion, fullParameters);
    }

    @Override
    public String toString() {
        CqlBuilder b = new CqlBuilder().append(this.function.name()).append(" : (");
        List<AbstractType<?>> types = this.function.argTypes();
        int m = types.size();
        for (int i = 0; i < m; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.toCqlString(types.get(i)));
            if (this.partialParameters.get(i) == Function.UNRESOLVED) continue;
            b.append("(constant)");
        }
        b.append(") -> ").append(this.returnType);
        return b.toString();
    }
}

