/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hcatalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.hcatalog.HCatalogIO;
import org.apache.beam.sdk.io.hcatalog.HCatalogUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.transfer.DataTransferFactory;
import org.apache.hive.hcatalog.data.transfer.HCatReader;
import org.apache.hive.hcatalog.data.transfer.ReadEntity;
import org.apache.hive.hcatalog.data.transfer.ReaderContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PartitionReaderFn
extends DoFn<KV<HCatalogIO.Read, Integer>, HCatRecord> {
    private transient @UnknownKeyFor @NonNull @Initialized IMetaStoreClient metaStoreClient;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configProperties;

    public PartitionReaderFn(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> configProperties) {
        this.configProperties = configProperties;
    }

    private @UnknownKeyFor @NonNull @Initialized ReaderContext getReaderContext(@UnknownKeyFor @NonNull @Initialized HCatalogIO.Read readRequest, @UnknownKeyFor @NonNull @Initialized Integer partitionIndexToRead) throws @UnknownKeyFor @NonNull @Initialized Exception {
        List partitions = this.metaStoreClient.listPartitions(readRequest.getDatabase(), readRequest.getTable(), (short)Short.MAX_VALUE);
        Partition partition = (Partition)partitions.get(partitionIndexToRead);
        Preconditions.checkArgument((partition != null ? 1 : 0) != 0, (Object)("Unable to find a partition to read at index " + partitionIndexToRead));
        int desiredSplitCount = HCatalogUtils.getSplitCount(readRequest, partition);
        List values = partition.getValues();
        List<String> partitionCols = readRequest.getPartitionCols();
        Preconditions.checkArgument((values.size() == partitionCols.size() ? 1 : 0) != 0, (Object)"Number of input partitions should be equal to the values of list partition values.");
        ArrayList<String> filter = new ArrayList<String>();
        for (int i = 0; i < partitionCols.size(); ++i) {
            filter.add(partitionCols.get(i) + "='" + (String)values.get(i) + "'");
        }
        String filterString = String.join((CharSequence)" and ", filter);
        ReadEntity entity = new ReadEntity.Builder().withDatabase(readRequest.getDatabase()).withFilter(filterString).withTable(readRequest.getTable()).build();
        HashMap<String, String> configProps = new HashMap<String, String>(readRequest.getConfigProperties());
        configProps.put("hcat.desired.partition.num.splits", String.valueOf(desiredSplitCount));
        return DataTransferFactory.getHCatReader((ReadEntity)entity, configProps).prepareRead();
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        HCatalogIO.Read readRequest = (HCatalogIO.Read)((Object)((KV)c.element()).getKey());
        Integer partitionIndexToRead = (Integer)((KV)c.element()).getValue();
        ReaderContext readerContext = this.getReaderContext(readRequest, partitionIndexToRead);
        for (int i = 0; i < readerContext.numSplits(); ++i) {
            HCatReader reader = DataTransferFactory.getHCatReader((ReaderContext)readerContext, (int)i);
            Iterator hcatIterator = reader.read();
            while (hcatIterator.hasNext()) {
                HCatRecord record = (HCatRecord)hcatIterator.next();
                c.output((Object)record);
            }
        }
    }

    @DoFn.Setup
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Configuration conf = HCatalogUtils.createConfiguration(this.configProperties);
        this.metaStoreClient = HCatalogUtils.createMetaStoreClient(conf);
    }

    @DoFn.Teardown
    public void teardown() {
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
        }
    }
}

