/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator;

import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileNotFoundException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.CalculationType;
import org.apache.hop.pipeline.transforms.calculator.CalculatorData;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMetaFunction;

public class Calculator
extends BaseTransform<CalculatorMeta, CalculatorData> {
    private static final Class<?> PKG = CalculatorMeta.class;
    public static final String CONST_FOR_CALCULATION = " for calculation #";

    public Calculator(TransformMeta transformMeta, CalculatorMeta meta, CalculatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            ((CalculatorData)this.data).clearValuesMetaMapping();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((CalculatorData)this.data).setOutputRowMeta(this.getInputRowMeta().clone());
            ((CalculatorMeta)this.meta).getFields(((CalculatorData)this.data).getOutputRowMeta(), this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((CalculatorData)this.data).setCalcRowMeta(((CalculatorMeta)this.meta).getAllFields(this.getInputRowMeta()));
            ((CalculatorData)this.data).setFieldIndexes(new FieldIndexes[((CalculatorMeta)this.meta).getFunctions().size()]);
            ArrayList<Integer> tempIndexes = new ArrayList<Integer>();
            for (i = 0; i < ((CalculatorMeta)this.meta).getFunctions().size(); ++i) {
                CalculatorMetaFunction function = ((CalculatorMeta)this.meta).getFunctions().get(i);
                ((CalculatorData)this.data).getFieldIndexes()[i] = new FieldIndexes();
                if (!Utils.isEmpty((CharSequence)function.getFieldName())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexName = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldName());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexName < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.Error.UnableFindField", (String[])new String[]{function.getFieldName(), "" + (i + 1)}));
                    }
                } else {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.Error.NoNameField", (String[])new String[]{"" + (i + 1)}));
                }
                if (!Utils.isEmpty((CharSequence)function.getFieldA())) {
                    if (function.getCalcType() != CalculationType.CONSTANT) {
                        ((CalculatorData)this.data).getFieldIndexes()[i].indexA = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldA());
                        if (((CalculatorData)this.data).getFieldIndexes()[i].indexA < 0) {
                            throw new HopTransformException("Unable to find the first argument field '" + function.getFieldName() + CONST_FOR_CALCULATION + (i + 1));
                        }
                    } else {
                        ((CalculatorData)this.data).getFieldIndexes()[i].indexA = -1;
                    }
                } else {
                    throw new HopTransformException("There is no first argument specified for calculated field #" + (i + 1));
                }
                if (!Utils.isEmpty((CharSequence)function.getFieldB())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexB = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldB());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexB < 0) {
                        throw new HopTransformException("Unable to find the second argument field '" + function.getFieldName() + CONST_FOR_CALCULATION + (i + 1));
                    }
                }
                ((CalculatorData)this.data).getFieldIndexes()[i].indexC = -1;
                if (!Utils.isEmpty((CharSequence)function.getFieldC())) {
                    ((CalculatorData)this.data).getFieldIndexes()[i].indexC = ((CalculatorData)this.data).getCalcRowMeta().indexOfValue(function.getFieldC());
                    if (((CalculatorData)this.data).getFieldIndexes()[i].indexC < 0) {
                        throw new HopTransformException("Unable to find the third argument field '" + function.getFieldName() + CONST_FOR_CALCULATION + (i + 1));
                    }
                }
                if (!function.isRemovedFromResult()) continue;
                tempIndexes.add(this.getInputRowMeta().size() + i);
            }
            ((CalculatorData)this.data).setTempIndexes(new int[tempIndexes.size()]);
            for (i = 0; i < ((CalculatorData)this.data).getTempIndexes().length; ++i) {
                ((CalculatorData)this.data).getTempIndexes()[i] = (Integer)tempIndexes.get(i);
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Calculator.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] row = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(((CalculatorData)this.data).getOutputRowMeta(), row);
            if (this.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"Calculator.Log.Linenr", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (HopFileNotFoundException e) {
            if (((CalculatorMeta)this.meta).isFailIfNoFile()) {
                this.logError(BaseMessages.getString(PKG, (String)"Calculator.Log.NoFile", (String[])new String[0]) + " : " + e.getFilepath());
                this.setErrors(this.getErrors() + 1L);
                return false;
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)("Calculator.ErrorInTransformRunning : " + e.getMessage()), (String[])new String[0]));
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Calculator.ErrorInTransformRunning", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private Object[] calcFields(IRowMeta inputRowMeta, Object[] r) throws HopValueException, HopFileNotFoundException {
        Object[] calcData = RowDataUtil.resizeArray((Object[])r, (int)((CalculatorData)this.data).getCalcRowMeta().size());
        int i = 0;
        int index = inputRowMeta.size() + i;
        while (i < ((CalculatorMeta)this.meta).getFunctions().size()) {
            CalculatorMetaFunction fn = ((CalculatorMeta)this.meta).getFunctions().get(i);
            if (!Utils.isEmpty((CharSequence)fn.getFieldName())) {
                IValueMeta targetMeta = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(index);
                IValueMeta metaA = null;
                Object dataA = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexA >= 0) {
                    metaA = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexA);
                    dataA = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexA];
                }
                IValueMeta metaB = null;
                Object dataB = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexB >= 0) {
                    metaB = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexB);
                    dataB = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexB];
                }
                IValueMeta metaC = null;
                Object dataC = null;
                if (((CalculatorData)this.data).getFieldIndexes()[i].indexC >= 0) {
                    metaC = ((CalculatorData)this.data).getCalcRowMeta().getValueMeta(((CalculatorData)this.data).getFieldIndexes()[i].indexC);
                    dataC = calcData[((CalculatorData)this.data).getFieldIndexes()[i].indexC];
                }
                CalculationType calcType = fn.getCalcType();
                CalculationInput calcIn = new CalculationInput(metaA, metaB, metaC, dataA, dataB, dataC, fn, targetMeta, (IVariables)this, ((CalculatorMeta)this.meta).isFailIfNoFile());
                CalculationOutput calcOut = calcType.calculation.calculate(calcIn);
                calcData[index] = calcOut.value;
                int resultType = calcOut.resultType;
                if (targetMeta.getType() == 0) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"Calculator.Log.NoType", (String[])new String[0]) + (i + 1) + " : " + fn.getFieldName() + " = " + fn.getCalcType().getCode() + " / " + fn.getCalcType().getDescription());
                }
                if (calcData[index] != null && targetMeta.getType() != resultType) {
                    IValueMeta resultMeta;
                    try {
                        resultMeta = ((CalculatorData)this.data).getValueMetaFor(resultType, "result");
                    }
                    catch (Exception exception) {
                        throw new HopValueException("Error creating value");
                    }
                    resultMeta.setConversionMask(fn.getConversionMask());
                    resultMeta.setGroupingSymbol(fn.getGroupingSymbol());
                    resultMeta.setDecimalSymbol(fn.getDecimalSymbol());
                    resultMeta.setCurrencySymbol(fn.getCurrencySymbol());
                    try {
                        calcData[index] = targetMeta.convertData(resultMeta, calcData[index]);
                    }
                    catch (Exception ex) {
                        throw new HopValueException("resultType: " + resultType + "; targetMeta: " + targetMeta.getType(), (Throwable)ex);
                    }
                }
            }
            ++i;
            ++index;
        }
        return RowDataUtil.removeItems((Object[])calcData, (int[])((CalculatorData)this.data).getTempIndexes());
    }

    public class FieldIndexes {
        public int indexName;
        public int indexA;
        public int indexB;
        public int indexC;
    }
}

