/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.DateTime;
import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_CloneDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.annotation.Nullable;

@BetaApi
@AutoValue
public abstract class CloneDefinition
implements Serializable {
    private static final long serialVersionUID = 1460853787400450649L;

    public static Builder newBuilder() {
        return new AutoValue_CloneDefinition.Builder();
    }

    static CloneDefinition fromPb(com.google.api.services.bigquery.model.CloneDefinition cloneDefinition) {
        Builder builder = CloneDefinition.newBuilder();
        if (cloneDefinition.getCloneTime() != null) {
            builder.setCloneTime(cloneDefinition.getCloneTime().toString());
        }
        if (cloneDefinition.getBaseTableReference() != null) {
            builder.setBaseTableId(TableId.fromPb(cloneDefinition.getBaseTableReference()));
        }
        return builder.build();
    }

    @Nullable
    public abstract TableId getBaseTableId();

    @Nullable
    public abstract String getCloneTime();

    @VisibleForTesting
    public abstract Builder toBuilder();

    com.google.api.services.bigquery.model.CloneDefinition toPb() {
        com.google.api.services.bigquery.model.CloneDefinition cloneDefinition = new com.google.api.services.bigquery.model.CloneDefinition();
        cloneDefinition.setBaseTableReference(this.getBaseTableId().toPb());
        cloneDefinition.setCloneTime(DateTime.parseRfc3339((String)this.getCloneTime()));
        return cloneDefinition;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBaseTableId(TableId var1);

        public abstract Builder setCloneTime(String var1);

        public abstract CloneDefinition build();
    }
}

