/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.projects.util.ProjectsUtil;

@ExtensionPoint(id="PipelineStartCheckProjectExtensionPoint", description="At the start of a pipeline, verify it lives in the active project", extensionPointId="PipelinePrepareExecution")
public class PipelineStartCheckProjectExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        String filename = pipeline.getFilename();
        try {
            ProjectsUtil.validateFileInProject(log, filename, pipeline);
        }
        catch (Exception e) {
            throw new HopException("Validation error against pipeline '" + filename + "' in active project", (Throwable)e);
        }
    }
}

