/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.io.CleanupWhenUnsuccessful;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class FileOutputFormat<IT>
extends RichOutputFormat<IT>
implements InitializeOnMaster,
CleanupWhenUnsuccessful {
    private static final long serialVersionUID = 1L;
    private static FileSystem.WriteMode DEFAULT_WRITE_MODE;
    private static OutputDirectoryMode DEFAULT_OUTPUT_DIRECTORY_MODE;
    private static final Logger LOG;
    @Deprecated
    public static final String FILE_PARAMETER_KEY = "flink.output.file";
    protected Path outputFilePath;
    private FileSystem.WriteMode writeMode;
    private OutputDirectoryMode outputDirectoryMode;
    protected transient FSDataOutputStream stream;
    private transient Path actualFilePath;
    private transient boolean fileCreated;

    public static void initDefaultsFromConfiguration(Configuration configuration) {
        boolean overwrite = configuration.get(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE);
        DEFAULT_WRITE_MODE = overwrite ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        boolean alwaysCreateDirectory = configuration.get(CoreOptions.FILESYSTEM_OUTPUT_ALWAYS_CREATE_DIRECTORY);
        DEFAULT_OUTPUT_DIRECTORY_MODE = alwaysCreateDirectory ? OutputDirectoryMode.ALWAYS : OutputDirectoryMode.PARONLY;
    }

    public FileOutputFormat() {
    }

    public FileOutputFormat(Path outputPath) {
        this.outputFilePath = outputPath;
    }

    public void setOutputFilePath(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Output file path may not be null.");
        }
        this.outputFilePath = path;
    }

    public Path getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setWriteMode(FileSystem.WriteMode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.writeMode = mode;
    }

    public FileSystem.WriteMode getWriteMode() {
        return this.writeMode;
    }

    public void setOutputDirectoryMode(OutputDirectoryMode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.outputDirectoryMode = mode;
    }

    public OutputDirectoryMode getOutputDirectoryMode() {
        return this.outputDirectoryMode;
    }

    @Override
    public void configure(Configuration parameters) {
        if (this.outputFilePath == null) {
            String filePath = parameters.getString(FILE_PARAMETER_KEY, null);
            if (filePath == null) {
                throw new IllegalArgumentException("The output path has been specified neither via constructor/setters, nor via the Configuration.");
            }
            try {
                this.outputFilePath = new Path(filePath);
            }
            catch (RuntimeException rex) {
                throw new RuntimeException("Could not create a valid URI from the given file path name: " + rex.getMessage());
            }
        }
        if (this.writeMode == null) {
            this.writeMode = DEFAULT_WRITE_MODE;
        }
        if (this.outputDirectoryMode == null) {
            this.outputDirectoryMode = DEFAULT_OUTPUT_DIRECTORY_MODE;
        }
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        Path p;
        if (taskNumber < 0 || numTasks < 1) {
            throw new IllegalArgumentException("TaskNumber: " + taskNumber + ", numTasks: " + numTasks);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening stream for output (" + (taskNumber + 1) + "/" + numTasks + "). WriteMode=" + (Object)((Object)this.writeMode) + ", OutputDirectoryMode=" + (Object)((Object)this.outputDirectoryMode));
        }
        if ((p = this.outputFilePath) == null) {
            throw new IOException("The file path is null.");
        }
        FileSystem fs = p.getFileSystem();
        if (!fs.isDistributedFS()) {
            if (numTasks == 1 && this.outputDirectoryMode == OutputDirectoryMode.PARONLY) {
                if (!fs.initOutPathLocalFS(p, this.writeMode, false)) {
                    throw new IOException("Output path '" + p.toString() + "' could not be initialized. Canceling task...");
                }
            } else if (!fs.initOutPathLocalFS(p, this.writeMode, true)) {
                throw new IOException("Output directory '" + p.toString() + "' could not be created. Canceling task...");
            }
        }
        this.actualFilePath = numTasks > 1 || this.outputDirectoryMode == OutputDirectoryMode.ALWAYS ? p.suffix("/" + this.getDirectoryFileName(taskNumber)) : p;
        this.stream = fs.create(this.actualFilePath, this.writeMode);
        this.fileCreated = true;
    }

    protected String getDirectoryFileName(int taskNumber) {
        return Integer.toString(taskNumber + 1);
    }

    @Override
    public void close() throws IOException {
        FSDataOutputStream s = this.stream;
        if (s != null) {
            this.stream = null;
            s.close();
        }
    }

    @Override
    public void initializeGlobal(int parallelism) throws IOException {
        Path path = this.getOutputFilePath();
        FileSystem fs = path.getFileSystem();
        if (fs.isDistributedFS()) {
            FileSystem.WriteMode writeMode = this.getWriteMode();
            OutputDirectoryMode outDirMode = this.getOutputDirectoryMode();
            if (parallelism == 1 && outDirMode == OutputDirectoryMode.PARONLY) {
                if (!fs.initOutPathDistFS(path, writeMode, false)) {
                    throw new IOException("Output path could not be initialized.");
                }
            } else if (!fs.initOutPathDistFS(path, writeMode, true)) {
                throw new IOException("Output directory could not be created.");
            }
        }
    }

    @Override
    public void tryCleanupOnError() {
        if (this.fileCreated) {
            this.fileCreated = false;
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Could not properly close FileOutputFormat.", (Throwable)e);
            }
            try {
                FileSystem.get(this.actualFilePath.toUri()).delete(this.actualFilePath, false);
            }
            catch (FileNotFoundException e) {
            }
            catch (Throwable t) {
                LOG.error("Could not remove the incomplete file " + this.actualFilePath + '.', t);
            }
        }
    }

    static {
        FileOutputFormat.initDefaultsFromConfiguration(GlobalConfiguration.loadConfiguration());
        LOG = LoggerFactory.getLogger(FileOutputFormat.class);
    }

    public static enum OutputDirectoryMode {
        ALWAYS,
        PARONLY;

    }
}

