/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.bag;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure2;
import org.eclipse.collections.impl.multimap.AbstractMutableMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.bag.ImmutableBagMultimapImpl;
import org.eclipse.collections.impl.multimap.bag.SynchronizedBagMultimap;

public abstract class AbstractMutableBagMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableBag<V>>
implements MutableBagMultimap<K, V> {
    protected AbstractMutableBagMultimap() {
    }

    protected AbstractMutableBagMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    protected AbstractMutableBagMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    protected AbstractMutableBagMultimap(int size) {
        super(size);
    }

    public MutableBagMultimap<K, V> toMutable() {
        MutableBagMultimap mutableBagMultimap = this.newEmpty();
        mutableBagMultimap.putAll((Multimap)this);
        return mutableBagMultimap;
    }

    public ImmutableBagMultimap<K, V> toImmutable() {
        MutableMap result = this.createMapWithKeyCount(this.map.size());
        this.map.forEachKeyValue((Procedure2 & Serializable)(key, bag) -> {
            ImmutableBag cfr_ignored_0 = (ImmutableBag)result.put(key, (Object)bag.toImmutable());
        });
        return new ImmutableBagMultimapImpl(result);
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        return this.collectKeyMultiValues(keyFunction, valueFunction, HashBagMultimap.newMultimap());
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        int keysCount = this.map.size();
        out.writeInt(keysCount);
        this.map.forEachKeyValue((Procedure2)new CheckedProcedure2<K, MutableBag<V>>(){

            @Override
            public void safeValue(K key, MutableBag<V> bag) throws IOException {
                out.writeObject(key);
                out.writeInt(bag.sizeDistinct());
                bag.forEachWithOccurrences((ObjectIntProcedure)new CheckedObjectIntProcedure<V>(){

                    @Override
                    public void safeValue(V value, int count) throws IOException {
                        out.writeObject(value);
                        out.writeInt(count);
                    }
                });
            }
        });
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int keyCount = in.readInt();
        this.map = this.createMapWithKeyCount(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object key = in.readObject();
            int valuesSize = in.readInt();
            MutableBag bag = (MutableBag)this.createCollection();
            for (int j = 0; j < valuesSize; ++j) {
                Object value = in.readObject();
                int count = in.readInt();
                bag.addOccurrences(value, count);
            }
            this.putAll(key, bag);
        }
    }

    public void forEachKeyMutableBag(Procedure2<? super K, ? super MutableBag<V>> procedure) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, value) -> procedure.value(key, (Object)value.asUnmodifiable()));
    }

    public void putOccurrences(K key, V value, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            MutableBag bag = (MutableBag)this.map.getIfAbsentPutWith(key, this.createCollectionBlock(), (Object)this);
            bag.addOccurrences(value, occurrences);
            this.addToTotalSize(occurrences);
        }
    }

    public MutableBagMultimap<K, V> asSynchronized() {
        return SynchronizedBagMultimap.of(this);
    }
}

