/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.grpclb;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.InternalServiceProviders;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.NameResolver;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.NameResolverProvider;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.grpclb.GrpclbNameResolver;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.internal.GrpcUtil;

final class SecretGrpclbNameResolverProvider {
    private SecretGrpclbNameResolverProvider() {
    }

    public static final class Provider
    extends NameResolverProvider {
        private static final String SCHEME = "dns";
        private static final boolean IS_ANDROID = InternalServiceProviders.isAndroid(SecretGrpclbNameResolverProvider.class.getClassLoader());

        @Override
        public GrpclbNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (SCHEME.equals(targetUri.getScheme())) {
                String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
                Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
                String name = targetPath.substring(1);
                return new GrpclbNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), IS_ANDROID);
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            return SCHEME;
        }

        @Override
        protected boolean isAvailable() {
            return true;
        }

        @Override
        public int priority() {
            return 6;
        }

        @Override
        public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
            return Collections.singleton(InetSocketAddress.class);
        }
    }
}

