/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerowsbyhashset;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.UniqueRowsByHashSetMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniqueRowsByHashSetDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = UniqueRowsByHashSetMeta.class;
    private final UniqueRowsByHashSetMeta input;
    private TableView wFields;
    private Button wStoreValues;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;
    private Button wRejectDuplicateRow;
    private Label wlErrorDesc;
    private TextVar wErrorDesc;

    public UniqueRowsByHashSetDialog(Shell parent, IVariables variables, UniqueRowsByHashSetMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.Settings.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)settingsgroupLayout);
        Label wlStoreValues = new Label((Composite)wSettings, 131072);
        wlStoreValues.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.StoreValues.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStoreValues);
        FormData fdlStoreValues = new FormData();
        fdlStoreValues.left = new FormAttachment(0, 0);
        fdlStoreValues.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlStoreValues.right = new FormAttachment(middle, -margin);
        wlStoreValues.setLayoutData((Object)fdlStoreValues);
        this.wStoreValues = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wStoreValues);
        this.wStoreValues.setToolTipText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.StoreValues.ToolTip", (String[])new String[]{Const.CR}));
        FormData fdStoreValues = new FormData();
        fdStoreValues.left = new FormAttachment(middle, 0);
        fdStoreValues.top = new FormAttachment((Control)wlStoreValues, 0, 0x1000000);
        this.wStoreValues.setLayoutData((Object)fdStoreValues);
        this.wStoreValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UniqueRowsByHashSetDialog.this.input.setChanged();
            }
        });
        Label wlRejectDuplicateRow = new Label((Composite)wSettings, 131072);
        wlRejectDuplicateRow.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.RejectDuplicateRow.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRejectDuplicateRow);
        FormData fdlRejectDuplicateRow = new FormData();
        fdlRejectDuplicateRow.left = new FormAttachment(0, 0);
        fdlRejectDuplicateRow.top = new FormAttachment((Control)this.wStoreValues, margin);
        fdlRejectDuplicateRow.right = new FormAttachment(middle, -margin);
        wlRejectDuplicateRow.setLayoutData((Object)fdlRejectDuplicateRow);
        this.wRejectDuplicateRow = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wRejectDuplicateRow);
        this.wRejectDuplicateRow.setToolTipText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.RejectDuplicateRow.ToolTip", (String[])new String[]{Const.CR}));
        FormData fdRejectDuplicateRow = new FormData();
        fdRejectDuplicateRow.left = new FormAttachment(middle, 0);
        fdRejectDuplicateRow.top = new FormAttachment((Control)wlRejectDuplicateRow, 0, 0x1000000);
        this.wRejectDuplicateRow.setLayoutData((Object)fdRejectDuplicateRow);
        this.wRejectDuplicateRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UniqueRowsByHashSetDialog.this.input.setChanged();
                UniqueRowsByHashSetDialog.this.setErrorDesc();
            }
        });
        this.wlErrorDesc = new Label((Composite)wSettings, 16384);
        this.wlErrorDesc.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.ErrorDescription.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorDesc);
        FormData fdlErrorDesc = new FormData();
        fdlErrorDesc.left = new FormAttachment((Control)this.wRejectDuplicateRow, margin);
        fdlErrorDesc.top = new FormAttachment((Control)this.wStoreValues, margin);
        this.wlErrorDesc.setLayoutData((Object)fdlErrorDesc);
        this.wErrorDesc = new TextVar(this.variables, (Composite)wSettings, 18436);
        PropsUi.setLook((Widget)this.wErrorDesc);
        this.wErrorDesc.addModifyListener(lsMod);
        FormData fdErrorDesc = new FormData();
        fdErrorDesc.left = new FormAttachment((Control)this.wlErrorDesc, margin);
        fdErrorDesc.top = new FormAttachment((Control)this.wStoreValues, margin);
        fdErrorDesc.right = new FormAttachment(100, 0);
        this.wErrorDesc.setLayoutData((Object)fdErrorDesc);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.Get.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wSettings, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getCompareFields() == null ? 0 : this.input.getCompareFields().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet.addListener(13, e -> this.get());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.setErrorDesc();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setErrorDesc() {
        this.wlErrorDesc.setEnabled(this.wRejectDuplicateRow.getSelection());
        this.wErrorDesc.setEnabled(this.wRejectDuplicateRow.getSelection());
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        this.wStoreValues.setSelection(this.input.getStoreValues());
        this.wRejectDuplicateRow.setSelection(this.input.isRejectDuplicateRow());
        if (this.input.getErrorDescription() != null) {
            this.wErrorDesc.setText(this.input.getErrorDescription());
        }
        for (int i = 0; i < this.input.getCompareFields().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getCompareFields()[i] == null) continue;
            item.setText(1, this.input.getCompareFields()[i]);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getCompareFields()[i] = item.getText(1);
        }
        this.transformName = this.wTransformName.getText();
        this.input.setStoreValues(this.wStoreValues.getSelection());
        this.input.setRejectDuplicateRow(this.wRejectDuplicateRow.getSelection());
        this.input.setErrorDescription(this.wErrorDesc.getText());
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

