/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.poi;

import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.pipeline.transforms.excelinput.poi.PoiCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PoiSheet
implements IKSheet {
    private Sheet sheet;

    public PoiSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public IKCell[] getRow(int rownr) {
        if (rownr < this.sheet.getFirstRowNum()) {
            return new IKCell[0];
        }
        if (rownr > this.sheet.getLastRowNum()) {
            throw new ArrayIndexOutOfBoundsException("Read beyond last row: " + rownr);
        }
        Row row = this.sheet.getRow(rownr);
        if (row == null) {
            return new IKCell[0];
        }
        int cols = row.getLastCellNum();
        if (cols < 0) {
            return new IKCell[0];
        }
        IKCell[] xlsCells = new PoiCell[cols];
        for (int i = 0; i < cols; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            xlsCells[i] = new PoiCell(cell);
        }
        return xlsCells;
    }

    public int getRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    public IKCell getCell(int colnr, int rownr) {
        Row row = this.sheet.getRow(rownr);
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(colnr);
        if (cell == null) {
            return null;
        }
        return new PoiCell(cell);
    }
}

