/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.Index;
import io.github.spannm.jackcess.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class BlobAction
implements IFeedbackAction {
    private final Table table;
    private boolean containsBlob;
    private final Set<BlobKey> keys = new HashSet<BlobKey>();

    public BlobAction(Table _table, Object[] newValues) {
        this.table = _table;
        if (!BlobKey.hasPrimaryKey(_table)) {
            return;
        }
        Index pk = _table.getPrimaryKeyIndex();
        HashSet<String> hsKey = new HashSet<String>();
        for (Index.Column icl : pk.getColumns()) {
            hsKey.add(icl.getName());
        }
        HashSet<String> hsBlob = new HashSet<String>();
        int i = 0;
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (Column col : _table.getColumns()) {
            if (col.getType().equals((Object)DataType.OLE) && newValues[i] != null) {
                this.containsBlob = true;
                hsBlob.add(col.getName());
            }
            if (hsKey.contains(col.getName())) {
                keyMap.put(col.getName(), newValues[i]);
            }
            ++i;
        }
        for (String cln : hsBlob) {
            this.keys.add(new BlobKey(keyMap, this.table.getName(), cln));
        }
    }

    @Override
    public void doAction(ICommand toChange) throws SQLException {
        if (this.containsBlob) {
            UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
            Connection connHsqldb = conn.getHSQLDBConnection();
            for (BlobKey bkey : this.keys) {
                ArrayList<Object> values = new ArrayList<Object>(bkey.getKey().values());
                String sql = String.format("UPDATE %s SET %s=? WHERE %s", SQLConverter.escapeIdentifier(this.table.getName(), connHsqldb), SQLConverter.escapeIdentifier(bkey.getColumnName(), connHsqldb), bkey.getKey().keySet().stream().map(k -> SQLConverter.escapeIdentifier(k, connHsqldb) + " = ?").collect(Collectors.joining(" AND ")));
                conn.setFeedbackState(true);
                conn.setFeedbackState(true);
                try (PreparedStatement ps = connHsqldb.prepareStatement(sql);){
                    ps.setObject(1, bkey.getBytes());
                    int i = 2;
                    for (Object e : values) {
                        ps.setObject(i, e);
                        ++i;
                    }
                    ps.executeUpdate();
                    conn.setFeedbackState(false);
                }
            }
        }
    }
}

