/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.util;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import org.apache.cassandra.cql3.functions.types.LocalDate;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.serializers.TimestampSerializer;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.util.Compression;
import org.apache.hop.i18n.BaseMessages;

public class CassandraUtils {
    protected static final Class<?> PKG = CassandraUtils.class;

    public static String getCQLTypeForValueMeta(IValueMeta vm) {
        switch (vm.getType()) {
            case 2: {
                return "varchar";
            }
            case 6: {
                return "decimal";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "bigint";
            }
            case 1: {
                return "double";
            }
            case 3: 
            case 9: {
                return "timestamp";
            }
            case 7: 
            case 8: {
                return "blob";
            }
        }
        return "blob";
    }

    public static DataType getCassandraDataTypeFromValueMeta(IValueMeta vm) {
        switch (vm.getType()) {
            case 2: {
                return DataTypes.TEXT;
            }
            case 6: {
                return DataTypes.DECIMAL;
            }
            case 4: {
                return DataTypes.BOOLEAN;
            }
            case 5: {
                return DataTypes.BIGINT;
            }
            case 1: {
                return DataTypes.DOUBLE;
            }
            case 3: 
            case 9: {
                return DataTypes.TIMESTAMP;
            }
        }
        return DataTypes.BLOB;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> splitCQLStatements(String source) {
        String[] cqlStatements = source.split(";");
        ArrayList<String> individualStatements = new ArrayList<String>();
        for (String string : cqlStatements) {
            void var6_6;
            String string2 = string.trim();
            if (!string2.endsWith(";")) {
                String string3 = string2 + ";";
            }
            individualStatements.add((String)var6_6);
        }
        return individualStatements;
    }

    public static byte[] compressCQLQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(StandardCharsets.UTF_8);
        if (compression != Compression.GZIP) {
            return data;
        }
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        return byteArray.toByteArray();
    }

    public static String getTableNameFromCQLSelectQuery(String subQ) throws HopException {
        String result = null;
        if (Utils.isEmpty((CharSequence)subQ)) {
            throw new HopException("No query was specified");
        }
        if (!subQ.toLowerCase().startsWith("select")) {
            throw new HopException("This is not a SELECT statement");
        }
        if (subQ.indexOf(59) < 0) {
            throw new HopException("Please end the query expression with a ;");
        }
        if (subQ.toLowerCase().lastIndexOf("where") > 0) {
            subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
        }
        int fromIndex = subQ.toLowerCase().indexOf("from");
        String tempS = subQ.toLowerCase();
        int offset = fromIndex;
        while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
            tempS = tempS.substring(fromIndex + 4);
            fromIndex = tempS.indexOf("from");
            offset += 4 + fromIndex;
        }
        fromIndex = offset;
        if (fromIndex < 0) {
            throw new HopException("No FROM clause found in the query");
        }
        result = subQ.substring(fromIndex + 4).trim();
        result = result.replace(";", "");
        if ((result = result.replaceFirst("^\\s+", "").replaceFirst("\\s+$", "")).isEmpty()) {
            throw new HopException("No FROM clause found in the query");
        }
        return result;
    }

    public static String rowToStringRepresentation(IRowMeta inputMeta, Object[] row) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < inputMeta.size(); ++i) {
            String sep;
            String string = sep = i > 0 ? "," : "";
            if (row[i] == null) {
                buff.append(sep).append("<null>");
                continue;
            }
            buff.append(sep).append(row[i].toString());
        }
        return buff.toString();
    }

    protected static boolean preAddChecks(IRowMeta inputMeta, List<String> keyColNames, Object[] row, ILogChannel log) throws HopException {
        for (String string : keyColNames) {
            int keyIndex = inputMeta.indexOfValue(string);
            IValueMeta keyMeta = inputMeta.getValueMeta(keyIndex);
            if (!keyMeta.isNull(row[keyIndex])) continue;
            log.logBasic(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.SkippingRowNullKey", (String[])new String[]{CassandraUtils.rowToStringRepresentation(inputMeta, row)}));
            return false;
        }
        StringBuilder fullKey = new StringBuilder();
        for (String keyN : keyColNames) {
            int keyIndex = inputMeta.indexOfValue(keyN);
            IValueMeta keyMeta = inputMeta.getValueMeta(keyIndex);
            fullKey.append(keyMeta.getString(row[keyIndex])).append(" ");
        }
        if (keyColNames.size() == 1) {
            boolean bl;
            boolean bl2 = false;
            for (int i = 0; i < inputMeta.size(); ++i) {
                IValueMeta v;
                String colName = inputMeta.getValueMeta(i).getName();
                if (keyColNames.contains(colName) || (v = inputMeta.getValueMeta(i)).isNull(row[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                log.logBasic(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.SkippingRowNoNonNullValues", (String[])new String[]{fullKey.toString()}));
            }
            return bl;
        }
        return true;
    }

    public static List<Object[]> newNonCQLBatch(int numRows) {
        return new ArrayList<Object[]>(numRows);
    }

    public static boolean addRowToNonCQLBatch(List<Object[]> batch, Object[] row, IRowMeta inputMeta, ITableMetaData familyMeta, boolean insertFieldsNotInMetaData, ILogChannel log) throws Exception {
        if (!CassandraUtils.preAddChecks(inputMeta, familyMeta.getKeyColumnNames(), row, log)) {
            return false;
        }
        for (int i = 0; i < inputMeta.size(); ++i) {
            IValueMeta colMeta = inputMeta.getValueMeta(i);
            String colName = colMeta.getName();
            if (familyMeta.columnExistsInSchema(colName) || insertFieldsNotInMetaData) continue;
            row[i] = null;
        }
        batch.add(row);
        return true;
    }

    public static StringBuilder newCQLBatch(int numRows, boolean unloggedBatch) {
        StringBuilder batch = new StringBuilder(numRows * 80);
        if (unloggedBatch) {
            batch.append("BEGIN UNLOGGED BATCH");
        } else {
            batch.append("BEGIN BATCH");
        }
        batch.append("\n");
        return batch;
    }

    public static void completeCQLBatch(StringBuilder batch) {
        batch.append("APPLY BATCH");
    }

    public static String identifierQuoteChar(int cqlMajVersion) {
        if (cqlMajVersion >= 3) {
            return "\"";
        }
        return "'";
    }

    public static boolean addRowToCQLBatch(StringBuilder batch, String tableName, IRowMeta inputMeta, Object[] row, ITableMetaData familyMeta, boolean insertFieldsNotInMetaData, int cqlMajVersion, Map<String, String> additionalOpts, ILogChannel log) throws Exception {
        if (!CassandraUtils.preAddChecks(inputMeta, familyMeta.getKeyColumnNames(), row, log)) {
            return false;
        }
        String quoteChar = CassandraUtils.identifierQuoteChar(cqlMajVersion);
        HashMap<String, String> columnValues = new HashMap<String, String>();
        for (int i = 0; i < inputMeta.size(); ++i) {
            IValueMeta colMeta = inputMeta.getValueMeta(i);
            String colName = colMeta.getName();
            if (!familyMeta.columnExistsInSchema(colName) && !insertFieldsNotInMetaData || colMeta.isNull(row[i])) continue;
            columnValues.put(colName, CassandraUtils.hopValueToCql(colMeta, row[i], cqlMajVersion));
        }
        tableName = CassandraUtils.cql3MixedCaseQuote(tableName);
        Set columnOrder = columnValues.keySet();
        ArrayList<CallSite> columns = new ArrayList<CallSite>(columnOrder.size());
        ArrayList<String> values = new ArrayList<String>(columnOrder.size());
        for (String column : columnOrder) {
            columns.add((CallSite)((Object)(quoteChar + column + quoteChar)));
            values.add((String)columnValues.get(column));
        }
        Joiner joiner = Joiner.on((char)',').skipNulls();
        batch.append("INSERT INTO ").append(tableName).append(" (");
        joiner.appendTo(batch, columns);
        batch.append(") VALUES (");
        joiner.appendTo(batch, values);
        batch.append(")");
        if (CassandraUtils.containsInsertOptions(additionalOpts)) {
            batch.append(" USING ");
            boolean first = true;
            for (Map.Entry<String, String> o : additionalOpts.entrySet()) {
                if (!CassandraUtils.validInsertOption(o.getKey())) continue;
                if (first) {
                    batch.append(o.getKey()).append(" ").append(o.getValue());
                    first = false;
                    continue;
                }
                batch.append(" AND ").append(o.getKey()).append(" ").append(o.getValue());
            }
        }
        batch.append("\n");
        return true;
    }

    protected static boolean validInsertOption(String opt) {
        return opt.equalsIgnoreCase("ttl") || opt.equalsIgnoreCase("timestamp");
    }

    protected static boolean containsInsertOptions(Map<String, String> opts) {
        for (String opt : opts.keySet()) {
            if (!CassandraUtils.validInsertOption(opt)) continue;
            return true;
        }
        return false;
    }

    protected static String escapeSingleQuotes(String source) {
        return source.replace("'", "''");
    }

    public static String removeQuotes(String source) {
        String result = source;
        result = source.startsWith("\"") && source.endsWith("\"") ? result.substring(1, result.length() - 1) : result.toLowerCase();
        return result;
    }

    public static String cql3MixedCaseQuote(String source) {
        if (source.toLowerCase().equals(source) || source.startsWith("\"") && source.endsWith("\"")) {
            return source;
        }
        return "\"" + source + "\"";
    }

    public static String hopValueToCql(IValueMeta vm, Object value, int cqlMajVersion) throws HopValueException {
        String quote = cqlMajVersion == 2 ? "'" : "";
        switch (vm.getType()) {
            case 2: {
                UTF8Type u = UTF8Type.instance;
                String toConvert = vm.getString(value);
                ByteBuffer decomposed = u.decompose((Object)toConvert);
                String cassandraString = u.getString(decomposed);
                return "'" + CassandraUtils.escapeSingleQuotes(cassandraString) + "'";
            }
            case 6: {
                DecimalType dt = DecimalType.instance;
                BigDecimal toConvert = vm.getBigNumber(value);
                ByteBuffer decomposed = dt.decompose((Object)toConvert);
                String cassandraString = dt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 4: {
                BooleanType bt = BooleanType.instance;
                Boolean toConvert = vm.getBoolean(value);
                ByteBuffer decomposed = bt.decompose((Object)toConvert);
                String cassandraString = bt.getString(decomposed);
                return quote + CassandraUtils.escapeSingleQuotes(cassandraString) + quote;
            }
            case 5: {
                LongType lt = LongType.instance;
                Long toConvert = vm.getInteger(value);
                ByteBuffer decomposed = lt.decompose((Object)toConvert);
                String cassandraString = lt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 1: {
                DoubleType dt = DoubleType.instance;
                Double toConvert = vm.getNumber(value);
                ByteBuffer decomposed = dt.decompose((Object)toConvert);
                String cassandraString = dt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 3: 
            case 9: {
                TimestampSerializer ts = TimestampSerializer.instance;
                Date toConvert = vm.getDate(value);
                String cassandraFormattedDateString = ts.toStringUTC(toConvert);
                return "'" + CassandraUtils.escapeSingleQuotes(cassandraFormattedDateString) + "'";
            }
            case 7: 
            case 8: {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.CantConvertBinaryToCQL", (String[])new String[0]));
            }
        }
        throw new HopValueException(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.CantConvertType", (String[])new String[]{vm.getName(), vm.getTypeDesc()}));
    }

    public static String optionsToString(Map<String, String> opts) {
        if (opts.isEmpty()) {
            return "";
        }
        StringBuilder optsBuilder = new StringBuilder();
        for (Map.Entry<String, String> e : opts.entrySet()) {
            optsBuilder.append(e.getKey()).append("=").append(e.getValue()).append(" ");
        }
        return optsBuilder.toString();
    }

    public static DriverConnection getCassandraConnection(String hosts, int port, String localDataCenter, String username, String password, Map<String, String> opts) {
        DriverConnection conn = new DriverConnection();
        conn.setHosts(hosts);
        conn.setDefaultPort(port);
        conn.setLocalDataCenter(localDataCenter);
        conn.setUsername(username);
        conn.setPassword(password);
        conn.setAdditionalOptions(opts);
        return conn;
    }

    public static String[] getColumnNames(IRowMeta inputMeta) {
        String[] columns = new String[inputMeta.size()];
        for (int i = 0; i < inputMeta.size(); ++i) {
            columns[i] = inputMeta.getValueMeta(i).getName();
        }
        return columns;
    }

    public static IPartitioner getPartitionerClassInstance(String partitionerClass) {
        switch (partitionerClass) {
            case "org.apache.cassandra.dht.Murmur3Partitioner": {
                return Murmur3Partitioner.instance;
            }
            case "org.apache.cassandra.dht.ByteOrderedPartitioner": {
                return ByteOrderedPartitioner.instance;
            }
            case "org.apache.cassandra.dht.RandomPartitioner": {
                return RandomPartitioner.instance;
            }
            case "org.apache.cassandra.dht.OrderPreservingPartitioner": {
                return OrderPreservingPartitioner.instance;
            }
        }
        return null;
    }

    public static List<Object[]> fixBatchMismatchedTypes(List<Object[]> batch, IRowMeta inputMeta, ITableMetaData cassandraMeta) {
        if (cassandraMeta != null) {
            List<String> colNames = cassandraMeta.getColumnNames();
            for (int i = 0; i < batch.size(); ++i) {
                for (int j = 0; j < batch.get(i).length; ++j) {
                    String dateCql;
                    DataType dataType;
                    String typeCql;
                    if (batch.get(i)[j] == null || !(typeCql = (dataType = cassandraMeta.getColumnCQLType(colNames.get(j))).asCql(true, false)).equals(dateCql = DataTypes.DATE.asCql(true, false))) continue;
                    int index = inputMeta.indexOfValue(colNames.get(j));
                    if (batch.get(i)[index].getClass() != Date.class) continue;
                    Date d = (Date)batch.get(i)[index];
                    LocalDate ld = LocalDate.fromMillisSinceEpoch((long)d.getTime());
                    batch.get((int)i)[index] = ld;
                }
            }
        }
        return batch;
    }

    public static String getPartitionKey(String primaryKey) {
        String partitionKey = null;
        if (!Utils.isEmpty((CharSequence)primaryKey)) {
            partitionKey = !primaryKey.contains("(") && !primaryKey.contains(")") ? (primaryKey.contains(",") ? primaryKey.substring(0, primaryKey.indexOf(44)) : primaryKey) : CassandraUtils.getPartitionKeyIter(primaryKey, "", 0);
        }
        return partitionKey;
    }

    private static String getPartitionKeyIter(String primaryKey, String partitionKey, int parenLevel) {
        if (parenLevel == 0 && !partitionKey.isEmpty()) {
            return partitionKey;
        }
        if (primaryKey.charAt(0) == '(') {
            return CassandraUtils.getPartitionKeyIter(primaryKey.substring(1), partitionKey + primaryKey.charAt(0), ++parenLevel);
        }
        if (primaryKey.charAt(0) == ')') {
            return CassandraUtils.getPartitionKeyIter(primaryKey.substring(1), partitionKey + primaryKey.charAt(0), --parenLevel);
        }
        return CassandraUtils.getPartitionKeyIter(primaryKey.substring(1), partitionKey + primaryKey.charAt(0), parenLevel);
    }

    public static class BatchOptions {
        public static final String BATCH_TIMEOUT = "batchTimeout";
        public static final String TTL = "TTL";
    }

    public static class ConnectionOptions {
        public static final String SOCKET_TIMEOUT = "socketTimeout";
        public static final String MAX_LENGTH = "maxLength";
        public static final String COMPRESSION = "compression";
    }
}

