/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.databases.cassandra.datastax.DriverKeyspace;
import org.apache.hop.databases.cassandra.spi.CqlRowHandler;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.pipeline.transform.ITransform;

public class DriverCqlRowHandler
implements CqlRowHandler {
    private final CqlSession session;
    DriverKeyspace keyspace;
    ResultSet result;
    ColumnDefinitions columns;
    private boolean unloggedBatch = true;
    private int ttlSec;

    public DriverCqlRowHandler(DriverKeyspace keyspace, CqlSession session, boolean expandCollection) {
        this.keyspace = keyspace;
        this.session = session;
    }

    public DriverCqlRowHandler(DriverKeyspace keyspace) {
        this(keyspace, keyspace.getConnection().getSession(keyspace.getName()), true);
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = (DriverKeyspace)keyspace;
    }

    @Override
    public void newRowQuery(ITransform requestingTransform, String tableName, String cqlQuery, String compress, String consistencyLevel, ILogChannel log) throws Exception {
        this.result = this.getSession().execute(cqlQuery);
        this.columns = this.result.getColumnDefinitions();
    }

    @Override
    public Object[][] getNextOutputRow(IRowMeta outputRowMeta, Map<String, Integer> outputFormatMap) throws Exception {
        if (this.result == null || !this.result.iterator().hasNext()) {
            this.result = null;
            this.columns = null;
            return null;
        }
        Row row = (Row)this.result.one();
        Object[][] outputRowData = new Object[1][];
        Object[] baseOutputRowData = RowDataUtil.allocateRowData((int)Math.max(outputRowMeta.size(), this.columns.size()));
        for (int i = 0; i < this.columns.size(); ++i) {
            baseOutputRowData[i] = DriverCqlRowHandler.readValue(outputRowMeta.getValueMeta(i), row, i);
        }
        outputRowData[0] = baseOutputRowData;
        return outputRowData;
    }

    public static Object readValue(IValueMeta meta, Row row, int i) {
        if (row.isNull(i)) {
            return null;
        }
        switch (meta.getType()) {
            case 5: {
                return row.getLong(i);
            }
            case 1: {
                return row.getDouble(i);
            }
            case 6: {
                return row.get(i, GenericType.BIG_DECIMAL);
            }
            case 3: {
                return row.get(i, GenericType.of(Date.class));
            }
            case 9: {
                return row.get(i, GenericType.of(Timestamp.class));
            }
        }
        return row.getObject(i);
    }

    public static Object[] readRow(IRowMeta rowMeta, Row row) {
        Object[] hopRow = RowDataUtil.allocateRowData((int)rowMeta.size());
        for (int i = 0; i < rowMeta.size(); ++i) {
            IValueMeta valueMeta = rowMeta.getValueMeta(i);
            hopRow[i] = DriverCqlRowHandler.readValue(valueMeta, row, i);
        }
        return hopRow;
    }

    public void batchInsert(IRowMeta inputMeta, Iterable<Object[]> rows, ITableMetaData tableMeta, String consistencyLevel, boolean insertFieldsNotInMetadata) throws Exception {
        String[] columnNames = this.getColumnNames(inputMeta);
        InsertInto insertInto = QueryBuilder.insertInto((String)tableMeta.getTableName());
        RegularInsert insert = null;
        HashSet<Integer> excludedIndexes = new HashSet<Integer>();
        for (int index = 0; index < columnNames.length; ++index) {
            String columnName = columnNames[index];
            if (insertFieldsNotInMetadata || tableMeta.columnExistsInSchema(columnName)) {
                if (insert == null) {
                    insert = insertInto.value(columnName, (Term)QueryBuilder.bindMarker());
                    continue;
                }
                insert = insert.value(columnName, (Term)QueryBuilder.bindMarker());
                continue;
            }
            excludedIndexes.add(index);
        }
        if (insert == null) {
            throw new HopException("No fields found to insert");
        }
        BatchStatementBuilder batchBuilder = new BatchStatementBuilder(this.unloggedBatch ? BatchType.UNLOGGED : BatchType.LOGGED);
        PreparedStatement preparedInsert = this.getSession().prepare(insert.asCql());
        for (Object[] row : rows) {
            Object[] bindRow = new Object[columnNames.length - excludedIndexes.size()];
            int bindIndex = 0;
            for (int index = 0; index < columnNames.length; ++index) {
                if (excludedIndexes.contains(index)) continue;
                bindRow[bindIndex++] = row[index];
            }
            BoundStatement statement = preparedInsert.bind(bindRow);
            batchBuilder.addStatement((BatchableStatement)statement);
        }
        if (StringUtils.isNotEmpty((String)consistencyLevel)) {
            batchBuilder = (BatchStatementBuilder)batchBuilder.setConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)consistencyLevel));
        }
        BatchStatement batch = batchBuilder.build();
        this.session.execute((Statement)batch);
    }

    private String[] getColumnNames(IRowMeta inputMeta) {
        String[] columns = new String[inputMeta.size()];
        for (int i = 0; i < inputMeta.size(); ++i) {
            columns[i] = inputMeta.getValueMeta(i).getName();
        }
        return columns;
    }

    @Override
    public void commitCQLBatch(ITransform requestingTransform, StringBuilder batch, String compress, String consistencyLevel, ILogChannel log) throws Exception {
        throw new NotImplementedException();
    }

    public void setUnloggedBatch(boolean unloggedBatch) {
        this.unloggedBatch = unloggedBatch;
    }

    public boolean isUnloggedBatch() {
        return this.unloggedBatch;
    }

    private CqlSession getSession() {
        return this.session;
    }

    public void setTtlSec(int ttl) {
        this.ttlSec = ttl;
    }
}

