/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListDataEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class AS400ListModel
implements ListModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    VNode root_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    transient ListDataEventSupport listDataEventSupport_;
    private transient VObjectListener objectListener_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public AS400ListModel() {
        this.initializeTransient();
    }

    public AS400ListModel(VNode root) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.root_ = root;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listDataEventSupport_.addListDataListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Object getElementAt(int index) {
        if (this.root_ == null) {
            return null;
        }
        if (index < 0 || index >= this.root_.getDetailsChildCount()) {
            return null;
        }
        return this.root_.getDetailsChildAt(index);
    }

    public VNode getRoot() {
        return this.root_;
    }

    @Override
    public int getSize() {
        if (this.root_ == null) {
            return 0;
        }
        return this.root_.getDetailsChildCount();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listDataEventSupport_ = new ListDataEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.root_ != null) {
            this.root_.addErrorListener(this.errorEventSupport_);
            this.root_.addVObjectListener(this.objectListener_);
            this.root_.addWorkingListener(this.workingEventSupport_);
        }
    }

    public void load() {
        int previousCount = this.getSize();
        if (this.root_ != null) {
            this.root_.load();
            int rowCount = this.root_.getDetailsChildCount();
            for (int i = 0; i < rowCount; ++i) {
                VObject detailsChild = this.root_.getDetailsChildAt(i);
                if (detailsChild == null) continue;
                this.root_.getDetailsChildAt(i);
            }
        }
        this.listDataEventSupport_.fireIntervalRemoved(0, previousCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listDataEventSupport_.removeListDataListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setRoot(VNode root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        VNode oldValue = this.root_;
        VNode newValue = root;
        this.vetoableChangeSupport_.fireVetoableChange("root", oldValue, newValue);
        if (oldValue != newValue) {
            int oldSize = this.root_ == null ? 0 : this.root_.getDetailsChildCount();
            if (oldValue != null) {
                oldValue.removeErrorListener(this.errorEventSupport_);
                oldValue.removeVObjectListener(this.objectListener_);
                oldValue.removeWorkingListener(this.workingEventSupport_);
            }
            newValue.addErrorListener(this.errorEventSupport_);
            newValue.addVObjectListener(this.objectListener_);
            newValue.addWorkingListener(this.workingEventSupport_);
            this.root_ = newValue;
            this.listDataEventSupport_.fireContentsChanged(0, oldSize);
        }
        this.propertyChangeSupport_.firePropertyChange("root", oldValue, newValue);
    }

    public void sort(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
        if (this.root_ != null && this.root_.isSortable()) {
            this.root_.sortDetailsChildren(propertyIdentifiers, orders);
            this.listDataEventSupport_.fireContentsChanged(0, this.getSize());
        }
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        @Override
        public void objectChanged(VObjectEvent event) {
            VObject object = event.getObject();
            if (object == AS400ListModel.this.root_) {
                if (!event.isDuringLoad()) {
                    AS400ListModel.this.load();
                }
                AS400ListModel.this.listDataEventSupport_.fireContentsChanged(0, AS400ListModel.this.root_.getDetailsChildCount());
            } else {
                int index = AS400ListModel.this.root_.getDetailsIndex(object);
                if (index >= 0) {
                    AS400ListModel.this.listDataEventSupport_.fireContentsChanged(index, index);
                }
            }
        }

        @Override
        public void objectCreated(VObjectEvent event) {
            int index;
            VObject object = event.getObject();
            VNode parent = event.getParent();
            if (parent == AS400ListModel.this.root_ && (index = AS400ListModel.this.root_.getDetailsIndex(object)) >= 0) {
                AS400ListModel.this.listDataEventSupport_.fireIntervalAdded(index, index);
            }
        }

        @Override
        public void objectDeleted(VObjectEvent event) {
            VObject object = event.getObject();
            int index = AS400ListModel.this.root_.getDetailsIndex(object);
            if (index >= 0) {
                AS400ListModel.this.listDataEventSupport_.fireIntervalRemoved(index, index);
            }
        }
    }
}

