/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinterFile;
import com.ibm.as400.access.NPCPSelPrtF;
import com.ibm.as400.access.PrintObjectList;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrinterFile;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.Serializable;

public class PrinterFileList
extends PrintObjectList<PrinterFile>
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRINTER_FILE_FILTER = "printerFileFilter";

    public PrinterFileList() {
        super(5, new NPCPSelPrtF());
    }

    public PrinterFileList(AS400 system) {
        super(5, new NPCPSelPrtF(), system);
    }

    @Override
    void chooseImpl() {
        AS400 system = this.getSystem();
        if (system == null) {
            Trace.log(2, "Attempt to use PrinterFileList before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectListImpl)system.loadImpl2("com.ibm.as400.access.PrinterFileListImplRemote", "com.ibm.as400.access.PrinterFileListImplProxy");
        super.setImpl();
    }

    public String getPrinterFileFilter() {
        NPCPSelPrtF selectionCP = (NPCPSelPrtF)this.getSelectionCP();
        return selectionCP.getPrinterFile();
    }

    @Override
    PrinterFile newNPObject(NPCPID cpid, NPCPAttribute cpattr) {
        return new PrinterFile(this.system_, (NPCPIDPrinterFile)cpid, cpattr);
    }

    public void setPrinterFileFilter(String printerFileFilter) throws PropertyVetoException {
        if (printerFileFilter == null) {
            Trace.log(2, "Parameter 'printerFileFilter' is null");
            throw new NullPointerException(PRINTER_FILE_FILTER);
        }
        String oldPrinterFileFilter = this.getPrinterFileFilter();
        this.vetos.fireVetoableChange(PRINTER_FILE_FILTER, oldPrinterFileFilter, printerFileFilter);
        NPCPSelPrtF selectionCP = (NPCPSelPrtF)this.getSelectionCP();
        selectionCP.setPrinterFile(printerFileFilter);
        if (this.impl_ != null) {
            this.impl_.setFilter("printerFile", printerFileFilter);
        }
        this.changes.firePropertyChange(PRINTER_FILE_FILTER, oldPrinterFileFilter, printerFileFilter);
    }
}

