/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyFactoryImpl;
import com.ibm.as400.access.ProxyReturnValue;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;

class JDReaderProxy
extends Reader
implements ProxyFactoryImpl {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private long pxId_;
    private ProxyClientConnection connection_;
    private static final boolean[] ARGS_TO_RETURN = new boolean[]{true, false, false};

    JDReaderProxy() {
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    protected void finalize() throws Throwable {
        this.connection_.callFinalize(this.pxId_);
        super.finalize();
    }

    @Override
    public void initialize(long proxyId, ProxyClientConnection connection) {
        this.pxId_ = proxyId;
        this.connection_ = connection;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "mark", new Class[]{Integer.TYPE}, new Object[]{readAheadLimit});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "markSupported");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, "read");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "read", new Class[]{char[].class, Integer.TYPE, Integer.TYPE}, new Object[]{cbuf, off, len}, ARGS_TO_RETURN, false);
            char[] returnDataBuffer = (char[])rv.getArgument(0);
            System.arraycopy(returnDataBuffer, 0, cbuf, 0, cbuf.length);
            return rv.getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public boolean ready() throws IOException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "ready");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "reset");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.connection_.callMethod(this.pxId_, "skip", new Class[]{Long.TYPE}, new Object[]{n}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

