/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMEXCSATReplyDataStream
extends DDMDataStream {
    DDMEXCSATReplyDataStream() {
    }

    boolean checkReply() {
        if (this.getCodePoint() != 5187) {
            String text;
            Trace.log(2, "DDM EXCSAT failed with code point:", this.data_, 8, 2);
            switch (this.getCodePoint()) {
                case 4658: {
                    text = "Permanent agent error.";
                    break;
                }
                case 4636: {
                    text = "Not authorized to command.";
                    break;
                }
                case 4692: {
                    text = "Command check.";
                    break;
                }
                case 4688: {
                    text = "Command not supported.";
                    break;
                }
                case 4689: {
                    text = "Parameter not supported.";
                    break;
                }
                case 8730: {
                    text = "RDB access failed reply message.";
                    break;
                }
                case 8707: {
                    text = "Not authorized to RDB.";
                    break;
                }
                case 4684: {
                    text = "Data stream syntax error.";
                    break;
                }
                default: {
                    text = null;
                }
            }
            if (text != null) {
                Trace.log(2, text);
            }
            return false;
        }
        return true;
    }

    byte[] getEXTNAM() {
        byte[] extNam = null;
        int offset = 6;
        int streamLL = this.get16bit(offset);
        if (streamLL <= 4) {
            if (Trace.traceOn_) {
                Trace.log(4, "Insufficient reply length: 0x" + Integer.toHexString(streamLL));
            }
            return new byte[0];
        }
        offset += 4;
        while (offset <= this.data_.length - 4) {
            int termLL = this.get16bit(offset);
            int termCP = this.get16bit(offset + 2);
            switch (termCP) {
                case 4446: {
                    if (termLL > 4) {
                        extNam = new byte[termLL - 4];
                        System.arraycopy(this.data_, offset + 4, extNam, 0, extNam.length);
                        break;
                    }
                    if (!Trace.traceOn_) break;
                    Trace.log(4, "No data returned in EXTNAM term.");
                }
            }
            offset += termLL;
        }
        return extNam == null ? new byte[]{} : extNam;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM EXCSAT Reply...");
        }
        if (this.readFromStream(in, header = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM EXCSAT reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 6);
        this.readAfterHeader(in);
    }
}

