/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class AS400Time
extends AS400AbstractTime {
    static final long serialVersionUID = 4L;
    private Time defaultValue_;
    private static Hashtable formatsMap_;
    public static final Time MIN_VALUE;
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    public static final Time MAX_VALUE;
    public static final int FORMAT_HMS = 100;
    public static final int FORMAT_ISO = 101;
    public static final int FORMAT_USA = 102;
    public static final int FORMAT_EUR = 103;
    public static final int FORMAT_JIS = 104;
    private static final int FORMAT_RANGE_MINIMUM = 100;
    private static final int FORMAT_RANGE_MAXIMUM = 104;

    public AS400Time() {
        this(101);
    }

    public AS400Time(TimeZone timeZone) {
        this(timeZone, 101);
    }

    public AS400Time(int format) {
        this.setFormat(format, this.defaultSeparatorFor(format));
    }

    public AS400Time(TimeZone timeZone, int format) {
        super(timeZone);
        this.setFormat(format, this.defaultSeparatorFor(format));
    }

    public AS400Time(int format, Character separator) {
        this.setFormat(format, separator);
    }

    public AS400Time(TimeZone timeZone, int format, Character separator) {
        super(timeZone);
        this.setFormat(format, separator);
    }

    @Override
    public int getFormat() {
        return super.getFormat();
    }

    @Override
    public Character getSeparator() {
        return super.getSeparator();
    }

    @Override
    public void setFormat(int format) {
        super.setFormat(format, this.defaultSeparatorFor(format));
    }

    void setFormat(String format) {
        super.setFormat(AS400Time.toFormat(format));
    }

    @Override
    void setSeparator(Character separator) {
        super.setSeparator(separator);
    }

    @Override
    public void setFormat(int format, Character separator) {
        super.setFormat(format, separator);
    }

    public void setFormat(int format, char separator) {
        super.setFormat(format, Character.valueOf(separator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Hashtable getFormatsMap() {
        if (formatsMap_ != null) return formatsMap_;
        Class<AS400Time> clazz = AS400Time.class;
        synchronized (AS400Time.class) {
            if (formatsMap_ != null) return formatsMap_;
            formatsMap_ = new Hashtable(12);
            formatsMap_.put("HMS", 100);
            formatsMap_.put("ISO", 101);
            formatsMap_.put("USA", 102);
            formatsMap_.put("EUR", 103);
            formatsMap_.put("JIS", 104);
            // ** MonitorExit[var0] (shouldn't be in output)
            return formatsMap_;
        }
    }

    public static int toFormat(String formatName) {
        if (formatName == null || formatName.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Time.toFormat(" + formatName + "): Returning default time format.");
            }
            return 101;
        }
        Integer formatInt = (Integer)AS400Time.getFormatsMap().get(formatName.trim().toUpperCase());
        if (formatInt == null) {
            throw new ExtendedIllegalArgumentException("format (" + formatName + ")", 2);
        }
        return formatInt;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new Time(0L);
        }
        return this.defaultValue_;
    }

    @Override
    public int getInstanceType() {
        return 18;
    }

    @Override
    public Class getJavaType() {
        return Time.class;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        return super.toBytes(javaValue, as400Value, offset);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        if (as400Value == null) {
            throw new NullPointerException("as400Value");
        }
        String timeString = this.getCharConverter().byteArrayToString(as400Value, offset, this.getLength());
        return this.parse(timeString);
    }

    @Override
    public String toString(Object javaValue) {
        Time timeObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timeObj = (Time)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        return this.getDateFormatter().format(timeObj);
    }

    public Time parse(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            SimpleDateFormat formatter = this.getDateFormatter();
            Date dateObj = formatter.parse(source);
            long milliseconds = dateObj.getTime();
            Time time = new Time(milliseconds);
            return time;
        }
        catch (Exception e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Time string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()));
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2);
        }
    }

    public static Time parseXsdString(String source) {
        return AS400Time.parseXsdString(source, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static Time parseXsdString(String source, TimeZone timeZone) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        try {
            Date simpleDateObj = AS400Time.getTimeFormatterXSD(timeZone).parse(source);
            long milliseconds = simpleDateObj.getTime();
            Time returnTime = new Time(milliseconds);
            return returnTime;
        }
        catch (ParseException e) {
            Trace.log(2, e.getMessage(), source);
            Trace.log(2, "Value is expected to be in standard XML Schema 'time' format: HH:mm:ss");
            throw new ExtendedIllegalArgumentException("source (" + source + ")", 2);
        }
    }

    public static String toXsdString(Object javaValue) {
        return AS400Time.toXsdString(javaValue, TIMEZONE_GMT);
    }

    public static String toXsdString(Object javaValue, TimeZone timeZone) {
        Time timeObj;
        if (javaValue == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timeObj = (Time)javaValue;
        }
        catch (ClassCastException e) {
            Trace.log(2, "javaValue is of type " + javaValue.getClass().getName());
            throw e;
        }
        return AS400Time.getTimeFormatterXSD(timeZone).format(timeObj);
    }

    @Override
    String patternFor(int format, Character separator) {
        String sep = separator == null ? "" : separator.toString();
        switch (format) {
            case 102: {
                String sep2 = sep.equals("") ? "" : " ";
                return "hh" + sep + "mm" + sep2 + "a";
            }
        }
        return "HH" + sep + "mm" + sep + "ss";
    }

    @Override
    Character defaultSeparatorFor(int format) {
        if (!this.isValidFormat(format)) {
            throw new ExtendedIllegalArgumentException("format (" + format + ")", 2);
        }
        switch (format) {
            case 100: 
            case 102: 
            case 104: {
                return COLON;
            }
            case 101: 
            case 103: {
                return PERIOD;
            }
        }
        throw new InternalErrorException(6, "Unrecognized format: " + format, null);
    }

    @Override
    boolean isValidFormat(int format) {
        return AS400Time.validateFormat(format);
    }

    public static boolean validateFormat(int format) {
        return format >= 100 && format <= 104;
    }

    public static int getByteLength(int format, Character separator) {
        if (separator == null) {
            return 6;
        }
        return 8;
    }

    @Override
    int lengthFor(int format) {
        return AS400Time.getByteLength(format, this.getSeparator());
    }

    static {
        MIN_VALUE = new Time(0L);
        MAX_VALUE = new Time(86399999L);
    }
}

