/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AS400Calendar {
    static TimeZone gmtTimeZone = null;

    public static Calendar getGregorianInstance() {
        Calendar returnCalendar = Calendar.getInstance();
        boolean isGregorian = returnCalendar instanceof GregorianCalendar;
        boolean isBuddhist = AS400Calendar.isBuddhistCalendar(returnCalendar);
        if (isGregorian && !isBuddhist) {
            return returnCalendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return gregorianCalendar;
    }

    public static Calendar getGregorianInstance(TimeZone timezone) {
        Calendar returnCalendar = Calendar.getInstance(timezone);
        boolean isGregorian = returnCalendar instanceof GregorianCalendar;
        boolean isBuddhist = AS400Calendar.isBuddhistCalendar(returnCalendar);
        if (isGregorian && !isBuddhist) {
            return returnCalendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timezone);
        return gregorianCalendar;
    }

    public static Calendar getConversionCalendar(Calendar calendar) {
        if (calendar == null) {
            return AS400Calendar.getGregorianInstance();
        }
        boolean isGregorian = calendar instanceof GregorianCalendar;
        boolean isBuddhist = AS400Calendar.isBuddhistCalendar(calendar);
        if (isGregorian && !isBuddhist) {
            return calendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendar.getTimeZone());
        gregorianCalendar.setLenient(calendar.isLenient());
        return gregorianCalendar;
    }

    private static boolean isBuddhistCalendar(Calendar calendar) {
        try {
            Class<?> c = Class.forName("sun.util.BuddhistCalendar");
            return c.isInstance(calendar);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Calendar getGMTInstance() {
        if (gmtTimeZone == null) {
            gmtTimeZone = TimeZone.getTimeZone("GMT");
        }
        return Calendar.getInstance(gmtTimeZone);
    }
}

