/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.resolvers.pipeline;

import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.resolver.IVariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolverPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.ui.hopgui.file.pipeline.extension.TypePipelineFile;
import org.json.simple.JSONObject;

@GuiPlugin
@VariableResolverPlugin(id="Variable-Resolver-Pipeline", name="Pipeline Variable Resolver", description="Use a pipeline to resolve the value of a variable expression", documentationUrl="/metadata-types/variable-resolver/pipeline-variable-resolver.html")
public class VariableResolverPipeline
implements IVariableResolver {
    @GuiWidgetElement(id="filename", order="01", label="i18n::VariableResolverEditor.label.Filename", typeFilename=TypePipelineFile.class, type=GuiElementType.FILENAME, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String filename;
    @GuiWidgetElement(id="runConfigurationName", order="02", label="i18n::VariableResolverEditor.label.RunConfigurationName", type=GuiElementType.METADATA, metadata=PipelineRunConfiguration.class, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String runConfigurationName;
    @GuiWidgetElement(id="expressionVariableName", order="03", label="i18n::VariableResolverEditor.label.ExpressionVariableName", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String expressionVariableName;
    @GuiWidgetElement(id="outputTransformName", order="03", label="i18n::VariableResolverEditor.label.OutputTransformName", type=GuiElementType.TEXT, parentId="VariableResolver-PluginSpecific-Options")
    @HopMetadataProperty
    private String outputTransformName;

    public void init() {
    }

    public void setPluginId() {
    }

    public String getPluginId() {
        return "Variable-Resolver-Pipeline";
    }

    public void setPluginName(String pluginName) {
    }

    public String getPluginName() {
        return "Pipeline Variable Resolver";
    }

    public String resolve(String expression, IVariables variables) throws HopException {
        MultiMetadataProvider metadataProvider = HopMetadataInstance.getMetadataProvider();
        String pipelineFilename = variables.resolve(this.filename);
        if (StringUtils.isEmpty((String)pipelineFilename)) {
            throw new HopException("Please provide a pipeline filename to use to resolve the variable expression.");
        }
        String pipelineRunConfigurationName = variables.resolve(this.runConfigurationName);
        PipelineRunConfiguration defaultRunConfiguration = PipelineRunConfiguration.findDefault((IHopMetadataProvider)metadataProvider);
        if (defaultRunConfiguration == null && StringUtils.isEmpty((String)pipelineRunConfigurationName)) {
            throw new HopException("Please specify a local pipeline run configuration to use to resolve the variable expression.");
        }
        String variableName = variables.resolve(this.expressionVariableName);
        if (StringUtils.isEmpty((String)variableName)) {
            throw new HopException("Please specify a variable name to use to contain the variable expression.");
        }
        PipelineExecutionConfiguration configuration = new PipelineExecutionConfiguration();
        configuration.setLogLevel(LogLevel.BASIC);
        configuration.setRunConfiguration(pipelineRunConfigurationName);
        PipelineMeta pipelineMeta = new PipelineMeta(pipelineFilename, (IHopMetadataProvider)metadataProvider, variables);
        IPipelineEngine pipeline = PipelineEngineFactory.createPipelineEngine((IVariables)variables, (String)pipelineRunConfigurationName, (IHopMetadataProvider)metadataProvider, (PipelineMeta)pipelineMeta);
        pipeline.getPipelineMeta().setInternalHopVariables((IVariables)pipeline);
        pipeline.initializeFrom(null);
        pipeline.setVariable(variableName, expression);
        pipeline.setLogLevel(configuration.getLogLevel());
        pipeline.setMetadataProvider((IHopMetadataProvider)metadataProvider);
        if (!(pipeline instanceof LocalPipelineEngine)) {
            LogChannel.GENERAL.logError("The pipeline run configuration needs to be of type 'Native Local' to resolve variable expression '" + expression + "'");
            return null;
        }
        pipeline.prepareExecution();
        final JSONObject resultJs = new JSONObject();
        ITransform transform = ((LocalPipelineEngine)pipeline).getRunThread(variables.resolve(this.outputTransformName), 0);
        transform.addRowListener((IRowListener)new RowAdapter(){

            public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                if (resultJs.isEmpty()) {
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(i);
                        String name = valueMeta.getName();
                        try {
                            String value = rowMeta.getString(row, i);
                            resultJs.put((Object)name, (Object)value);
                            continue;
                        }
                        catch (Exception e) {
                            LogChannel.GENERAL.logError("Error getting string field from value '" + name + "'", (Throwable)e);
                        }
                    }
                }
            }
        });
        pipeline.startThreads();
        pipeline.waitUntilFinished();
        return resultJs.toJSONString();
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    @Generated
    public String getExpressionVariableName() {
        return this.expressionVariableName;
    }

    @Generated
    public String getOutputTransformName() {
        return this.outputTransformName;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    @Generated
    public void setExpressionVariableName(String expressionVariableName) {
        this.expressionVariableName = expressionVariableName;
    }

    @Generated
    public void setOutputTransformName(String outputTransformName) {
        this.outputTransformName = outputTransformName;
    }
}

