/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.io;

import org.apache.hop.beam.metadata.FileDefinition;
import org.apache.hop.beam.transforms.io.BeamOutput;
import org.apache.hop.beam.transforms.io.BeamOutputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamOutputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamOutput.class;
    private final BeamOutputMeta input;
    int middle;
    int margin;
    private boolean getpreviousFields = false;
    private TextVar wOutputLocation;
    private MetaSelectionLine<FileDefinition> wFileDefinition;
    private TextVar wFilePrefix;
    private TextVar wFileSuffix;
    private Button wWindowed;

    public BeamOutputDialog(Shell parent, IVariables variables, BeamOutputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamOutputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        MetaSelectionLine<FileDefinition> lastControl = this.wTransformName;
        Label wlOutputLocation = new Label((Composite)this.shell, 131072);
        wlOutputLocation.setText(BaseMessages.getString(PKG, (String)"BeamOutputDialog.OutputLocation", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputLocation);
        FormData fdlOutputLocation = new FormData();
        fdlOutputLocation.left = new FormAttachment(0, 0);
        fdlOutputLocation.top = new FormAttachment((Control)lastControl, this.margin);
        fdlOutputLocation.right = new FormAttachment(this.middle, -this.margin);
        wlOutputLocation.setLayoutData((Object)fdlOutputLocation);
        this.wOutputLocation = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wOutputLocation);
        FormData fdOutputLocation = new FormData();
        fdOutputLocation.left = new FormAttachment(this.middle, 0);
        fdOutputLocation.top = new FormAttachment((Control)wlOutputLocation, 0, 0x1000000);
        fdOutputLocation.right = new FormAttachment(100, 0);
        this.wOutputLocation.setLayoutData((Object)fdOutputLocation);
        lastControl = this.wOutputLocation;
        Label wlFilePrefix = new Label((Composite)this.shell, 131072);
        wlFilePrefix.setText(BaseMessages.getString(PKG, (String)"BeamOutputDialog.FilePrefix", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilePrefix);
        FormData fdlFilePrefix = new FormData();
        fdlFilePrefix.left = new FormAttachment(0, 0);
        fdlFilePrefix.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFilePrefix.right = new FormAttachment(this.middle, -this.margin);
        wlFilePrefix.setLayoutData((Object)fdlFilePrefix);
        this.wFilePrefix = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilePrefix);
        FormData fdFilePrefix = new FormData();
        fdFilePrefix.left = new FormAttachment(this.middle, 0);
        fdFilePrefix.top = new FormAttachment((Control)wlFilePrefix, 0, 0x1000000);
        fdFilePrefix.right = new FormAttachment(100, 0);
        this.wFilePrefix.setLayoutData((Object)fdFilePrefix);
        lastControl = this.wFilePrefix;
        Label wlFileSuffix = new Label((Composite)this.shell, 131072);
        wlFileSuffix.setText(BaseMessages.getString(PKG, (String)"BeamOutputDialog.FileSuffix", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileSuffix);
        FormData fdlFileSuffix = new FormData();
        fdlFileSuffix.left = new FormAttachment(0, 0);
        fdlFileSuffix.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFileSuffix.right = new FormAttachment(this.middle, -this.margin);
        wlFileSuffix.setLayoutData((Object)fdlFileSuffix);
        this.wFileSuffix = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFileSuffix);
        FormData fdFileSuffix = new FormData();
        fdFileSuffix.left = new FormAttachment(this.middle, 0);
        fdFileSuffix.top = new FormAttachment((Control)wlFileSuffix, 0, 0x1000000);
        fdFileSuffix.right = new FormAttachment(100, 0);
        this.wFileSuffix.setLayoutData((Object)fdFileSuffix);
        lastControl = this.wFileSuffix;
        Label wlWindowed = new Label((Composite)this.shell, 131072);
        wlWindowed.setText(BaseMessages.getString(PKG, (String)"BeamOutputDialog.Windowed", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWindowed);
        FormData fdlWindowed = new FormData();
        fdlWindowed.left = new FormAttachment(0, 0);
        fdlWindowed.top = new FormAttachment((Control)lastControl, this.margin);
        fdlWindowed.right = new FormAttachment(this.middle, -this.margin);
        wlWindowed.setLayoutData((Object)fdlWindowed);
        this.wWindowed = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wWindowed);
        FormData fdWindowed = new FormData();
        fdWindowed.left = new FormAttachment(this.middle, 0);
        fdWindowed.top = new FormAttachment((Control)wlWindowed, 0, 0x1000000);
        fdWindowed.right = new FormAttachment(100, 0);
        this.wWindowed.setLayoutData((Object)fdWindowed);
        lastControl = this.wWindowed;
        this.wFileDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, FileDefinition.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"BeamOutputDialog.FileDefinition", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamOutputDialog.FileDefinition", (String[])new String[0]));
        PropsUi.setLook(this.wFileDefinition);
        FormData fdFileDefinition = new FormData();
        fdFileDefinition.left = new FormAttachment(0, 0);
        fdFileDefinition.top = new FormAttachment((Control)lastControl, this.margin);
        fdFileDefinition.right = new FormAttachment(100, 0);
        this.wFileDefinition.setLayoutData((Object)fdFileDefinition);
        lastControl = this.wFileDefinition;
        try {
            this.wFileDefinition.fillItems();
        }
        catch (Exception e2) {
            this.log.logError("Error getting file definition items", (Throwable)e2);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wFileDefinition.setText(Const.NVL((String)this.input.getFileDefinitionName(), (String)""));
        this.wOutputLocation.setText(Const.NVL((String)this.input.getOutputLocation(), (String)""));
        this.wFilePrefix.setText(Const.NVL((String)this.input.getFilePrefix(), (String)""));
        this.wFileSuffix.setText(Const.NVL((String)this.input.getFileSuffix(), (String)""));
        this.wWindowed.setSelection(this.input.isWindowed());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamOutputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setFileDefinitionName(this.wFileDefinition.getText());
        in.setOutputLocation(this.wOutputLocation.getText());
        in.setFilePrefix(this.wFilePrefix.getText());
        in.setFileSuffix(this.wFileSuffix.getText());
        in.setWindowed(this.wWindowed.getSelection());
        this.input.setChanged();
    }
}

