/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.hop.core.SwingUniversalImage;

public class SwingUniversalImageBitmap
extends SwingUniversalImage {
    private final BufferedImage bitmap;

    public SwingUniversalImageBitmap(BufferedImage bitmap) {
        this.bitmap = bitmap;
    }

    @Override
    public boolean isBitmap() {
        return true;
    }

    @Override
    protected void renderSimple(BufferedImage area) {
        Graphics2D gc = SwingUniversalImageBitmap.createGraphics(area);
        gc.drawImage(this.bitmap, 0, 0, area.getWidth(), area.getHeight(), null);
        gc.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(Graphics2D gc, int centerX, int centerY, int width, int height, double angleRadians) {
        AffineTransform oldTransform = gc.getTransform();
        try {
            double scaleX = (double)width * 1.0 / (double)this.bitmap.getWidth();
            double scaleY = (double)height * 1.0 / (double)this.bitmap.getHeight();
            AffineTransform affineTransform = new AffineTransform(oldTransform);
            if (centerX != 0 || centerY != 0) {
                affineTransform.translate(centerX, centerY);
            }
            affineTransform.scale(scaleX, scaleY);
            if (angleRadians != 0.0) {
                affineTransform.rotate(angleRadians);
            }
            affineTransform.translate(-this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2);
            gc.setTransform(affineTransform);
            gc.drawImage(this.bitmap, 0, 0, this.bitmap.getWidth(), this.bitmap.getHeight(), null);
        }
        finally {
            gc.setTransform(oldTransform);
        }
    }
}

