/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async.xp;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.workflow.WorkflowExecutionExtension;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.async.AsyncWebService;
import org.apache.hop.www.async.Defaults;

@ExtensionPoint(id="MarkAsyncWorkflowActionExtensionPoint", extensionPointId="WorkflowBeforeActionExecution", description="Before the execution of an action, pass service to workflow data map")
public class MarkAsyncWorkflowActionExtensionPoint
implements IExtensionPoint<WorkflowExecutionExtension> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables iVariables, WorkflowExecutionExtension ext) throws HopException {
        ActionMeta actionMeta = ext.actionMeta;
        if (!actionMeta.isPipeline()) {
            return;
        }
        Map attributesMap = (Map)actionMeta.getAttributesMap().get("ASYNC_STATUS_GROUP");
        if (attributesMap == null) {
            return;
        }
        String serviceName = (String)attributesMap.get("enable-asynchronous-pipeline-service-name");
        if (serviceName == null) {
            return;
        }
        IWorkflowEngine workflow = ext.workflow;
        IHopMetadataSerializer serializer = workflow.getMetadataProvider().getSerializer(AsyncWebService.class);
        AsyncWebService service = (AsyncWebService)serializer.load(serviceName);
        if (service == null) {
            throw new HopException("Unable to load asynchronous service " + serviceName);
        }
        String key = Defaults.createWorkflowExtensionDataKey(actionMeta.getName());
        workflow.getExtensionDataMap().put(key, service);
    }
}

