/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino.editor;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.janino.JaninoMeta;
import org.apache.hop.pipeline.transforms.janino.function.FunctionDescription;
import org.apache.hop.pipeline.transforms.janino.function.FunctionLib;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FormulaEditor
extends Dialog
implements KeyListener {
    public static final Class<?> PKG = JaninoMeta.class;
    private Shell shell;
    private Tree tree;
    private SashForm sashForm;
    private StyledTextComp expressionEditor;
    private String formula;
    private Browser message;
    private FunctionLib functionLib;
    private Button ok;
    private Button cancel;
    private Color blue;
    private Color red;
    private Color green;
    private Color white;
    private Color gray;
    private Color black;
    Menu helperMenu;
    private String[] categories;
    private SashForm rightSash;

    public FormulaEditor(IVariables variables, Shell parent, int style, String formula, List<String> inputFields) throws HopException {
        super(parent, style);
        this.formula = formula;
        this.shell = new Shell(parent, 68848);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        FillLayout bcLayout = new FillLayout();
        bcLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)bcLayout);
        this.ok = new Button(buttonsComposite, 8);
        this.ok.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.cancel = new Button(buttonsComposite, 8);
        this.cancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormulaEditor.this.ok();
            }
        });
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormulaEditor.this.cancel();
            }
        });
        this.sashForm = new SashForm((Composite)this.shell, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.top = new FormAttachment(0, 10);
        fdSashForm.bottom = new FormAttachment((Control)buttonsComposite, -10);
        this.sashForm.setLayoutData((Object)fdSashForm);
        FormData fdBC = new FormData();
        fdBC.left = new FormAttachment((Control)this.sashForm, 0, 0x1000000);
        fdBC.bottom = new FormAttachment(100, 0);
        buttonsComposite.setLayoutData((Object)fdBC);
        this.readFunctions();
        this.tree = new Tree((Composite)this.sashForm, 4);
        TreeItem fieldsItem = new TreeItem(this.tree, 0);
        fieldsItem.setText("Fields");
        for (String inputField : inputFields) {
            TreeItem fieldItem = new TreeItem(fieldsItem, 0);
            fieldItem.setText(inputField);
        }
        for (int i = 0; i < this.categories.length; ++i) {
            String[] fnames;
            String category;
            String i18nCategory = category = this.categories[i];
            if (category.startsWith("%")) {
                i18nCategory = BaseMessages.getString(PKG, (String)category.substring(1), (String[])new String[0]);
            }
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(i18nCategory);
            for (String fname : fnames = this.functionLib.getFunctionsForACategory(category)) {
                TreeItem fitem = new TreeItem(item, 0);
                fitem.setText(fname);
            }
        }
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String functionName;
                FunctionDescription functionDescription;
                TreeItem item;
                if (FormulaEditor.this.tree.getSelectionCount() == 1 && (item = FormulaEditor.this.tree.getSelection()[0]).getParentItem() != null && (functionDescription = FormulaEditor.this.functionLib.getFunctionDescription(functionName = item.getText())) != null) {
                    String report = functionDescription.getHtmlReport();
                    FormulaEditor.this.message.setText(report);
                }
            }
        });
        this.tree.addListener(8, event -> {
            TreeItem item;
            if (this.tree.getSelectionCount() == 1 && (item = this.tree.getSelection()[0]).getParentItem() != null) {
                String partToInsert = "";
                partToInsert = item.getParentItem().getText().equals("Fields") ? item.getText() : (this.functionLib.getFunctionDescription(item.getText()).getSyntax() == null ? item.getText() : this.functionLib.getFunctionDescription(item.getText()).getSyntax());
                String oldFormula = this.expressionEditor.getText();
                int caretPosition = this.expressionEditor.getCaretPosition();
                int textLength = this.expressionEditor.getText().length();
                int selectionsize = this.expressionEditor.getSelectionCount();
                if (textLength == 0) {
                    this.expressionEditor.setText(partToInsert);
                } else if (textLength == caretPosition) {
                    this.expressionEditor.setText(oldFormula + partToInsert);
                } else {
                    this.expressionEditor.setText(oldFormula.substring(0, caretPosition) + partToInsert + oldFormula.substring(caretPosition + selectionsize));
                }
            }
        });
        this.rightSash = new SashForm((Composite)this.sashForm, 512);
        this.expressionEditor = new StyledTextComp(variables, (Composite)this.rightSash, 19202);
        this.expressionEditor.setText(this.formula);
        this.expressionEditor.addModifyListener(event -> this.setStyles());
        this.expressionEditor.addKeyListener((KeyListener)this);
        this.message = new Browser((Composite)this.rightSash, 778);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(0, 0);
        fdMessage.right = new FormAttachment(100, 0);
        fdMessage.top = new FormAttachment(0, 0);
        fdMessage.bottom = new FormAttachment(0, 100);
        this.message.setLayoutData((Object)fdMessage);
        this.rightSash.setWeights(new int[]{10, 80});
        this.sashForm.setWeights(new int[]{15, 85});
        this.red = new Color((Device)this.shell.getDisplay(), 255, 0, 0);
        this.green = new Color((Device)this.shell.getDisplay(), 0, 220, 0);
        this.blue = new Color((Device)this.shell.getDisplay(), 0, 0, 255);
        this.white = new Color((Device)this.shell.getDisplay(), 255, 255, 255);
        this.gray = new Color((Device)this.shell.getDisplay(), 150, 150, 150);
        this.black = new Color((Device)this.shell.getDisplay(), 0, 0, 0);
        this.setStyles();
        this.shell.addDisposeListener(arg0 -> {
            this.red.dispose();
            this.green.dispose();
            this.blue.dispose();
            this.white.dispose();
            this.gray.dispose();
            this.black.dispose();
        });
    }

    public String open() {
        this.shell.layout();
        this.shell.open();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FormulaEditor.this.cancel();
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.formula;
    }

    public void ok() {
        this.formula = this.expressionEditor.getText();
        this.shell.dispose();
    }

    public void cancel() {
        this.formula = null;
        this.shell.dispose();
    }

    public void readFunctions() throws HopException {
        this.functionLib = new FunctionLib();
        this.categories = this.functionLib.getFunctionCategories();
    }

    public void setStyles() {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

