/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.mssql;

import java.sql.ResultSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@DatabaseMetaPlugin(type="MSSQL", typeDescription="MS SQL Server", image="microsoft-sql.svg", documentationUrl="/database/databases/mssql.html")
@GuiPlugin(id="GUI-MSSQLServerDatabaseMeta")
public class MsSqlServerDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";
    @GuiWidgetElement(id="instanceName", order="20", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.SQLServerInstance")
    @HopMetadataProperty
    private String instanceName;
    @GuiWidgetElement(id="usingDoubleDigit", order="22", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.UseDoubleDecimalSeparator")
    @HopMetadataProperty
    private boolean usingDoubleDigit;

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public boolean isUsingDoubleDigit() {
        return this.usingDoubleDigit;
    }

    public void setUsingDoubleDigit(boolean usingDoubleDigit) {
        this.usingDoubleDigit = usingDoubleDigit;
    }

    public boolean isSupportsCatalogs() {
        return false;
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1433;
        }
        return -1;
    }

    public String getDriverClass() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        StringBuilder sb = new StringBuilder("jdbc:jtds:sqlserver://");
        sb.append(hostname);
        if (!Utils.isEmpty((CharSequence)port) && Const.toInt((String)port, (int)-1) > 0) {
            sb.append(':');
            sb.append(port);
        }
        if (!Utils.isEmpty((CharSequence)databaseName)) {
            sb.append('/');
            sb.append(databaseName);
        }
        if (!Utils.isEmpty((CharSequence)this.instanceName)) {
            sb.append(";instance=");
            sb.append(this.instanceName);
        }
        return sb.toString();
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        if (this.isUsingDoubleDecimalAsSchemaTableSeparator()) {
            return schemaName + ".." + tablePart;
        }
        return schemaName + "." + tablePart;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT TOP 1 * FROM " + tableName;
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT TOP 1 " + columnname + " FROM " + tableName;
    }

    public String getSqlLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("SELECT top 0 * FROM ").append(tableNames[i]).append(" WITH (UPDLOCK, HOLDLOCK);").append(Const.CR);
        }
        return sql.toString();
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BIT";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "BIGINT PRIMARY KEY IDENTITY(0,1)";
                        break;
                    }
                    retval = (String)retval + "BIGINT PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 18) {
                        retval = (String)retval + "DECIMAL(" + length + ",0)";
                        break;
                    }
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    retval = (String)retval + "INT";
                    break;
                }
                if (precision > 0 && length > 0) {
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "FLOAT(53)";
                break;
            }
            case 2: {
                if (length < this.getMaxVARCHARLength()) {
                    if (length > 0) {
                        retval = (String)retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    retval = (String)retval + "VARCHAR(100)";
                    break;
                }
                retval = (String)retval + "TEXT";
                break;
            }
            case 8: {
                retval = (String)retval + "VARBINARY(MAX)";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getSqlListOfProcedures() {
        return "select o.name from sysobjects o, sysusers u where  xtype in ( 'FN', 'P' ) and o.uid = u.uid order by o.name";
    }

    public String[] getReservedWords() {
        return new String[]{"ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "BACKUP", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BREAK", "BROWSE", "BULK", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CHECKPOINT", "CLASS", "CLOB", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "COMPUTE", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATABASE", "DATE", "DAY", "DBCC", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DENY", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISK", "DISTINCT", "DISTRIBUTED", "DOMAIN", "DOUBLE", "DROP", "DUMMY", "DUMP", "DYNAMIC", "EACH", "ELSE", "END", "END-EXEC", "EQUALS", "ERRLVL", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FALSE", "FETCH", "FILE", "FILLFACTOR", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HAVING", "HOLDLOCK", "HOST", "HOUR", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "KILL", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LINENO", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "MAP", "MATCH", "MINUTE", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NOCHECK", "NONCLUSTERED", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OF", "OFF", "OFFSETS", "OLD", "ON", "ONLY", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "PERCENT", "PLAN", "POSTFIX", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRINT", "PRIOR", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READS", "READTEXT", "REAL", "RECONFIGURE", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "REPLICATION", "RESTORE", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWCOUNT", "ROWGUIDCOL", "ROWS", "RULE", "SAVE", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SETUSER", "SHUTDOWN", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATEMENT", "STATIC", "STATISTICS", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "TEXTSIZE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TOP", "TRAILING", "TRAN", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "TRUNCATE", "TSEQUAL", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UPDATE", "UPDATETEXT", "USAGE", "USE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "WRITETEXT", "YEAR", "ZONE"};
    }

    public String getExtraOptionsHelpText() {
        return "http://jtds.sourceforge.net/faq.html#urlFormat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasIndex(Database database, String schemaName, String tableName, String[] idxFields) throws HopDatabaseException {
        String schemaTable = database.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)database, schemaName, tableName);
        boolean[] exists = new boolean[idxFields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            StringBuilder sql = new StringBuilder(128);
            sql.append("select i.name table_name, c.name column_name ");
            sql.append("from     sysindexes i, sysindexkeys k, syscolumns c ");
            sql.append("where    i.name = '" + schemaTable + "' ");
            sql.append("AND      i.id = k.id ");
            sql.append("AND      i.id = c.id ");
            sql.append("AND      k.colid = c.colid ");
            ResultSet res = null;
            try {
                res = database.openQuery(sql.toString());
                if (res == null) {
                    boolean row22 = false;
                    return row22;
                }
                Object[] row22 = database.getRow(res);
                while (row22 != null) {
                    String column = database.getReturnRowMeta().getString(row22, "column_name", "");
                    int idx = Const.indexOfString((String)column, (String[])idxFields);
                    if (idx >= 0) {
                        exists[idx] = true;
                    }
                    row22 = database.getRow(res);
                }
            }
            finally {
                if (res != null) {
                    database.closeQuery(res);
                }
            }
            boolean all = true;
            int i = 0;
            while (i < exists.length) {
                if (!all) return all;
                if (!exists[i]) {
                    all = false;
                }
                ++i;
            }
            return all;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to determine if indexes exists on table [" + schemaTable + "]", (Throwable)e);
        }
    }

    public String getSqlListOfSchemas() {
        return "select name from sys.schemas";
    }

    public boolean isSupportsSchemas() {
        return true;
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        return String.format("SELECT NEXT VALUE FOR %s", sequenceName);
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return String.format("SELECT current_value FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    public String getSqlSequenceExists(String sequenceName) {
        return String.format("SELECT 1 FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    public boolean isSupportsSequences() {
        return true;
    }

    public boolean isSupportsSequenceNoMaxValueOption() {
        return true;
    }

    public String getSqlListOfSequences() {
        return "SELECT name FROM sys.sequences";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "''");
        string = string.replace("\\n", "'+char(13)+'");
        string = string.replace("\\r", "'+char(10)+'");
        return "'" + string + "'";
    }

    public boolean isUseSafePoints() {
        return false;
    }

    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public int getMaxVARCHARLength() {
        return 8000;
    }

    public boolean isMsSqlServerVariant() {
        return true;
    }

    public String getStartQuote() {
        return "[";
    }

    public String getEndQuote() {
        return "]";
    }
}

