/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.management.jmx.JMXService;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.blob.JobPermanentBlobService;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TaskExecutorBlobService;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatReceiver;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionInfo;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTracker;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.AllocatedSlotInfo;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationRejection;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.ResourceManagerAddress;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskThreadInfoResponse;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TaskNotRunningException;
import org.apache.flink.runtime.query.KvStateClientProxy;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.KvStateServer;
import org.apache.flink.runtime.registration.RegistrationConnectionListener;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcServiceUtils;
import org.apache.flink.runtime.security.token.DelegationTokenReceiverRepository;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.state.TaskExecutorChannelStateExecutorFactoryManager;
import org.apache.flink.runtime.state.TaskExecutorFileMergingManager;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.state.TaskExecutorStateChangelogStoragesManager;
import org.apache.flink.runtime.state.TaskLocalStateStore;
import org.apache.flink.runtime.state.TaskStateManagerImpl;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.taskexecutor.AccumulatorReport;
import org.apache.flink.runtime.taskexecutor.EstablishedResourceManagerConnection;
import org.apache.flink.runtime.taskexecutor.ExecutionDeploymentReport;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.JobLeaderListener;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobTable;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.PartitionProducerStateChecker;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationRejection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToJobManagerHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToResourceManagerConnection;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.ThreadInfoSampleService;
import org.apache.flink.runtime.taskexecutor.exceptions.RegistrationTimeoutException;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotAllocationException;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotOccupiedException;
import org.apache.flink.runtime.taskexecutor.exceptions.TaskException;
import org.apache.flink.runtime.taskexecutor.exceptions.TaskManagerException;
import org.apache.flink.runtime.taskexecutor.exceptions.TaskSubmissionException;
import org.apache.flink.runtime.taskexecutor.rpc.RpcCheckpointResponder;
import org.apache.flink.runtime.taskexecutor.rpc.RpcGlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.rpc.RpcInputSplitProvider;
import org.apache.flink.runtime.taskexecutor.rpc.RpcKvStateRegistryListener;
import org.apache.flink.runtime.taskexecutor.rpc.RpcPartitionStateChecker;
import org.apache.flink.runtime.taskexecutor.rpc.RpcTaskOperatorEventGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshot;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshotPersistenceService;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.runtime.util.GroupCache;
import org.apache.flink.runtime.util.profiler.ProfilingService;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.apache.flink.types.SerializableOptional;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkExpectedException;
import org.apache.flink.util.OptionalConsumer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public class TaskExecutor
extends RpcEndpoint
implements TaskExecutorGateway {
    public static final String TASK_MANAGER_NAME = "taskmanager";
    private final HighAvailabilityServices haServices;
    private final TaskManagerServices taskExecutorServices;
    private final TaskManagerConfiguration taskManagerConfiguration;
    private final FatalErrorHandler fatalErrorHandler;
    private final TaskExecutorBlobService taskExecutorBlobService;
    private final LibraryCacheManager libraryCacheManager;
    @Nullable
    private final String metricQueryServiceAddress;
    private final UnresolvedTaskManagerLocation unresolvedTaskManagerLocation;
    private final TaskManagerMetricGroup taskManagerMetricGroup;
    private final TaskExecutorLocalStateStoresManager localStateStoresManager;
    private final TaskExecutorFileMergingManager fileMergingManager;
    private final TaskExecutorStateChangelogStoragesManager changelogStoragesManager;
    private final TaskExecutorChannelStateExecutorFactoryManager channelStateExecutorFactoryManager;
    private final ExternalResourceInfoProvider externalResourceInfoProvider;
    private final ShuffleEnvironment<?, ?> shuffleEnvironment;
    private final KvStateService kvStateService;
    private final Executor ioExecutor;
    private final SharedResources sharedResources;
    private final TaskSlotTable<Task> taskSlotTable;
    private final Map<JobID, UUID> currentSlotOfferPerJob = new HashMap<JobID, UUID>();
    private final JobTable jobTable;
    private final JobLeaderService jobLeaderService;
    private final LeaderRetrievalService resourceManagerLeaderRetriever;
    private final SlotAllocationSnapshotPersistenceService slotAllocationSnapshotPersistenceService;
    private final HardwareDescription hardwareDescription;
    private final TaskExecutorMemoryConfiguration memoryConfiguration;
    private FileCache fileCache;
    private final HeartbeatManager<AllocatedSlotReport, TaskExecutorToJobManagerHeartbeatPayload> jobManagerHeartbeatManager;
    private final HeartbeatManager<Void, TaskExecutorHeartbeatPayload> resourceManagerHeartbeatManager;
    private final TaskExecutorPartitionTracker partitionTracker;
    private final DelegationTokenReceiverRepository delegationTokenReceiverRepository;
    @Nullable
    private ResourceManagerAddress resourceManagerAddress;
    @Nullable
    private EstablishedResourceManagerConnection establishedResourceManagerConnection;
    @Nullable
    private TaskExecutorToResourceManagerConnection resourceManagerConnection;
    @Nullable
    private UUID currentRegistrationTimeoutId;
    private final Map<JobID, Collection<CompletableFuture<ExecutionState>>> taskResultPartitionCleanupFuturesPerJob = CollectionUtil.newHashMapWithExpectedSize((int)8);
    private final ThreadInfoSampleService threadInfoSampleService;
    private final GroupCache<JobID, PermanentBlobKey, JobInformation> jobInformationCache;
    private final GroupCache<JobID, PermanentBlobKey, TaskInformation> taskInformationCache;
    private final GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache;
    private final ProfilingService profilingService;

    public TaskExecutor(RpcService rpcService, TaskManagerConfiguration taskManagerConfiguration, HighAvailabilityServices haServices, TaskManagerServices taskExecutorServices, ExternalResourceInfoProvider externalResourceInfoProvider, HeartbeatServices heartbeatServices, TaskManagerMetricGroup taskManagerMetricGroup, @Nullable String metricQueryServiceAddress, TaskExecutorBlobService taskExecutorBlobService, FatalErrorHandler fatalErrorHandler, TaskExecutorPartitionTracker partitionTracker, DelegationTokenReceiverRepository delegationTokenReceiverRepository) {
        super(rpcService, RpcServiceUtils.createRandomName((String)TASK_MANAGER_NAME));
        Preconditions.checkArgument((taskManagerConfiguration.getNumberSlots() > 0 ? 1 : 0) != 0, (Object)"The number of slots has to be larger than 0.");
        this.taskManagerConfiguration = (TaskManagerConfiguration)Preconditions.checkNotNull((Object)taskManagerConfiguration);
        this.taskExecutorServices = (TaskManagerServices)Preconditions.checkNotNull((Object)taskExecutorServices);
        this.haServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)haServices);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.partitionTracker = partitionTracker;
        this.delegationTokenReceiverRepository = (DelegationTokenReceiverRepository)Preconditions.checkNotNull((Object)delegationTokenReceiverRepository);
        this.taskManagerMetricGroup = (TaskManagerMetricGroup)Preconditions.checkNotNull((Object)taskManagerMetricGroup);
        this.taskExecutorBlobService = (TaskExecutorBlobService)Preconditions.checkNotNull((Object)taskExecutorBlobService);
        this.metricQueryServiceAddress = metricQueryServiceAddress;
        this.externalResourceInfoProvider = (ExternalResourceInfoProvider)Preconditions.checkNotNull((Object)externalResourceInfoProvider);
        this.libraryCacheManager = taskExecutorServices.getLibraryCacheManager();
        this.taskSlotTable = taskExecutorServices.getTaskSlotTable();
        this.jobTable = taskExecutorServices.getJobTable();
        this.jobLeaderService = taskExecutorServices.getJobLeaderService();
        this.unresolvedTaskManagerLocation = taskExecutorServices.getUnresolvedTaskManagerLocation();
        this.localStateStoresManager = taskExecutorServices.getTaskManagerStateStore();
        this.fileMergingManager = taskExecutorServices.getTaskManagerFileMergingManager();
        this.changelogStoragesManager = taskExecutorServices.getTaskManagerChangelogManager();
        this.channelStateExecutorFactoryManager = taskExecutorServices.getTaskManagerChannelStateManager();
        this.shuffleEnvironment = taskExecutorServices.getShuffleEnvironment();
        this.kvStateService = taskExecutorServices.getKvStateService();
        this.ioExecutor = taskExecutorServices.getIOExecutor();
        this.resourceManagerLeaderRetriever = haServices.getResourceManagerLeaderRetriever();
        this.hardwareDescription = HardwareDescription.extractFromSystem(taskExecutorServices.getManagedMemorySize());
        this.memoryConfiguration = TaskExecutorMemoryConfiguration.create(taskManagerConfiguration.getConfiguration());
        this.resourceManagerAddress = null;
        this.resourceManagerConnection = null;
        this.currentRegistrationTimeoutId = null;
        ResourceID resourceId = taskExecutorServices.getUnresolvedTaskManagerLocation().getResourceID();
        this.jobManagerHeartbeatManager = this.createJobManagerHeartbeatManager(heartbeatServices, resourceId);
        this.resourceManagerHeartbeatManager = this.createResourceManagerHeartbeatManager(heartbeatServices, resourceId);
        ExecutorThreadFactory sampleThreadFactory = new ExecutorThreadFactory.Builder().setPoolName("flink-thread-info-sampler").build();
        ScheduledExecutorService sampleExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)sampleThreadFactory);
        this.threadInfoSampleService = new ThreadInfoSampleService(sampleExecutor);
        this.profilingService = ProfilingService.getInstance(taskManagerConfiguration.getConfiguration());
        this.slotAllocationSnapshotPersistenceService = taskExecutorServices.getSlotAllocationSnapshotPersistenceService();
        this.sharedResources = taskExecutorServices.getSharedResources();
        this.jobInformationCache = taskExecutorServices.getJobInformationCache();
        this.taskInformationCache = taskExecutorServices.getTaskInformationCache();
        this.shuffleDescriptorsCache = taskExecutorServices.getShuffleDescriptorCache();
    }

    private HeartbeatManager<Void, TaskExecutorHeartbeatPayload> createResourceManagerHeartbeatManager(HeartbeatServices heartbeatServices, ResourceID resourceId) {
        return heartbeatServices.createHeartbeatManager(resourceId, new ResourceManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
    }

    private HeartbeatManager<AllocatedSlotReport, TaskExecutorToJobManagerHeartbeatPayload> createJobManagerHeartbeatManager(HeartbeatServices heartbeatServices, ResourceID resourceId) {
        return heartbeatServices.createHeartbeatManager(resourceId, new JobManagerHeartbeatListener(), (ScheduledExecutor)this.getMainThreadExecutor(), this.log);
    }

    @Override
    public CompletableFuture<Boolean> canBeReleased() {
        return CompletableFuture.completedFuture(this.shuffleEnvironment.getPartitionsOccupyingLocalResources().isEmpty());
    }

    @Override
    public CompletableFuture<Collection<LogInfo>> requestLogList(Time timeout) {
        return CompletableFuture.supplyAsync(() -> {
            String logDir = this.taskManagerConfiguration.getTaskManagerLogDir();
            if (logDir != null) {
                File[] logFiles = new File(logDir).listFiles();
                if (logFiles == null) {
                    throw new CompletionException(new FlinkException(String.format("There isn't a log file in TaskExecutor\u2019s log dir %s.", logDir)));
                }
                return Arrays.stream(logFiles).filter(File::isFile).map(logFile -> new LogInfo(logFile.getName(), logFile.length(), logFile.lastModified())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }, this.ioExecutor);
    }

    public void onStart() throws Exception {
        try {
            this.startTaskExecutorServices();
        }
        catch (Throwable t) {
            TaskManagerException exception = new TaskManagerException(String.format("Could not start the TaskExecutor %s", this.getAddress()), t);
            this.onFatalError(exception);
            throw exception;
        }
        this.startRegistrationTimeout();
    }

    private void startTaskExecutorServices() throws Exception {
        try {
            this.resourceManagerLeaderRetriever.start(new ResourceManagerLeaderListener());
            this.taskSlotTable.start(new SlotActionsImpl(), (ComponentMainThreadExecutor)this.getMainThreadExecutor());
            this.jobLeaderService.start(this.getAddress(), this.getRpcService(), this.haServices, new JobLeaderListenerImpl());
            this.fileCache = new FileCache(this.taskManagerConfiguration.getTmpDirectories(), this.taskExecutorBlobService.getPermanentBlobService());
            this.tryLoadLocalAllocationSnapshots();
        }
        catch (Exception e) {
            this.handleStartTaskExecutorServicesException(e);
        }
    }

    private void handleStartTaskExecutorServicesException(Exception e) throws Exception {
        try {
            this.stopTaskExecutorServices();
        }
        catch (Exception inner) {
            e.addSuppressed(inner);
        }
        throw e;
    }

    public CompletableFuture<Void> onStop() {
        this.log.info("Stopping TaskExecutor {}.", (Object)this.getAddress());
        Throwable jobManagerDisconnectThrowable = null;
        FlinkExpectedException cause = new FlinkExpectedException("The TaskExecutor is shutting down.");
        this.closeResourceManagerConnection((Exception)cause);
        for (JobTable.Job job : this.jobTable.getJobs()) {
            try {
                this.closeJob(job, (Exception)cause);
            }
            catch (Throwable t) {
                jobManagerDisconnectThrowable = ExceptionUtils.firstOrSuppressed((Throwable)t, jobManagerDisconnectThrowable);
            }
        }
        this.changelogStoragesManager.shutdown();
        this.channelStateExecutorFactoryManager.shutdown();
        this.jobInformationCache.clear();
        this.taskInformationCache.clear();
        this.shuffleDescriptorsCache.clear();
        Preconditions.checkState((boolean)this.jobTable.isEmpty());
        Throwable throwableBeforeTasksCompletion = jobManagerDisconnectThrowable;
        return FutureUtils.runAfterwards((CompletableFuture)this.taskSlotTable.closeAsync(), this::stopTaskExecutorServices).handle((ignored, throwable) -> {
            this.handleOnStopException(throwableBeforeTasksCompletion, (Throwable)throwable);
            return null;
        });
    }

    private void handleOnStopException(Throwable throwableBeforeTasksCompletion, Throwable throwableAfterTasksCompletion) {
        Throwable throwable = throwableBeforeTasksCompletion != null ? ExceptionUtils.firstOrSuppressed((Throwable)throwableBeforeTasksCompletion, (Throwable)throwableAfterTasksCompletion) : throwableAfterTasksCompletion;
        if (throwable != null) {
            throw new CompletionException(new FlinkException("Error while shutting the TaskExecutor down.", throwable));
        }
        this.log.info("Stopped TaskExecutor {}.", (Object)this.getAddress());
    }

    private void stopTaskExecutorServices() throws Exception {
        Exception exception = null;
        try {
            this.threadInfoSampleService.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
        }
        try {
            this.jobLeaderService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.resourceManagerLeaderRetriever.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.taskExecutorServices.shutDown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.fileCache.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        this.taskManagerMetricGroup.close();
        ExceptionUtils.tryRethrowException((Exception)exception);
    }

    @Override
    public CompletableFuture<TaskThreadInfoResponse> requestThreadInfoSamples(Collection<ExecutionAttemptID> taskExecutionAttemptIds, ThreadInfoSamplesRequest requestParams, Time timeout) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (ExecutionAttemptID executionAttemptId : taskExecutionAttemptIds) {
            Task task2 = this.taskSlotTable.getTask(executionAttemptId);
            if (task2 == null) {
                this.log.warn(String.format("Cannot sample task %s. Task is not known to the task manager.", executionAttemptId));
                continue;
            }
            tasks.add(task2);
        }
        Map<Long, ExecutionAttemptID> sampleableTasks = tasks.stream().collect(Collectors.toMap(task -> task.getExecutingThread().getId(), Task::getExecutionId));
        CompletableFuture<Map<ExecutionAttemptID, Collection<ThreadInfoSample>>> stackTracesFuture = this.threadInfoSampleService.requestThreadInfoSamples(sampleableTasks, requestParams);
        return stackTracesFuture.thenApply(TaskThreadInfoResponse::new);
    }

    @Override
    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, JobMasterId jobMasterId, Time timeout) {
        try {
            boolean taskAdded;
            MemoryManager memoryManager;
            StateChangelogStorage<?> changelogStorage;
            TaskInformation taskInformation;
            JobInformation jobInformation;
            JobID jobId = tdd.getJobId();
            ExecutionAttemptID executionAttemptID = tdd.getExecutionAttemptId();
            JobTable.Connection jobManagerConnection = this.jobTable.getConnection(jobId).orElseThrow(() -> {
                String message = "Could not submit task because there is no JobManager associated for the job " + jobId + '.';
                this.log.debug(message);
                return new TaskSubmissionException(message);
            });
            if (!Objects.equals((Object)jobManagerConnection.getJobMasterId(), (Object)jobMasterId)) {
                String message = "Rejecting the task submission because the job manager leader id " + (Object)((Object)jobMasterId) + " does not match the expected job manager leader id " + (Object)((Object)jobManagerConnection.getJobMasterId()) + '.';
                this.log.debug(message);
                throw new TaskSubmissionException(message);
            }
            if (!this.taskSlotTable.tryMarkSlotActive(jobId, tdd.getAllocationId())) {
                String message = "No task slot allocated for job ID " + jobId + " and allocation ID " + (Object)((Object)tdd.getAllocationId()) + '.';
                this.log.debug(message);
                throw new TaskSubmissionException(message);
            }
            try {
                tdd.loadBigData(this.taskExecutorBlobService.getPermanentBlobService(), this.jobInformationCache, this.taskInformationCache, this.shuffleDescriptorsCache);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new TaskSubmissionException("Could not re-integrate offloaded TaskDeploymentDescriptor data.", e);
            }
            try {
                jobInformation = tdd.getJobInformation();
                taskInformation = tdd.getTaskInformation();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new TaskSubmissionException("Could not deserialize the job or task information.", e);
            }
            if (!jobId.equals((Object)jobInformation.getJobId())) {
                throw new TaskSubmissionException("Inconsistent job ID information inside TaskDeploymentDescriptor (" + tdd.getJobId() + " vs. " + jobInformation.getJobId() + ")");
            }
            TaskManagerJobMetricGroup jobGroup = this.taskManagerMetricGroup.addJob(jobInformation.getJobId(), jobInformation.getJobName());
            TaskMetricGroup taskMetricGroup = jobGroup.addTask(tdd.getExecutionAttemptId(), taskInformation.getTaskName());
            RpcInputSplitProvider inputSplitProvider = new RpcInputSplitProvider(jobManagerConnection.getJobManagerGateway(), taskInformation.getJobVertexId(), tdd.getExecutionAttemptId(), this.taskManagerConfiguration.getRpcTimeout());
            RpcTaskOperatorEventGateway taskOperatorEventGateway = new RpcTaskOperatorEventGateway(jobManagerConnection.getJobManagerGateway(), executionAttemptID, t -> this.runAsync(() -> this.failTask(executionAttemptID, (Throwable)t)));
            TaskManagerActions taskManagerActions = jobManagerConnection.getTaskManagerActions();
            CheckpointResponder checkpointResponder = jobManagerConnection.getCheckpointResponder();
            GlobalAggregateManager aggregateManager = jobManagerConnection.getGlobalAggregateManager();
            LibraryCacheManager.ClassLoaderHandle classLoaderHandle = jobManagerConnection.getClassLoaderHandle();
            PartitionProducerStateChecker partitionStateChecker = jobManagerConnection.getPartitionStateChecker();
            TaskLocalStateStore localStateStore = this.localStateStoresManager.localStateStoreForSubtask(jobId, tdd.getAllocationId(), taskInformation.getJobVertexId(), tdd.getSubtaskIndex(), this.taskManagerConfiguration.getConfiguration(), (Configuration)jobInformation.getJobConfiguration());
            FileMergingSnapshotManager fileMergingSnapshotManager = this.fileMergingManager.fileMergingSnapshotManagerForJob(jobId);
            try {
                changelogStorage = this.changelogStoragesManager.stateChangelogStorageForJob(jobId, this.taskManagerConfiguration.getConfiguration(), jobGroup, localStateStore.getLocalRecoveryConfig());
            }
            catch (IOException e) {
                throw new TaskSubmissionException(e);
            }
            JobManagerTaskRestore taskRestore = tdd.getTaskRestore();
            TaskStateManagerImpl taskStateManager = new TaskStateManagerImpl(jobId, tdd.getExecutionAttemptId(), localStateStore, fileMergingSnapshotManager, changelogStorage, this.changelogStoragesManager, taskRestore, checkpointResponder);
            try {
                memoryManager = this.taskSlotTable.getTaskMemoryManager(tdd.getAllocationId());
            }
            catch (SlotNotFoundException e) {
                throw new TaskSubmissionException("Could not submit task.", e);
            }
            Task task = new Task(jobInformation, taskInformation, tdd.getExecutionAttemptId(), tdd.getAllocationId(), tdd.getProducedPartitions(), tdd.getInputGates(), memoryManager, this.sharedResources, this.taskExecutorServices.getIOManager(), this.taskExecutorServices.getShuffleEnvironment(), this.taskExecutorServices.getKvStateService(), this.taskExecutorServices.getBroadcastVariableManager(), this.taskExecutorServices.getTaskEventDispatcher(), this.externalResourceInfoProvider, taskStateManager, taskManagerActions, inputSplitProvider, checkpointResponder, taskOperatorEventGateway, aggregateManager, classLoaderHandle, this.fileCache, this.taskManagerConfiguration, taskMetricGroup, partitionStateChecker, (Executor)this.getRpcService().getScheduledExecutor(), this.channelStateExecutorFactoryManager.getOrCreateExecutorFactory(jobId));
            taskMetricGroup.gauge("isBackPressured", task::isBackPressured);
            this.log.info("Received task {} ({}), deploy into slot with allocation id {}.", new Object[]{task.getTaskInfo().getTaskNameWithSubtasks(), tdd.getExecutionAttemptId(), tdd.getAllocationId()});
            try {
                taskAdded = this.taskSlotTable.addTask(task);
            }
            catch (SlotNotActiveException | SlotNotFoundException e) {
                throw new TaskSubmissionException("Could not submit task.", e);
            }
            if (taskAdded) {
                task.startTaskThread();
                this.setupResultPartitionBookkeeping(tdd.getJobId(), tdd.getProducedPartitions(), task.getTerminationFuture());
                return CompletableFuture.completedFuture(Acknowledge.get());
            }
            String message = "TaskManager already contains a task for id " + task.getExecutionId() + '.';
            this.log.debug(message);
            throw new TaskSubmissionException(message);
        }
        catch (TaskSubmissionException e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    private void setupResultPartitionBookkeeping(JobID jobId, Collection<ResultPartitionDeploymentDescriptor> producedResultPartitions, CompletableFuture<ExecutionState> terminationFuture) {
        Set partitionsRequiringRelease = this.filterPartitionsRequiringRelease(producedResultPartitions).peek(rpdd -> this.partitionTracker.startTrackingPartition(jobId, TaskExecutorPartitionInfo.from(rpdd))).map(ResultPartitionDeploymentDescriptor::getShuffleDescriptor).map(ShuffleDescriptor::getResultPartitionID).collect(Collectors.toSet());
        CompletionStage taskTerminationWithResourceCleanupFuture = terminationFuture.thenApplyAsync(executionState -> {
            if (executionState != ExecutionState.FINISHED) {
                this.partitionTracker.stopTrackingPartitions(partitionsRequiringRelease);
            }
            return executionState;
        }, (Executor)this.getMainThreadExecutor());
        this.taskResultPartitionCleanupFuturesPerJob.compute(jobId, (arg_0, arg_1) -> TaskExecutor.lambda$setupResultPartitionBookkeeping$9((CompletableFuture)taskTerminationWithResourceCleanupFuture, arg_0, arg_1));
    }

    private Stream<ResultPartitionDeploymentDescriptor> filterPartitionsRequiringRelease(Collection<ResultPartitionDeploymentDescriptor> producedResultPartitions) {
        return producedResultPartitions.stream().filter(d -> d.getPartitionType().isReleaseByScheduler()).filter(d -> d.getShuffleDescriptor().storesLocalResourcesOn().isPresent());
    }

    @Override
    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            try {
                task.cancelExecution();
                return CompletableFuture.completedFuture(Acknowledge.get());
            }
            catch (Throwable t) {
                return FutureUtils.completedExceptionally((Throwable)new TaskException("Cannot cancel task for execution " + executionAttemptID + '.', t));
            }
        }
        String message = "Cannot find task to stop for execution " + executionAttemptID + '.';
        this.log.debug(message);
        return FutureUtils.completedExceptionally((Throwable)new TaskException(message));
    }

    @Override
    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            for (PartitionInfo partitionInfo : partitionInfos) {
                FutureUtils.assertNoException(CompletableFuture.runAsync(() -> {
                    try {
                        if (!this.shuffleEnvironment.updatePartitionInfo(executionAttemptID, partitionInfo)) {
                            this.log.debug("Discard update for input gate partition {} of result {} in task {}. The partition is no longer available.", new Object[]{partitionInfo.getShuffleDescriptor().getResultPartitionID(), partitionInfo.getIntermediateDataSetID(), executionAttemptID});
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        this.log.error("Could not update input data location for task {}. Trying to fail task.", (Object)task.getTaskInfo().getTaskName(), (Object)e);
                        task.failExternally(e);
                    }
                }, (Executor)this.getRpcService().getScheduledExecutor()));
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        this.log.debug("Discard update for input partitions of task {}. Task is no longer running.", (Object)executionAttemptID);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public void releasePartitions(JobID jobId, Set<ResultPartitionID> partitionIds) {
        try {
            this.partitionTracker.stopTrackingAndReleaseJobPartitions(partitionIds);
            this.closeJobManagerConnectionIfNoAllocatedResources(jobId);
        }
        catch (Throwable t) {
            this.onFatalError(t);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> promotePartitions(JobID jobId, Set<ResultPartitionID> partitionIds) {
        CompletableFuture<Acknowledge> future = new CompletableFuture<Acknowledge>();
        try {
            this.partitionTracker.promoteJobPartitions(partitionIds);
            if (this.establishedResourceManagerConnection != null) {
                this.establishedResourceManagerConnection.getResourceManagerGateway().reportClusterPartitions(this.getResourceID(), this.partitionTracker.createClusterPartitionReport()).thenAccept(ignore -> future.complete(Acknowledge.get()));
            } else {
                future.completeExceptionally(new RuntimeException("Task executor is not connecting to ResourceManager. Fail to report cluster partition to ResourceManager"));
            }
            this.closeJobManagerConnectionIfNoAllocatedResources(jobId);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            this.onFatalError(t);
        }
        return future;
    }

    @Override
    public CompletableFuture<Acknowledge> releaseClusterPartitions(Collection<IntermediateDataSetID> dataSetsToRelease, Time timeout) {
        this.partitionTracker.stopTrackingAndReleaseClusterPartitions(dataSetsToRelease);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID resourceID, AllocatedSlotReport allocatedSlotReport) {
        return this.jobManagerHeartbeatManager.requestHeartbeat(resourceID, allocatedSlotReport);
    }

    @Override
    public CompletableFuture<Void> heartbeatFromResourceManager(ResourceID resourceID) {
        return this.resourceManagerHeartbeatManager.requestHeartbeat(resourceID, null);
    }

    @Override
    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long checkpointTimestamp, CheckpointOptions checkpointOptions) {
        this.log.debug("Trigger checkpoint {}@{} for {}.", new Object[]{checkpointId, checkpointTimestamp, executionAttemptID});
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            task.triggerCheckpointBarrier(checkpointId, checkpointTimestamp, checkpointOptions);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        String message = "TaskManager received a checkpoint request for unknown task " + executionAttemptID + '.';
        this.log.debug(message);
        return FutureUtils.completedExceptionally((Throwable)new CheckpointException(message, CheckpointFailureReason.TASK_CHECKPOINT_FAILURE));
    }

    @Override
    public CompletableFuture<Acknowledge> confirmCheckpoint(ExecutionAttemptID executionAttemptID, long completedCheckpointId, long completedCheckpointTimestamp, long lastSubsumedCheckpointId) {
        this.log.debug("Confirm completed checkpoint {}@{} and last subsumed checkpoint {} for {}.", new Object[]{completedCheckpointId, completedCheckpointTimestamp, lastSubsumedCheckpointId, executionAttemptID});
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            task.notifyCheckpointComplete(completedCheckpointId);
            task.notifyCheckpointSubsumed(lastSubsumedCheckpointId);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        String message = "TaskManager received a checkpoint confirmation for unknown task " + executionAttemptID + '.';
        this.log.debug(message);
        return FutureUtils.completedExceptionally((Throwable)new CheckpointException(message, CheckpointFailureReason.UNKNOWN_TASK_CHECKPOINT_NOTIFICATION_FAILURE));
    }

    @Override
    public CompletableFuture<Acknowledge> abortCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long latestCompletedCheckpointId, long checkpointTimestamp) {
        this.log.debug("Abort checkpoint {}@{} for {}.", new Object[]{checkpointId, checkpointTimestamp, executionAttemptID});
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            task.notifyCheckpointAborted(checkpointId, latestCompletedCheckpointId);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        String message = "TaskManager received an aborted checkpoint for unknown task " + executionAttemptID + '.';
        this.log.debug(message);
        return FutureUtils.completedExceptionally((Throwable)new CheckpointException(message, CheckpointFailureReason.UNKNOWN_TASK_CHECKPOINT_NOTIFICATION_FAILURE));
    }

    @Override
    public CompletableFuture<Acknowledge> requestSlot(SlotID slotId, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress, ResourceManagerId resourceManagerId, Time timeout) {
        this.log.info("Receive slot request {} for job {} from resource manager with leader id {}.", new Object[]{allocationId, jobId, resourceManagerId});
        if (!this.isConnectedToResourceManager(resourceManagerId)) {
            String message = String.format("TaskManager is not connected to the resource manager %s.", new Object[]{resourceManagerId});
            this.log.debug(message);
            return FutureUtils.completedExceptionally((Throwable)new TaskManagerException(message));
        }
        this.tryPersistAllocationSnapshot(new SlotAllocationSnapshot(slotId, jobId, targetAddress, allocationId, resourceProfile));
        try {
            boolean isConnected = this.allocateSlotForJob(jobId, slotId, allocationId, resourceProfile, targetAddress);
            if (isConnected) {
                this.offerSlotsToJobManager(jobId);
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (SlotAllocationException e) {
            this.log.debug("Could not allocate slot for allocation id {}.", (Object)allocationId, (Object)e);
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }

    private boolean allocateSlotForJob(JobID jobId, SlotID slotId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress) throws SlotAllocationException {
        JobTable.Job job;
        this.allocateSlot(slotId, jobId, allocationId, resourceProfile);
        try {
            job = this.jobTable.getOrCreateJob(jobId, () -> this.registerNewJobAndCreateServices(jobId, targetAddress));
        }
        catch (Exception e) {
            try {
                this.taskSlotTable.freeSlot(allocationId);
            }
            catch (SlotNotFoundException slotNotFoundException) {
                this.onFatalError(slotNotFoundException);
            }
            this.localStateStoresManager.releaseLocalStateForAllocationId(allocationId);
            if (!this.taskSlotTable.isSlotFree(slotId.getSlotNumber())) {
                this.onFatalError(new Exception("Could not free slot " + slotId));
            }
            throw new SlotAllocationException("Could not create new job.", e);
        }
        return job.isConnected();
    }

    private TaskExecutorJobServices registerNewJobAndCreateServices(JobID jobId, String targetAddress) throws Exception {
        this.jobLeaderService.addJob(jobId, targetAddress);
        JobPermanentBlobService permanentBlobService = this.taskExecutorBlobService.getPermanentBlobService();
        permanentBlobService.registerJob(jobId);
        return TaskExecutorJobServices.create(this.libraryCacheManager.registerClassLoaderLease(jobId), () -> permanentBlobService.releaseJob(jobId));
    }

    private void allocateSlot(SlotID slotId, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile) throws SlotAllocationException {
        if (this.taskSlotTable.isSlotFree(slotId.getSlotNumber())) {
            if (!this.taskSlotTable.allocateSlot(slotId.getSlotNumber(), jobId, allocationId, resourceProfile, this.taskManagerConfiguration.getSlotTimeout())) {
                this.log.info("Could not allocate slot for {}.", (Object)allocationId);
                throw new SlotAllocationException("Could not allocate slot.");
            }
        } else if (!this.taskSlotTable.isAllocated(slotId.getSlotNumber(), jobId, allocationId)) {
            String message = "The slot " + slotId + " has already been allocated for a different job.";
            this.log.info(message);
            AllocationID allocationID = this.taskSlotTable.getCurrentAllocation(slotId.getSlotNumber());
            throw new SlotOccupiedException(message, allocationID, this.taskSlotTable.getOwningJob(allocationID));
        }
    }

    @Override
    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        this.freeSlotInternal(allocationId, cause);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public void freeInactiveSlots(JobID jobId, Time timeout) {
        this.log.debug("Freeing inactive slots for job {}.", (Object)jobId);
        ImmutableList inactiveSlots = ImmutableList.copyOf(this.taskSlotTable.getAllocatedSlots(jobId));
        for (TaskSlot slot : inactiveSlots) {
            this.freeSlotInternal(slot.getAllocationId(), new FlinkException("Slot was re-claimed by resource manager."));
        }
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestFileUploadByType(FileType fileType, Time timeout) {
        String filePath;
        switch (fileType) {
            case LOG: {
                filePath = this.taskManagerConfiguration.getTaskManagerLogPath();
                break;
            }
            case STDOUT: {
                filePath = this.taskManagerConfiguration.getTaskManagerStdoutPath();
                break;
            }
            default: {
                filePath = null;
            }
        }
        return this.requestFileUploadByFilePath(filePath, fileType.toString());
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestFileUploadByName(String fileName, Duration timeout) {
        return this.requestFileUploadByNameAndType(fileName, FileType.LOG, timeout);
    }

    @Override
    public CompletableFuture<TransientBlobKey> requestFileUploadByNameAndType(String fileName, FileType fileType, Duration timeout) {
        String baseDir;
        switch (fileType) {
            case LOG: {
                baseDir = this.taskManagerConfiguration.getTaskManagerLogDir();
                break;
            }
            case PROFILER: {
                baseDir = this.profilingService.getProfilingResultDir();
                break;
            }
            default: {
                baseDir = null;
            }
        }
        String filePath = StringUtils.isNullOrWhitespaceOnly((String)baseDir) || StringUtils.isNullOrWhitespaceOnly((String)fileName) ? null : new File(baseDir, new File(fileName).getName()).getPath();
        return this.requestFileUploadByFilePath(filePath, fileName);
    }

    @Override
    public CompletableFuture<SerializableOptional<String>> requestMetricQueryServiceAddress(Time timeout) {
        return CompletableFuture.completedFuture(SerializableOptional.ofNullable((Serializable)((Object)this.metricQueryServiceAddress)));
    }

    @Override
    public void disconnectJobManager(JobID jobId, Exception cause) {
        this.jobTable.getConnection(jobId).ifPresent(jobManagerConnection -> this.disconnectAndTryReconnectToJobManager((JobTable.Connection)jobManagerConnection, cause));
    }

    private void disconnectAndTryReconnectToJobManager(JobTable.Connection jobManagerConnection, Exception cause) {
        this.disconnectJobManagerConnection(jobManagerConnection, cause);
        this.jobLeaderService.reconnect(jobManagerConnection.getJobId());
    }

    @Override
    public void disconnectResourceManager(Exception cause) {
        if (this.isRunning()) {
            this.reconnectToResourceManager(cause);
        }
    }

    @Override
    public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID executionAttemptID, OperatorID operatorId, SerializedValue<OperatorEvent> evt) {
        this.log.debug("Operator event for {} - {}", (Object)executionAttemptID, (Object)operatorId);
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task == null) {
            return FutureUtils.completedExceptionally((Throwable)((Object)new TaskNotRunningException("Task " + executionAttemptID + " not running on TaskManager")));
        }
        try {
            task.deliverOperatorEvent(operatorId, evt);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError((Throwable)t);
            return FutureUtils.completedExceptionally((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ThreadDumpInfo> requestThreadDump(Time timeout) {
        int stacktraceMaxDepth = (Integer)this.taskManagerConfiguration.getConfiguration().get(ClusterOptions.THREAD_DUMP_STACKTRACE_MAX_DEPTH);
        return CompletableFuture.completedFuture(ThreadDumpInfo.dumpAndCreate(stacktraceMaxDepth));
    }

    @Override
    public CompletableFuture<Acknowledge> updateDelegationTokens(ResourceManagerId resourceManagerId, byte[] tokens) {
        this.log.info("Receive update delegation tokens from resource manager with leader id {}.", (Object)resourceManagerId);
        if (!this.isConnectedToResourceManager(resourceManagerId)) {
            String message = String.format("TaskManager is not connected to the resource manager %s.", new Object[]{resourceManagerId});
            this.log.debug(message);
            return FutureUtils.completedExceptionally((Throwable)new TaskManagerException(message));
        }
        try {
            this.delegationTokenReceiverRepository.onNewTokensObtained(tokens);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (Throwable t) {
            this.log.error("Could not update delegation tokens.", t);
            ExceptionUtils.rethrowIfFatalError((Throwable)t);
            return FutureUtils.completedExceptionally((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ProfilingInfo> requestProfiling(int duration, ProfilingInfo.ProfilingMode mode, Duration timeout) {
        return this.profilingService.requestProfiling(this.getResourceID().getResourceIdString(), duration, mode);
    }

    @Override
    public CompletableFuture<Collection<ProfilingInfo>> requestProfilingList(Duration timeout) {
        return this.profilingService.getProfilingList(this.getResourceID().getResourceIdString());
    }

    private void notifyOfNewResourceManagerLeader(String newLeaderAddress, ResourceManagerId newResourceManagerId) {
        this.resourceManagerAddress = this.createResourceManagerAddress(newLeaderAddress, newResourceManagerId);
        this.reconnectToResourceManager((Exception)((Object)new FlinkException(String.format("ResourceManager leader changed to new address %s", this.resourceManagerAddress))));
    }

    @Nullable
    private ResourceManagerAddress createResourceManagerAddress(@Nullable String newLeaderAddress, @Nullable ResourceManagerId newResourceManagerId) {
        if (newLeaderAddress == null) {
            return null;
        }
        assert (newResourceManagerId != null);
        return new ResourceManagerAddress(newLeaderAddress, newResourceManagerId);
    }

    private void reconnectToResourceManager(Exception cause) {
        this.closeResourceManagerConnection(cause);
        this.startRegistrationTimeout();
        this.tryConnectToResourceManager();
    }

    private void tryConnectToResourceManager() {
        if (this.resourceManagerAddress != null) {
            this.connectToResourceManager();
        }
    }

    private void connectToResourceManager() {
        assert (this.resourceManagerAddress != null);
        assert (this.establishedResourceManagerConnection == null);
        assert (this.resourceManagerConnection == null);
        this.log.info("Connecting to ResourceManager {}.", (Object)this.resourceManagerAddress);
        TaskExecutorRegistration taskExecutorRegistration = new TaskExecutorRegistration(this.getAddress(), this.getResourceID(), this.unresolvedTaskManagerLocation.getDataPort(), JMXService.getPort().orElse(-1), this.hardwareDescription, this.memoryConfiguration, this.taskManagerConfiguration.getDefaultSlotResourceProfile(), this.taskManagerConfiguration.getTotalResourceProfile(), this.unresolvedTaskManagerLocation.getNodeId());
        this.resourceManagerConnection = new TaskExecutorToResourceManagerConnection(this.log, this.getRpcService(), this.taskManagerConfiguration.getRetryingRegistrationConfiguration(), this.resourceManagerAddress.getAddress(), this.resourceManagerAddress.getResourceManagerId(), (Executor)this.getMainThreadExecutor(), new ResourceManagerRegistrationListener(), taskExecutorRegistration);
        this.resourceManagerConnection.start();
    }

    private void establishResourceManagerConnection(ResourceManagerGateway resourceManagerGateway, ResourceID resourceManagerResourceId, InstanceID taskExecutorRegistrationId, ClusterInformation clusterInformation) {
        CompletableFuture<Acknowledge> slotReportResponseFuture = resourceManagerGateway.sendSlotReport(this.getResourceID(), taskExecutorRegistrationId, this.taskSlotTable.createSlotReport(this.getResourceID()), Time.fromDuration((Duration)this.taskManagerConfiguration.getRpcTimeout()));
        slotReportResponseFuture.whenCompleteAsync((acknowledge, throwable) -> {
            if (throwable != null) {
                this.reconnectToResourceManager(new TaskManagerException("Failed to send initial slot report to ResourceManager.", (Throwable)throwable));
            }
        }, (Executor)this.getMainThreadExecutor());
        this.resourceManagerHeartbeatManager.monitorTarget(resourceManagerResourceId, new ResourceManagerHeartbeatReceiver(resourceManagerGateway));
        InetSocketAddress blobServerAddress = new InetSocketAddress(clusterInformation.getBlobServerHostname(), clusterInformation.getBlobServerPort());
        this.taskExecutorBlobService.setBlobServerAddress(blobServerAddress);
        this.establishedResourceManagerConnection = new EstablishedResourceManagerConnection(resourceManagerGateway, resourceManagerResourceId, taskExecutorRegistrationId);
        this.stopRegistrationTimeout();
    }

    private void closeResourceManagerConnection(Exception cause) {
        if (this.establishedResourceManagerConnection != null) {
            ResourceID resourceManagerResourceId = this.establishedResourceManagerConnection.getResourceManagerResourceId();
            this.log.info("Close ResourceManager connection {}.", (Object)resourceManagerResourceId, (Object)ExceptionUtils.returnExceptionIfUnexpected((Throwable)cause.getCause()));
            ExceptionUtils.logExceptionIfExcepted((Throwable)cause.getCause(), (Logger)this.log);
            this.resourceManagerHeartbeatManager.unmonitorTarget(resourceManagerResourceId);
            ResourceManagerGateway resourceManagerGateway = this.establishedResourceManagerConnection.getResourceManagerGateway();
            resourceManagerGateway.disconnectTaskManager(this.getResourceID(), cause);
            this.establishedResourceManagerConnection = null;
            this.partitionTracker.stopTrackingAndReleaseAllClusterPartitions();
        }
        if (this.resourceManagerConnection != null) {
            if (!this.resourceManagerConnection.isConnected()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Terminating registration attempts towards ResourceManager {}.", (Object)this.resourceManagerConnection.getTargetAddress(), (Object)cause);
                } else {
                    this.log.info("Terminating registration attempts towards ResourceManager {}.", (Object)this.resourceManagerConnection.getTargetAddress());
                }
            }
            this.resourceManagerConnection.close();
            this.resourceManagerConnection = null;
        }
    }

    private void startRegistrationTimeout() {
        Duration maxRegistrationDuration = this.taskManagerConfiguration.getMaxRegistrationDuration();
        if (maxRegistrationDuration != null) {
            UUID newRegistrationTimeoutId;
            this.currentRegistrationTimeoutId = newRegistrationTimeoutId = UUID.randomUUID();
            this.scheduleRunAsync(() -> this.registrationTimeout(newRegistrationTimeoutId), maxRegistrationDuration);
        }
    }

    private void stopRegistrationTimeout() {
        this.currentRegistrationTimeoutId = null;
    }

    private void registrationTimeout(@Nonnull UUID registrationTimeoutId) {
        if (registrationTimeoutId.equals(this.currentRegistrationTimeoutId)) {
            Duration maxRegistrationDuration = this.taskManagerConfiguration.getMaxRegistrationDuration();
            this.onFatalError(new RegistrationTimeoutException(String.format("Could not register at the ResourceManager within the specified maximum registration duration %s. This indicates a problem with this instance. Terminating now.", maxRegistrationDuration)));
        }
    }

    private void offerSlotsToJobManager(JobID jobId) {
        this.jobTable.getConnection(jobId).ifPresent(this::internalOfferSlotsToJobManager);
    }

    private void internalOfferSlotsToJobManager(JobTable.Connection jobManagerConnection) {
        JobID jobId = jobManagerConnection.getJobId();
        if (this.taskSlotTable.hasAllocatedSlots(jobId)) {
            this.log.info("Offer reserved slots to the leader of job {}.", (Object)jobId);
            JobMasterGateway jobMasterGateway = jobManagerConnection.getJobManagerGateway();
            Iterator<TaskSlot<Task>> reservedSlotsIterator = this.taskSlotTable.getAllocatedSlots(jobId);
            JobMasterId jobMasterId = jobManagerConnection.getJobMasterId();
            HashSet reservedSlots = CollectionUtil.newHashSetWithExpectedSize((int)2);
            while (reservedSlotsIterator.hasNext()) {
                SlotOffer offer = reservedSlotsIterator.next().generateSlotOffer();
                reservedSlots.add(offer);
            }
            UUID slotOfferId = UUID.randomUUID();
            this.currentSlotOfferPerJob.put(jobId, slotOfferId);
            CompletableFuture<Collection<SlotOffer>> acceptedSlotsFuture = jobMasterGateway.offerSlots(this.getResourceID(), reservedSlots, Time.fromDuration((Duration)this.taskManagerConfiguration.getRpcTimeout()));
            acceptedSlotsFuture.whenCompleteAsync(this.handleAcceptedSlotOffers(jobId, jobMasterGateway, jobMasterId, reservedSlots, slotOfferId), (Executor)this.getMainThreadExecutor());
        } else {
            this.log.debug("There are no unassigned slots for the job {}.", (Object)jobId);
        }
    }

    @Nonnull
    private BiConsumer<Iterable<SlotOffer>, Throwable> handleAcceptedSlotOffers(JobID jobId, JobMasterGateway jobMasterGateway, JobMasterId jobMasterId, Collection<SlotOffer> offeredSlots, UUID offerId) {
        return (acceptedSlots, throwable) -> {
            if (!offerId.equals(this.currentSlotOfferPerJob.get(jobId))) {
                this.log.debug("Discard slot offer response since there is a newer offer for the job {}.", (Object)jobId);
                return;
            }
            if (throwable != null) {
                if (throwable instanceof TimeoutException) {
                    this.log.info("Slot offering to JobManager did not finish in time. Retrying the slot offering.");
                    this.offerSlotsToJobManager(jobId);
                } else {
                    this.log.warn("Slot offering to JobManager failed. Freeing the slots and returning them to the ResourceManager.", throwable);
                    for (SlotOffer reservedSlot : offeredSlots) {
                        this.freeSlotInternal(reservedSlot.getAllocationId(), (Throwable)throwable);
                    }
                }
            } else if (this.isJobManagerConnectionValid(jobId, jobMasterId)) {
                for (SlotOffer acceptedSlot : acceptedSlots) {
                    AllocationID allocationId = acceptedSlot.getAllocationId();
                    try {
                        if (!this.taskSlotTable.markSlotActive(allocationId)) {
                            String message = "Could not mark slot " + (Object)((Object)allocationId) + " active.";
                            this.log.debug(message);
                            jobMasterGateway.failSlot(this.getResourceID(), allocationId, (Exception)((Object)new FlinkException(message)));
                        }
                    }
                    catch (SlotNotFoundException e) {
                        String message = "Could not mark slot " + (Object)((Object)allocationId) + " active.";
                        jobMasterGateway.failSlot(this.getResourceID(), allocationId, (Exception)((Object)new FlinkException(message)));
                    }
                    offeredSlots.remove(acceptedSlot);
                }
                Exception e = new Exception("The slot was rejected by the JobManager.");
                for (SlotOffer rejectedSlot : offeredSlots) {
                    this.freeSlotInternal(rejectedSlot.getAllocationId(), e);
                }
            } else {
                this.log.debug("Discard slot offer response since there is a new leader for the job {}.", (Object)jobId);
            }
        };
    }

    private void establishJobManagerConnection(JobTable.Job job, JobMasterGateway jobMasterGateway, JMTMRegistrationSuccess registrationSuccess) {
        JobID jobId = job.getJobId();
        Optional<JobTable.Connection> connection = job.asConnection();
        if (connection.isPresent()) {
            JobTable.Connection oldJobManagerConnection = connection.get();
            if (Objects.equals((Object)oldJobManagerConnection.getJobMasterId(), jobMasterGateway.getFencingToken())) {
                this.log.debug("Ignore JobManager gained leadership message for {} because we are already connected to it.", (Object)jobMasterGateway.getFencingToken());
                return;
            }
            this.disconnectJobManagerConnection(oldJobManagerConnection, new Exception("Found new job leader for job id " + jobId + '.'));
        }
        this.log.info("Establish JobManager connection for job {}.", (Object)jobId);
        ResourceID jobManagerResourceID = registrationSuccess.getResourceID();
        JobTable.Connection establishedConnection = this.associateWithJobManager(job, jobManagerResourceID, jobMasterGateway);
        this.jobManagerHeartbeatManager.monitorTarget(jobManagerResourceID, new JobManagerHeartbeatReceiver(jobMasterGateway));
        this.internalOfferSlotsToJobManager(establishedConnection);
    }

    private void closeJob(JobTable.Job job, Exception cause) {
        job.asConnection().ifPresent(jobManagerConnection -> this.disconnectJobManagerConnection((JobTable.Connection)jobManagerConnection, cause));
        job.close();
    }

    private void disconnectJobManagerConnection(JobTable.Connection jobManagerConnection, Exception cause) {
        JobID jobId = jobManagerConnection.getJobId();
        this.log.info("Close JobManager connection for job {}.", (Object)jobId, (Object)ExceptionUtils.returnExceptionIfUnexpected((Throwable)cause.getCause()));
        ExceptionUtils.logExceptionIfExcepted((Throwable)cause.getCause(), (Logger)this.log);
        Iterator<Task> tasks = this.taskSlotTable.getTasks(jobId);
        FlinkException failureCause = new FlinkException(String.format("Disconnect from JobManager responsible for %s.", jobId), (Throwable)cause);
        while (tasks.hasNext()) {
            tasks.next().failExternally(failureCause);
        }
        Set<AllocationID> activeSlotAllocationIDs = this.taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId);
        FlinkException freeingCause = new FlinkException("Slot could not be marked inactive.");
        for (AllocationID activeSlotAllocationID : activeSlotAllocationIDs) {
            try {
                if (this.taskSlotTable.markSlotInactive(activeSlotAllocationID, this.taskManagerConfiguration.getSlotTimeout())) continue;
                this.freeSlotInternal(activeSlotAllocationID, freeingCause);
            }
            catch (SlotNotFoundException e) {
                this.log.debug("Could not mark the slot {} inactive.", (Object)activeSlotAllocationID, (Object)e);
            }
        }
        try {
            this.jobManagerHeartbeatManager.unmonitorTarget(jobManagerConnection.getResourceId());
            this.disassociateFromJobManager(jobManagerConnection, cause);
        }
        catch (IOException e) {
            this.log.warn("Could not properly disassociate from JobManager {}.", (Object)jobManagerConnection.getJobManagerGateway().getAddress(), (Object)e);
        }
        jobManagerConnection.disconnect();
    }

    private JobTable.Connection associateWithJobManager(JobTable.Job job, ResourceID resourceID, JobMasterGateway jobMasterGateway) {
        Preconditions.checkNotNull((Object)resourceID);
        Preconditions.checkNotNull((Object)jobMasterGateway);
        TaskManagerActionsImpl taskManagerActions = new TaskManagerActionsImpl(jobMasterGateway);
        RpcCheckpointResponder checkpointResponder = new RpcCheckpointResponder(jobMasterGateway);
        RpcGlobalAggregateManager aggregateManager = new RpcGlobalAggregateManager(jobMasterGateway);
        RpcPartitionStateChecker partitionStateChecker = new RpcPartitionStateChecker(jobMasterGateway);
        this.registerQueryableState(job.getJobId(), jobMasterGateway);
        return job.connect(resourceID, jobMasterGateway, taskManagerActions, checkpointResponder, aggregateManager, partitionStateChecker);
    }

    private void disassociateFromJobManager(JobTable.Connection jobManagerConnection, Exception cause) throws IOException {
        KvStateClientProxy kvStateClientProxy;
        Preconditions.checkNotNull((Object)jobManagerConnection);
        JobID jobId = jobManagerConnection.getJobId();
        this.scheduleResultPartitionCleanup(jobId);
        KvStateRegistry kvStateRegistry = this.kvStateService.getKvStateRegistry();
        if (kvStateRegistry != null) {
            kvStateRegistry.unregisterListener(jobId);
        }
        if ((kvStateClientProxy = this.kvStateService.getKvStateClientProxy()) != null) {
            kvStateClientProxy.updateKvStateLocationOracle(jobManagerConnection.getJobId(), null);
        }
        JobMasterGateway jobManagerGateway = jobManagerConnection.getJobManagerGateway();
        jobManagerGateway.disconnectTaskManager(this.getResourceID(), cause);
    }

    private void handleRejectedJobManagerConnection(JobID jobId, String targetAddress, JMTMRegistrationRejection rejection) {
        this.log.info("The JobManager under {} rejected the registration for job {}: {}. Releasing all job related resources.", new Object[]{targetAddress, jobId, rejection.getReason()});
        this.releaseJobResources(jobId, (Exception)((Object)new FlinkException(String.format("JobManager %s has rejected the registration.", jobId))));
    }

    private void releaseJobResources(JobID jobId, Exception cause) {
        Set<AllocationID> allocationIds;
        this.log.debug("Releasing job resources for job {}.", (Object)jobId, (Object)cause);
        if (this.partitionTracker.isTrackingPartitionsFor(jobId)) {
            this.partitionTracker.stopTrackingAndReleaseJobPartitionsFor(jobId);
        }
        if (!(allocationIds = this.taskSlotTable.getAllocationIdsPerJob(jobId)).isEmpty()) {
            for (AllocationID allocationId : allocationIds) {
                this.freeSlotInternal(allocationId, cause);
            }
        }
        this.jobLeaderService.removeJob(jobId);
        this.jobTable.getJob(jobId).ifPresent(job -> this.closeJob((JobTable.Job)job, cause));
        this.taskManagerMetricGroup.removeJobMetricsGroup(jobId);
        this.changelogStoragesManager.releaseResourcesForJob(jobId);
        this.currentSlotOfferPerJob.remove(jobId);
        this.channelStateExecutorFactoryManager.releaseResourcesForJob(jobId);
        this.jobInformationCache.clearCacheForGroup(jobId);
        this.taskInformationCache.clearCacheForGroup(jobId);
        this.shuffleDescriptorsCache.clearCacheForGroup(jobId);
        this.fileMergingManager.releaseMergingSnapshotManagerForJob(jobId);
    }

    private void scheduleResultPartitionCleanup(JobID jobId) {
        Collection<CompletableFuture<ExecutionState>> taskTerminationFutures = this.taskResultPartitionCleanupFuturesPerJob.remove(jobId);
        if (taskTerminationFutures != null) {
            FutureUtils.waitForAll(taskTerminationFutures).thenRunAsync(() -> this.partitionTracker.stopTrackingAndReleaseJobPartitionsFor(jobId), (Executor)this.getMainThreadExecutor());
        }
    }

    private void registerQueryableState(JobID jobId, JobMasterGateway jobMasterGateway) {
        KvStateClientProxy kvStateProxy;
        KvStateServer kvStateServer = this.kvStateService.getKvStateServer();
        KvStateRegistry kvStateRegistry = this.kvStateService.getKvStateRegistry();
        if (kvStateServer != null && kvStateRegistry != null) {
            kvStateRegistry.registerListener(jobId, new RpcKvStateRegistryListener(jobMasterGateway, kvStateServer.getServerAddress()));
        }
        if ((kvStateProxy = this.kvStateService.getKvStateClientProxy()) != null) {
            kvStateProxy.updateKvStateLocationOracle(jobId, jobMasterGateway);
        }
    }

    private void failTask(ExecutionAttemptID executionAttemptID, Throwable cause) {
        Task task = this.taskSlotTable.getTask(executionAttemptID);
        if (task != null) {
            try {
                task.failExternally(cause);
            }
            catch (Throwable t) {
                this.log.error("Could not fail task {}.", (Object)executionAttemptID, (Object)t);
            }
        } else {
            this.log.info("Cannot find task to fail for execution {} with exception:", (Object)executionAttemptID, (Object)cause);
        }
    }

    private void updateTaskExecutionState(JobMasterGateway jobMasterGateway, TaskExecutionState taskExecutionState) {
        ExecutionAttemptID executionAttemptID = taskExecutionState.getID();
        CompletableFuture<Acknowledge> futureAcknowledge = jobMasterGateway.updateTaskExecutionState(taskExecutionState);
        futureAcknowledge.whenCompleteAsync((ack, throwable) -> {
            if (throwable != null) {
                this.failTask(executionAttemptID, (Throwable)throwable);
            }
        }, (Executor)this.getMainThreadExecutor());
    }

    private void unregisterTaskAndNotifyFinalState(JobMasterGateway jobMasterGateway, ExecutionAttemptID executionAttemptID) {
        Task task = this.taskSlotTable.removeTask(executionAttemptID);
        if (task != null) {
            if (!task.getExecutionState().isTerminal()) {
                try {
                    task.failExternally(new IllegalStateException("Task is being remove from TaskManager."));
                }
                catch (Exception e) {
                    this.log.error("Could not properly fail task.", (Throwable)e);
                }
            }
            this.log.info("Un-registering task and sending final execution state {} to JobManager for task {} {}.", new Object[]{task.getExecutionState(), task.getTaskInfo().getTaskNameWithSubtasks(), task.getExecutionId()});
            AccumulatorSnapshot accumulatorSnapshot = task.getAccumulatorRegistry().getSnapshot();
            this.updateTaskExecutionState(jobMasterGateway, new TaskExecutionState(task.getExecutionId(), task.getExecutionState(), task.getFailureCause(), accumulatorSnapshot, task.getMetricGroup().getIOMetricGroup().createSnapshot()));
        } else {
            this.log.error("Cannot find task with ID {} to unregister.", (Object)executionAttemptID);
        }
    }

    private void freeSlotInternal(AllocationID allocationId, Throwable cause) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        if (this.isRunning()) {
            this.log.debug("Free slot with allocation id {} because: {}", (Object)allocationId, (Object)cause.getMessage());
            try {
                JobID jobId = this.taskSlotTable.getOwningJob(allocationId);
                int slotIndex = this.taskSlotTable.freeSlot(allocationId, cause);
                this.slotAllocationSnapshotPersistenceService.deleteAllocationSnapshot(slotIndex);
                if (slotIndex != -1) {
                    if (this.isConnectedToResourceManager()) {
                        ResourceManagerGateway resourceManagerGateway = this.establishedResourceManagerConnection.getResourceManagerGateway();
                        resourceManagerGateway.notifySlotAvailable(this.establishedResourceManagerConnection.getTaskExecutorRegistrationId(), new SlotID(this.getResourceID(), slotIndex), allocationId);
                    }
                    if (jobId != null) {
                        this.closeJobManagerConnectionIfNoAllocatedResources(jobId);
                    }
                }
            }
            catch (SlotNotFoundException e) {
                this.log.debug("Could not free slot for allocation id {}.", (Object)allocationId, (Object)e);
            }
            this.localStateStoresManager.releaseLocalStateForAllocationId(allocationId);
        } else {
            this.log.debug("Ignoring the freeing of slot {} because the TaskExecutor is shutting down.", (Object)allocationId);
        }
    }

    private void closeJobManagerConnectionIfNoAllocatedResources(JobID jobId) {
        if (this.taskSlotTable.getAllocationIdsPerJob(jobId).isEmpty() && !this.partitionTracker.isTrackingPartitionsFor(jobId)) {
            FlinkExpectedException cause = new FlinkExpectedException("TaskExecutor " + this.getAddress() + " has no more allocated slots for job " + jobId + '.');
            this.releaseJobResources(jobId, (Exception)cause);
        }
    }

    private void timeoutSlot(AllocationID allocationId, UUID ticket) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        Preconditions.checkNotNull((Object)ticket);
        if (this.taskSlotTable.isValidTimeout(allocationId, ticket)) {
            this.freeSlotInternal(allocationId, new Exception("The slot " + (Object)((Object)allocationId) + " has timed out."));
        } else {
            this.log.debug("Received an invalid timeout for allocation id {} with ticket {}.", (Object)allocationId, (Object)ticket);
        }
    }

    private void syncSlotsWithSnapshotFromJobMaster(JobMasterGateway jobMasterGateway, AllocatedSlotReport allocatedSlotReport) {
        this.failNoLongerAllocatedSlots(allocatedSlotReport, jobMasterGateway);
        this.freeNoLongerUsedSlots(allocatedSlotReport);
    }

    private void failNoLongerAllocatedSlots(AllocatedSlotReport allocatedSlotReport, JobMasterGateway jobMasterGateway) {
        for (AllocatedSlotInfo allocatedSlotInfo : allocatedSlotReport.getAllocatedSlotInfos()) {
            AllocationID allocationId = allocatedSlotInfo.getAllocationId();
            if (this.taskSlotTable.isAllocated(allocatedSlotInfo.getSlotIndex(), allocatedSlotReport.getJobId(), allocationId)) continue;
            jobMasterGateway.failSlot(this.getResourceID(), allocationId, (Exception)((Object)new FlinkException(String.format("Slot %s on TaskExecutor %s is not allocated by job %s.", allocatedSlotInfo.getSlotIndex(), this.getResourceID().getStringWithMetadata(), allocatedSlotReport.getJobId()))));
        }
    }

    private void freeNoLongerUsedSlots(AllocatedSlotReport allocatedSlotReport) {
        Set<AllocationID> activeSlots = this.taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(allocatedSlotReport.getJobId());
        Set reportedSlots = allocatedSlotReport.getAllocatedSlotInfos().stream().map(AllocatedSlotInfo::getAllocationId).collect(Collectors.toSet());
        Sets.SetView difference = Sets.difference(activeSlots, reportedSlots);
        for (AllocationID allocationID : difference) {
            this.freeSlotInternal(allocationID, new FlinkException(String.format("%s is no longer allocated by job %s.", new Object[]{allocationID, allocatedSlotReport.getJobId()})));
        }
    }

    private void tryPersistAllocationSnapshot(SlotAllocationSnapshot slotAllocationSnapshot) {
        try {
            this.slotAllocationSnapshotPersistenceService.persistAllocationSnapshot(slotAllocationSnapshot);
        }
        catch (IOException e) {
            this.log.debug("Cannot persist the slot allocation snapshot {}.", (Object)slotAllocationSnapshot, (Object)e);
        }
    }

    private void tryLoadLocalAllocationSnapshots() {
        Collection<SlotAllocationSnapshot> slotAllocationSnapshots = this.slotAllocationSnapshotPersistenceService.loadAllocationSnapshots();
        this.log.debug("Recovered slot allocation snapshots {}.", slotAllocationSnapshots);
        HashSet<AllocationID> allocatedSlots = new HashSet<AllocationID>();
        for (SlotAllocationSnapshot slotAllocationSnapshot : slotAllocationSnapshots) {
            try {
                this.allocateSlotForJob(slotAllocationSnapshot.getJobId(), slotAllocationSnapshot.getSlotID(), slotAllocationSnapshot.getAllocationId(), slotAllocationSnapshot.getResourceProfile(), slotAllocationSnapshot.getJobTargetAddress());
            }
            catch (SlotAllocationException e) {
                this.log.debug("Cannot reallocate restored slot {}.", (Object)slotAllocationSnapshot, (Object)e);
            }
            allocatedSlots.add(slotAllocationSnapshot.getAllocationId());
        }
        this.localStateStoresManager.retainLocalStateForAllocations(allocatedSlots);
    }

    private boolean isConnectedToResourceManager() {
        return this.establishedResourceManagerConnection != null;
    }

    private boolean isConnectedToResourceManager(ResourceManagerId resourceManagerId) {
        return this.establishedResourceManagerConnection != null && this.resourceManagerAddress != null && this.resourceManagerAddress.getResourceManagerId().equals((Object)resourceManagerId);
    }

    private boolean isJobManagerConnectionValid(JobID jobId, JobMasterId jobMasterId) {
        return this.jobTable.getConnection(jobId).map(jmConnection -> Objects.equals((Object)jmConnection.getJobMasterId(), (Object)jobMasterId)).orElse(false);
    }

    private CompletableFuture<TransientBlobKey> requestFileUploadByFilePath(String filePath, String fileTag) {
        this.log.debug("Received file upload request for file {}", (Object)fileTag);
        if (!StringUtils.isNullOrWhitespaceOnly((String)filePath)) {
            return CompletableFuture.supplyAsync(() -> {
                File file = new File(filePath);
                if (file.exists()) {
                    try {
                        return this.putTransientBlobStream(new FileInputStream(file), fileTag).get();
                    }
                    catch (Exception e) {
                        this.log.debug("Could not upload file {}.", (Object)fileTag, (Object)e);
                        throw new CompletionException(new FlinkException("Could not upload file " + fileTag + '.', (Throwable)e));
                    }
                }
                this.log.debug("The file {} does not exist on the TaskExecutor {}.", (Object)fileTag, (Object)this.getResourceID().getStringWithMetadata());
                throw new CompletionException(new FileNotFoundException("The file " + fileTag + " does not exist on the TaskExecutor."));
            }, this.ioExecutor);
        }
        this.log.debug("The file {} is unavailable on the TaskExecutor {}.", (Object)fileTag, (Object)this.getResourceID().getStringWithMetadata());
        return FutureUtils.completedExceptionally((Throwable)new FlinkException("The file " + fileTag + " is not available on the TaskExecutor."));
    }

    private CompletableFuture<TransientBlobKey> putTransientBlobStream(InputStream inputStream, String fileTag) {
        TransientBlobKey transientBlobKey;
        TransientBlobService transientBlobService = this.taskExecutorBlobService.getTransientBlobService();
        try {
            transientBlobKey = transientBlobService.putTransient(inputStream);
        }
        catch (IOException e) {
            this.log.debug("Could not upload file {}.", (Object)fileTag, (Object)e);
            return FutureUtils.completedExceptionally((Throwable)new FlinkException("Could not upload file " + fileTag + '.', (Throwable)e));
        }
        return CompletableFuture.completedFuture(transientBlobKey);
    }

    public ResourceID getResourceID() {
        return this.unresolvedTaskManagerLocation.getResourceID();
    }

    void onFatalError(Throwable t) {
        try {
            this.log.error("Fatal error occurred in TaskExecutor {}.", (Object)this.getAddress(), (Object)t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fatalErrorHandler.onFatalError(t);
    }

    @VisibleForTesting
    TaskExecutorToResourceManagerConnection getResourceManagerConnection() {
        return this.resourceManagerConnection;
    }

    @VisibleForTesting
    HeartbeatManager<Void, TaskExecutorHeartbeatPayload> getResourceManagerHeartbeatManager() {
        return this.resourceManagerHeartbeatManager;
    }

    private static /* synthetic */ Collection lambda$setupResultPartitionBookkeeping$9(CompletableFuture taskTerminationWithResourceCleanupFuture, JobID ignored, Collection completableFutures) {
        if (completableFutures == null) {
            completableFutures = new ArrayList<CompletableFuture>(4);
        }
        completableFutures.add(taskTerminationWithResourceCleanupFuture);
        return completableFutures;
    }

    @VisibleForTesting
    static final class TaskExecutorJobServices
    implements JobTable.JobServices {
        private final LibraryCacheManager.ClassLoaderLease classLoaderLease;
        private final Runnable closeHook;

        private TaskExecutorJobServices(LibraryCacheManager.ClassLoaderLease classLoaderLease, Runnable closeHook) {
            this.classLoaderLease = classLoaderLease;
            this.closeHook = closeHook;
        }

        @Override
        public LibraryCacheManager.ClassLoaderHandle getClassLoaderHandle() {
            return this.classLoaderLease;
        }

        @Override
        public void close() {
            this.classLoaderLease.release();
            this.closeHook.run();
        }

        @VisibleForTesting
        static TaskExecutorJobServices create(LibraryCacheManager.ClassLoaderLease classLoaderLease, Runnable closeHook) {
            return new TaskExecutorJobServices(classLoaderLease, closeHook);
        }
    }

    private class ResourceManagerHeartbeatListener
    implements HeartbeatListener<Void, TaskExecutorHeartbeatPayload> {
        private ResourceManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceId) {
            String message = String.format("The heartbeat of ResourceManager with id %s timed out.", resourceId.getStringWithMetadata());
            TaskExecutor.this.log.info(message);
            this.handleResourceManagerConnectionLoss(resourceId, new TaskManagerException(message));
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("ResourceManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            TaskExecutor.this.log.info(message);
            this.handleResourceManagerConnectionLoss(resourceID, new TaskManagerException(message));
        }

        private void handleResourceManagerConnectionLoss(ResourceID resourceId, TaskManagerException cause) {
            TaskExecutor.this.validateRunsInMainThread();
            if (TaskExecutor.this.establishedResourceManagerConnection != null && TaskExecutor.this.establishedResourceManagerConnection.getResourceManagerResourceId().equals(resourceId)) {
                TaskExecutor.this.reconnectToResourceManager(cause);
            }
        }

        @Override
        public void reportPayload(ResourceID resourceID, Void payload) {
        }

        @Override
        public TaskExecutorHeartbeatPayload retrievePayload(ResourceID resourceID) {
            TaskExecutor.this.validateRunsInMainThread();
            return new TaskExecutorHeartbeatPayload(TaskExecutor.this.taskSlotTable.createSlotReport(TaskExecutor.this.getResourceID()), TaskExecutor.this.partitionTracker.createClusterPartitionReport());
        }
    }

    private class JobManagerHeartbeatListener
    implements HeartbeatListener<AllocatedSlotReport, TaskExecutorToJobManagerHeartbeatPayload> {
        private JobManagerHeartbeatListener() {
        }

        @Override
        public void notifyHeartbeatTimeout(ResourceID resourceID) {
            String message = String.format("The heartbeat of JobManager with id %s timed out.", resourceID.getStringWithMetadata());
            TaskExecutor.this.log.info(message);
            this.handleJobManagerConnectionLoss(resourceID, new TimeoutException(message));
        }

        @Override
        public void notifyTargetUnreachable(ResourceID resourceID) {
            String message = String.format("JobManager with id %s is no longer reachable.", resourceID.getStringWithMetadata());
            TaskExecutor.this.log.info(message);
            this.handleJobManagerConnectionLoss(resourceID, new TaskManagerException(message));
        }

        private void handleJobManagerConnectionLoss(ResourceID resourceID, Exception cause) {
            TaskExecutor.this.validateRunsInMainThread();
            TaskExecutor.this.jobTable.getConnection(resourceID).ifPresent(jobManagerConnection -> TaskExecutor.this.disconnectAndTryReconnectToJobManager(jobManagerConnection, cause));
        }

        @Override
        public void reportPayload(ResourceID resourceID, AllocatedSlotReport allocatedSlotReport) {
            TaskExecutor.this.validateRunsInMainThread();
            OptionalConsumer.of(TaskExecutor.this.jobTable.getConnection(allocatedSlotReport.getJobId())).ifPresent(jobManagerConnection -> TaskExecutor.this.syncSlotsWithSnapshotFromJobMaster(jobManagerConnection.getJobManagerGateway(), allocatedSlotReport)).ifNotPresent(() -> TaskExecutor.this.log.debug("Ignoring allocated slot report from job {} because there is no active leader.", (Object)allocatedSlotReport.getJobId()));
        }

        @Override
        public TaskExecutorToJobManagerHeartbeatPayload retrievePayload(ResourceID resourceID) {
            TaskExecutor.this.validateRunsInMainThread();
            return TaskExecutor.this.jobTable.getConnection(resourceID).map(jobManagerConnection -> {
                JobID jobId = jobManagerConnection.getJobId();
                HashSet<ExecutionAttemptID> deployedExecutions = new HashSet<ExecutionAttemptID>();
                ArrayList<AccumulatorSnapshot> accumulatorSnapshots = new ArrayList<AccumulatorSnapshot>(16);
                Iterator allTasks = TaskExecutor.this.taskSlotTable.getTasks(jobId);
                while (allTasks.hasNext()) {
                    Task task = (Task)allTasks.next();
                    deployedExecutions.add(task.getExecutionId());
                    accumulatorSnapshots.add(task.getAccumulatorRegistry().getSnapshot());
                }
                return new TaskExecutorToJobManagerHeartbeatPayload(new AccumulatorReport(accumulatorSnapshots), new ExecutionDeploymentReport(deployedExecutions));
            }).orElseGet(TaskExecutorToJobManagerHeartbeatPayload::empty);
        }
    }

    private class SlotActionsImpl
    implements SlotActions {
        private SlotActionsImpl() {
        }

        @Override
        public void freeSlot(AllocationID allocationId) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.freeSlotInternal(allocationId, new FlinkException("TaskSlotTable requested freeing the TaskSlot " + (Object)((Object)allocationId) + '.')));
        }

        @Override
        public void timeoutSlot(AllocationID allocationId, UUID ticket) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.timeoutSlot(allocationId, ticket));
        }
    }

    private final class TaskManagerActionsImpl
    implements TaskManagerActions {
        private final JobMasterGateway jobMasterGateway;

        private TaskManagerActionsImpl(JobMasterGateway jobMasterGateway) {
            this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        }

        @Override
        public void notifyFatalError(String message, Throwable cause) {
            try {
                TaskExecutor.this.log.error(message, cause);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TaskExecutor.this.fatalErrorHandler.onFatalError(cause);
        }

        @Override
        public void failTask(ExecutionAttemptID executionAttemptID, Throwable cause) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.failTask(executionAttemptID, cause));
        }

        @Override
        public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
            if (taskExecutionState.getExecutionState().isTerminal()) {
                TaskExecutor.this.runAsync(() -> TaskExecutor.this.unregisterTaskAndNotifyFinalState(this.jobMasterGateway, taskExecutionState.getID()));
            } else {
                TaskExecutor.this.updateTaskExecutionState(this.jobMasterGateway, taskExecutionState);
            }
        }

        @Override
        public void notifyEndOfData(ExecutionAttemptID executionAttemptID) {
            TaskExecutor.this.runAsync(() -> this.jobMasterGateway.notifyEndOfData(executionAttemptID));
        }
    }

    private final class ResourceManagerRegistrationListener
    implements RegistrationConnectionListener<TaskExecutorToResourceManagerConnection, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> {
        private ResourceManagerRegistrationListener() {
        }

        @Override
        public void onRegistrationSuccess(TaskExecutorToResourceManagerConnection connection, TaskExecutorRegistrationSuccess success) {
            ResourceID resourceManagerId = success.getResourceManagerId();
            InstanceID taskExecutorRegistrationId = success.getRegistrationId();
            ClusterInformation clusterInformation = success.getClusterInformation();
            ResourceManagerGateway resourceManagerGateway = (ResourceManagerGateway)connection.getTargetGateway();
            byte[] tokens = success.getInitialTokens();
            if (tokens != null) {
                try {
                    TaskExecutor.this.log.info("Receive initial delegation tokens from resource manager");
                    TaskExecutor.this.delegationTokenReceiverRepository.onNewTokensObtained(tokens);
                }
                catch (Throwable t) {
                    TaskExecutor.this.log.error("Could not update delegation tokens.", t);
                    ExceptionUtils.rethrowIfFatalError((Throwable)t);
                }
            }
            TaskExecutor.this.runAsync(() -> {
                if (TaskExecutor.this.resourceManagerConnection == connection) {
                    try {
                        TaskExecutor.this.establishResourceManagerConnection(resourceManagerGateway, resourceManagerId, taskExecutorRegistrationId, clusterInformation);
                    }
                    catch (Throwable t) {
                        TaskExecutor.this.log.error("Establishing Resource Manager connection in Task Executor failed", t);
                    }
                }
            });
        }

        @Override
        public void onRegistrationFailure(Throwable failure) {
            TaskExecutor.this.onFatalError(failure);
        }

        @Override
        public void onRegistrationRejection(String targetAddress, TaskExecutorRegistrationRejection rejection) {
            TaskExecutor.this.onFatalError(new FlinkException(String.format("The TaskExecutor's registration at the ResourceManager %s has been rejected: %s", targetAddress, rejection)));
        }
    }

    private final class JobLeaderListenerImpl
    implements JobLeaderListener {
        private JobLeaderListenerImpl() {
        }

        @Override
        public void jobManagerGainedLeadership(JobID jobId, JobMasterGateway jobManagerGateway, JMTMRegistrationSuccess registrationMessage) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.jobTable.getJob(jobId).ifPresent(job -> TaskExecutor.this.establishJobManagerConnection(job, jobManagerGateway, registrationMessage)));
        }

        @Override
        public void jobManagerLostLeadership(JobID jobId, JobMasterId jobMasterId) {
            TaskExecutor.this.log.info("JobManager for job {} with leader id {} lost leadership.", (Object)jobId, (Object)jobMasterId);
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.jobTable.getConnection(jobId).ifPresent(jobManagerConnection -> TaskExecutor.this.disconnectJobManagerConnection(jobManagerConnection, new Exception("Job leader for job id " + jobId + " lost leadership."))));
        }

        @Override
        public void handleError(Throwable throwable) {
            TaskExecutor.this.onFatalError(throwable);
        }

        @Override
        public void jobManagerRejectedRegistration(JobID jobId, String targetAddress, JMTMRegistrationRejection rejection) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.handleRejectedJobManagerConnection(jobId, targetAddress, rejection));
        }
    }

    private final class ResourceManagerLeaderListener
    implements LeaderRetrievalListener {
        private ResourceManagerLeaderListener() {
        }

        @Override
        public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
            TaskExecutor.this.runAsync(() -> TaskExecutor.this.notifyOfNewResourceManagerLeader(leaderAddress, ResourceManagerId.fromUuidOrNull(leaderSessionID)));
        }

        @Override
        public void handleError(Exception exception) {
            TaskExecutor.this.onFatalError(exception);
        }
    }

    private static final class ResourceManagerHeartbeatReceiver
    extends HeartbeatReceiver<TaskExecutorHeartbeatPayload> {
        private final ResourceManagerGateway resourceManagerGateway;

        private ResourceManagerHeartbeatReceiver(ResourceManagerGateway resourceManagerGateway) {
            this.resourceManagerGateway = resourceManagerGateway;
        }

        @Override
        public CompletableFuture<Void> receiveHeartbeat(ResourceID resourceID, TaskExecutorHeartbeatPayload heartbeatPayload) {
            return this.resourceManagerGateway.heartbeatFromTaskManager(resourceID, heartbeatPayload);
        }
    }

    private static final class JobManagerHeartbeatReceiver
    extends HeartbeatReceiver<TaskExecutorToJobManagerHeartbeatPayload> {
        private final JobMasterGateway jobMasterGateway;

        private JobManagerHeartbeatReceiver(JobMasterGateway jobMasterGateway) {
            this.jobMasterGateway = jobMasterGateway;
        }

        @Override
        public CompletableFuture<Void> receiveHeartbeat(ResourceID resourceID, TaskExecutorToJobManagerHeartbeatPayload payload) {
            return this.jobMasterGateway.heartbeatFromTaskManager(resourceID, payload);
        }
    }
}

