/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.spark.SparkException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.sparkproject.guava.base.Objects;

public class SparkStructuredStreamingPipelineResult
implements PipelineResult {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> pipelineExecution;
    private final @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Runnable onTerminalState;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State state;

    SparkStructuredStreamingPipelineResult(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> pipelineExecution, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Runnable onTerminalState) {
        this.pipelineExecution = pipelineExecution;
        this.metrics = metrics;
        this.onTerminalState = onTerminalState;
        this.state = PipelineResult.State.RUNNING;
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException runtimeExceptionFrom(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static @UnknownKeyFor @NonNull @Initialized RuntimeException unwrapCause(@UnknownKeyFor @NonNull @Initialized Throwable exception) {
        Throwable next;
        for (next = exception; next != null && (next instanceof SparkException || next instanceof UserCodeException); next = next.getCause()) {
            exception = next;
        }
        return exception == next ? SparkStructuredStreamingPipelineResult.runtimeExceptionFrom(exception) : new Pipeline.PipelineExecutionException((Throwable)Objects.firstNonNull((Object)next, (Object)exception));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized Duration duration) throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        this.pipelineExecution.get(duration.getMillis(), TimeUnit.MILLISECONDS);
        return PipelineResult.State.DONE;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        return this.state;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)Long.MAX_VALUE));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        try {
            PipelineResult.State finishState = this.awaitTermination(duration);
            this.offerNewState(finishState);
        }
        catch (TimeoutException finishState) {
        }
        catch (ExecutionException e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.unwrapCause((Throwable)Objects.firstNonNull((Object)e.getCause(), (Object)e));
        }
        catch (Exception e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.unwrapCause(e);
        }
        return this.state;
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metrics.value());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.offerNewState(PipelineResult.State.CANCELLED);
        return this.state;
    }

    private void offerNewState(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State newState) {
        PipelineResult.State oldState = this.state;
        this.state = newState;
        if (!oldState.isTerminal() && newState.isTerminal() && this.onTerminalState != null) {
            try {
                this.onTerminalState.run();
            }
            catch (Exception e) {
                throw SparkStructuredStreamingPipelineResult.unwrapCause(e);
            }
        }
    }
}

