/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforfile;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="WAIT_FOR_FILE", name="i18n::ActionWaitForFile.Name", description="i18n::ActionWaitForFile.Description", image="WaitForFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionWaitForFile.keyword"}, documentationUrl="/workflow/actions/waitforfile.html")
public class ActionWaitForFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWaitForFile.class;
    public static final String CONST_TO_STOP_GROWING = "] to stop growing";
    @HopMetadataProperty(key="filename")
    private String filename = null;
    @HopMetadataProperty(key="maximum_timeout")
    private String maximumTimeout = "0";
    @HopMetadataProperty(key="check_cycle_time")
    private String checkCycleTime = "60";
    @HopMetadataProperty(key="success_on_timeout")
    private boolean successOnTimeout = false;
    @HopMetadataProperty(key="file_size_check")
    private boolean fileSizeCheck = false;
    @HopMetadataProperty(key="add_filename_result")
    private boolean addFilenameToResult = false;
    private static final String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static final String DEFAULT_CHECK_CYCLE_TIME = "60";

    public ActionWaitForFile(String n) {
        super(n, "");
    }

    public ActionWaitForFile() {
        this("");
    }

    public Object clone() {
        ActionWaitForFile je = (ActionWaitForFile)super.clone();
        return je;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        long timeStart = System.currentTimeMillis() / 1000L;
        if (this.filename != null) {
            FileObject fileObject = null;
            String realFilename = this.getRealFilename();
            try {
                fileObject = HopVfs.getFileObject((String)realFilename);
                long iMaximumTimeout = Const.toInt((String)this.getRealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
                long iCycleTime = Const.toInt((String)this.getRealCheckCycleTime(), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
                if (iMaximumTimeout < 0L) {
                    iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                    if (this.isBasic()) {
                        this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
                    }
                }
                if (iCycleTime < 1L) {
                    iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                    if (this.isBasic()) {
                        this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
                    }
                }
                if (iMaximumTimeout == 0L) {
                    if (this.isBasic()) {
                        this.logBasic("Waiting indefinitely for file [" + realFilename + "]");
                    }
                } else if (this.isBasic()) {
                    this.logBasic("Waiting " + iMaximumTimeout + " seconds for file [" + realFilename + "]");
                }
                boolean continueLoop = true;
                while (continueLoop && !this.parentWorkflow.isStopped()) {
                    fileObject = HopVfs.getFileObject((String)realFilename);
                    if (fileObject.exists()) {
                        if (this.isBasic()) {
                            this.logBasic("Detected file [" + realFilename + "] within timeout");
                        }
                        result.setResult(true);
                        continueLoop = false;
                        if (!this.addFilenameToResult || fileObject.getType() != FileType.FILE) continue;
                        ResultFile resultFile = new ResultFile(0, fileObject, this.parentWorkflow.getWorkflowName(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        continue;
                    }
                    long now = System.currentTimeMillis() / 1000L;
                    if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                        continueLoop = false;
                        if (this.isSuccessOnTimeout()) {
                            if (this.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, success");
                            }
                            result.setResult(true);
                        } else {
                            if (this.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, failure");
                            }
                            result.setResult(false);
                        }
                    }
                    long sleepTime = 0L;
                    sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                    try {
                        if (sleepTime <= 0L) continue;
                        if (this.isDetailed()) {
                            this.logDetailed("Sleeping " + sleepTime + " seconds before next check for file [" + realFilename + "]");
                        }
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        result.setResult(false);
                        continueLoop = false;
                    }
                }
                if (!this.parentWorkflow.isStopped() && fileObject.exists() && this.isFileSizeCheck()) {
                    long oldSize = -1L;
                    long newSize = fileObject.getContent().getSize();
                    if (this.isDetailed()) {
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.isBasic()) {
                        this.logBasic("Waiting until file [" + realFilename + "] stops growing for " + iCycleTime + " seconds");
                    }
                    while (oldSize != newSize && !this.parentWorkflow.isStopped()) {
                        try {
                            if (this.isDetailed()) {
                                this.logDetailed("Sleeping " + iCycleTime + " seconds, waiting for file [" + realFilename + CONST_TO_STOP_GROWING);
                            }
                            Thread.sleep(iCycleTime * 1000L);
                        }
                        catch (InterruptedException e) {
                            result.setResult(false);
                            continueLoop = false;
                        }
                        oldSize = newSize;
                        newSize = fileObject.getContent().getSize();
                        if (!this.isDetailed()) continue;
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.isBasic()) {
                        this.logBasic("Stopped waiting for file [" + realFilename + CONST_TO_STOP_GROWING);
                    }
                }
                if (!this.parentWorkflow.isStopped()) return result;
                result.setResult(false);
                return result;
            }
            catch (Exception e) {
                this.logBasic("Exception while waiting for file [" + realFilename + CONST_TO_STOP_GROWING, new Object[]{e});
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.logError("No filename is defined.");
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public String getRealCheckCycleTime() {
        return this.resolve(this.getCheckCycleTime());
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getRealMaximumTimeout() {
        return this.resolve(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public boolean isFileSizeCheck() {
        return this.fileSizeCheck;
    }

    public void setFileSizeCheck(boolean fileSizeCheck) {
        this.fileSizeCheck = fileSizeCheck;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.getRealFilename(), ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "maximumTimeout", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "checkCycleTime", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

