/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.External;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.GeneratedMessageV3;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExternalTranslation {
    public static final @UnknownKeyFor @NonNull @Initialized String EXTERNAL_TRANSFORM_URN = "beam:transform:external:v1";

    public static class ExternalTranslator
    implements PTransformTranslation.TransformTranslator<External.ExpandableTransform<?, ?>> {
        public static @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformTranslator create() {
            return new ExternalTranslator();
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getUrn(@UnknownKeyFor @NonNull @Initialized External.ExpandableTransform transform) {
            return ExternalTranslation.EXTERNAL_TRANSFORM_URN;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> pTransform) {
            return pTransform instanceof External.ExpandableTransform;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedPTransform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> subtransforms, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkArgument((boolean)this.canTranslate((PTransform<?, ?>)appliedPTransform.getTransform()), (Object)"can only translate ExpandableTransform");
            External.ExpandableTransform expandableTransform = (External.ExpandableTransform)appliedPTransform.getTransform();
            String nameSpace = expandableTransform.getNamespace();
            String impulsePrefix = expandableTransform.getImpulsePrefix();
            RunnerApi.PTransform expandedTransform = expandableTransform.getExpandedTransform();
            RunnerApi.Components expandedComponents = expandableTransform.getExpandedComponents();
            List<String> expandedRequirements = expandableTransform.getExpandedRequirements();
            for (String requirement : expandedRequirements) {
                components.addRequirement(requirement);
            }
            Map<PCollection, String> externalPCollectionIdMap = expandableTransform.getExternalPCollectionIdMap();
            Map<Coder<?>, String> externalCoderIdMap = expandableTransform.getExternalCoderIdMap();
            ImmutableMap.Builder pColRenameMapBuilder = ImmutableMap.builder();
            for (Map.Entry<PCollection, String> entry : externalPCollectionIdMap.entrySet()) {
                pColRenameMapBuilder.put((Object)entry.getValue(), (Object)components.registerPCollection(entry.getKey()));
            }
            ImmutableMap pColRenameMap = pColRenameMapBuilder.build();
            ImmutableMap.Builder coderRenameMapBuilder = ImmutableMap.builder();
            for (Map.Entry<Coder<?>, String> entry : externalCoderIdMap.entrySet()) {
                coderRenameMapBuilder.put((Object)entry.getValue(), (Object)components.registerCoder(entry.getKey()));
            }
            ImmutableMap coderRenameMap = coderRenameMapBuilder.build();
            RunnerApi.Components.Builder mergingComponentsBuilder = RunnerApi.Components.newBuilder();
            for (Map.Entry<String, RunnerApi.Coder> entry : expandedComponents.getCodersMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putCoders(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getWindowingStrategiesMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putWindowingStrategies(entry.getKey(), (RunnerApi.WindowingStrategy)entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getEnvironmentsMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                mergingComponentsBuilder.putEnvironments(entry.getKey(), (RunnerApi.Environment)entry.getValue());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getPcollectionsMap().entrySet()) {
                if (!entry.getKey().startsWith(nameSpace)) continue;
                String coderId = ((RunnerApi.PCollection)entry.getValue()).getCoderId();
                mergingComponentsBuilder.putPcollections(entry.getKey(), ((RunnerApi.PCollection)entry.getValue()).toBuilder().setCoderId((String)Preconditions.checkNotNull((Object)((String)coderRenameMap.getOrDefault((Object)coderId, (Object)coderId)))).build());
            }
            for (Map.Entry<String, GeneratedMessageV3> entry : expandedComponents.getTransformsMap().entrySet()) {
                if (entry.getKey().startsWith(impulsePrefix)) continue;
                Preconditions.checkState((boolean)entry.getKey().startsWith(nameSpace), (Object)"unknown transform found");
                RunnerApi.PTransform proto = (RunnerApi.PTransform)entry.getValue();
                RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
                transformBuilder.setUniqueName(proto.getUniqueName()).setSpec(proto.getSpec()).setEnvironmentId(proto.getEnvironmentId()).addAllSubtransforms((Iterable<String>)proto.getSubtransformsList());
                for (Map.Entry<String, String> inputEntry : proto.getInputsMap().entrySet()) {
                    transformBuilder.putInputs(inputEntry.getKey(), (String)Preconditions.checkNotNull((Object)((String)pColRenameMap.getOrDefault((Object)inputEntry.getValue(), (Object)inputEntry.getValue()))));
                }
                for (Map.Entry<String, String> outputEntry : proto.getOutputsMap().entrySet()) {
                    transformBuilder.putOutputs(outputEntry.getKey(), (String)Preconditions.checkNotNull((Object)((String)pColRenameMap.getOrDefault((Object)outputEntry.getValue(), (Object)outputEntry.getValue()))));
                }
                mergingComponentsBuilder.putTransforms(entry.getKey(), transformBuilder.build());
            }
            RunnerApi.PTransform.Builder rootTransformBuilder = RunnerApi.PTransform.newBuilder();
            rootTransformBuilder.setUniqueName(expandedTransform.getUniqueName()).setSpec(expandedTransform.getSpec()).addAllSubtransforms((Iterable<String>)expandedTransform.getSubtransformsList()).setEnvironmentId(expandedTransform.getEnvironmentId()).putAllInputs(expandedTransform.getInputsMap());
            for (Map.Entry<String, String> outputEntry : expandedTransform.getOutputsMap().entrySet()) {
                rootTransformBuilder.putOutputs(outputEntry.getKey(), (String)Preconditions.checkNotNull((Object)((String)pColRenameMap.getOrDefault((Object)outputEntry.getValue(), (Object)outputEntry.getValue()))));
            }
            components.mergeFrom(mergingComponentsBuilder.build(), null);
            return rootTransformBuilder.build();
        }
    }
}

