/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultiset;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoGbkResult {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> valueMap;
    private final @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_IN_MEMORY_ELEMENT_COUNT = 10000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MIN_ELEMENTS_PER_TAG = 100;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CoGbkResult.class);
    private @UnknownKeyFor @NonNull @Initialized Counter keyCount = Metrics.counter(CoGbkResult.class, "cogbk-keys");
    private @UnknownKeyFor @NonNull @Initialized Counter largeKeyCount = Metrics.counter(CoGbkResult.class, "cogbk-large-keys");
    private @UnknownKeyFor @NonNull @Initialized int nextTestUnionId = 0;

    public CoGbkResult(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedValues) {
        this(schema, taggedValues, 10000, 100);
    }

    public CoGbkResult(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedValues, @UnknownKeyFor @NonNull @Initialized int inMemoryElementCount, @UnknownKeyFor @NonNull @Initialized int minElementsPerTag) {
        Function<Integer, Iterable> makeIterable;
        this.schema = schema;
        this.keyCount.inc();
        ArrayList valuesByTag = new ArrayList();
        for (int unionTag2 = 0; unionTag2 < schema.size(); ++unionTag2) {
            valuesByTag.add(new ArrayList());
        }
        Iterator<RawUnionValue> taggedIter = taggedValues.iterator();
        int elementCount = 0;
        while (taggedIter.hasNext()) {
            if (elementCount++ >= inMemoryElementCount) {
                this.largeKeyCount.inc();
                break;
            }
            RawUnionValue value = taggedIter.next();
            int unionTag3 = value.getUnionTag();
            if (schema.size() <= unionTag3) {
                throw new IllegalStateException("union tag " + unionTag3 + " has no corresponding tuple tag in the result schema");
            }
            ((List)valuesByTag.get(unionTag3)).add(value.getValue());
        }
        if (!taggedIter.hasNext()) {
            this.valueMap = valuesByTag;
            return;
        }
        LOG.info("CoGbkResult has more than {} elements, reiteration (which may be slow) is required.", (Object)inMemoryElementCount);
        this.valueMap = new ArrayList();
        if (taggedIter instanceof Reiterator) {
            Reiterator tail = (Reiterator)taggedIter;
            ObservingReiterator<RawUnionValue> tip = new ObservingReiterator<RawUnionValue>(tail, new ObservingReiterator.Observer<RawUnionValue>(){

                @Override
                public void observeAt(@UnknownKeyFor @NonNull @Initialized ObservingReiterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> reiterator) {
                    ((TagIterable)CoGbkResult.this.valueMap.get(reiterator.peek().getUnionTag())).offer(reiterator);
                }

                @Override
                public void done() {
                    for (Iterable iter : CoGbkResult.this.valueMap) {
                        ((TagIterable)iter).finish();
                    }
                }
            });
            makeIterable = unionTag -> new TagIterable((List)valuesByTag.get((int)unionTag), (int)unionTag, minElementsPerTag, tip);
        } else {
            boolean[] sharedSeenEnd = new boolean[]{false};
            makeIterable = unionTag -> this.recordingFilteringIterable(taggedValues, (int)unionTag, Math.max(inMemoryElementCount / (schema.size() * schema.size()), minElementsPerTag), this.valueMap, sharedSeenEnd);
        }
        for (int unionTag4 = 0; unionTag4 < schema.size(); ++unionTag4) {
            this.valueMap.add(makeIterable.apply(unionTag4));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        for (Iterable<?> tagValues : this.valueMap) {
            if (!tagValues.iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema getSchema() {
        return this.schema;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.valueMap.toString();
    }

    public <V> @UnknownKeyFor @NonNull @Initialized Iterable<V> getAll(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterable<?> unions = this.valueMap.get(index);
        return unions;
    }

    public <V> @UnknownKeyFor @NonNull @Initialized Iterable<V> getAll(@UnknownKeyFor @NonNull @Initialized String tag) {
        return this.getAll(new TupleTag(tag));
    }

    public <V> V getOnly(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag) {
        return this.innerGetOnly(tag, null, false);
    }

    public <V> V getOnly(@UnknownKeyFor @NonNull @Initialized String tag) {
        return this.getOnly(new TupleTag(tag));
    }

    public <V> @Nullable V getOnly(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag, @Nullable V defaultValue) {
        return this.innerGetOnly(tag, defaultValue, true);
    }

    public <V> @Nullable V getOnly(@UnknownKeyFor @NonNull @Initialized String tag, @Nullable V defaultValue) {
        return this.getOnly(new TupleTag(tag), defaultValue);
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized CoGbkResult of(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag, @UnknownKeyFor @NonNull @Initialized List<V> data) {
        return CoGbkResult.empty().and(tag, data);
    }

    public <V> @UnknownKeyFor @NonNull @Initialized CoGbkResult and(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag, @UnknownKeyFor @NonNull @Initialized List<V> data) {
        if (this.nextTestUnionId != this.schema.size()) {
            throw new IllegalArgumentException("Attempting to call and() on a CoGbkResult apparently not created by of().");
        }
        ArrayList valueMap = new ArrayList(this.valueMap);
        valueMap.add(data);
        return new CoGbkResult(new CoGbkResultSchema(this.schema.getTupleTagList().and(tag)), valueMap, this.nextTestUnionId + 1);
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized CoGbkResult empty() {
        return new CoGbkResult(new CoGbkResultSchema(TupleTagList.empty()), new ArrayList());
    }

    private CoGbkResult(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> valueMap, @UnknownKeyFor @NonNull @Initialized int nextTestUnionId) {
        this(schema, valueMap);
        this.nextTestUnionId = nextTestUnionId;
    }

    private CoGbkResult(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> valueMap) {
        this.schema = schema;
        this.valueMap = valueMap;
    }

    private <V> @Nullable V innerGetOnly(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag, @Nullable V defaultValue, @UnknownKeyFor @NonNull @Initialized boolean useDefault) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterator<?> unions = this.valueMap.get(index).iterator();
        if (!unions.hasNext()) {
            if (useDefault) {
                return defaultValue;
            }
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to an empty result, and no default was provided");
        }
        Object value = unions.next();
        if (unions.hasNext()) {
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to a non-singleton result");
        }
        return (V)value;
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> recordingFilteringIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedIteratable, @UnknownKeyFor @NonNull @Initialized int unionTag, @UnknownKeyFor @NonNull @Initialized int minElementsPerTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> sharedValueMap, @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] sharedSeenEnd) {
        return () -> new RecordingFilteringIterator(taggedIteratable, unionTag, minElementsPerTag, sharedValueMap, sharedSeenEnd);
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> simpleFilteringIterable(final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedIterable, final @UnknownKeyFor @NonNull @Initialized int unionTag) {
        return () -> new AbstractIterator<Object>(){
            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized Iterator taggedIterator;
            {
                this.taggedIterator = taggedIterable.iterator();
            }

            protected @UnknownKeyFor @NonNull @Initialized Object computeNext() {
                while (this.taggedIterator.hasNext()) {
                    RawUnionValue unionValue = (RawUnionValue)this.taggedIterator.next();
                    if (unionValue.getUnionTag() != unionTag) continue;
                    return unionValue.getValue();
                }
                return this.endOfData();
            }
        };
    }

    private static class RecordingFilteringIterator
    extends AbstractIterator<Object> {
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedIterable;
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedIterator;
        private final @UnknownKeyFor @NonNull @Initialized int unionTag;
        private final @UnknownKeyFor @NonNull @Initialized int minElementsPerTag;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object>> localValueMap;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> sharedValueMap;
        private @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] sharedSeenEnd;
        private @UnknownKeyFor @NonNull @Initialized RemainingStatus remainingStatus = RemainingStatus.UNCOMPUTED;
        private @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Object> remaining;

        public RecordingFilteringIterator(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized RawUnionValue> taggedIteratable, @UnknownKeyFor @NonNull @Initialized int unionTag, @UnknownKeyFor @NonNull @Initialized int minElementsPerTag, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> sharedValueMap, @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] sharedSeenEnd) {
            this.taggedIterable = taggedIteratable;
            this.taggedIterator = taggedIteratable.iterator();
            this.unionTag = unionTag;
            this.minElementsPerTag = minElementsPerTag;
            this.localValueMap = new ArrayList<List<Object>>();
            for (int i = 0; i < sharedValueMap.size(); ++i) {
                this.localValueMap.add(new ArrayList());
            }
            this.sharedValueMap = sharedValueMap;
            this.sharedSeenEnd = sharedSeenEnd;
        }

        protected @UnknownKeyFor @NonNull @Initialized Object computeNext() {
            if (this.sharedSeenEnd[0]) {
                if (this.remainingStatus == RemainingStatus.UNCOMPUTED) {
                    this.remainingStatus = this.computeRemaining(this.sharedValueMap.get(this.unionTag));
                }
                if (this.remainingStatus == RemainingStatus.COMPUTED) {
                    if (this.remaining.hasNext()) {
                        return this.remaining.next();
                    }
                    return this.endOfData();
                }
            }
            while (this.taggedIterator.hasNext()) {
                List<Object> valuesForTag;
                RawUnionValue unionValue = this.taggedIterator.next();
                if (!this.sharedSeenEnd[0] && (valuesForTag = this.localValueMap.get(unionValue.getUnionTag())) != null) {
                    if (valuesForTag.size() < this.minElementsPerTag) {
                        valuesForTag.add(unionValue.getValue());
                    } else {
                        this.localValueMap.set(unionValue.getUnionTag(), null);
                    }
                }
                if (unionValue.getUnionTag() != this.unionTag) continue;
                return unionValue.getValue();
            }
            if (!this.sharedSeenEnd[0]) {
                Counter smallIterablesCount = Metrics.counter(CoGbkResult.class, "cogbk-small-iterables");
                Counter largeIterablesCount = Metrics.counter(CoGbkResult.class, "cogbk-large-iterables");
                for (int i = 0; i < this.sharedValueMap.size(); ++i) {
                    List<Object> localValues = this.localValueMap.get(i);
                    (localValues == null ? largeIterablesCount : smallIterablesCount).inc();
                    this.sharedValueMap.set(i, localValues != null ? localValues : CoGbkResult.simpleFilteringIterable(this.taggedIterable, i));
                }
                this.sharedSeenEnd[0] = true;
            }
            return this.endOfData();
        }

        private @UnknownKeyFor @NonNull @Initialized RemainingStatus computeRemaining(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> allValuesIter) {
            if (!(allValuesIter instanceof Collection)) {
                return RemainingStatus.UNCOMPUTABLE;
            }
            Collection allValues = (Collection)allValuesIter;
            List<Object> seenValues = this.localValueMap.get(this.unionTag);
            if (allValues.size() == seenValues.size()) {
                this.remaining = Collections.emptyIterator();
                return RemainingStatus.COMPUTED;
            }
            if (seenValues.size() == 0) {
                this.remaining = allValues.iterator();
                return RemainingStatus.COMPUTED;
            }
            if (seenValues.size() == 1) {
                Iterator iter = allValues.iterator();
                if (Objects.equals(iter.next(), seenValues.get(0))) {
                    this.remaining = iter;
                    return RemainingStatus.COMPUTED;
                }
                ArrayList allButOne = Lists.newArrayList((Iterable)allValues);
                if (allButOne.remove(seenValues.get(0))) {
                    this.remaining = allButOne.iterator();
                    return RemainingStatus.COMPUTED;
                }
                return RemainingStatus.UNCOMPUTABLE;
            }
            try {
                HashMultiset seenValueSet = HashMultiset.create(seenValues);
                ArrayList unseenValues = new ArrayList();
                for (Object value : allValues) {
                    if (seenValueSet.remove(value)) continue;
                    unseenValues.add(value);
                }
                if (seenValueSet.isEmpty()) {
                    this.remaining = unseenValues.iterator();
                    return RemainingStatus.COMPUTED;
                }
                return RemainingStatus.UNCOMPUTABLE;
            }
            catch (Exception exn) {
                return RemainingStatus.UNCOMPUTABLE;
            }
        }

        private static enum RemainingStatus {
            UNCOMPUTED,
            UNCOMPUTABLE,
            COMPUTED;

        }
    }

    private static class TagIterable<@UnknownKeyFor T>
    implements Iterable<T> {
        @UnknownKeyFor @NonNull @Initialized int tag;
        @UnknownKeyFor @NonNull @Initialized int cacheSize;
        @UnknownKeyFor @NonNull @Initialized ObservingReiterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> tip;
        @UnknownKeyFor @NonNull @Initialized List<T> head;
        @UnknownKeyFor @NonNull @Initialized Reiterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> tail;
        @UnknownKeyFor @NonNull @Initialized boolean finished;

        public TagIterable(@UnknownKeyFor @NonNull @Initialized List<T> head, @UnknownKeyFor @NonNull @Initialized int tag, @UnknownKeyFor @NonNull @Initialized int cacheSize, @UnknownKeyFor @NonNull @Initialized ObservingReiterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> tip) {
            this.tag = tag;
            this.cacheSize = cacheSize;
            this.head = head;
            this.tip = tip;
        }

        void offer(@UnknownKeyFor @NonNull @Initialized ObservingReiterator<@UnknownKeyFor @NonNull @Initialized RawUnionValue> tail) {
            assert (!this.finished);
            assert (tail.peek().getUnionTag() == this.tag);
            if (this.head.size() < this.cacheSize) {
                this.head.add(tail.peek().getValue());
            } else if (this.tail == null) {
                this.tail = tail.copy();
            }
        }

        void finish() {
            Metrics.counter(CoGbkResult.class, this.tail == null ? "cogbk-small-iterables" : "cogbk-large-iterables").inc();
            this.finished = true;
        }

        void seek(@UnknownKeyFor @NonNull @Initialized int tag) {
            while (this.tip.hasNext() && this.tip.peek().getUnionTag() != tag) {
                this.tip.next();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator() {
            return new Iterator<T>(){
                @UnknownKeyFor @NonNull @Initialized boolean isDone;
                @UnknownKeyFor @NonNull @Initialized boolean advanced;
                T next;
                @UnknownKeyFor @NonNull @Initialized int index = -1;
                @UnknownKeyFor @NonNull @Initialized Iterator<T> tailIter;

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                    if (!this.advanced) {
                        this.advance();
                    }
                    return !this.isDone;
                }

                @Override
                public T next() {
                    if (!this.advanced) {
                        this.advance();
                    }
                    if (this.isDone) {
                        throw new NoSuchElementException();
                    }
                    this.advanced = false;
                    return this.next;
                }

                private void advance() {
                    assert (!this.advanced);
                    assert (!this.isDone);
                    this.advanced = true;
                    ++this.index;
                    if (this.maybeAdvance()) {
                        return;
                    }
                    tip.fastForward();
                    if (tip.hasNext()) {
                        tip.next();
                        this.seek(tag);
                    }
                    Preconditions.checkState((boolean)this.maybeAdvance());
                }

                private @UnknownKeyFor @NonNull @Initialized boolean maybeAdvance() {
                    if (this.index < head.size()) {
                        assert (this.tailIter == null);
                        this.next = head.get(this.index);
                        return true;
                    }
                    if (tail != null) {
                        if (this.tailIter == null) {
                            this.tailIter = Iterators.transform((Iterator)Iterators.filter(tail.copy(), taggedUnion -> taggedUnion.getUnionTag() == tag), taggedUnion -> taggedUnion.getValue());
                        }
                        if (this.tailIter.hasNext()) {
                            this.next = this.tailIter.next();
                        } else {
                            this.isDone = true;
                        }
                        return true;
                    }
                    if (finished) {
                        this.isDone = true;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class PeekingReiterator<@UnknownKeyFor T>
    implements Reiterator<T> {
        private @UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying;
        private T next;
        private @UnknownKeyFor @NonNull @Initialized boolean nextIsValid;

        public PeekingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying) {
            this(underlying, null, false);
        }

        private PeekingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying, T next, @UnknownKeyFor @NonNull @Initialized boolean nextIsValid) {
            this.underlying = underlying;
            this.next = next;
            this.nextIsValid = nextIsValid;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PeekingReiterator<T> copy() {
            return new PeekingReiterator<T>(this.underlying.copy(), this.next, this.nextIsValid);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return this.nextIsValid || this.underlying.hasNext();
        }

        @Override
        public T next() {
            if (this.nextIsValid) {
                this.nextIsValid = false;
                return this.next;
            }
            return (T)this.underlying.next();
        }

        public T peek() {
            if (!this.nextIsValid) {
                this.next = this.underlying.next();
                this.nextIsValid = true;
            }
            return this.next;
        }
    }

    private static class IndexingReiterator<@UnknownKeyFor T>
    implements Reiterator<Indexed<T>> {
        private @UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying;
        private @UnknownKeyFor @NonNull @Initialized int index;

        public IndexingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying) {
            this(underlying, 0);
        }

        public IndexingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying, @UnknownKeyFor @NonNull @Initialized int start) {
            this.underlying = underlying;
            this.index = start;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IndexingReiterator<T> copy() {
            return new IndexingReiterator<T>(this.underlying.copy(), this.index);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return this.underlying.hasNext();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Indexed<T> next() {
            return new Indexed(this.index++, this.underlying.next());
        }

        public static class Indexed<@UnknownKeyFor T> {
            public final @UnknownKeyFor @NonNull @Initialized int index;
            public final T value;

            public Indexed(@UnknownKeyFor @NonNull @Initialized int index, T value) {
                this.index = index;
                this.value = value;
            }
        }
    }

    private static class ObservingReiterator<@UnknownKeyFor T>
    implements Reiterator<T> {
        private @UnknownKeyFor @NonNull @Initialized PeekingReiterator<@UnknownKeyFor @NonNull @Initialized IndexingReiterator.Indexed<T>> underlying;
        private @UnknownKeyFor @NonNull @Initialized Observer<T> observer;
        private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] lastObserved;
        private final @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] doneHasRun;
        private final @UnknownKeyFor @NonNull @Initialized PeekingReiterator<@UnknownKeyFor @NonNull @Initialized IndexingReiterator.Indexed<T>> @UnknownKeyFor @NonNull @Initialized [] mostAdvanced;

        public ObservingReiterator(@UnknownKeyFor @NonNull @Initialized Reiterator<T> underlying, @UnknownKeyFor @NonNull @Initialized Observer<T> observer) {
            this(new PeekingReiterator<IndexingReiterator.Indexed<T>>(new IndexingReiterator<T>(underlying)), observer);
        }

        public ObservingReiterator(@UnknownKeyFor @NonNull @Initialized PeekingReiterator<@UnknownKeyFor @NonNull @Initialized IndexingReiterator.Indexed<T>> underlying, @UnknownKeyFor @NonNull @Initialized Observer<T> observer) {
            this(underlying, observer, new int[]{-1}, new boolean[]{false}, new PeekingReiterator[]{underlying});
        }

        private ObservingReiterator(@UnknownKeyFor @NonNull @Initialized PeekingReiterator<@UnknownKeyFor @NonNull @Initialized IndexingReiterator.Indexed<T>> underlying, @UnknownKeyFor @NonNull @Initialized Observer<T> observer, @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] lastObserved, @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] doneHasRun, @UnknownKeyFor @NonNull @Initialized PeekingReiterator<@UnknownKeyFor @NonNull @Initialized IndexingReiterator.Indexed<T>> @UnknownKeyFor @NonNull @Initialized [] mostAdvanced) {
            this.underlying = underlying;
            this.observer = observer;
            this.lastObserved = lastObserved;
            this.doneHasRun = doneHasRun;
            this.mostAdvanced = mostAdvanced;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Reiterator<T> copy() {
            return new ObservingReiterator<T>(this.underlying.copy(), this.observer, this.lastObserved, this.doneHasRun, this.mostAdvanced);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            boolean hasNext = this.underlying.hasNext();
            if (!hasNext && !this.doneHasRun[0]) {
                this.mostAdvanced[0] = this.underlying;
                this.observer.done();
                this.doneHasRun[0] = true;
            }
            return hasNext;
        }

        @Override
        public T next() {
            this.peek();
            return this.underlying.next().value;
        }

        public T peek() {
            IndexingReiterator.Indexed<T> next = this.underlying.peek();
            if (next.index > this.lastObserved[0]) {
                assert (next.index == this.lastObserved[0] + 1);
                this.mostAdvanced[0] = this.underlying;
                this.lastObserved[0] = next.index;
                this.observer.observeAt(this);
            }
            return next.value;
        }

        public void fastForward() {
            if (this.underlying != this.mostAdvanced[0]) {
                this.underlying = this.mostAdvanced[0].copy();
            }
        }

        public static interface Observer<@UnknownKeyFor T> {
            public void observeAt(@UnknownKeyFor @NonNull @Initialized ObservingReiterator<T> var1);

            public void done();
        }
    }

    public static class CoGbkResultCoder
    extends CustomCoder<CoGbkResult> {
        private final @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema;
        private final @UnknownKeyFor @NonNull @Initialized UnionCoder unionCoder;

        public static @UnknownKeyFor @NonNull @Initialized CoGbkResultCoder of(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema, @UnknownKeyFor @NonNull @Initialized UnionCoder unionCoder) {
            return new CoGbkResultCoder(schema, unionCoder);
        }

        private CoGbkResultCoder(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema tupleTags, @UnknownKeyFor @NonNull @Initialized UnionCoder unionCoder) {
            this.schema = tupleTags;
            this.unionCoder = unionCoder;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return ImmutableList.of((Object)this.unionCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema getSchema() {
            return this.schema;
        }

        public @UnknownKeyFor @NonNull @Initialized UnionCoder getUnionCoder() {
            return this.unionCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized CoGbkResult value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (!this.schema.equals(value.getSchema())) {
                throw new CoderException("input schema does not match coder schema");
            }
            if (this.schema.size() == 0) {
                return;
            }
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                this.tagListCoder(unionTag).encode((Iterable)value.valueMap.get(unionTag), outStream);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CoGbkResult decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.schema.size() == 0) {
                return new CoGbkResult(this.schema, (List)ImmutableList.of());
            }
            ArrayList valueMap = Lists.newArrayListWithExpectedSize((int)this.schema.size());
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                valueMap.add(this.tagListCoder(unionTag).decode(inStream));
            }
            return new CoGbkResult(this.schema, (List)valueMap);
        }

        private @UnknownKeyFor @NonNull @Initialized IterableCoder tagListCoder(@UnknownKeyFor @NonNull @Initialized int unionTag) {
            return IterableCoder.of(this.unionCoder.getElementCoders().get(unionTag));
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoGbkResultCoder)) {
                return false;
            }
            CoGbkResultCoder other = (CoGbkResultCoder)object;
            return this.schema.equals(other.schema) && this.unionCoder.equals(other.unionCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode(this.schema);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            CoGbkResultCoder.verifyDeterministic(this, "CoGbkResult requires the union coder to be deterministic", this.unionCoder);
        }
    }
}

