/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyCycle;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public final class DefaultDependencyCycle
implements DependencyCycle {
    private final List<Dependency> dependencies;
    private final int cycleEntry;

    public DefaultDependencyCycle(List<DependencyNode> nodes, int cycleEntry, Dependency dependency) {
        int offset = cycleEntry > 0 && nodes.get(0).getDependency() == null ? 1 : 0;
        Dependency[] dependencies2 = new Dependency[nodes.size() - offset + 1];
        int n = dependencies2.length - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            DependencyNode node = nodes.get(i2 + offset);
            dependencies2[i2] = node.getDependency();
            if (dependencies2[i2] != null) continue;
            dependencies2[i2] = new Dependency(node.getArtifact(), null);
        }
        dependencies2[dependencies2.length - 1] = dependency;
        this.dependencies = Collections.unmodifiableList(Arrays.asList(dependencies2));
        this.cycleEntry = cycleEntry;
    }

    @Override
    public List<Dependency> getPrecedingDependencies() {
        return this.dependencies.subList(0, this.cycleEntry);
    }

    @Override
    public List<Dependency> getCyclicDependencies() {
        return this.dependencies.subList(this.cycleEntry, this.dependencies.size());
    }

    public static int find(List<DependencyNode> nodes, Artifact artifact) {
        DependencyNode node;
        Artifact a;
        for (int i2 = nodes.size() - 1; i2 >= 0 && (a = (node = nodes.get(i2)).getArtifact()) != null; --i2) {
            if (!a.getArtifactId().equals(artifact.getArtifactId()) || !a.getGroupId().equals(artifact.getGroupId()) || !a.getExtension().equals(artifact.getExtension()) || !a.getClassifier().equals(artifact.getClassifier())) continue;
            return i2;
        }
        return -1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        int i2 = 0;
        for (Dependency dependency : this.dependencies) {
            if (i2++ > 0) {
                buffer.append(" -> ");
            }
            buffer.append(ArtifactIdUtils.toVersionlessId(dependency.getArtifact()));
        }
        return buffer.toString();
    }
}

