/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

@Internal
public abstract class AbstractClassWriterOutputVisitor
implements ClassWriterOutputVisitor {
    private final Map<String, Set<String>> serviceDescriptors = new LinkedHashMap<String, Set<String>>();
    private final boolean isWriteOnFinish;

    protected AbstractClassWriterOutputVisitor(boolean isWriteOnFinish) {
        this.isWriteOnFinish = isWriteOnFinish;
    }

    public AbstractClassWriterOutputVisitor() {
        this.isWriteOnFinish = false;
    }

    @Override
    public final Map<String, Set<String>> getServiceEntries() {
        return this.serviceDescriptors;
    }

    @Override
    public final void visitServiceDescriptor(String type, String classname) {
        if (StringUtils.isNotEmpty(type) && StringUtils.isNotEmpty(classname)) {
            this.serviceDescriptors.computeIfAbsent(type, s -> new LinkedHashSet()).add(classname);
        }
    }

    @Override
    public final void finish() {
        if (this.isWriteOnFinish) {
            Map<String, Set<String>> serviceEntries = this.getServiceEntries();
            this.writeServiceEntries(serviceEntries, new Element[0]);
        }
    }

    public void writeServiceEntries(Map<String, Set<String>> serviceEntries, Element ... originatingElements) {
        for (Map.Entry<String, Set<String>> entry : serviceEntries.entrySet()) {
            GeneratedFile generatedFile;
            TreeSet<String> serviceTypes;
            block20: {
                String serviceName = entry.getKey();
                serviceTypes = new TreeSet<String>((Collection)entry.getValue());
                Optional<GeneratedFile> serviceFile = this.visitMetaInfFile("services/" + serviceName, originatingElements);
                if (!serviceFile.isPresent()) continue;
                generatedFile = serviceFile.get();
                try (BufferedReader bufferedReader2 = new BufferedReader(generatedFile.openReader());){
                    String line = bufferedReader2.readLine();
                    while (line != null) {
                        serviceTypes.add(line);
                        line = bufferedReader2.readLine();
                    }
                }
                catch (FileNotFoundException | NoSuchFileException bufferedReader2) {
                }
                catch (IOException x) {
                    Throwable cause = x.getCause();
                    if (this.isNotEclipseNotFound(cause)) {
                        throw new ClassGenerationException("Failed to load existing service definition files: " + x, x);
                    }
                }
                catch (Throwable e) {
                    if (!this.isNotEclipseNotFound(e)) break block20;
                    throw new ClassGenerationException("Failed to load existing service definition files: " + e, e);
                }
            }
            try (BufferedWriter writer = new BufferedWriter(generatedFile.openWriter());){
                for (String serviceType : serviceTypes) {
                    writer.write(serviceType);
                    writer.newLine();
                }
            }
            catch (IOException x) {
                throw new ClassGenerationException("Failed to open writer for service definition files: " + x);
            }
        }
    }

    private boolean isNotEclipseNotFound(Throwable e) {
        if (this.isWriteOnFinish) {
            return false;
        }
        String message = e.getMessage();
        return !message.contains("does not exist") || !e.getClass().getName().startsWith("org.eclipse");
    }
}

