/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.VndError;
import java.util.Optional;

@Internal
public interface HttpClientErrorDecoder {
    public static final HttpClientErrorDecoder DEFAULT = new HttpClientErrorDecoder(){};

    default public Optional<String> getMessage(Object error2) {
        if (error2 == null) {
            return Optional.empty();
        }
        if (error2 instanceof JsonError) {
            return Optional.ofNullable(((JsonError)error2).getMessage());
        }
        if (error2 instanceof Described) {
            return Optional.ofNullable(((Described)error2).getDescription());
        }
        return Optional.of(error2.toString());
    }

    default public Argument<?> getErrorType(MediaType mediaType) {
        if (mediaType.equals(MediaType.APPLICATION_JSON_TYPE)) {
            return Argument.of(JsonError.class);
        }
        if (mediaType.equals(MediaType.APPLICATION_VND_ERROR_TYPE)) {
            return Argument.of(VndError.class);
        }
        return Argument.STRING;
    }
}

