/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.database.DatabaseDriverFeature;
import org.grails.forge.feature.database.HibernateGorm;
import org.grails.forge.feature.database.TestContainers;

@Singleton
public class SQLServer
extends DatabaseDriverFeature {
    public SQLServer(HibernateGorm hibernateGorm, TestContainers testContainers) {
        super(hibernateGorm, testContainers);
    }

    @Override
    @NonNull
    public String getName() {
        return "sqlserver";
    }

    @Override
    public String getTitle() {
        return "Microsoft SQL Server";
    }

    @Override
    public String getDescription() {
        return "Add Microsoft SQL Server driver and default configuration.";
    }

    @Override
    public String getJdbcDevUrl() {
        return "jdbc:sqlserver://localhost:1433;databaseName=devDb;socketKeepAlive=true";
    }

    @Override
    public String getJdbcTestUrl() {
        return "jdbc:sqlserver://localhost:1433;databaseName=testDb;socketKeepAlive=true";
    }

    @Override
    public String getJdbcProdUrl() {
        return "jdbc:sqlserver://localhost:1433;databaseName=prodDb;socketKeepAlive=true";
    }

    @Override
    public String getDriverClass() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getDefaultUser() {
        return "sa";
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public String getDataDialect() {
        return "SQL_SERVER";
    }

    @Override
    public boolean embedded() {
        return false;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("com.microsoft.sqlserver").artifactId("mssql-jdbc").runtimeOnly());
    }
}

