/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.asm.signature.SignatureVisitor;
import io.micronaut.context.AbstractConstructorInjectionPoint;
import io.micronaut.context.AbstractExecutableMethod;
import io.micronaut.context.AbstractInitializableBeanDefinition;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.InjectScope;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.PropertySource;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutableMethodsDefinition;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.beans.BeanElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.configuration.PropertyMetadata;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.visitor.BeanElementVisitor;
import io.micronaut.inject.visitor.BeanElementVisitorContext;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ArrayAwareSignatureWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ConfigBuilderState;
import io.micronaut.inject.writer.DispatchWriter;
import io.micronaut.inject.writer.ExecutableMethodWriter;
import io.micronaut.inject.writer.ExecutableMethodsDefinitionWriter;
import io.micronaut.inject.writer.OriginatingElements;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public class BeanDefinitionWriter
extends AbstractClassFileWriter
implements BeanDefinitionVisitor,
BeanElement,
Toggleable {
    public static final String OMIT_CONFPROP_INJECTION_POINTS = "micronaut.processing.omit.confprop.injectpoints";
    public static final String CLASS_SUFFIX = "$Definition";
    private static final String ANN_CONSTRAINT = "javax.validation.Constraint";
    private static final Constructor<AbstractConstructorInjectionPoint> CONSTRUCTOR_ABSTRACT_CONSTRUCTOR_IP = ReflectionUtils.findConstructor(AbstractConstructorInjectionPoint.class, BeanDefinition.class).orElseThrow(() -> new ClassGenerationException("Invalid version of Micronaut present on the class path"));
    private static final java.lang.reflect.Method POST_CONSTRUCT_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "postConstruct", BeanResolutionContext.class, BeanContext.class, Object.class);
    private static final java.lang.reflect.Method INJECT_BEAN_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "injectBean", BeanResolutionContext.class, BeanContext.class, Object.class);
    private static final java.lang.reflect.Method PRE_DESTROY_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "preDestroy", BeanResolutionContext.class, BeanContext.class, Object.class);
    private static final java.lang.reflect.Method GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanForConstructorArgument", false);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationsForConstructorArgument", true);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationForConstructorArgument", true);
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getBeansOfTypeForConstructorArgument", true);
    private static final java.lang.reflect.Method GET_STREAM_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("getStreamOfTypeForConstructorArgument", true);
    private static final java.lang.reflect.Method FIND_BEAN_FOR_CONSTRUCTOR_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethod("findBeanForConstructorArgument", true);
    private static final java.lang.reflect.Method GET_BEAN_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanForField", false);
    private static final java.lang.reflect.Method GET_BEAN_FOR_ANNOTATION = BeanDefinitionWriter.getBeanLookupMethod("getBeanForAnnotation", false);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationsForField", true);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeanRegistrationForField", true);
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getBeansOfTypeForField", true);
    private static final java.lang.reflect.Method GET_VALUE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getValueForField", false);
    private static final java.lang.reflect.Method GET_STREAM_OF_TYPE_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("getStreamOfTypeForField", true);
    private static final java.lang.reflect.Method FIND_BEAN_FOR_FIELD = BeanDefinitionWriter.getBeanLookupMethod("findBeanForField", true);
    private static final java.lang.reflect.Method GET_VALUE_FOR_PATH = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getValueForPath", BeanResolutionContext.class, BeanContext.class, Argument.class, String.class);
    private static final java.lang.reflect.Method CONTAINS_PROPERTIES_METHOD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "containsProperties", BeanResolutionContext.class, BeanContext.class);
    private static final java.lang.reflect.Method GET_BEAN_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanForMethodArgument", false);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATIONS_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanRegistrationsForMethodArgument", true);
    private static final java.lang.reflect.Method GET_BEAN_REGISTRATION_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeanRegistrationForMethodArgument", true);
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getBeansOfTypeForMethodArgument", true);
    private static final java.lang.reflect.Method GET_STREAM_OF_TYPE_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("getStreamOfTypeForMethodArgument", true);
    private static final java.lang.reflect.Method FIND_BEAN_FOR_METHOD_ARGUMENT = BeanDefinitionWriter.getBeanLookupMethodForArgument("findBeanForMethodArgument", true);
    private static final java.lang.reflect.Method CHECK_INJECTED_BEAN_PROPERTY_VALUE = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "checkInjectedBeanPropertyValue", String.class, Object.class, String.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_VALUE_FOR_METHOD_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyValueForMethodArgument", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE, String.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_PLACEHOLDER_VALUE_FOR_METHOD_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyPlaceholderValueForMethodArgument", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE, String.class);
    private static final java.lang.reflect.Method GET_BEAN_FOR_SETTER = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getBeanForSetter", BeanResolutionContext.class, BeanContext.class, String.class, Argument.class, Qualifier.class);
    private static final java.lang.reflect.Method GET_BEANS_OF_TYPE_FOR_SETTER = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getBeansOfTypeForSetter", BeanResolutionContext.class, BeanContext.class, String.class, Argument.class, Argument.class, Qualifier.class);
    private static final java.lang.reflect.Method GET_PROPERTY_VALUE_FOR_SETTER = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyValueForSetter", BeanResolutionContext.class, BeanContext.class, String.class, Argument.class, String.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_PLACEHOLDER_VALUE_FOR_SETTER = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyPlaceholderValueForSetter", BeanResolutionContext.class, BeanContext.class, String.class, Argument.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_VALUE_FOR_CONSTRUCTOR_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyValueForConstructorArgument", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, String.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_PLACEHOLDER_VALUE_FOR_CONSTRUCTOR_ARGUMENT = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyPlaceholderValueForConstructorArgument", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_VALUE_FOR_FIELD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyValueForField", BeanResolutionContext.class, BeanContext.class, Argument.class, String.class, String.class);
    private static final java.lang.reflect.Method GET_PROPERTY_PLACEHOLDER_VALUE_FOR_FIELD = ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "getPropertyPlaceholderValueForField", BeanResolutionContext.class, BeanContext.class, Argument.class, String.class);
    private static final Method CONTAINS_PROPERTIES_VALUE_METHOD = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "containsPropertiesValue", BeanResolutionContext.class, BeanContext.class, String.class));
    private static final Method CONTAINS_PROPERTY_VALUE_METHOD = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, "containsPropertyValue", BeanResolutionContext.class, BeanContext.class, String.class));
    private static final io.micronaut.asm.Type TYPE_ABSTRACT_BEAN_DEFINITION = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.class);
    private static final Method METHOD_OPTIONAL_EMPTY = Method.getMethod(ReflectionUtils.getRequiredMethod(Optional.class, "empty", new Class[0]));
    private static final io.micronaut.asm.Type TYPE_OPTIONAL = io.micronaut.asm.Type.getType(Optional.class);
    private static final Method METHOD_OPTIONAL_OF = Method.getMethod(ReflectionUtils.getRequiredMethod(Optional.class, "of", Object.class));
    private static final Method METHOD_INVOKE_CONSTRUCTOR = Method.getMethod(ReflectionUtils.getRequiredMethod(ConstructorInjectionPoint.class, "invoke", Object[].class));
    private static final String METHOD_DESCRIPTOR_CONSTRUCTOR_INSTANTIATE = BeanDefinitionWriter.getMethodDescriptor(Object.class, Arrays.asList(BeanResolutionContext.class, BeanContext.class, List.class, BeanDefinition.class, BeanConstructor.class, Integer.TYPE, Object[].class));
    private static final String METHOD_DESCRIPTOR_INTERCEPTED_LIFECYCLE = BeanDefinitionWriter.getMethodDescriptor(Object.class, Arrays.asList(BeanResolutionContext.class, BeanContext.class, BeanDefinition.class, ExecutableMethod.class, Object.class));
    private static final java.lang.reflect.Method METHOD_GET_BEAN = ReflectionUtils.getRequiredInternalMethod(DefaultBeanContext.class, "getBean", BeanResolutionContext.class, Class.class, Qualifier.class);
    private static final Method COLLECTION_TO_ARRAY = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(Collection.class, "toArray", Object[].class));
    private static final io.micronaut.asm.Type TYPE_RESOLUTION_CONTEXT = io.micronaut.asm.Type.getType(BeanResolutionContext.class);
    private static final io.micronaut.asm.Type TYPE_BEAN_CONTEXT = io.micronaut.asm.Type.getType(BeanContext.class);
    private static final io.micronaut.asm.Type TYPE_BEAN_DEFINITION = io.micronaut.asm.Type.getType(BeanDefinition.class);
    private static final String METHOD_DESCRIPTOR_INITIALIZE = io.micronaut.asm.Type.getMethodDescriptor(io.micronaut.asm.Type.getType(Object.class), io.micronaut.asm.Type.getType(BeanResolutionContext.class), io.micronaut.asm.Type.getType(BeanContext.class), io.micronaut.asm.Type.getType(Object.class));
    private static final Method PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, AbstractInitializableBeanDefinition.MethodOrFieldReference.class));
    private static final Method SET_FIELD_WITH_REFLECTION_METHOD = Method.getMethod(ReflectionUtils.getRequiredMethod(AbstractInitializableBeanDefinition.class, "setFieldWithReflection", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Object.class, Object.class));
    private static final Method INVOKE_WITH_REFLECTION_METHOD = Method.getMethod(ReflectionUtils.getRequiredMethod(AbstractInitializableBeanDefinition.class, "invokeMethodWithReflection", BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Object.class, Object[].class));
    private static final io.micronaut.asm.Type TYPE_REFLECTION_UTILS = io.micronaut.asm.Type.getType(ReflectionUtils.class);
    private static final Method GET_FIELD_WITH_REFLECTION_METHOD = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, "getField", Class.class, String.class, Object.class));
    private static final Method METHOD_INVOKE_METHOD = Method.getMethod(ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, "invokeMethod", Object.class, java.lang.reflect.Method.class, Object[].class));
    private static final Method BEAN_DEFINITION_CLASS_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, AbstractInitializableBeanDefinition.MethodOrFieldReference.class, AnnotationMetadata.class, AbstractInitializableBeanDefinition.MethodReference[].class, AbstractInitializableBeanDefinition.FieldReference[].class, AbstractInitializableBeanDefinition.AnnotationReference[].class, ExecutableMethodsDefinition.class, Map.class, Optional.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
    private static final String FIELD_CONSTRUCTOR = "$CONSTRUCTOR";
    private static final String FIELD_INJECTION_METHODS = "$INJECTION_METHODS";
    private static final String FIELD_INJECTION_FIELDS = "$INJECTION_FIELDS";
    private static final String FIELD_ANNOTATION_INJECTIONS = "$ANNOTATION_INJECTIONS";
    private static final String FIELD_TYPE_ARGUMENTS = "$TYPE_ARGUMENTS";
    private static final String FIELD_INNER_CLASSES = "$INNER_CONFIGURATION_CLASSES";
    private static final String FIELD_EXPOSED_TYPES = "$EXPOSED_TYPES";
    private static final Method METHOD_REFERENCE_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE));
    private static final Method METHOD_REFERENCE_CONSTRUCTOR_POST_PRE = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, String.class, Argument[].class, AnnotationMetadata.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
    private static final Method FIELD_REFERENCE_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Class.class, Argument.class, Boolean.TYPE));
    private static final Method ANNOTATION_REFERENCE_CONSTRUCTOR = new Method("<init>", BeanDefinitionWriter.getConstructorDescriptor(Argument.class));
    private static final Method METHOD_QUALIFIER_FOR_ARGUMENT = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "forArgument", Argument.class));
    private static final Method METHOD_QUALIFIER_BY_NAME = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byName", String.class));
    private static final Method METHOD_QUALIFIER_BY_ANNOTATION = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byAnnotationSimple", AnnotationMetadata.class, String.class));
    private static final Method METHOD_QUALIFIER_BY_REPEATABLE_ANNOTATION = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byRepeatableAnnotation", AnnotationMetadata.class, String.class));
    private static final Method METHOD_QUALIFIER_BY_QUALIFIERS = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byQualifiers", Qualifier[].class));
    private static final Method METHOD_QUALIFIER_BY_INTERCEPTOR_BINDING = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byInterceptorBinding", AnnotationMetadata.class));
    private static final Method METHOD_QUALIFIER_BY_TYPE = Method.getMethod(ReflectionUtils.getRequiredMethod(Qualifiers.class, "byType", Class[].class));
    private static final Method METHOD_BEAN_RESOLUTION_CONTEXT_MARK_FACTORY = Method.getMethod(ReflectionUtils.getRequiredMethod(BeanResolutionContext.class, "markDependentAsFactory", new Class[0]));
    private static final io.micronaut.asm.Type TYPE_QUALIFIERS = io.micronaut.asm.Type.getType(Qualifiers.class);
    private static final io.micronaut.asm.Type TYPE_QUALIFIER = io.micronaut.asm.Type.getType(Qualifier.class);
    private static final String MESSAGE_ONLY_SINGLE_CALL_PERMITTED = "Only a single call to visitBeanFactoryMethod(..) is permitted";
    private final ClassWriter classWriter;
    private final String beanFullClassName;
    private final String beanDefinitionName;
    private final String beanDefinitionInternalName;
    private final io.micronaut.asm.Type beanType;
    private final Set<Class> interfaceTypes;
    private final Map<String, Integer> defaultsStorage = new HashMap<String, Integer>();
    private final Map<String, GeneratorAdapter> loadTypeMethods = new LinkedHashMap<String, GeneratorAdapter>();
    private final Map<String, ClassWriter> innerClasses = new LinkedHashMap<String, ClassWriter>(2);
    private final String packageName;
    private final String beanSimpleClassName;
    private final io.micronaut.asm.Type beanDefinitionType;
    private final boolean isInterface;
    private final boolean isAbstract;
    private final boolean isConfigurationProperties;
    private final ConfigurationMetadataBuilder<?> metadataBuilder;
    private final Element beanProducingElement;
    private final ClassElement beanTypeElement;
    private final VisitorContext visitorContext;
    private final boolean isPrimitiveBean;
    private final List<String> beanTypeInnerClasses;
    private GeneratorAdapter buildMethodVisitor;
    private GeneratorAdapter injectMethodVisitor;
    private GeneratorAdapter checkIfShouldLoadMethodVisitor;
    private Label injectEnd = null;
    private GeneratorAdapter preDestroyMethodVisitor;
    private GeneratorAdapter postConstructMethodVisitor;
    private boolean postConstructAdded;
    private GeneratorAdapter interceptedDisposeMethod;
    private int currentFieldIndex = 0;
    private int currentMethodIndex = 0;
    private int buildInstanceLocalVarIndex = -1;
    private int injectInstanceLocalVarIndex = -1;
    private int postConstructInstanceLocalVarIndex = -1;
    private int preDestroyInstanceLocalVarIndex = -1;
    private boolean beanFinalized = false;
    private io.micronaut.asm.Type superType = TYPE_ABSTRACT_BEAN_DEFINITION;
    private boolean isParametrized = false;
    private boolean superBeanDefinition = false;
    private boolean isSuperFactory = false;
    private final AnnotationMetadata annotationMetadata;
    private ConfigBuilderState currentConfigBuilderState;
    private boolean preprocessMethods = false;
    private Map<String, Map<String, ClassElement>> typeArguments;
    private String interceptedType;
    private int innerClassIndex;
    private final List<FieldVisitData> fieldInjectionPoints = new ArrayList<FieldVisitData>(2);
    private final List<MethodVisitData> methodInjectionPoints = new ArrayList<MethodVisitData>(2);
    private final List<MethodVisitData> postConstructMethodVisits = new ArrayList<MethodVisitData>(2);
    private final List<MethodVisitData> preDestroyMethodVisits = new ArrayList<MethodVisitData>(2);
    private final List<MethodVisitData> allMethodVisits = new ArrayList<MethodVisitData>(2);
    private final Map<io.micronaut.asm.Type, List<AnnotationVisitData>> annotationInjectionPoints = new LinkedHashMap<io.micronaut.asm.Type, List<AnnotationVisitData>>(2);
    private final Map<String, Boolean> isLifeCycleCache = new HashMap<String, Boolean>(2);
    private ExecutableMethodsDefinitionWriter executableMethodsDefinitionWriter;
    private Object constructor;
    private boolean constructorRequiresReflection;
    private boolean disabled = false;
    private final boolean keepConfPropInjectPoints;

    public BeanDefinitionWriter(ClassElement classElement, ConfigurationMetadataBuilder<?> metadataBuilder, VisitorContext visitorContext) {
        this((Element)classElement, OriginatingElements.of(classElement), metadataBuilder, visitorContext, null);
    }

    public BeanDefinitionWriter(ClassElement classElement, OriginatingElements originatingElements, ConfigurationMetadataBuilder<?> metadataBuilder, VisitorContext visitorContext) {
        this((Element)classElement, originatingElements, metadataBuilder, visitorContext, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BeanDefinitionWriter(Element beanProducingElement, OriginatingElements originatingElements, ConfigurationMetadataBuilder<?> metadataBuilder, VisitorContext visitorContext, @Nullable Integer uniqueIdentifier) {
        super(originatingElements);
        MemberElement factoryMethodElement;
        this.metadataBuilder = metadataBuilder;
        this.classWriter = new ClassWriter(3);
        this.beanProducingElement = beanProducingElement;
        if (beanProducingElement instanceof ClassElement) {
            ClassElement classElement = (ClassElement)beanProducingElement;
            this.autoApplyNamedToBeanProducingElement(classElement);
            if (classElement.isPrimitive()) {
                throw new IllegalArgumentException("Primitive beans can only be created from factories");
            }
            this.beanTypeElement = classElement;
            this.packageName = classElement.getPackageName();
            this.isInterface = classElement.isInterface();
            this.isAbstract = classElement.isAbstract();
            this.beanFullClassName = classElement.getName();
            this.beanSimpleClassName = classElement.getSimpleName();
            this.beanDefinitionName = BeanDefinitionWriter.getBeanDefinitionName(this.packageName, this.beanSimpleClassName);
        } else if (beanProducingElement instanceof MethodElement) {
            ClassElement producedElement;
            this.autoApplyNamedToBeanProducingElement(beanProducingElement);
            factoryMethodElement = (MethodElement)beanProducingElement;
            this.beanTypeElement = producedElement = factoryMethodElement.getGenericReturnType();
            this.packageName = producedElement.getPackageName();
            this.isInterface = producedElement.isInterface();
            this.isAbstract = false;
            this.beanFullClassName = producedElement.getName();
            this.beanSimpleClassName = producedElement.getSimpleName();
            String upperCaseMethodName = NameUtils.capitalize(factoryMethodElement.getName());
            if (uniqueIdentifier == null) {
                throw new IllegalArgumentException("Factory methods require passing a unique identifier");
            }
            ClassElement declaringType = factoryMethodElement.getOwningType();
            this.beanDefinitionName = declaringType.getPackageName() + "." + BeanDefinitionWriter.prefixClassName(declaringType.getSimpleName()) + "$" + upperCaseMethodName + uniqueIdentifier + CLASS_SUFFIX;
        } else if (beanProducingElement instanceof FieldElement) {
            ClassElement producedElement;
            this.autoApplyNamedToBeanProducingElement(beanProducingElement);
            factoryMethodElement = (FieldElement)beanProducingElement;
            this.beanTypeElement = producedElement = factoryMethodElement.getGenericField();
            this.packageName = producedElement.getPackageName();
            this.isInterface = producedElement.isInterface();
            this.isAbstract = false;
            this.beanFullClassName = producedElement.getName();
            this.beanSimpleClassName = producedElement.getSimpleName();
            String fieldName = NameUtils.capitalize(factoryMethodElement.getName());
            if (uniqueIdentifier == null) {
                throw new IllegalArgumentException("Factory fields require passing a unique identifier");
            }
            ClassElement declaringType = factoryMethodElement.getOwningType();
            this.beanDefinitionName = declaringType.getPackageName() + "." + BeanDefinitionWriter.prefixClassName(declaringType.getSimpleName()) + "$" + fieldName + uniqueIdentifier + CLASS_SUFFIX;
        } else {
            if (!(beanProducingElement instanceof BeanElementBuilder)) throw new IllegalArgumentException("Unsupported element type: " + beanProducingElement.getClass().getName());
            BeanElementBuilder beanElementBuilder = (BeanElementBuilder)beanProducingElement;
            this.beanTypeElement = beanElementBuilder.getBeanType();
            this.packageName = this.beanTypeElement.getPackageName();
            this.isInterface = this.beanTypeElement.isInterface();
            this.isAbstract = beanElementBuilder.getProducingElement() instanceof ClassElement && this.beanTypeElement.isAbstract();
            this.beanFullClassName = this.beanTypeElement.getName();
            this.beanSimpleClassName = this.beanTypeElement.getSimpleName();
            if (uniqueIdentifier == null) {
                throw new IllegalArgumentException("Beans produced by addAssociatedBean(..) require passing a unique identifier");
            }
            Element originatingElement = beanElementBuilder.getOriginatingElement();
            if (originatingElement instanceof ClassElement) {
                ClassElement originatingClass = (ClassElement)originatingElement;
                this.beanDefinitionName = this.getAssociatedBeanName(uniqueIdentifier, originatingClass);
            } else {
                if (!(originatingElement instanceof MethodElement)) throw new IllegalArgumentException("Unsupported originating element");
                ClassElement originatingClass = ((MethodElement)originatingElement).getDeclaringType();
                this.beanDefinitionName = this.getAssociatedBeanName(uniqueIdentifier, originatingClass);
            }
        }
        this.isPrimitiveBean = this.beanTypeElement.isPrimitive() && !this.beanTypeElement.isArray();
        this.annotationMetadata = beanProducingElement.getAnnotationMetadata();
        this.beanDefinitionType = BeanDefinitionWriter.getTypeReferenceForName(this.beanDefinitionName, new String[0]);
        this.beanType = BeanDefinitionWriter.getTypeReference(this.beanTypeElement);
        this.beanDefinitionInternalName = BeanDefinitionWriter.getInternalName(this.beanDefinitionName);
        this.interfaceTypes = new TreeSet<Class>(Comparator.comparing(Class::getName));
        this.interfaceTypes.add(BeanFactory.class);
        this.isConfigurationProperties = this.isConfigurationProperties(this.annotationMetadata);
        this.validateExposedTypes(this.annotationMetadata, visitorContext);
        this.visitorContext = visitorContext;
        this.beanTypeInnerClasses = this.beanTypeElement.getEnclosedElements(ElementQuery.of(ClassElement.class)).stream().filter(this::isConfigurationProperties).map(Element::getName).collect(Collectors.toList());
        String prop = visitorContext.getOptions().get(OMIT_CONFPROP_INJECTION_POINTS);
        this.keepConfPropInjectPoints = prop == null || !prop.equals("true");
    }

    @Override
    public boolean isEnabled() {
        return !this.disabled;
    }

    @Nullable
    public ExecutableMethodsDefinitionWriter getExecutableMethodsWriter() {
        return this.executableMethodsDefinitionWriter;
    }

    @NonNull
    private String getAssociatedBeanName(@NonNull Integer uniqueIdentifier, ClassElement originatingClass) {
        return originatingClass.getPackageName() + "." + BeanDefinitionWriter.prefixClassName(originatingClass.getSimpleName()) + BeanDefinitionWriter.prefixClassName(this.beanSimpleClassName) + uniqueIdentifier + CLASS_SUFFIX;
    }

    private void autoApplyNamedToBeanProducingElement(Element beanProducingElement) {
        AnnotationMetadata annotationMetadata = beanProducingElement.getAnnotationMetadata();
        if (!annotationMetadata.hasAnnotation(EachProperty.class) && !annotationMetadata.hasAnnotation(EachBean.class)) {
            this.autoApplyNamedIfPresent(beanProducingElement, annotationMetadata);
        }
    }

    private void validateExposedTypes(AnnotationMetadata annotationMetadata, VisitorContext visitorContext) {
        Object[] types;
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (ArrayUtils.isNotEmpty(types = annotationMetadata.stringValues(Bean.class, "typed")) && !this.beanTypeElement.isProxy()) {
            for (Object name : types) {
                ClassElement exposedType = visitorContext.getClassElement((String)name).orElse(null);
                if (exposedType == null) {
                    visitorContext.fail("Bean defines an exposed type [" + (String)name + "] that is not on the classpath", this.beanProducingElement);
                    continue;
                }
                if (this.beanTypeElement.isAssignable(exposedType)) continue;
                visitorContext.fail("Bean defines an exposed type [" + (String)name + "] that is not implemented by the bean type", this.beanProducingElement);
            }
        }
    }

    @NonNull
    private static String getBeanDefinitionName(String packageName, String className) {
        return packageName + "." + BeanDefinitionWriter.prefixClassName(className) + CLASS_SUFFIX;
    }

    private static String prefixClassName(String className) {
        if (className.startsWith("$")) {
            return className;
        }
        return "$" + className;
    }

    @Override
    @NonNull
    public ClassElement[] getTypeArguments() {
        Map<String, ClassElement> args;
        if (this.hasTypeArguments() && CollectionUtils.isNotEmpty(args = this.typeArguments.get(this.getBeanTypeName()))) {
            return args.values().toArray(ClassElement.ZERO_CLASS_ELEMENTS);
        }
        return BeanDefinitionVisitor.super.getTypeArguments();
    }

    @Override
    @NonNull
    public String getBeanDefinitionReferenceClassName() {
        return this.beanDefinitionName + "$Reference";
    }

    public final List<MethodVisitData> getPostConstructMethodVisits() {
        return Collections.unmodifiableList(this.postConstructMethodVisits);
    }

    public ClassVisitor getClassWriter() {
        return this.classWriter;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isSingleton() {
        return this.annotationMetadata.hasDeclaredStereotype("javax.inject.Singleton");
    }

    @Override
    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.interfaceTypes.add(interfaceType);
    }

    @Override
    public void visitSuperBeanDefinition(String name) {
        this.superBeanDefinition = true;
        this.superType = BeanDefinitionWriter.getTypeReferenceForName(name, new String[0]);
    }

    @Override
    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.visitSuperBeanDefinition(beanName);
        this.superBeanDefinition = false;
        this.isSuperFactory = true;
    }

    @Override
    public String getBeanTypeName() {
        return this.beanFullClassName;
    }

    @Override
    public io.micronaut.asm.Type getProvidedType() {
        return this.beanType;
    }

    @Override
    public void setValidated(boolean validated) {
        if (validated) {
            this.interfaceTypes.add(ValidatedBeanDefinition.class);
        } else {
            this.interfaceTypes.remove(ValidatedBeanDefinition.class);
        }
    }

    @Override
    public void setInterceptedType(String typeName) {
        if (typeName != null) {
            this.interfaceTypes.add(AdvisedBeanType.class);
        }
        this.interceptedType = typeName;
    }

    @Override
    public Optional<io.micronaut.asm.Type> getInterceptedType() {
        return Optional.ofNullable(this.interceptedType).map(x$0 -> BeanDefinitionWriter.getTypeReferenceForName(x$0, new String[0]));
    }

    @Override
    public boolean isValidated() {
        return this.interfaceTypes.contains(ValidatedBeanDefinition.class);
    }

    @Override
    public String getBeanDefinitionName() {
        return this.beanDefinitionName;
    }

    @Override
    public void visitBeanFactoryMethod(ClassElement factoryClass, MethodElement factoryMethod) {
        if (this.constructor != null) {
            throw new IllegalStateException(MESSAGE_ONLY_SINGLE_CALL_PERMITTED);
        }
        this.constructor = factoryMethod;
        this.visitBuildFactoryMethodDefinition(factoryClass, factoryMethod, factoryMethod.getParameters());
        this.visitInjectMethodDefinition();
    }

    @Override
    public void visitBeanFactoryMethod(ClassElement factoryClass, MethodElement factoryMethod, ParameterElement[] parameters) {
        if (this.constructor != null) {
            throw new IllegalStateException(MESSAGE_ONLY_SINGLE_CALL_PERMITTED);
        }
        this.constructor = factoryMethod;
        this.visitBuildFactoryMethodDefinition(factoryClass, factoryMethod, parameters);
        this.visitInjectMethodDefinition();
    }

    @Override
    public void visitBeanFactoryField(ClassElement factoryClass, FieldElement factoryField) {
        if (this.constructor != null) {
            throw new IllegalStateException(MESSAGE_ONLY_SINGLE_CALL_PERMITTED);
        }
        this.constructor = factoryField;
        this.autoApplyNamedIfPresent(factoryField, factoryField.getAnnotationMetadata());
        this.visitBuildFactoryMethodDefinition(factoryClass, factoryField, new ParameterElement[0]);
        this.visitInjectMethodDefinition();
    }

    @Override
    public void visitBeanDefinitionConstructor(MethodElement constructor, boolean requiresReflection, VisitorContext visitorContext) {
        if (this.constructor == null) {
            this.applyConfigurationInjectionIfNecessary(constructor);
            this.constructor = constructor;
            this.constructorRequiresReflection = requiresReflection;
            this.visitBuildMethodDefinition(constructor, requiresReflection);
            this.visitInjectMethodDefinition();
        }
    }

    private void applyConfigurationInjectionIfNecessary(MethodElement constructor) {
        boolean isRecordConfig = this.isRecordConfig(constructor);
        if (isRecordConfig || constructor.hasAnnotation(ConfigurationInject.class)) {
            List<String> injectionTypes = Arrays.asList(Property.class.getName(), Value.class.getName(), Parameter.class.getName(), "javax.inject.Qualifier", "javax.inject.Inject");
            if (isRecordConfig) {
                List<PropertyElement> beanProperties = constructor.getDeclaringType().getBeanProperties();
                ParameterElement[] parameters = constructor.getParameters();
                if (beanProperties.size() == parameters.length) {
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        ParameterElement parameter = parameters[i2];
                        PropertyElement bp = beanProperties.get(i2);
                        AnnotationMetadata beanPropertyMetadata = bp.getAnnotationMetadata();
                        AnnotationMetadata annotationMetadata = parameter.getAnnotationMetadata();
                        if (injectionTypes.stream().noneMatch(beanPropertyMetadata::hasStereotype)) {
                            this.processConfigurationConstructorParameter(parameter, annotationMetadata);
                        }
                        if (!annotationMetadata.hasStereotype(ANN_CONSTRAINT)) continue;
                        this.setValidated(true);
                    }
                } else {
                    this.processConfigurationInjectionConstructor(constructor, injectionTypes);
                }
            } else {
                this.processConfigurationInjectionConstructor(constructor, injectionTypes);
            }
        }
    }

    private void processConfigurationInjectionConstructor(MethodElement constructor, List<String> injectionTypes) {
        ParameterElement[] parameters;
        for (ParameterElement parameter : parameters = constructor.getParameters()) {
            AnnotationMetadata annotationMetadata = parameter.getAnnotationMetadata();
            if (injectionTypes.stream().noneMatch(annotationMetadata::hasStereotype)) {
                this.processConfigurationConstructorParameter(parameter, annotationMetadata);
            }
            if (!annotationMetadata.hasStereotype(ANN_CONSTRAINT)) continue;
            this.setValidated(true);
        }
    }

    private void processConfigurationConstructorParameter(ParameterElement parameter, AnnotationMetadata annotationMetadata) {
        ClassElement parameterType = parameter.getGenericType();
        if (!parameterType.hasStereotype("javax.inject.Scope")) {
            PropertyMetadata pm = this.metadataBuilder.visitProperty(parameterType.getName(), parameter.getName(), parameter.getDocumentation().orElse(null), annotationMetadata.stringValue(Bindable.class, "defaultValue").orElse(null));
            parameter.annotate(Property.class, (AnnotationValueBuilder<T> builder) -> builder.member("name", pm.getPath()));
        }
    }

    private boolean isRecordConfig(MethodElement constructor) {
        ClassElement declaringType = constructor.getDeclaringType();
        return declaringType.isRecord() && declaringType.hasStereotype((Class<? extends Annotation>)ConfigurationReader.class);
    }

    @Override
    public void visitDefaultConstructor(AnnotationMetadata annotationMetadata, VisitorContext visitorContext) {
        if (this.constructor == null) {
            ClassElement bean2 = ClassElement.of(this.beanType.getClassName());
            MethodElement defaultConstructor = MethodElement.of(bean2, annotationMetadata, bean2, bean2, "<init>", new ParameterElement[0]);
            this.constructor = defaultConstructor;
            this.visitBuildMethodDefinition(defaultConstructor, false);
            this.visitInjectMethodDefinition();
        }
    }

    @Override
    public void visitBeanDefinitionEnd() {
        MethodElement methodElement;
        boolean isParametrized;
        if (this.classWriter == null) {
            throw new IllegalStateException("At least one called to visitBeanDefinitionConstructor(..) is required");
        }
        this.processAllBeanElementVisitors();
        if (this.constructor instanceof MethodElement && (isParametrized = Arrays.stream((methodElement = (MethodElement)this.constructor).getParameters()).map(AnnotationMetadataProvider::getAnnotationMetadata).anyMatch(this::isAnnotatedWithParameter))) {
            this.interfaceTypes.add(ParametrizedBeanFactory.class);
        }
        String[] interfaceInternalNames = new String[this.interfaceTypes.size()];
        Iterator<Class> j = this.interfaceTypes.iterator();
        for (int i2 = 0; i2 < interfaceInternalNames.length; ++i2) {
            interfaceInternalNames[i2] = io.micronaut.asm.Type.getInternalName(j.next());
        }
        String beanDefSignature = this.generateBeanDefSig(this.beanType);
        this.classWriter.visit(52, 4096, this.beanDefinitionInternalName, beanDefSignature, this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), interfaceInternalNames);
        this.classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        if (this.buildMethodVisitor == null) {
            throw new IllegalStateException("At least one call to visitBeanDefinitionConstructor() is required");
        }
        final GeneratorAdapter staticInit = this.visitStaticInitializer(this.classWriter);
        this.classWriter.visitField(26, FIELD_CONSTRUCTOR, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodOrFieldReference.class).getDescriptor(), null, null);
        int methodsLength = this.allMethodVisits.size();
        if (!this.superBeanDefinition && methodsLength > 0) {
            io.micronaut.asm.Type methodsFieldType = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference[].class);
            this.classWriter.visitField(26, FIELD_INJECTION_METHODS, methodsFieldType.getDescriptor(), null, null);
            BeanDefinitionWriter.pushNewArray(staticInit, AbstractInitializableBeanDefinition.MethodReference.class, methodsLength);
            int i3 = 0;
            for (MethodVisitData methodVisitData : this.allMethodVisits) {
                BeanDefinitionWriter.pushStoreInArray(staticInit, i3++, methodsLength, () -> this.pushNewMethodReference(staticInit, JavaModelUtils.getTypeReference(methodVisitData.beanType), methodVisitData.methodElement, methodVisitData.requiresReflection, methodVisitData.isPostConstruct(), methodVisitData.isPreDestroy()));
            }
            staticInit.putStatic(this.beanDefinitionType, FIELD_INJECTION_METHODS, methodsFieldType);
        }
        if (!this.fieldInjectionPoints.isEmpty()) {
            io.micronaut.asm.Type fieldsFieldType = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference[].class);
            this.classWriter.visitField(26, FIELD_INJECTION_FIELDS, fieldsFieldType.getDescriptor(), null, null);
            int length = this.fieldInjectionPoints.size();
            BeanDefinitionWriter.pushNewArray(staticInit, AbstractInitializableBeanDefinition.FieldReference.class, length);
            for (int i4 = 0; i4 < length; ++i4) {
                FieldVisitData fieldVisitData = this.fieldInjectionPoints.get(i4);
                BeanDefinitionWriter.pushStoreInArray(staticInit, i4, length, () -> this.pushNewFieldReference(staticInit, JavaModelUtils.getTypeReference(fieldVisitData.beanType), fieldVisitData.fieldElement, fieldVisitData.requiresReflection));
            }
            staticInit.putStatic(this.beanDefinitionType, FIELD_INJECTION_FIELDS, fieldsFieldType);
        }
        if (!this.annotationInjectionPoints.isEmpty()) {
            io.micronaut.asm.Type annotationInjectionsFieldType = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference[].class);
            this.classWriter.visitField(26, FIELD_ANNOTATION_INJECTIONS, annotationInjectionsFieldType.getDescriptor(), null, null);
            ArrayList<io.micronaut.asm.Type> injectedTypes = new ArrayList<io.micronaut.asm.Type>(this.annotationInjectionPoints.keySet());
            int length = injectedTypes.size();
            BeanDefinitionWriter.pushNewArray(staticInit, AbstractInitializableBeanDefinition.AnnotationReference.class, length);
            for (int i5 = 0; i5 < length; ++i5) {
                io.micronaut.asm.Type annotationVisitData = (io.micronaut.asm.Type)injectedTypes.get(i5);
                BeanDefinitionWriter.pushStoreInArray(staticInit, i5, length, () -> this.pushNewAnnotationReference(staticInit, annotationVisitData));
            }
            staticInit.putStatic(this.beanDefinitionType, FIELD_ANNOTATION_INJECTIONS, annotationInjectionsFieldType);
        }
        if (!this.superBeanDefinition && this.hasTypeArguments()) {
            io.micronaut.asm.Type typeArgumentsFieldType = io.micronaut.asm.Type.getType(Map.class);
            this.classWriter.visitField(26, FIELD_TYPE_ARGUMENTS, typeArgumentsFieldType.getDescriptor(), null, null);
            BeanDefinitionWriter.pushStringMapOf(staticInit, this.typeArguments, true, null, new Consumer<Map<String, ClassElement>>(){

                @Override
                public void accept(Map<String, ClassElement> stringClassElementMap) {
                    AbstractClassFileWriter.pushTypeArgumentElements(BeanDefinitionWriter.this.beanDefinitionType, BeanDefinitionWriter.this.classWriter, staticInit, BeanDefinitionWriter.this.beanDefinitionName, stringClassElementMap, BeanDefinitionWriter.this.defaultsStorage, BeanDefinitionWriter.this.loadTypeMethods);
                }
            });
            staticInit.putStatic(this.beanDefinitionType, FIELD_TYPE_ARGUMENTS, typeArgumentsFieldType);
        }
        this.visitBeanDefinitionConstructorInternal(staticInit, this.constructor, this.constructorRequiresReflection);
        this.addInnerConfigurationMethod(staticInit);
        this.addGetExposedTypes(staticInit);
        staticInit.returnValue();
        staticInit.visitMaxs(13, this.defaultsStorage.size() + 3);
        staticInit.visitEnd();
        if (this.buildMethodVisitor != null) {
            if (this.isPrimitiveBean) {
                BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(this.beanType, (MethodVisitor)this.buildMethodVisitor);
            }
            this.buildMethodVisitor.returnValue();
            this.buildMethodVisitor.visitMaxs(13, 10);
        }
        if (this.injectMethodVisitor != null) {
            if (this.injectEnd != null) {
                this.injectMethodVisitor.visitLabel(this.injectEnd);
            }
            this.invokeSuperInjectMethod(this.injectMethodVisitor, INJECT_BEAN_METHOD);
            if (this.isPrimitiveBean) {
                BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(this.beanType, (MethodVisitor)this.injectMethodVisitor);
            }
            this.injectMethodVisitor.returnValue();
            this.injectMethodVisitor.visitMaxs(13, 10);
        }
        if (this.postConstructMethodVisitor != null) {
            this.postConstructMethodVisitor.loadLocal(this.postConstructInstanceLocalVarIndex);
            this.postConstructMethodVisitor.returnValue();
            this.postConstructMethodVisitor.visitMaxs(13, 10);
        }
        if (this.preDestroyMethodVisitor != null) {
            this.preDestroyMethodVisitor.loadLocal(this.preDestroyInstanceLocalVarIndex);
            this.preDestroyMethodVisitor.returnValue();
            this.preDestroyMethodVisitor.visitMaxs(13, 10);
        }
        if (this.interceptedDisposeMethod != null) {
            this.interceptedDisposeMethod.visitMaxs(1, 1);
            this.interceptedDisposeMethod.visitEnd();
        }
        if (this.checkIfShouldLoadMethodVisitor != null) {
            this.buildCheckIfShouldLoadMethod(this.checkIfShouldLoadMethodVisitor, this.annotationInjectionPoints);
            this.checkIfShouldLoadMethodVisitor.visitMaxs(13, 10);
        }
        this.getInterceptedType().ifPresent(t -> this.implementInterceptedTypeMethod((io.micronaut.asm.Type)t, this.classWriter));
        for (GeneratorAdapter method : this.loadTypeMethods.values()) {
            method.visitMaxs(3, 1);
            method.visitEnd();
        }
        this.classWriter.visitEnd();
        this.beanFinalized = true;
    }

    private void buildCheckIfShouldLoadMethod(GeneratorAdapter adapter, Map<io.micronaut.asm.Type, List<AnnotationVisitData>> beanPropertyVisitData) {
        ArrayList<io.micronaut.asm.Type> injectedTypes = new ArrayList<io.micronaut.asm.Type>(beanPropertyVisitData.keySet());
        for (int currentTypeIndex = 0; currentTypeIndex < injectedTypes.size(); ++currentTypeIndex) {
            io.micronaut.asm.Type injectedType = (io.micronaut.asm.Type)injectedTypes.get(currentTypeIndex);
            List<AnnotationVisitData> annotationVisitData = beanPropertyVisitData.get(injectedType);
            boolean multiplePropertiesFromType = annotationVisitData.size() > 1;
            Integer injectedBeanIndex = null;
            for (int i2 = 0; i2 < annotationVisitData.size(); ++i2) {
                int currentPropertyIndex = i2;
                boolean isLastProperty = currentTypeIndex == injectedTypes.size() - 1 && currentPropertyIndex == annotationVisitData.size() - 1;
                AnnotationVisitData visitData = annotationVisitData.get(currentPropertyIndex);
                MethodElement propertyGetter = visitData.memberPropertyGetter;
                adapter.loadThis();
                adapter.push(visitData.memberPropertyName);
                if (injectedBeanIndex != null) {
                    adapter.loadLocal(injectedBeanIndex);
                } else {
                    adapter.loadThis();
                    adapter.loadArg(0);
                    adapter.loadArg(1);
                    adapter.push(currentTypeIndex);
                    this.pushQualifier(adapter, visitData.memberBeanType, () -> this.resolveAnnotationArgument(adapter, currentPropertyIndex));
                    this.pushInvokeMethodOnSuperClass(adapter, GET_BEAN_FOR_ANNOTATION);
                    BeanDefinitionWriter.pushCastToType((MethodVisitor)adapter, visitData.memberBeanType);
                    if (multiplePropertiesFromType) {
                        injectedBeanIndex = adapter.newLocal(injectedType);
                        adapter.storeLocal(injectedBeanIndex);
                        adapter.loadLocal(injectedBeanIndex);
                    }
                }
                Method propertyGetterMethod = Method.getMethod(propertyGetter.getDescription(false));
                if (visitData.memberBeanType.getType().isInterface()) {
                    adapter.invokeInterface(injectedType, propertyGetterMethod);
                } else {
                    adapter.invokeVirtual(injectedType, propertyGetterMethod);
                }
                BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(propertyGetterMethod.getReturnType(), (MethodVisitor)adapter);
                adapter.push(visitData.requiredValue);
                adapter.push(visitData.notEqualsValue);
                this.pushInvokeMethodOnSuperClass(adapter, CHECK_INJECTED_BEAN_PROPERTY_VALUE);
                if (!isLastProperty) continue;
                adapter.returnValue();
            }
        }
    }

    private void processAllBeanElementVisitors() {
        for (BeanElementVisitor<?> visitor : BeanElementVisitor.VISITORS) {
            if (!visitor.isEnabled() || !visitor.supports(this)) continue;
            try {
                boolean bl = this.disabled = visitor.visitBeanElement(this, this.visitorContext) == null;
                if (!this.disabled) continue;
            }
            catch (Exception e) {
                this.visitorContext.fail("Error occurred visiting BeanElementVisitor of type [" + visitor.getClass().getName() + "]: " + e.getMessage(), this);
            }
            break;
        }
    }

    private void addInnerConfigurationMethod(GeneratorAdapter staticInit) {
        if (this.isConfigurationProperties && this.beanTypeInnerClasses.size() > 0) {
            this.classWriter.visitField(26, FIELD_INNER_CLASSES, io.micronaut.asm.Type.getType(Set.class).getDescriptor(), null, null);
            this.pushStoreClassesAsSet(staticInit, this.beanTypeInnerClasses.toArray(new String[0]));
            staticInit.putStatic(this.beanDefinitionType, FIELD_INNER_CLASSES, io.micronaut.asm.Type.getType(Set.class));
            GeneratorAdapter isInnerConfigurationMethod = this.startProtectedMethod(this.classWriter, "isInnerConfiguration", Boolean.TYPE.getName(), Class.class.getName());
            isInnerConfigurationMethod.getStatic(this.beanDefinitionType, FIELD_INNER_CLASSES, io.micronaut.asm.Type.getType(Set.class));
            isInnerConfigurationMethod.loadArg(0);
            isInnerConfigurationMethod.invokeInterface(io.micronaut.asm.Type.getType(Collection.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Collection.class, "contains", Object.class)));
            isInnerConfigurationMethod.returnValue();
            isInnerConfigurationMethod.visitMaxs(1, 1);
            isInnerConfigurationMethod.visitEnd();
        }
    }

    private void addGetExposedTypes(GeneratorAdapter staticInit) {
        String[] exposedTypes;
        if (this.annotationMetadata.hasDeclaredAnnotation(Bean.class.getName()) && (exposedTypes = this.annotationMetadata.stringValues(Bean.class.getName(), "typed")).length > 0) {
            this.classWriter.visitField(26, FIELD_EXPOSED_TYPES, io.micronaut.asm.Type.getType(Set.class).getDescriptor(), null, null);
            this.pushStoreClassesAsSet(staticInit, exposedTypes);
            staticInit.putStatic(this.beanDefinitionType, FIELD_EXPOSED_TYPES, io.micronaut.asm.Type.getType(Set.class));
            GeneratorAdapter getExposedTypesMethod = this.startPublicMethod(this.classWriter, "getExposedTypes", Set.class.getName(), new String[0]);
            getExposedTypesMethod.getStatic(this.beanDefinitionType, FIELD_EXPOSED_TYPES, io.micronaut.asm.Type.getType(Set.class));
            getExposedTypesMethod.returnValue();
            getExposedTypesMethod.visitMaxs(1, 1);
            getExposedTypesMethod.visitEnd();
        }
    }

    private void pushStoreClassesAsSet(GeneratorAdapter writer, String[] classes) {
        if (classes.length > 1) {
            writer.newInstance(io.micronaut.asm.Type.getType(HashSet.class));
            writer.dup();
            this.pushArrayOfClasses(writer, classes);
            writer.invokeStatic(io.micronaut.asm.Type.getType(Arrays.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Arrays.class, "asList", Object[].class)));
            writer.invokeConstructor(io.micronaut.asm.Type.getType(HashSet.class), Method.getMethod(ReflectionUtils.findConstructor(HashSet.class, Collection.class).get()));
        } else {
            this.pushClass(writer, classes[0]);
            writer.invokeStatic(io.micronaut.asm.Type.getType(Collections.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Collections.class, "singleton", Object.class)));
        }
    }

    private boolean hasTypeArguments() {
        return this.typeArguments != null && !this.typeArguments.isEmpty() && this.typeArguments.entrySet().stream().anyMatch(e -> !((Map)e.getValue()).isEmpty());
    }

    private boolean isSingleton(String scope) {
        if (this.beanProducingElement instanceof FieldElement && this.beanProducingElement.isFinal()) {
            return true;
        }
        if (scope != null) {
            return scope.equals(Singleton.class.getName()) || scope.equals("javax.inject.Singleton");
        }
        AnnotationMetadata annotationMetadata = this.beanProducingElement instanceof ClassElement ? this.getAnnotationMetadata() : this.beanProducingElement.getDeclaredMetadata();
        return annotationMetadata.stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("javax.inject.Singleton")).orElse(false);
    }

    private void lookupReferenceAnnotationMetadata(GeneratorAdapter annotationMetadataMethod) {
        annotationMetadataMethod.loadThis();
        annotationMetadataMethod.getStatic(BeanDefinitionWriter.getTypeReferenceForName(this.getBeanDefinitionReferenceClassName(), new String[0]), "$ANNOTATION_METADATA", io.micronaut.asm.Type.getType(AnnotationMetadata.class));
        annotationMetadataMethod.returnValue();
        annotationMetadataMethod.visitMaxs(1, 1);
        annotationMetadataMethod.visitEnd();
    }

    public byte[] toByteArray() {
        if (!this.beanFinalized) {
            throw new IllegalStateException("Bean definition not finalized. Call visitBeanDefinitionEnd() first.");
        }
        return this.classWriter.toByteArray();
    }

    @Override
    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        if (this.disabled) {
            return;
        }
        try (OutputStream out = visitor.visitClass(this.getBeanDefinitionName(), this.getOriginatingElements());){
            if (!this.innerClasses.isEmpty()) {
                for (Map.Entry<String, ClassWriter> entry : this.innerClasses.entrySet()) {
                    try (OutputStream constructorOut = visitor.visitClass(entry.getKey(), this.getOriginatingElements());){
                        constructorOut.write(entry.getValue().toByteArray());
                    }
                }
            }
            try {
                if (this.executableMethodsDefinitionWriter != null) {
                    this.executableMethodsDefinitionWriter.accept(visitor);
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
            out.write(this.toByteArray());
        }
    }

    @Override
    public void visitSetterValue(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, boolean isOptional) {
        if (!requiresReflection) {
            ParameterElement parameter = methodElement.getParameters()[0];
            AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(parameter.getAnnotationMetadata(), methodElement.getAnnotationMetadata());
            Label falseCondition = isOptional ? this.pushPropertyContainsCheck(this.injectMethodVisitor, parameter.getType(), parameter.getName(), annotationMetadata) : null;
            AnnotationMetadata currentAnnotationMetadata = methodElement.getAnnotationMetadata();
            ClassElement genericType = parameter.getGenericType();
            if (this.isConfigurationProperties && this.isValueType(currentAnnotationMetadata)) {
                this.injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
                Optional<String> property = currentAnnotationMetadata.stringValue(Property.class, "name");
                Optional<String> valueValue = parameter.stringValue(Value.class);
                if (this.isInnerType(genericType)) {
                    boolean isArray = genericType.isArray();
                    boolean isCollection = genericType.isAssignable(Collection.class);
                    if (isCollection || isArray) {
                        ClassElement typeArgument;
                        ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
                        if (typeArgument != null && !typeArgument.isPrimitive()) {
                            this.pushInvokeGetBeansOfTypeForSetter(this.injectMethodVisitor, methodElement.getName(), parameter);
                        } else {
                            this.pushInvokeGetBeanForSetter(this.injectMethodVisitor, methodElement.getName(), parameter);
                        }
                    } else {
                        this.pushInvokeGetBeanForSetter(this.injectMethodVisitor, methodElement.getName(), parameter);
                    }
                } else if (property.isPresent()) {
                    this.pushInvokeGetPropertyValueForSetter(this.injectMethodVisitor, methodElement.getName(), parameter, property.get());
                } else if (valueValue.isPresent()) {
                    this.pushInvokeGetPropertyPlaceholderValueForSetter(this.injectMethodVisitor, methodElement.getName(), parameter, valueValue.get());
                } else {
                    throw new IllegalStateException();
                }
                io.micronaut.asm.Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
                String methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(methodElement.getReturnType(), Arrays.asList(methodElement.getParameters()));
                this.injectMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeRef.getInternalName(), methodElement.getName(), methodDescriptor, this.isInterface);
                if (methodElement.getReturnType() != PrimitiveElement.VOID) {
                    this.injectMethodVisitor.pop();
                }
                if (this.keepConfPropInjectPoints) {
                    MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, false);
                    this.methodInjectionPoints.add(methodVisitData);
                    this.allMethodVisits.add(methodVisitData);
                    ++this.currentMethodIndex;
                }
            } else {
                MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, false);
                this.visitMethodInjectionPointInternal(methodVisitData, this.injectMethodVisitor, this.injectInstanceLocalVarIndex);
                this.methodInjectionPoints.add(methodVisitData);
                this.allMethodVisits.add(methodVisitData);
                ++this.currentMethodIndex;
            }
            if (falseCondition != null) {
                this.injectMethodVisitor.visitLabel(falseCondition);
            }
        } else {
            MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, false);
            this.methodInjectionPoints.add(methodVisitData);
            this.allMethodVisits.add(methodVisitData);
            ++this.currentMethodIndex;
        }
    }

    @Override
    public void visitPostConstructMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        this.visitPostConstructMethodDefinition(false);
        if (!this.superBeanDefinition || this.isInterceptedLifeCycleByType(this.annotationMetadata, "POST_CONSTRUCT")) {
            MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, requiresReflection, true, false);
            this.postConstructMethodVisits.add(methodVisitData);
            this.allMethodVisits.add(methodVisitData);
            this.visitMethodInjectionPointInternal(methodVisitData, this.postConstructMethodVisitor, this.postConstructInstanceLocalVarIndex);
            ++this.currentMethodIndex;
        }
    }

    @Override
    public void visitPreDestroyMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        if (!this.superBeanDefinition || this.isInterceptedLifeCycleByType(this.annotationMetadata, "PRE_DESTROY")) {
            this.visitPreDestroyMethodDefinition(false);
            MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, requiresReflection, false, true);
            this.preDestroyMethodVisits.add(methodVisitData);
            this.allMethodVisits.add(methodVisitData);
            this.visitMethodInjectionPointInternal(methodVisitData, this.preDestroyMethodVisitor, this.preDestroyInstanceLocalVarIndex);
            ++this.currentMethodIndex;
        }
    }

    @Override
    public void visitMethodInjectionPoint(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        this.applyConfigurationInjectionIfNecessary(methodElement);
        MethodVisitData methodVisitData = new MethodVisitData(declaringType, methodElement, requiresReflection);
        this.methodInjectionPoints.add(methodVisitData);
        this.allMethodVisits.add(methodVisitData);
        this.visitMethodInjectionPointInternal(methodVisitData, this.injectMethodVisitor, this.injectInstanceLocalVarIndex);
        ++this.currentMethodIndex;
    }

    @Override
    public int visitExecutableMethod(TypedElement declaringBean, MethodElement methodElement, VisitorContext visitorContext) {
        return this.visitExecutableMethod(declaringBean, methodElement, null, null);
    }

    public int visitExecutableMethod(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName) {
        AnnotationMetadata annotationMetadata = methodElement.getAnnotationMetadata();
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        for (ParameterElement parameterElement : methodElement.getSuspendParameters()) {
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, parameterElement.getAnnotationMetadata());
            DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, parameterElement.getGenericType());
        }
        if (this.executableMethodsDefinitionWriter == null) {
            this.executableMethodsDefinitionWriter = new ExecutableMethodsDefinitionWriter(this.beanDefinitionName, this.getBeanDefinitionReferenceClassName(), this.originatingElements);
        }
        return this.executableMethodsDefinitionWriter.visitExecutableMethod(declaringType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName);
    }

    public String toString() {
        return "BeanDefinitionWriter{beanFullClassName='" + this.beanFullClassName + '\'' + '}';
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getBeanSimpleName() {
        return this.beanSimpleClassName;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public void visitConfigBuilderField(ClassElement type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty(factoryMethod)) {
            io.micronaut.asm.Type builderType = JavaModelUtils.getTypeReference(type);
            this.injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod(builderType.getClassName() + " " + factoryMethod + "()"));
            this.injectMethodVisitor.putField(this.beanType, field, builderType);
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, field, false, annotationMetadata, metadataBuilder, isInterface);
    }

    public void visitConfigBuilderMethod(ClassElement type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        String factoryMethod = annotationMetadata.getValue(ConfigurationBuilder.class, "factoryMethod", String.class).orElse(null);
        if (StringUtils.isNotEmpty(factoryMethod)) {
            io.micronaut.asm.Type builderType = JavaModelUtils.getTypeReference(type);
            this.injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
            this.injectMethodVisitor.invokeStatic(builderType, Method.getMethod(builderType.getClassName() + " " + factoryMethod + "()"));
            String propertyName = NameUtils.getPropertyNameForGetter(methodName);
            String setterName = NameUtils.setterNameFor(propertyName);
            this.injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod("void " + setterName + "(" + builderType.getClassName() + ")"));
        }
        this.currentConfigBuilderState = new ConfigBuilderState(type, methodName, true, annotationMetadata, metadataBuilder, isInterface);
    }

    @Override
    public void visitConfigBuilderDurationMethod(String prefix, ClassElement returnType, String methodName, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, ClassElement.of(Duration.class), Collections.emptyMap(), true, path);
    }

    @Override
    public void visitConfigBuilderMethod(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, String path) {
        this.visitConfigBuilderMethodInternal(prefix, returnType, methodName, paramType, generics, false, path);
    }

    @Override
    public void visitConfigBuilderEnd() {
        this.currentConfigBuilderState = null;
    }

    @Override
    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.preprocessMethods = shouldPreProcess;
    }

    @Override
    public void visitTypeArguments(Map<String, Map<String, ClassElement>> typeArguments) {
        this.typeArguments = typeArguments;
    }

    @Override
    public boolean requiresMethodProcessing() {
        return this.preprocessMethods;
    }

    @Override
    public void visitFieldInjectionPoint(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection) {
        this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection);
    }

    private void visitFieldInjectionPointInternal(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection) {
        java.lang.reflect.Method methodToInvoke;
        boolean requiresGenericType = false;
        ClassElement genericType = fieldElement.getGenericType();
        boolean isArray = genericType.isArray();
        boolean isCollection = genericType.isAssignable(Collection.class);
        if (isCollection || isArray) {
            ClassElement typeArgument;
            requiresGenericType = true;
            ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
            if (typeArgument != null && !typeArgument.isPrimitive()) {
                methodToInvoke = typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_FIELD : GET_BEANS_OF_TYPE_FOR_FIELD;
            } else {
                requiresGenericType = false;
                methodToInvoke = GET_BEAN_FOR_FIELD;
            }
        } else if (genericType.isAssignable(Stream.class)) {
            requiresGenericType = true;
            methodToInvoke = GET_STREAM_OF_TYPE_FOR_FIELD;
        } else if (genericType.isAssignable(Optional.class)) {
            requiresGenericType = true;
            methodToInvoke = FIND_BEAN_FOR_FIELD;
        } else if (genericType.isAssignable(BeanRegistration.class)) {
            requiresGenericType = true;
            methodToInvoke = GET_BEAN_REGISTRATION_FOR_FIELD;
        } else {
            methodToInvoke = GET_BEAN_FOR_FIELD;
        }
        this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection, methodToInvoke, isArray, requiresGenericType);
    }

    private boolean isInnerType(ClassElement genericType) {
        String type = genericType.isAssignable(Collection.class) ? genericType.getFirstTypeArgument().map(Element::getName).orElse("") : (genericType.isArray() ? genericType.fromArray().getName() : genericType.getName());
        return this.beanTypeInnerClasses.contains(type);
    }

    @Override
    public void visitAnnotationMemberPropertyInjectionPoint(TypedElement annotationMemberBeanType, String annotationMemberProperty, @Nullable String requiredValue, @Nullable String notEqualsValue) {
        ClassElement annotationMemberClassElement = annotationMemberBeanType.getType();
        MethodElement memberPropertyGetter = annotationMemberClassElement.getBeanProperties().stream().filter(property -> property.getSimpleName().equals(annotationMemberProperty)).findFirst().flatMap(PropertyElement::getReadMethod).orElse(null);
        if (memberPropertyGetter == null) {
            String[] readPrefixes = annotationMemberBeanType.getAnnotationMetadata().getValue(AccessorsStyle.class, "readPrefixes", String[].class).orElse(new String[]{"get"});
            memberPropertyGetter = annotationMemberClassElement.getEnclosedElement(ElementQuery.ALL_METHODS.onlyAccessible(this.beanTypeElement).onlyInstance().named(name -> annotationMemberProperty.equals(NameUtils.getPropertyNameForGetter(name, readPrefixes))).filter(e -> !e.hasParameters())).orElse(null);
        }
        if (memberPropertyGetter == null) {
            this.visitorContext.fail("Bean property [" + annotationMemberProperty + "] is not available on bean [" + annotationMemberBeanType.getName() + "]", annotationMemberBeanType);
        } else {
            io.micronaut.asm.Type injectedType = JavaModelUtils.getTypeReference(annotationMemberClassElement);
            this.annotationInjectionPoints.computeIfAbsent(injectedType, type -> new ArrayList(2)).add(new AnnotationVisitData(annotationMemberBeanType, annotationMemberProperty, memberPropertyGetter, requiredValue, notEqualsValue));
        }
    }

    @Override
    public void visitFieldValue(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection, boolean isOptional) {
        Label falseCondition;
        Label label = falseCondition = isOptional ? this.pushPropertyContainsCheck(this.injectMethodVisitor, fieldElement.getType(), fieldElement.getName(), fieldElement.getAnnotationMetadata()) : null;
        if (this.isInnerType(fieldElement.getGenericType())) {
            this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection);
        } else if (!this.isConfigurationProperties || requiresReflection) {
            this.visitFieldInjectionPointInternal(declaringType, fieldElement, requiresReflection, GET_VALUE_FOR_FIELD, isOptional, false);
        } else {
            this.injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
            Optional<String> property = fieldElement.stringValue(Property.class, "name");
            if (property.isPresent()) {
                this.pushInvokeGetPropertyValueForField(this.injectMethodVisitor, fieldElement, property.get());
            } else {
                Optional<String> valueValue = fieldElement.stringValue(Value.class);
                if (valueValue.isPresent()) {
                    this.pushInvokeGetPropertyPlaceholderValueForField(this.injectMethodVisitor, fieldElement, valueValue.get());
                }
            }
            this.putField(this.injectMethodVisitor, fieldElement, requiresReflection, declaringType);
            if (this.keepConfPropInjectPoints) {
                this.fieldInjectionPoints.add(new FieldVisitData(declaringType, fieldElement, requiresReflection));
                ++this.currentFieldIndex;
            }
        }
        if (falseCondition != null) {
            this.injectMethodVisitor.visitLabel(falseCondition);
        }
    }

    private void pushInvokeGetPropertyValueForField(GeneratorAdapter injectMethodVisitor, FieldElement fieldElement, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        MutableAnnotationMetadata mutableAnnotationMetadata = ((MutableAnnotationMetadata)fieldElement.getAnnotationMetadata()).clone();
        this.removeAnnotations(mutableAnnotationMetadata, PropertySource.class.getName(), Property.class.getName());
        if (this.keepConfPropInjectPoints) {
            this.resolveFieldArgument(injectMethodVisitor, this.currentFieldIndex);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, fieldElement.getName(), fieldElement.getGenericType(), mutableAnnotationMetadata, fieldElement.getGenericType().getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(value);
        injectMethodVisitor.push(this.getCliPrefix(fieldElement.getName()));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_VALUE_FOR_FIELD);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, fieldElement.getType());
    }

    private void pushInvokeGetPropertyPlaceholderValueForField(GeneratorAdapter injectMethodVisitor, FieldElement fieldElement, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        MutableAnnotationMetadata mutableAnnotationMetadata = ((MutableAnnotationMetadata)fieldElement.getAnnotationMetadata()).clone();
        this.removeAnnotations(mutableAnnotationMetadata, PropertySource.class.getName(), Property.class.getName());
        if (this.keepConfPropInjectPoints) {
            this.resolveFieldArgument(injectMethodVisitor, this.currentFieldIndex);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, fieldElement.getName(), fieldElement.getGenericType(), mutableAnnotationMetadata, fieldElement.getGenericType().getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(value);
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_PLACEHOLDER_VALUE_FOR_FIELD);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, fieldElement.getType());
    }

    private void visitConfigBuilderMethodInternal(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, boolean isDurationWithTimeUnit, String propertyPath) {
        if (this.currentConfigBuilderState != null) {
            io.micronaut.asm.Type builderType = this.currentConfigBuilderState.getType();
            String builderName = this.currentConfigBuilderState.getName();
            boolean isResolveBuilderViaMethodCall = this.currentConfigBuilderState.isMethod();
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
            String propertyName = NameUtils.hyphenate(NameUtils.decapitalize(methodName.substring(prefix.length())), true);
            boolean zeroArgs = paramType == null;
            int optionalLocalIndex = this.pushGetValueForPathCall(injectMethodVisitor, paramType, propertyName, propertyPath, zeroArgs, generics);
            Label ifEnd = new Label();
            injectMethodVisitor.invokeVirtual(io.micronaut.asm.Type.getType(Optional.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Optional.class, "isPresent", new Class[0])));
            injectMethodVisitor.push(false);
            injectMethodVisitor.ifCmp(io.micronaut.asm.Type.BOOLEAN_TYPE, 153, ifEnd);
            if (zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor, optionalLocalIndex);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, Boolean.TYPE);
                injectMethodVisitor.push(false);
                injectMethodVisitor.ifCmp(io.micronaut.asm.Type.BOOLEAN_TYPE, 153, ifEnd);
            }
            injectMethodVisitor.visitLabel(new Label());
            String methodDescriptor = zeroArgs ? BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList()) : (isDurationWithTimeUnit ? BeanDefinitionWriter.getMethodDescriptor(returnType, Arrays.asList(ClassElement.of(Long.TYPE), ClassElement.of(TimeUnit.class))) : BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.singleton(paramType)));
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label exceptionHandler = new Label();
            injectMethodVisitor.visitTryCatchBlock(tryStart, tryEnd, exceptionHandler, io.micronaut.asm.Type.getInternalName(NoSuchMethodError.class));
            injectMethodVisitor.visitLabel(tryStart);
            injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex);
            if (isResolveBuilderViaMethodCall) {
                String desc = builderType.getClassName() + " " + builderName + "()";
                injectMethodVisitor.invokeVirtual(this.beanType, Method.getMethod(desc));
            } else {
                injectMethodVisitor.getField(this.beanType, builderName, builderType);
            }
            if (!zeroArgs) {
                this.pushOptionalGet(injectMethodVisitor, optionalLocalIndex);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, paramType);
            }
            boolean anInterface = this.currentConfigBuilderState.isInterface();
            if (isDurationWithTimeUnit) {
                injectMethodVisitor.invokeVirtual(io.micronaut.asm.Type.getType(Duration.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Duration.class, "toMillis", new Class[0])));
                io.micronaut.asm.Type tu = io.micronaut.asm.Type.getType(TimeUnit.class);
                injectMethodVisitor.getStatic(tu, "MILLISECONDS", tu);
            }
            if (anInterface) {
                injectMethodVisitor.invokeInterface(builderType, new Method(methodName, methodDescriptor));
            } else {
                injectMethodVisitor.invokeVirtual(builderType, new Method(methodName, methodDescriptor));
            }
            if (returnType != PrimitiveElement.VOID) {
                injectMethodVisitor.pop();
            }
            injectMethodVisitor.visitJumpInsn(167, tryEnd);
            injectMethodVisitor.visitLabel(exceptionHandler);
            injectMethodVisitor.pop();
            injectMethodVisitor.visitLabel(tryEnd);
            injectMethodVisitor.visitLabel(ifEnd);
        }
    }

    private void pushOptionalGet(GeneratorAdapter injectMethodVisitor, int optionalLocalIndex) {
        injectMethodVisitor.loadLocal(optionalLocalIndex);
        injectMethodVisitor.invokeVirtual(io.micronaut.asm.Type.getType(Optional.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Optional.class, "get", new Class[0])));
    }

    private int pushGetValueForPathCall(GeneratorAdapter injectMethodVisitor, ClassElement propertyType, String propertyName, String propertyPath, boolean zeroArgs, Map<String, ClassElement> generics) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        if (zeroArgs) {
            BeanDefinitionWriter.buildArgument(injectMethodVisitor, propertyName, io.micronaut.asm.Type.getType(Boolean.class));
        } else {
            BeanDefinitionWriter.buildArgumentWithGenerics(this.beanDefinitionType, this.classWriter, injectMethodVisitor, propertyName, JavaModelUtils.getTypeReference(propertyType), propertyType, generics, new HashSet<String>(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(propertyPath);
        injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod(GET_VALUE_FOR_PATH));
        int optionalInstanceIndex = injectMethodVisitor.newLocal(io.micronaut.asm.Type.getType(Optional.class));
        injectMethodVisitor.storeLocal(optionalInstanceIndex);
        injectMethodVisitor.loadLocal(optionalInstanceIndex);
        return optionalInstanceIndex;
    }

    private void visitFieldInjectionPointInternal(TypedElement declaringType, FieldElement fieldElement, boolean requiresReflection, java.lang.reflect.Method methodToInvoke, boolean isArray, boolean requiresGenericType) {
        AnnotationMetadata annotationMetadata = fieldElement.getAnnotationMetadata();
        this.autoApplyNamedIfPresent(fieldElement, annotationMetadata);
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, fieldElement.getGenericField());
        io.micronaut.asm.Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor;
        injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
        if (fieldElement.getGenericField().isAssignable(BeanContext.class)) {
            injectMethodVisitor.loadArg(1);
        } else {
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentFieldIndex);
            if (requiresGenericType) {
                this.resolveFieldArgumentGenericType(injectMethodVisitor, fieldElement.getGenericType(), this.currentFieldIndex);
            }
            this.pushQualifier(injectMethodVisitor, fieldElement, () -> this.resolveFieldArgument(injectMethodVisitor, this.currentFieldIndex));
            this.pushInvokeMethodOnSuperClass(injectMethodVisitor, methodToInvoke);
            if (isArray && requiresGenericType) {
                this.convertToArray(fieldElement.getType().fromArray(), injectMethodVisitor);
            }
            BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, fieldElement.getType());
        }
        this.putField(injectMethodVisitor, fieldElement, requiresReflection, declaringType);
        ++this.currentFieldIndex;
        this.fieldInjectionPoints.add(new FieldVisitData(declaringType, fieldElement, requiresReflection));
    }

    private void putField(GeneratorAdapter injectMethodVisitor, FieldElement fieldElement, boolean requiresReflection, TypedElement declaringType) {
        io.micronaut.asm.Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        io.micronaut.asm.Type fieldType = JavaModelUtils.getTypeReference(fieldElement.getType());
        if (!requiresReflection) {
            injectMethodVisitor.putField(declaringTypeRef, fieldElement.getName(), fieldType);
        } else {
            BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(fieldType, (MethodVisitor)injectMethodVisitor);
            int storedIndex = injectMethodVisitor.newLocal(io.micronaut.asm.Type.getType(Object.class));
            injectMethodVisitor.storeLocal(storedIndex);
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentFieldIndex);
            injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex);
            injectMethodVisitor.loadLocal(storedIndex);
            injectMethodVisitor.invokeVirtual(this.superType, SET_FIELD_WITH_REFLECTION_METHOD);
            injectMethodVisitor.pop();
        }
    }

    private Label pushPropertyContainsCheck(GeneratorAdapter injectMethodVisitor, ClassElement propertyType, String propertyName, AnnotationMetadata annotationMetadata) {
        Optional<String> propertyValue = annotationMetadata.stringValue(Property.class, "name");
        Label trueCondition = new Label();
        Label falseCondition = new Label();
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(propertyValue.get());
        if (this.isMultiValueProperty(propertyType)) {
            injectMethodVisitor.invokeVirtual(this.beanDefinitionType, CONTAINS_PROPERTIES_VALUE_METHOD);
        } else {
            injectMethodVisitor.invokeVirtual(this.beanDefinitionType, CONTAINS_PROPERTY_VALUE_METHOD);
        }
        injectMethodVisitor.push(false);
        String cliProperty = this.getCliPrefix(propertyName);
        if (cliProperty != null) {
            injectMethodVisitor.ifCmp(io.micronaut.asm.Type.BOOLEAN_TYPE, 154, trueCondition);
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(cliProperty);
            injectMethodVisitor.invokeVirtual(this.beanDefinitionType, CONTAINS_PROPERTY_VALUE_METHOD);
            injectMethodVisitor.push(false);
        }
        injectMethodVisitor.ifCmp(io.micronaut.asm.Type.BOOLEAN_TYPE, 153, falseCondition);
        injectMethodVisitor.visitLabel(trueCondition);
        return falseCondition;
    }

    private String getCliPrefix(String propertyName) {
        if (this.isConfigurationProperties && this.annotationMetadata.isPresent(ConfigurationProperties.class, "cliPrefix")) {
            return this.annotationMetadata.stringValue(ConfigurationProperties.class, "cliPrefix").map(val -> val + propertyName).orElse(null);
        }
        return null;
    }

    private boolean isMultiValueProperty(ClassElement type) {
        return type.isAssignable(Map.class) || type.isAssignable(Collection.class) || this.isConfigurationProperties(type);
    }

    private void pushQualifier(GeneratorAdapter generatorAdapter, Element element, Runnable resolveArgument) {
        List<String> qualifierNames = element.getAnnotationNamesByStereotype("javax.inject.Qualifier");
        if (!qualifierNames.isEmpty()) {
            if (qualifierNames.size() == 1) {
                String annotationName = qualifierNames.iterator().next();
                this.pushQualifierForAnnotation(generatorAdapter, element, annotationName, resolveArgument);
            } else {
                int len = qualifierNames.size();
                BeanDefinitionWriter.pushNewArray(generatorAdapter, TYPE_QUALIFIER, len);
                for (int i2 = 0; i2 < len; ++i2) {
                    String annotationName = qualifierNames.get(i2);
                    BeanDefinitionWriter.pushStoreInArray(generatorAdapter, i2, len, () -> this.pushQualifierForAnnotation(generatorAdapter, element, annotationName, resolveArgument));
                }
                generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_QUALIFIERS);
            }
        } else if (element.hasAnnotation("io.micronaut.inject.qualifiers.InterceptorBindingQualifier")) {
            resolveArgument.run();
            this.retrieveAnnotationMetadataFromProvider(generatorAdapter);
            generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_INTERCEPTOR_BINDING);
        } else {
            String[] byType;
            String[] stringArray = byType = element.hasDeclaredAnnotation(Type.NAME) ? element.stringValues(Type.NAME) : null;
            if (byType != null && byType.length > 0) {
                this.pushArrayOfClasses(generatorAdapter, byType);
                generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_TYPE);
            } else {
                generatorAdapter.push((String)null);
            }
        }
    }

    private void retrieveAnnotationMetadataFromProvider(GeneratorAdapter generatorAdapter) {
        generatorAdapter.invokeInterface(io.micronaut.asm.Type.getType(AnnotationMetadataProvider.class), Method.getMethod(ReflectionUtils.getRequiredMethod(AnnotationMetadataProvider.class, "getAnnotationMetadata", new Class[0])));
    }

    private void pushQualifierForAnnotation(GeneratorAdapter generatorAdapter, Element element, String annotationName, Runnable resolveArgument) {
        if (annotationName.equals(Primary.NAME)) {
            generatorAdapter.visitInsn(1);
        } else if (annotationName.equals("javax.inject.Named")) {
            String n = element.stringValue("javax.inject.Named").orElse(element.getName());
            if (!n.contains("$")) {
                generatorAdapter.push(n);
                generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_NAME);
            } else {
                this.doResolveArgument(generatorAdapter, resolveArgument);
            }
        } else if (annotationName.equals(Any.NAME)) {
            io.micronaut.asm.Type t = io.micronaut.asm.Type.getType(AnyQualifier.class);
            generatorAdapter.getStatic(t, "INSTANCE", t);
        } else {
            String repeatableName = this.visitorContext.getClassElement(annotationName).flatMap(ce -> ce.stringValue(Repeatable.class)).orElse(null);
            resolveArgument.run();
            this.retrieveAnnotationMetadataFromProvider(generatorAdapter);
            if (repeatableName != null) {
                generatorAdapter.push(repeatableName);
                generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_REPEATABLE_ANNOTATION);
            } else {
                generatorAdapter.push(annotationName);
                generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_BY_ANNOTATION);
            }
        }
    }

    private void doResolveArgument(GeneratorAdapter generatorAdapter, Runnable resolveArgument) {
        resolveArgument.run();
        generatorAdapter.invokeStatic(TYPE_QUALIFIERS, METHOD_QUALIFIER_FOR_ARGUMENT);
    }

    private void pushArrayOfClasses(GeneratorAdapter writer, String[] byType) {
        int len = byType.length;
        BeanDefinitionWriter.pushNewArray(writer, Class.class, len);
        for (int i2 = 0; i2 < len; ++i2) {
            String type = byType[i2];
            BeanDefinitionWriter.pushStoreInArray(writer, i2, len, () -> this.pushClass(writer, type));
        }
    }

    private void pushClass(GeneratorAdapter writer, String className) {
        writer.push(io.micronaut.asm.Type.getObjectType(className.replace('.', '/')));
    }

    private void convertToArray(ClassElement arrayType, GeneratorAdapter injectMethodVisitor) {
        injectMethodVisitor.push(0);
        injectMethodVisitor.newArray(JavaModelUtils.getTypeReference(arrayType));
        injectMethodVisitor.invokeInterface(io.micronaut.asm.Type.getType(Collection.class), COLLECTION_TO_ARRAY);
    }

    private void autoApplyNamedIfPresent(Element element, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata.hasAnnotation("javax.inject.Named") || annotationMetadata.hasStereotype("javax.inject.Named")) {
            this.autoApplyNamed(element);
        }
    }

    private void autoApplyNamed(Element element) {
        if (!element.stringValue("javax.inject.Named").isPresent()) {
            element.annotate("javax.inject.Named", (AnnotationValueBuilder<T> builder) -> {
                String n;
                String name = element instanceof ClassElement ? NameUtils.decapitalize(element.getSimpleName()) : (element instanceof MethodElement ? (NameUtils.isGetterName(n = element.getName()) ? NameUtils.getPropertyNameForGetter(n) : n) : element.getName());
                builder.value(name);
            });
        }
    }

    private void visitMethodInjectionPointInternal(MethodVisitData methodVisitData, GeneratorAdapter injectMethodVisitor, int injectInstanceIndex) {
        MethodElement methodElement = methodVisitData.getMethodElement();
        AnnotationMetadata annotationMetadata = methodElement.getAnnotationMetadata();
        List<ParameterElement> argumentTypes = Arrays.asList(methodElement.getParameters());
        this.applyDefaultNamedToParameters(argumentTypes);
        TypedElement declaringType = methodVisitData.beanType;
        String methodName = methodElement.getName();
        boolean requiresReflection = methodVisitData.requiresReflection;
        ClassElement returnType = methodElement.getReturnType();
        DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
        DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, returnType);
        boolean hasArguments = methodElement.hasParameters();
        int argCount = hasArguments ? argumentTypes.size() : 0;
        io.micronaut.asm.Type declaringTypeRef = JavaModelUtils.getTypeReference(declaringType);
        boolean hasInjectScope = false;
        for (ParameterElement value : argumentTypes) {
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value.getAnnotationMetadata());
            DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, value.getGenericType());
            if (!value.hasDeclaredAnnotation(InjectScope.class)) continue;
            hasInjectScope = true;
        }
        if (!requiresReflection) {
            String methodDescriptor;
            injectMethodVisitor.loadLocal(injectInstanceIndex, this.beanType);
            if (hasArguments) {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, argumentTypes);
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i2 = 0; i2 < argCount; ++i2) {
                    ParameterElement entry = argIterator.next();
                    this.pushMethodParameterValue(injectMethodVisitor, i2, entry);
                }
            } else {
                methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(returnType, Collections.emptyList());
            }
            injectMethodVisitor.visitMethodInsn(this.isInterface ? 185 : 182, declaringTypeRef.getInternalName(), methodName, methodDescriptor, this.isInterface);
            if (this.isConfigurationProperties && returnType != PrimitiveElement.VOID) {
                injectMethodVisitor.pop();
            }
        } else {
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentMethodIndex);
            injectMethodVisitor.loadLocal(this.injectInstanceLocalVarIndex, this.beanType);
            if (hasArguments) {
                BeanDefinitionWriter.pushNewArray(injectMethodVisitor, Object.class, argumentTypes.size());
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i3 = 0; i3 < argCount; ++i3) {
                    int finalI = i3;
                    BeanDefinitionWriter.pushStoreInArray(injectMethodVisitor, i3, argumentTypes.size(), () -> {
                        ParameterElement entry = (ParameterElement)argIterator.next();
                        this.pushMethodParameterValue(injectMethodVisitor, finalI, entry);
                        BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(entry.getType(), (MethodVisitor)injectMethodVisitor);
                    });
                }
            } else {
                BeanDefinitionWriter.pushNewArray(injectMethodVisitor, Object.class, 0);
            }
            injectMethodVisitor.invokeVirtual(this.superType, INVOKE_WITH_REFLECTION_METHOD);
        }
        this.destroyInjectScopeBeansIfNecessary(injectMethodVisitor, hasInjectScope);
    }

    private void destroyInjectScopeBeansIfNecessary(GeneratorAdapter injectMethodVisitor, boolean hasInjectScope) {
        if (hasInjectScope) {
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.invokeInterface(io.micronaut.asm.Type.getType(BeanResolutionContext.class), Method.getMethod(ReflectionUtils.getRequiredInternalMethod(BeanResolutionContext.class, "destroyInjectScopedBeans", new Class[0])));
        }
    }

    private void pushMethodParameterValue(GeneratorAdapter injectMethodVisitor, int i2, ParameterElement entry) {
        AnnotationMetadata argMetadata = entry.getAnnotationMetadata();
        if (entry.getGenericType().isAssignable(BeanResolutionContext.class)) {
            injectMethodVisitor.loadArg(0);
        } else if (entry.getGenericType().isAssignable(BeanContext.class)) {
            injectMethodVisitor.loadArg(1);
        } else {
            java.lang.reflect.Method methodToInvoke;
            boolean requiresGenericType = false;
            ClassElement genericType = entry.getGenericType();
            boolean isCollection = genericType.isAssignable(Collection.class);
            boolean isArray = genericType.isArray();
            if (this.isValueType(argMetadata) && !this.isInnerType(entry.getGenericType())) {
                Optional<String> property = argMetadata.stringValue(Property.class, "name");
                if (property.isPresent()) {
                    this.pushInvokeGetPropertyValueForMethod(injectMethodVisitor, i2, entry, property.get());
                } else {
                    Optional<String> valueValue = entry.getAnnotationMetadata().stringValue(Value.class);
                    if (valueValue.isPresent()) {
                        this.pushInvokeGetPropertyPlaceholderValueForMethod(injectMethodVisitor, i2, entry, valueValue.get());
                    }
                }
                return;
            }
            if (isCollection || isArray) {
                ClassElement typeArgument;
                requiresGenericType = true;
                ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
                if (typeArgument != null && !typeArgument.isPrimitive()) {
                    methodToInvoke = typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_METHOD_ARGUMENT : GET_BEANS_OF_TYPE_FOR_METHOD_ARGUMENT;
                } else {
                    methodToInvoke = GET_BEAN_FOR_METHOD_ARGUMENT;
                    requiresGenericType = false;
                }
            } else if (genericType.isAssignable(Stream.class)) {
                requiresGenericType = true;
                methodToInvoke = GET_STREAM_OF_TYPE_FOR_METHOD_ARGUMENT;
            } else if (genericType.isAssignable(Optional.class)) {
                requiresGenericType = true;
                methodToInvoke = FIND_BEAN_FOR_METHOD_ARGUMENT;
            } else if (genericType.isAssignable(BeanRegistration.class)) {
                requiresGenericType = true;
                methodToInvoke = GET_BEAN_REGISTRATION_FOR_METHOD_ARGUMENT;
            } else {
                methodToInvoke = GET_BEAN_FOR_METHOD_ARGUMENT;
            }
            injectMethodVisitor.loadThis();
            injectMethodVisitor.loadArg(0);
            injectMethodVisitor.loadArg(1);
            injectMethodVisitor.push(this.currentMethodIndex);
            injectMethodVisitor.push(i2);
            if (requiresGenericType) {
                this.resolveMethodArgumentGenericType(injectMethodVisitor, genericType, this.currentMethodIndex, i2);
            }
            this.pushQualifier(injectMethodVisitor, entry, () -> this.resolveMethodArgument(injectMethodVisitor, this.currentMethodIndex, i2));
            this.pushInvokeMethodOnSuperClass(injectMethodVisitor, methodToInvoke);
            if (isArray && requiresGenericType) {
                this.convertToArray(genericType.fromArray(), injectMethodVisitor);
            }
            BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
        }
    }

    private void pushInvokeGetPropertyValueForMethod(GeneratorAdapter injectMethodVisitor, int i2, ParameterElement entry, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(this.currentMethodIndex);
        injectMethodVisitor.push(i2);
        injectMethodVisitor.push(value);
        injectMethodVisitor.push(this.getCliPrefix(entry.getName()));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_VALUE_FOR_METHOD_ARGUMENT);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetPropertyPlaceholderValueForMethod(GeneratorAdapter injectMethodVisitor, int i2, ParameterElement entry, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(this.currentMethodIndex);
        injectMethodVisitor.push(i2);
        injectMethodVisitor.push(value);
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_PLACEHOLDER_VALUE_FOR_METHOD_ARGUMENT);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetPropertyValueForSetter(GeneratorAdapter injectMethodVisitor, String setterName, ParameterElement entry, String value) {
        AnnotationMetadata annotationMetadata;
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(setterName);
        if (entry.getAnnotationMetadata() instanceof MutableAnnotationMetadata) {
            annotationMetadata = ((MutableAnnotationMetadata)entry.getAnnotationMetadata()).clone();
            this.removeAnnotations(annotationMetadata, PropertySource.class.getName(), Property.class.getName());
        } else {
            annotationMetadata = entry.getAnnotationMetadata();
        }
        if (this.keepConfPropInjectPoints) {
            this.resolveMethodArgument(injectMethodVisitor, this.currentMethodIndex, 0);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, entry.getName(), entry.getGenericType(), annotationMetadata, entry.getGenericType().getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(value);
        injectMethodVisitor.push(this.getCliPrefix(entry.getName()));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_VALUE_FOR_SETTER);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetBeanForSetter(GeneratorAdapter injectMethodVisitor, String setterName, ParameterElement entry) {
        AnnotationMetadata annotationMetadata;
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(setterName);
        if (entry.getAnnotationMetadata() instanceof MutableAnnotationMetadata) {
            annotationMetadata = ((MutableAnnotationMetadata)entry.getAnnotationMetadata()).clone();
            this.removeAnnotations(annotationMetadata, PropertySource.class.getName(), Property.class.getName());
        } else {
            annotationMetadata = entry.getAnnotationMetadata();
        }
        if (this.keepConfPropInjectPoints) {
            this.resolveMethodArgument(injectMethodVisitor, this.currentMethodIndex, 0);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, entry.getName(), entry.getGenericType(), annotationMetadata, entry.getGenericType().getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        this.pushQualifier(injectMethodVisitor, entry.getGenericType(), injectMethodVisitor::dup);
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_BEAN_FOR_SETTER);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetBeansOfTypeForSetter(GeneratorAdapter injectMethodVisitor, String setterName, ParameterElement entry) {
        AnnotationMetadata annotationMetadata;
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(setterName);
        if (entry.getAnnotationMetadata() instanceof MutableAnnotationMetadata) {
            annotationMetadata = ((MutableAnnotationMetadata)entry.getAnnotationMetadata()).clone();
            this.removeAnnotations(annotationMetadata, PropertySource.class.getName(), Property.class.getName());
        } else {
            annotationMetadata = entry.getAnnotationMetadata();
        }
        ClassElement genericType = entry.getGenericType();
        if (this.keepConfPropInjectPoints) {
            this.resolveMethodArgument(injectMethodVisitor, this.currentMethodIndex, 0);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, entry.getName(), genericType, annotationMetadata, genericType.getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        int thisArgument = injectMethodVisitor.newLocal(io.micronaut.asm.Type.getType(Argument.class));
        injectMethodVisitor.storeLocal(thisArgument);
        injectMethodVisitor.loadLocal(thisArgument);
        if (!this.resolveArgumentGenericType(injectMethodVisitor, genericType)) {
            injectMethodVisitor.loadLocal(thisArgument);
            this.resolveFirstTypeArgument(injectMethodVisitor);
            this.resolveInnerTypeArgumentIfNeeded(injectMethodVisitor, genericType);
        } else {
            injectMethodVisitor.push((String)null);
        }
        this.pushQualifier(injectMethodVisitor, genericType, () -> injectMethodVisitor.loadLocal(thisArgument));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_BEANS_OF_TYPE_FOR_SETTER);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetPropertyPlaceholderValueForSetter(GeneratorAdapter injectMethodVisitor, String setterName, ParameterElement entry, String value) {
        AnnotationMetadata annotationMetadata;
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(setterName);
        if (entry.getAnnotationMetadata() instanceof MutableAnnotationMetadata) {
            annotationMetadata = ((MutableAnnotationMetadata)entry.getAnnotationMetadata()).clone();
            this.removeAnnotations(annotationMetadata, PropertySource.class.getName(), Property.class.getName());
        } else {
            annotationMetadata = entry.getAnnotationMetadata();
        }
        if (this.keepConfPropInjectPoints) {
            this.resolveMethodArgument(injectMethodVisitor, this.currentMethodIndex, 0);
        } else {
            BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, injectMethodVisitor, entry.getName(), entry.getGenericType(), annotationMetadata, entry.getGenericType().getTypeArguments(), new HashMap<String, Integer>(), this.loadTypeMethods);
        }
        injectMethodVisitor.push(value);
        injectMethodVisitor.push(this.getCliPrefix(entry.getName()));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_PLACEHOLDER_VALUE_FOR_SETTER);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void removeAnnotations(AnnotationMetadata annotationMetadata, String ... annotationNames) {
        if (annotationMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
            for (String annotation : annotationNames) {
                mutableAnnotationMetadata.removeAnnotation(annotation);
            }
        }
    }

    private void applyDefaultNamedToParameters(List<ParameterElement> argumentTypes) {
        for (ParameterElement parameterElement : argumentTypes) {
            AnnotationMetadata annotationMetadata = parameterElement.getAnnotationMetadata();
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, annotationMetadata);
            DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, parameterElement.getGenericType());
            this.autoApplyNamedIfPresent(parameterElement, annotationMetadata);
        }
    }

    private void pushInvokeMethodOnSuperClass(MethodVisitor constructorVisitor, java.lang.reflect.Method methodToInvoke) {
        constructorVisitor.visitMethodInsn(183, this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName(), methodToInvoke.getName(), io.micronaut.asm.Type.getMethodDescriptor(methodToInvoke), false);
    }

    private void visitCheckIfShouldLoadMethodDefinition() {
        String desc = BeanDefinitionWriter.getMethodDescriptor("void", BeanResolutionContext.class.getName(), BeanContext.class.getName());
        this.checkIfShouldLoadMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(4, "checkIfShouldLoad", desc, null, null), 4, "checkIfShouldLoad", desc);
    }

    private void visitInjectMethodDefinition() {
        if (!this.isPrimitiveBean && !this.superBeanDefinition && this.injectMethodVisitor == null) {
            String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
            GeneratorAdapter injectMethodVisitor = this.injectMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(4, "injectBean", desc, null, null), 4, "injectBean", desc);
            if (this.isConfigurationProperties) {
                injectMethodVisitor.loadThis();
                injectMethodVisitor.loadArg(0);
                injectMethodVisitor.loadArg(1);
                injectMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod(CONTAINS_PROPERTIES_METHOD));
                injectMethodVisitor.push(false);
                this.injectEnd = new Label();
                injectMethodVisitor.ifCmp(io.micronaut.asm.Type.BOOLEAN_TYPE, 153, this.injectEnd);
                injectMethodVisitor.visitLabel(new Label());
            }
            injectMethodVisitor.loadArg(2);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, this.beanType);
            this.injectInstanceLocalVarIndex = injectMethodVisitor.newLocal(this.beanType);
            injectMethodVisitor.storeLocal(this.injectInstanceLocalVarIndex);
        }
    }

    private void visitPostConstructMethodDefinition(boolean intercepted) {
        if (!this.postConstructAdded) {
            String lifeCycleMethodName = "initialize";
            if (!this.superBeanDefinition || intercepted) {
                GeneratorAdapter postConstructMethodVisitor;
                this.interfaceTypes.add(InitializingBeanDefinition.class);
                this.postConstructMethodVisitor = postConstructMethodVisitor = this.newLifeCycleMethod("initialize");
                postConstructMethodVisitor.loadArg(2);
                BeanDefinitionWriter.pushCastToType((MethodVisitor)postConstructMethodVisitor, this.beanType);
                this.postConstructInstanceLocalVarIndex = postConstructMethodVisitor.newLocal(this.beanType);
                postConstructMethodVisitor.storeLocal(this.postConstructInstanceLocalVarIndex);
                this.invokeSuperInjectMethod(postConstructMethodVisitor, POST_CONSTRUCT_METHOD);
            }
            if (intercepted) {
                this.writeInterceptedLifecycleMethod("initialize", "initialize", this.buildMethodVisitor, this.buildInstanceLocalVarIndex);
            } else {
                this.pushBeanDefinitionMethodInvocation(this.buildMethodVisitor, "initialize");
            }
            BeanDefinitionWriter.pushCastToType((MethodVisitor)this.buildMethodVisitor, this.beanType);
            this.buildMethodVisitor.loadLocal(this.buildInstanceLocalVarIndex);
            this.postConstructAdded = true;
        }
    }

    private void writeInterceptedLifecycleMethod(String lifeCycleMethodName, String dispatchMethodName, GeneratorAdapter targetMethodVisitor, int instanceLocalIndex) {
        InnerClassDef postConstructInnerMethod = this.newInnerClass(AbstractExecutableMethod.class);
        ClassWriter postConstructInnerWriter = postConstructInnerMethod.innerClassWriter;
        io.micronaut.asm.Type postConstructInnerClassType = postConstructInnerMethod.innerClassType;
        String fieldBeanDef = "$beanDef";
        String fieldResContext = "$resolutionContext";
        String fieldBeanContext = "$beanContext";
        String fieldBean = "$bean";
        this.newFinalField(postConstructInnerWriter, this.beanDefinitionType, "$beanDef");
        this.newFinalField(postConstructInnerWriter, TYPE_RESOLUTION_CONTEXT, "$resolutionContext");
        this.newFinalField(postConstructInnerWriter, TYPE_BEAN_CONTEXT, "$beanContext");
        this.newFinalField(postConstructInnerWriter, this.beanType, "$bean");
        String constructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(new io.micronaut.asm.Type[]{this.beanDefinitionType, TYPE_RESOLUTION_CONTEXT, TYPE_BEAN_CONTEXT, this.beanType});
        GeneratorAdapter protectedConstructor = new GeneratorAdapter(postConstructInnerWriter.visitMethod(4, "<init>", constructorDescriptor, null, null), 4, "<init>", constructorDescriptor);
        protectedConstructor.loadThis();
        protectedConstructor.loadArg(0);
        protectedConstructor.putField(postConstructInnerClassType, "$beanDef", this.beanDefinitionType);
        protectedConstructor.loadThis();
        protectedConstructor.loadArg(1);
        protectedConstructor.putField(postConstructInnerClassType, "$resolutionContext", TYPE_RESOLUTION_CONTEXT);
        protectedConstructor.loadThis();
        protectedConstructor.loadArg(2);
        protectedConstructor.putField(postConstructInnerClassType, "$beanContext", TYPE_BEAN_CONTEXT);
        protectedConstructor.loadThis();
        protectedConstructor.loadArg(3);
        protectedConstructor.putField(postConstructInnerClassType, "$bean", this.beanType);
        protectedConstructor.loadThis();
        protectedConstructor.push(this.beanType);
        protectedConstructor.push(lifeCycleMethodName);
        this.invokeConstructor(protectedConstructor, AbstractExecutableMethod.class, Class.class, String.class);
        protectedConstructor.returnValue();
        protectedConstructor.visitMaxs(1, 1);
        protectedConstructor.visitEnd();
        GeneratorAdapter getAnnotationMetadata = this.startPublicFinalMethodZeroArgs(postConstructInnerWriter, AnnotationMetadata.class, "getAnnotationMetadata");
        this.lookupReferenceAnnotationMetadata(getAnnotationMetadata);
        GeneratorAdapter invokeMethod = this.startPublicMethod(postConstructInnerWriter, ExecutableMethodWriter.METHOD_INVOKE_INTERNAL);
        invokeMethod.loadThis();
        invokeMethod.getField(postConstructInnerClassType, "$beanDef", this.beanDefinitionType);
        invokeMethod.loadThis();
        invokeMethod.getField(postConstructInnerClassType, "$resolutionContext", TYPE_RESOLUTION_CONTEXT);
        invokeMethod.loadThis();
        invokeMethod.getField(postConstructInnerClassType, "$beanContext", TYPE_BEAN_CONTEXT);
        invokeMethod.loadThis();
        invokeMethod.getField(postConstructInnerClassType, "$bean", this.beanType);
        invokeMethod.visitMethodInsn(182, this.beanDefinitionInternalName, lifeCycleMethodName, METHOD_DESCRIPTOR_INITIALIZE, false);
        invokeMethod.returnValue();
        invokeMethod.visitMaxs(1, 1);
        invokeMethod.visitEnd();
        targetMethodVisitor.visitTypeInsn(187, postConstructInnerMethod.constructorInternalName);
        targetMethodVisitor.visitInsn(89);
        targetMethodVisitor.loadThis();
        targetMethodVisitor.loadArg(0);
        targetMethodVisitor.loadArg(1);
        targetMethodVisitor.loadLocal(instanceLocalIndex);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)targetMethodVisitor, this.beanType);
        targetMethodVisitor.visitMethodInsn(183, postConstructInnerMethod.constructorInternalName, "<init>", constructorDescriptor, false);
        int executableInstanceIndex = targetMethodVisitor.newLocal(io.micronaut.asm.Type.getType(ExecutableMethod.class));
        targetMethodVisitor.storeLocal(executableInstanceIndex);
        targetMethodVisitor.loadArg(0);
        targetMethodVisitor.loadArg(1);
        targetMethodVisitor.loadThis();
        targetMethodVisitor.loadLocal(executableInstanceIndex);
        targetMethodVisitor.loadLocal(instanceLocalIndex);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)targetMethodVisitor, this.beanType);
        targetMethodVisitor.visitMethodInsn(184, "io/micronaut/aop/chain/MethodInterceptorChain", dispatchMethodName, METHOD_DESCRIPTOR_INTERCEPTED_LIFECYCLE, false);
        targetMethodVisitor.loadLocal(instanceLocalIndex);
    }

    private void visitPreDestroyMethodDefinition(boolean intercepted) {
        if (this.preDestroyMethodVisitor == null) {
            GeneratorAdapter preDestroyMethodVisitor;
            this.interfaceTypes.add(DisposableBeanDefinition.class);
            if (intercepted) {
                preDestroyMethodVisitor = this.newLifeCycleMethod("doDispose");
                GeneratorAdapter disposeMethod = this.newLifeCycleMethod("dispose");
                disposeMethod.loadArg(2);
                int instanceLocalIndex = disposeMethod.newLocal(this.beanType);
                disposeMethod.storeLocal(instanceLocalIndex);
                this.writeInterceptedLifecycleMethod("doDispose", "dispose", disposeMethod, instanceLocalIndex);
                disposeMethod.returnValue();
                this.interceptedDisposeMethod = disposeMethod;
            } else {
                preDestroyMethodVisitor = this.newLifeCycleMethod("dispose");
            }
            this.preDestroyMethodVisitor = preDestroyMethodVisitor;
            preDestroyMethodVisitor.loadArg(2);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)preDestroyMethodVisitor, this.beanType);
            this.preDestroyInstanceLocalVarIndex = preDestroyMethodVisitor.newLocal(this.beanType);
            preDestroyMethodVisitor.storeLocal(this.preDestroyInstanceLocalVarIndex);
            this.invokeSuperInjectMethod(preDestroyMethodVisitor, PRE_DESTROY_METHOD);
        }
    }

    private GeneratorAdapter newLifeCycleMethod(String methodName) {
        String desc = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), Object.class.getName());
        return new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, desc, BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.beanFullClassName), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(this.beanFullClassName)), null), 1, methodName, desc);
    }

    private void invokeSuperInjectMethod(GeneratorAdapter methodVisitor, java.lang.reflect.Method methodToInvoke) {
        methodVisitor.loadThis();
        methodVisitor.loadArg(0);
        methodVisitor.loadArg(1);
        methodVisitor.loadArg(2);
        this.pushInvokeMethodOnSuperClass(methodVisitor, methodToInvoke);
    }

    private void visitBuildFactoryMethodDefinition(ClassElement factoryClass, Element factoryElement, ParameterElement ... parameters) {
        if (this.buildMethodVisitor == null) {
            List<ParameterElement> parameterList = Arrays.asList(parameters);
            boolean isParametrized = this.isParametrized(parameters);
            boolean isIntercepted = this.isConstructorIntercepted(factoryElement);
            io.micronaut.asm.Type factoryType = JavaModelUtils.getTypeReference(factoryClass);
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            int factoryVar = -1;
            if (!factoryElement.isStatic()) {
                factoryVar = this.pushGetFactoryBean(factoryClass, factoryType, buildMethodVisitor);
            }
            String methodDescriptor = BeanDefinitionWriter.getMethodDescriptorForReturnType(this.beanType, parameterList);
            boolean hasInjectScope = false;
            if (isIntercepted) {
                int constructorIndex = this.initInterceptedConstructorWriter(buildMethodVisitor, parameterList, new FactoryMethodDef(factoryType, factoryElement, methodDescriptor, factoryVar));
                int parametersIndex = this.createParameterArray(parameterList, buildMethodVisitor);
                this.invokeConstructorChain(buildMethodVisitor, constructorIndex, parametersIndex, parameterList);
            } else if (factoryElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)factoryElement;
                if (!methodElement.isReflectionRequired() && !parameterList.isEmpty()) {
                    hasInjectScope = this.pushConstructorArguments(buildMethodVisitor, parameters);
                }
                if (methodElement.isReflectionRequired()) {
                    if (methodElement.isStatic()) {
                        buildMethodVisitor.push((String)null);
                    }
                    DispatchWriter.pushTypeUtilsGetRequiredMethod(buildMethodVisitor, factoryType, methodElement);
                    buildMethodVisitor.dup();
                    buildMethodVisitor.push(true);
                    buildMethodVisitor.invokeVirtual(io.micronaut.asm.Type.getType(java.lang.reflect.Method.class), Method.getMethod(ReflectionUtils.getRequiredMethod(java.lang.reflect.Method.class, "setAccessible", Boolean.TYPE)));
                    hasInjectScope = this.pushParametersAsArray(buildMethodVisitor, parameters);
                    buildMethodVisitor.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_INVOKE_METHOD);
                    if (methodElement.isReflectionRequired() && this.isPrimitiveBean) {
                        BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
                    }
                } else if (methodElement.isStatic()) {
                    buildMethodVisitor.invokeStatic(factoryType, new Method(factoryElement.getName(), methodDescriptor));
                } else {
                    buildMethodVisitor.invokeVirtual(factoryType, new Method(factoryElement.getName(), methodDescriptor));
                }
            } else {
                FieldElement fieldElement = (FieldElement)factoryElement;
                if (fieldElement.isReflectionRequired()) {
                    if (!fieldElement.isStatic()) {
                        buildMethodVisitor.storeLocal(factoryVar);
                    }
                    buildMethodVisitor.push(factoryType);
                    buildMethodVisitor.push(fieldElement.getName());
                    if (fieldElement.isStatic()) {
                        buildMethodVisitor.push((String)null);
                    } else {
                        buildMethodVisitor.loadLocal(factoryVar);
                    }
                    buildMethodVisitor.invokeStatic(TYPE_REFLECTION_UTILS, GET_FIELD_WITH_REFLECTION_METHOD);
                    if (fieldElement.isReflectionRequired() && this.isPrimitiveBean) {
                        BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
                    }
                } else if (fieldElement.isStatic()) {
                    buildMethodVisitor.getStatic(factoryType, factoryElement.getName(), this.beanType);
                } else {
                    buildMethodVisitor.getField(factoryType, factoryElement.getName(), this.beanType);
                }
            }
            this.buildInstanceLocalVarIndex = buildMethodVisitor.newLocal(this.beanType);
            buildMethodVisitor.storeLocal(this.buildInstanceLocalVarIndex, this.beanType);
            if (!this.isPrimitiveBean) {
                this.pushBeanDefinitionMethodInvocation(buildMethodVisitor, "injectBean");
                BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
                buildMethodVisitor.storeLocal(this.buildInstanceLocalVarIndex);
            }
            this.destroyInjectScopeBeansIfNecessary(buildMethodVisitor, hasInjectScope);
            buildMethodVisitor.loadLocal(this.buildInstanceLocalVarIndex, this.beanType);
            this.initLifeCycleMethodsIfNecessary();
        }
    }

    private int pushGetFactoryBean(ClassElement factoryClass, io.micronaut.asm.Type factoryType, GeneratorAdapter buildMethodVisitor) {
        this.invokeCheckIfShouldLoadIfNecessary(buildMethodVisitor);
        buildMethodVisitor.loadArg(1);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, DefaultBeanContext.class);
        buildMethodVisitor.loadArg(0);
        buildMethodVisitor.push(factoryType);
        this.pushQualifier(buildMethodVisitor, factoryClass, () -> {
            buildMethodVisitor.push(factoryType);
            buildMethodVisitor.push("factory");
            BeanDefinitionWriter.invokeInterfaceStaticMethod(buildMethodVisitor, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
        });
        buildMethodVisitor.invokeVirtual(io.micronaut.asm.Type.getType(DefaultBeanContext.class), Method.getMethod(METHOD_GET_BEAN));
        int factoryVar = buildMethodVisitor.newLocal(factoryType);
        buildMethodVisitor.storeLocal(factoryVar, factoryType);
        buildMethodVisitor.loadArg(0);
        buildMethodVisitor.invokeInterface(TYPE_RESOLUTION_CONTEXT, METHOD_BEAN_RESOLUTION_CONTEXT_MARK_FACTORY);
        buildMethodVisitor.loadLocal(factoryVar);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, factoryClass);
        return factoryVar;
    }

    private void visitBuildMethodDefinition(MethodElement constructor, boolean requiresReflection) {
        if (this.buildMethodVisitor == null) {
            boolean isIntercepted = this.isConstructorIntercepted(constructor);
            ParameterElement[] parameterArray = constructor.getParameters();
            List<ParameterElement> parameters = Arrays.asList(parameterArray);
            boolean isParametrized = this.isParametrized(parameterArray);
            this.defineBuilderMethod(isParametrized);
            GeneratorAdapter buildMethodVisitor = this.buildMethodVisitor;
            this.invokeCheckIfShouldLoadIfNecessary(buildMethodVisitor);
            if (isIntercepted) {
                int constructorIndex = this.initInterceptedConstructorWriter(buildMethodVisitor, parameters, null);
                int parametersIndex = this.createParameterArray(parameters, buildMethodVisitor);
                this.invokeConstructorChain(buildMethodVisitor, constructorIndex, parametersIndex, parameters);
            } else if (constructor.isStatic()) {
                this.pushConstructorArguments(buildMethodVisitor, parameterArray);
                String methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(constructor.getReturnType(), parameters);
                buildMethodVisitor.invokeStatic(BeanDefinitionWriter.getTypeReference(constructor.getDeclaringType()), new Method(constructor.getName(), methodDescriptor));
            } else if (requiresReflection) {
                int parameterArrayLocalVarIndex = this.createParameterArray(parameters, buildMethodVisitor);
                int parameterTypeArrayLocalVarIndex = this.createParameterTypeArray(parameters, buildMethodVisitor);
                buildMethodVisitor.push(this.beanType);
                buildMethodVisitor.loadLocal(parameterTypeArrayLocalVarIndex);
                buildMethodVisitor.loadLocal(parameterArrayLocalVarIndex);
                buildMethodVisitor.invokeStatic(io.micronaut.asm.Type.getType(InstantiationUtils.class), Method.getMethod(ReflectionUtils.getRequiredInternalMethod(InstantiationUtils.class, "instantiate", Class.class, Class[].class, Object[].class)));
                BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
            } else {
                buildMethodVisitor.newInstance(this.beanType);
                buildMethodVisitor.dup();
                this.pushConstructorArguments(buildMethodVisitor, parameterArray);
                String constructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(parameters);
                buildMethodVisitor.invokeConstructor(this.beanType, new Method("<init>", constructorDescriptor));
            }
            this.buildInstanceLocalVarIndex = buildMethodVisitor.newLocal(this.beanType);
            buildMethodVisitor.storeLocal(this.buildInstanceLocalVarIndex);
            this.pushBeanDefinitionMethodInvocation(buildMethodVisitor, "injectBean");
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, this.beanType);
            buildMethodVisitor.storeLocal(this.buildInstanceLocalVarIndex);
            buildMethodVisitor.loadLocal(this.buildInstanceLocalVarIndex);
            this.initLifeCycleMethodsIfNecessary();
            BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(this.beanType, (MethodVisitor)buildMethodVisitor);
        }
    }

    private void invokeCheckIfShouldLoadIfNecessary(GeneratorAdapter buildMethodVisitor) {
        AnnotationValue<Requires> requiresAnnotation = this.annotationMetadata.getAnnotation(Requires.class);
        if (requiresAnnotation != null && requiresAnnotation.stringValue("bean").isPresent() && requiresAnnotation.stringValue("beanProperty").isPresent()) {
            this.visitCheckIfShouldLoadMethodDefinition();
            buildMethodVisitor.loadThis();
            buildMethodVisitor.loadArg(0);
            buildMethodVisitor.loadArg(1);
            buildMethodVisitor.invokeVirtual(this.beanDefinitionType, Method.getMethod(ReflectionUtils.getRequiredMethod(AbstractInitializableBeanDefinition.class, "checkIfShouldLoad", BeanResolutionContext.class, BeanContext.class)));
        }
    }

    private void initLifeCycleMethodsIfNecessary() {
        if (this.isInterceptedLifeCycleByType(this.annotationMetadata, "POST_CONSTRUCT")) {
            this.visitPostConstructMethodDefinition(true);
        }
        if (!this.superBeanDefinition && this.isInterceptedLifeCycleByType(this.annotationMetadata, "PRE_DESTROY")) {
            this.visitPreDestroyMethodDefinition(true);
        }
    }

    private void invokeConstructorChain(GeneratorAdapter generatorAdapter, int constructorLocalIndex, int parametersLocalIndex, List<ParameterElement> parameters) {
        generatorAdapter.loadArg(0);
        generatorAdapter.loadArg(1);
        if (StringUtils.isNotEmpty(this.interceptedType)) {
            generatorAdapter.loadLocal(parametersLocalIndex);
            generatorAdapter.push(parameters.size() - 1);
            generatorAdapter.arrayLoad(TYPE_OBJECT);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)generatorAdapter, List.class);
        } else {
            generatorAdapter.visitInsn(1);
        }
        generatorAdapter.loadThis();
        generatorAdapter.loadLocal(constructorLocalIndex);
        if (this.getInterceptedType().isPresent()) {
            generatorAdapter.push(4);
        } else {
            generatorAdapter.push(0);
        }
        generatorAdapter.loadLocal(parametersLocalIndex);
        generatorAdapter.visitMethodInsn(184, "io/micronaut/aop/chain/ConstructorInterceptorChain", "instantiate", METHOD_DESCRIPTOR_CONSTRUCTOR_INSTANTIATE, false);
    }

    private int initInterceptedConstructorWriter(GeneratorAdapter buildMethodVisitor, List<ParameterElement> parameters, @Nullable FactoryMethodDef factoryMethodDef) {
        GeneratorAdapter protectedConstructor;
        String interceptedConstructorDescriptor;
        InnerClassDef constructorInjectionPointInnerClass = this.newInnerClass(AbstractConstructorInjectionPoint.class);
        ClassWriter interceptedConstructorWriter = constructorInjectionPointInnerClass.innerClassWriter;
        Method constructorMethod = Method.getMethod(CONSTRUCTOR_ABSTRACT_CONSTRUCTOR_IP);
        boolean hasFactoryMethod = factoryMethodDef != null;
        io.micronaut.asm.Type factoryType = hasFactoryMethod ? factoryMethodDef.factoryType : null;
        String factoryFieldName = "$factory";
        if (hasFactoryMethod) {
            this.newFinalField(interceptedConstructorWriter, factoryType, "$factory");
            interceptedConstructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(new io.micronaut.asm.Type[]{TYPE_BEAN_DEFINITION, factoryType});
            protectedConstructor = new GeneratorAdapter(interceptedConstructorWriter.visitMethod(4, "<init>", interceptedConstructorDescriptor, null, null), 4, "<init>", interceptedConstructorDescriptor);
        } else {
            interceptedConstructorDescriptor = constructorMethod.getDescriptor();
            protectedConstructor = new GeneratorAdapter(interceptedConstructorWriter.visitMethod(4, "<init>", interceptedConstructorDescriptor, null, null), 4, "<init>", interceptedConstructorDescriptor);
        }
        if (hasFactoryMethod) {
            protectedConstructor.loadThis();
            protectedConstructor.loadArg(1);
            protectedConstructor.putField(constructorInjectionPointInnerClass.innerClassType, "$factory", factoryType);
        }
        protectedConstructor.loadThis();
        protectedConstructor.loadArg(0);
        protectedConstructor.invokeConstructor(io.micronaut.asm.Type.getType(AbstractConstructorInjectionPoint.class), constructorMethod);
        protectedConstructor.returnValue();
        protectedConstructor.visitMaxs(1, 1);
        protectedConstructor.visitEnd();
        GeneratorAdapter invokeMethod = this.startPublicMethod(interceptedConstructorWriter, METHOD_INVOKE_CONSTRUCTOR);
        if (hasFactoryMethod) {
            invokeMethod.loadThis();
            invokeMethod.getField(constructorInjectionPointInnerClass.innerClassType, "$factory", factoryType);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)invokeMethod, factoryType);
        } else {
            invokeMethod.visitTypeInsn(187, this.beanType.getInternalName());
            invokeMethod.visitInsn(89);
        }
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            invokeMethod.loadArg(0);
            invokeMethod.push(i2);
            invokeMethod.arrayLoad(TYPE_OBJECT);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)invokeMethod, parameters.get(i2));
        }
        if (hasFactoryMethod) {
            if (factoryMethodDef.factoryMethod instanceof MethodElement) {
                invokeMethod.visitMethodInsn(182, factoryType.getInternalName(), factoryMethodDef.factoryMethod.getName(), factoryMethodDef.methodDescriptor, false);
            } else {
                invokeMethod.getField(factoryType, factoryMethodDef.factoryMethod.getName(), this.beanType);
            }
        } else {
            String constructorDescriptor = BeanDefinitionWriter.getConstructorDescriptor(parameters);
            invokeMethod.visitMethodInsn(183, this.beanType.getInternalName(), "<init>", constructorDescriptor, false);
        }
        invokeMethod.returnValue();
        invokeMethod.visitMaxs(1, 1);
        invokeMethod.visitEnd();
        buildMethodVisitor.visitTypeInsn(187, constructorInjectionPointInnerClass.constructorInternalName);
        buildMethodVisitor.visitInsn(89);
        buildMethodVisitor.loadThis();
        if (hasFactoryMethod) {
            buildMethodVisitor.loadLocal(factoryMethodDef.factoryVar);
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, factoryType);
        }
        buildMethodVisitor.visitMethodInsn(183, constructorInjectionPointInnerClass.constructorInternalName, "<init>", interceptedConstructorDescriptor, false);
        int constructorIndex = buildMethodVisitor.newLocal(io.micronaut.asm.Type.getType(AbstractConstructorInjectionPoint.class));
        buildMethodVisitor.storeLocal(constructorIndex);
        return constructorIndex;
    }

    private void newFinalField(ClassWriter classWriter, io.micronaut.asm.Type fieldType, String fieldName) {
        classWriter.visitField(18, fieldName, fieldType.getDescriptor(), null, null);
    }

    private InnerClassDef newInnerClass(Class<?> superType) {
        ClassWriter interceptedConstructorWriter = new ClassWriter(3);
        String interceptedConstructorWriterName = this.newInnerClassName();
        this.innerClasses.put(interceptedConstructorWriterName, interceptedConstructorWriter);
        String constructorInternalName = BeanDefinitionWriter.getInternalName(interceptedConstructorWriterName);
        io.micronaut.asm.Type interceptedConstructorType = BeanDefinitionWriter.getTypeReferenceForName(interceptedConstructorWriterName, new String[0]);
        interceptedConstructorWriter.visit(52, 4114, constructorInternalName, null, io.micronaut.asm.Type.getInternalName(superType), null);
        interceptedConstructorWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        interceptedConstructorWriter.visitOuterClass(this.beanDefinitionInternalName, null, null);
        this.classWriter.visitInnerClass(constructorInternalName, this.beanDefinitionInternalName, null, 2);
        return new InnerClassDef(interceptedConstructorWriterName, interceptedConstructorWriter, constructorInternalName, interceptedConstructorType);
    }

    @NonNull
    private String newInnerClassName() {
        return this.beanDefinitionName + "$" + ++this.innerClassIndex;
    }

    private int createParameterTypeArray(List<ParameterElement> parameters, GeneratorAdapter buildMethodVisitor) {
        int pLen = parameters.size();
        BeanDefinitionWriter.pushNewArray(buildMethodVisitor, Class.class, pLen);
        for (int i2 = 0; i2 < pLen; ++i2) {
            ParameterElement parameter = parameters.get(i2);
            BeanDefinitionWriter.pushStoreInArray(buildMethodVisitor, i2, pLen, () -> buildMethodVisitor.push(BeanDefinitionWriter.getTypeReference(parameter)));
        }
        int local = buildMethodVisitor.newLocal(io.micronaut.asm.Type.getType(Object[].class));
        buildMethodVisitor.storeLocal(local);
        return local;
    }

    private int createParameterArray(List<ParameterElement> parameters, GeneratorAdapter buildMethodVisitor) {
        int pLen = parameters.size();
        BeanDefinitionWriter.pushNewArray(buildMethodVisitor, Object.class, pLen);
        for (int i2 = 0; i2 < pLen; ++i2) {
            ParameterElement parameter = parameters.get(i2);
            int parameterIndex = i2;
            BeanDefinitionWriter.pushStoreInArray(buildMethodVisitor, i2, pLen, () -> this.pushConstructorArgument(buildMethodVisitor, parameter.getName(), parameter, parameter.getAnnotationMetadata(), parameterIndex, false));
        }
        int local = buildMethodVisitor.newLocal(io.micronaut.asm.Type.getType(Object[].class));
        buildMethodVisitor.storeLocal(local);
        return local;
    }

    private boolean isConstructorIntercepted(Element constructor) {
        AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(this.annotationMetadata, constructor.getAnnotationMetadata());
        String interceptType = "AROUND_CONSTRUCT";
        return this.isInterceptedLifeCycleByType(annotationMetadata, "AROUND_CONSTRUCT");
    }

    private boolean isInterceptedLifeCycleByType(AnnotationMetadata annotationMetadata, String interceptType) {
        return this.isLifeCycleCache.computeIfAbsent(interceptType, s -> {
            boolean hasAroundConstruct;
            List<Object> interceptorBindingAnnotations;
            if (this.beanTypeElement.isAssignable("io.micronaut.aop.Interceptor")) {
                return false;
            }
            Element originatingElement = this.getOriginatingElements()[0];
            boolean isFactoryMethod = originatingElement instanceof MethodElement && !(originatingElement instanceof ConstructorElement);
            boolean isProxyTarget = annotationMetadata.booleanValue("io.micronaut.aop.Around", "proxyTarget").orElse(false) != false || isFactoryMethod;
            boolean isAopType = StringUtils.isNotEmpty(this.interceptedType);
            boolean isConstructorInterceptionCandidate = isProxyTarget && !isAopType || isAopType && !isProxyTarget;
            AnnotationValue interceptorBindings = annotationMetadata.getAnnotation("io.micronaut.aop.InterceptorBindingDefinitions");
            if (interceptorBindings != null) {
                interceptorBindingAnnotations = interceptorBindings.getAnnotations("value");
                hasAroundConstruct = interceptorBindingAnnotations.stream().anyMatch(av -> av.stringValue("kind").map(k -> k.equals(interceptType)).orElse(false));
            } else {
                interceptorBindingAnnotations = Collections.emptyList();
                hasAroundConstruct = false;
            }
            if (isConstructorInterceptionCandidate) {
                return hasAroundConstruct;
            }
            if (hasAroundConstruct) {
                AnnotationMetadata typeMetadata = annotationMetadata;
                if (!this.isSuperFactory && typeMetadata instanceof AnnotationMetadataHierarchy) {
                    AnnotationValue av2 = (typeMetadata = ((AnnotationMetadataHierarchy)typeMetadata).getRootMetadata()).getAnnotation("io.micronaut.aop.InterceptorBindingDefinitions");
                    interceptorBindingAnnotations = av2 != null ? av2.getAnnotations("value") : Collections.emptyList();
                }
                return interceptorBindingAnnotations.stream().noneMatch(av -> av.stringValue("kind").map(k -> k.equals("AROUND")).orElse(false));
            }
            return false;
        });
    }

    private boolean pushConstructorArguments(GeneratorAdapter buildMethodVisitor, ParameterElement[] parameters) {
        int size = parameters.length;
        boolean hasInjectScope = false;
        if (size > 0) {
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                ParameterElement parameter = parameters[i2];
                this.pushConstructorArgument(buildMethodVisitor, parameter.getName(), parameter, parameter.getAnnotationMetadata(), i2, false);
                if (!parameter.hasDeclaredAnnotation(InjectScope.class)) continue;
                hasInjectScope = true;
            }
        }
        return hasInjectScope;
    }

    private boolean pushParametersAsArray(GeneratorAdapter buildMethodVisitor, ParameterElement[] parameters) {
        int pLen = parameters.length;
        boolean hasInjectScope = false;
        BeanDefinitionWriter.pushNewArray(buildMethodVisitor, Object.class, pLen);
        for (int i2 = 0; i2 < pLen; ++i2) {
            ParameterElement parameter = parameters[i2];
            if (parameter.hasDeclaredAnnotation(InjectScope.class)) {
                hasInjectScope = true;
            }
            int finalI = i2;
            BeanDefinitionWriter.pushStoreInArray(buildMethodVisitor, i2, pLen, () -> this.pushConstructorArgument(buildMethodVisitor, parameter.getName(), parameter, parameter.getAnnotationMetadata(), finalI, true));
        }
        return hasInjectScope;
    }

    private void pushConstructorArgument(GeneratorAdapter buildMethodVisitor, String argumentName, ParameterElement argumentType, AnnotationMetadata annotationMetadata, int index2, boolean castToObject) {
        if (this.isAnnotatedWithParameter(annotationMetadata) && this.isParametrized) {
            buildMethodVisitor.loadArg(3);
            buildMethodVisitor.push(argumentName);
            buildMethodVisitor.invokeInterface(io.micronaut.asm.Type.getType(Map.class), Method.getMethod(ReflectionUtils.getRequiredMethod(Map.class, "get", Object.class)));
            BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
        } else if (argumentType.getGenericType().isAssignable(BeanContext.class)) {
            buildMethodVisitor.loadArg(1);
        } else if (argumentType.getGenericType().isAssignable(BeanResolutionContext.class)) {
            buildMethodVisitor.loadArg(0);
        } else {
            java.lang.reflect.Method methodToInvoke;
            boolean isArray = false;
            boolean hasGenericType = false;
            ClassElement genericType = argumentType.getGenericType();
            if (this.isValueType(annotationMetadata) && !this.isInnerType(genericType)) {
                Optional<String> property = argumentType.stringValue(Property.class, "name");
                if (property.isPresent()) {
                    this.pushInvokeGetPropertyValueForConstructor(buildMethodVisitor, index2, argumentType, property.get());
                } else {
                    Optional<String> valueValue = argumentType.stringValue(Value.class);
                    if (valueValue.isPresent()) {
                        this.pushInvokeGetPropertyPlaceholderValueForConstructor(buildMethodVisitor, index2, argumentType, valueValue.get());
                    }
                }
                return;
            }
            isArray = genericType.isArray();
            if (genericType.isAssignable(Collection.class) || isArray) {
                ClassElement typeArgument;
                hasGenericType = true;
                ClassElement classElement = typeArgument = genericType.isArray() ? genericType.fromArray() : (ClassElement)genericType.getFirstTypeArgument().orElse(null);
                if (typeArgument != null && !typeArgument.isPrimitive()) {
                    methodToInvoke = typeArgument.isAssignable(BeanRegistration.class) ? GET_BEAN_REGISTRATIONS_FOR_CONSTRUCTOR_ARGUMENT : GET_BEANS_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT;
                } else {
                    methodToInvoke = GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
                    hasGenericType = false;
                }
            } else if (genericType.isAssignable(Stream.class)) {
                hasGenericType = true;
                methodToInvoke = GET_STREAM_OF_TYPE_FOR_CONSTRUCTOR_ARGUMENT;
            } else if (genericType.isAssignable(Optional.class)) {
                hasGenericType = true;
                methodToInvoke = FIND_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
            } else if (genericType.isAssignable(BeanRegistration.class)) {
                hasGenericType = true;
                methodToInvoke = GET_BEAN_REGISTRATION_FOR_CONSTRUCTOR_ARGUMENT;
            } else {
                methodToInvoke = GET_BEAN_FOR_CONSTRUCTOR_ARGUMENT;
            }
            buildMethodVisitor.loadThis();
            buildMethodVisitor.loadArg(0);
            buildMethodVisitor.loadArg(1);
            buildMethodVisitor.push(index2);
            if (hasGenericType) {
                this.resolveConstructorArgumentGenericType(buildMethodVisitor, argumentType.getGenericType(), index2);
            }
            this.pushQualifier(buildMethodVisitor, argumentType, () -> this.resolveConstructorArgument(buildMethodVisitor, index2));
            this.pushInvokeMethodOnSuperClass(buildMethodVisitor, methodToInvoke);
            if (isArray && hasGenericType) {
                this.convertToArray(argumentType.getGenericType().fromArray(), buildMethodVisitor);
            }
            if (castToObject) {
                if (argumentType.isPrimitive()) {
                    BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, Object.class);
                }
            } else {
                BeanDefinitionWriter.pushCastToType((MethodVisitor)buildMethodVisitor, argumentType);
            }
        }
    }

    private void pushInvokeGetPropertyValueForConstructor(GeneratorAdapter injectMethodVisitor, int i2, ParameterElement entry, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(i2);
        injectMethodVisitor.push(value);
        injectMethodVisitor.push(this.getCliPrefix(entry.getName()));
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_VALUE_FOR_CONSTRUCTOR_ARGUMENT);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void pushInvokeGetPropertyPlaceholderValueForConstructor(GeneratorAdapter injectMethodVisitor, int i2, ParameterElement entry, String value) {
        injectMethodVisitor.loadThis();
        injectMethodVisitor.loadArg(0);
        injectMethodVisitor.loadArg(1);
        injectMethodVisitor.push(i2);
        injectMethodVisitor.push(value);
        this.pushInvokeMethodOnSuperClass(injectMethodVisitor, GET_PROPERTY_PLACEHOLDER_VALUE_FOR_CONSTRUCTOR_ARGUMENT);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)injectMethodVisitor, entry);
    }

    private void resolveConstructorArgumentGenericType(GeneratorAdapter visitor, ClassElement type, int argumentIndex) {
        if (!this.resolveArgumentGenericType(visitor, type)) {
            this.resolveConstructorArgument(visitor, argumentIndex);
            this.resolveFirstTypeArgument(visitor);
            this.resolveInnerTypeArgumentIfNeeded(visitor, type);
        }
    }

    private void resolveConstructorArgument(GeneratorAdapter visitor, int argumentIndex) {
        io.micronaut.asm.Type constructorField = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodOrFieldReference.class);
        io.micronaut.asm.Type methodRefType = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference.class);
        visitor.getStatic(this.beanDefinitionType, FIELD_CONSTRUCTOR, constructorField);
        BeanDefinitionWriter.pushCastToType((MethodVisitor)visitor, methodRefType);
        visitor.getField(methodRefType, "arguments", io.micronaut.asm.Type.getType(Argument[].class));
        visitor.push(argumentIndex);
        visitor.arrayLoad(io.micronaut.asm.Type.getType(Argument.class));
    }

    private void resolveMethodArgumentGenericType(GeneratorAdapter visitor, ClassElement type, int methodIndex, int argumentIndex) {
        if (!this.resolveArgumentGenericType(visitor, type)) {
            this.resolveMethodArgument(visitor, methodIndex, argumentIndex);
            this.resolveFirstTypeArgument(visitor);
            this.resolveInnerTypeArgumentIfNeeded(visitor, type);
        }
    }

    private void resolveMethodArgument(GeneratorAdapter visitor, int methodIndex, int argumentIndex) {
        io.micronaut.asm.Type methodsRef = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference[].class);
        io.micronaut.asm.Type methodRefType = io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference.class);
        visitor.getStatic(this.beanDefinitionType, FIELD_INJECTION_METHODS, methodsRef);
        visitor.push(methodIndex);
        visitor.arrayLoad(methodsRef);
        visitor.getField(methodRefType, "arguments", io.micronaut.asm.Type.getType(Argument[].class));
        visitor.push(argumentIndex);
        visitor.arrayLoad(io.micronaut.asm.Type.getType(Argument.class));
    }

    private void resolveFieldArgumentGenericType(GeneratorAdapter visitor, ClassElement type, int fieldIndex) {
        if (!this.resolveArgumentGenericType(visitor, type)) {
            this.resolveFieldArgument(visitor, fieldIndex);
            this.resolveFirstTypeArgument(visitor);
            this.resolveInnerTypeArgumentIfNeeded(visitor, type);
        }
    }

    private void resolveAnnotationArgument(GeneratorAdapter visitor, int index2) {
        visitor.getStatic(this.beanDefinitionType, FIELD_ANNOTATION_INJECTIONS, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference[].class));
        visitor.push(index2);
        visitor.arrayLoad(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference.class));
        visitor.getField(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference.class), "argument", io.micronaut.asm.Type.getType(Argument.class));
    }

    private void resolveFieldArgument(GeneratorAdapter visitor, int fieldIndex) {
        visitor.getStatic(this.beanDefinitionType, FIELD_INJECTION_FIELDS, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference[].class));
        visitor.push(fieldIndex);
        visitor.arrayLoad(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference.class));
        visitor.getField(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference.class), "argument", io.micronaut.asm.Type.getType(Argument.class));
    }

    private boolean resolveArgumentGenericType(GeneratorAdapter visitor, ClassElement type) {
        if (type.isArray()) {
            if (!type.getTypeArguments().isEmpty() && this.isInternalGenericTypeContainer(type.fromArray())) {
                return false;
            }
            ClassElement componentType = type.fromArray();
            if (componentType.isPrimitive()) {
                visitor.getStatic(TYPE_ARGUMENT, componentType.getName().toUpperCase(Locale.ENGLISH), TYPE_ARGUMENT);
            } else {
                visitor.push(JavaModelUtils.getTypeReference(componentType));
                visitor.push((String)null);
                BeanDefinitionWriter.invokeInterfaceStaticMethod(visitor, Argument.class, METHOD_CREATE_ARGUMENT_SIMPLE);
            }
            return true;
        }
        if (type.getTypeArguments().isEmpty()) {
            visitor.visitInsn(1);
            return true;
        }
        return false;
    }

    private void resolveInnerTypeArgumentIfNeeded(GeneratorAdapter visitor, ClassElement type) {
        if (this.isInternalGenericTypeContainer(type.getFirstTypeArgument().get())) {
            this.resolveFirstTypeArgument(visitor);
        }
    }

    private boolean isInternalGenericTypeContainer(ClassElement type) {
        return type.isAssignable(BeanRegistration.class);
    }

    private void resolveFirstTypeArgument(GeneratorAdapter visitor) {
        visitor.invokeInterface(io.micronaut.asm.Type.getType(TypeVariableResolver.class), Method.getMethod(ReflectionUtils.findMethod(TypeVariableResolver.class, "getTypeParameters", new Class[0]).get()));
        visitor.push(0);
        visitor.arrayLoad(io.micronaut.asm.Type.getType(Argument.class));
    }

    private boolean isValueType(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Value.class) || annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Property.class);
        }
        return false;
    }

    private boolean isAnnotatedWithParameter(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            return annotationMetadata.hasDeclaredAnnotation(Parameter.class);
        }
        return false;
    }

    private boolean isParametrized(ParameterElement ... parameters) {
        return Arrays.stream(parameters).anyMatch(p -> this.isAnnotatedWithParameter(p.getAnnotationMetadata()));
    }

    private void defineBuilderMethod(boolean isParametrized) {
        String methodSignature;
        String methodDescriptor;
        if (isParametrized) {
            this.isParametrized = true;
        }
        ClassElement beanDefinitionParam = ClassElement.of(BeanDefinition.class, AnnotationMetadata.EMPTY_METADATA, Collections.singletonMap("T", this.beanTypeElement));
        if (isParametrized) {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName(), Map.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.beanTypeElement), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(beanDefinitionParam), BeanDefinitionWriter.getTypeDescriptor(Map.class.getName()));
        } else {
            methodDescriptor = BeanDefinitionWriter.getMethodDescriptor(Object.class.getName(), BeanResolutionContext.class.getName(), BeanContext.class.getName(), BeanDefinition.class.getName());
            methodSignature = BeanDefinitionWriter.getMethodSignature(BeanDefinitionWriter.getTypeDescriptor(this.beanTypeElement), BeanDefinitionWriter.getTypeDescriptor(BeanResolutionContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(BeanContext.class.getName()), BeanDefinitionWriter.getTypeDescriptor(beanDefinitionParam));
        }
        String methodName = isParametrized ? "doBuild" : "build";
        this.buildMethodVisitor = new GeneratorAdapter(this.classWriter.visitMethod(1, methodName, methodDescriptor, methodSignature, null), 1, methodName, methodDescriptor);
    }

    private void pushBeanDefinitionMethodInvocation(GeneratorAdapter buildMethodVisitor, String methodName) {
        buildMethodVisitor.loadThis();
        buildMethodVisitor.loadArg(0);
        buildMethodVisitor.loadArg(1);
        buildMethodVisitor.loadLocal(this.buildInstanceLocalVarIndex);
        BeanDefinitionWriter.pushBoxPrimitiveIfNecessary(this.beanType, (MethodVisitor)buildMethodVisitor);
        buildMethodVisitor.visitMethodInsn(182, this.superBeanDefinition ? this.superType.getInternalName() : this.beanDefinitionInternalName, methodName, METHOD_DESCRIPTOR_INITIALIZE, false);
    }

    private void visitBeanDefinitionConstructorInternal(GeneratorAdapter staticInit, Object constructor, boolean requiresReflection) {
        if (constructor instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)constructor;
            AnnotationMetadata constructorMetadata = methodElement.getAnnotationMetadata();
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, constructorMetadata);
            DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, methodElement.getGenericReturnType());
            ParameterElement[] parameters = methodElement.getParameters();
            List<ParameterElement> parameterList = Arrays.asList(parameters);
            this.applyDefaultNamedToParameters(parameterList);
            this.pushNewMethodReference(staticInit, JavaModelUtils.getTypeReference(methodElement.getDeclaringType()), methodElement, requiresReflection, false, false);
        } else if (constructor instanceof FieldElement) {
            FieldElement fieldConstructor = (FieldElement)constructor;
            this.pushNewFieldReference(staticInit, JavaModelUtils.getTypeReference(fieldConstructor.getDeclaringType()), fieldConstructor, this.constructorRequiresReflection);
        } else {
            throw new IllegalArgumentException("Unexpected constructor: " + constructor);
        }
        staticInit.putStatic(this.beanDefinitionType, FIELD_CONSTRUCTOR, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodOrFieldReference.class));
        GeneratorAdapter publicConstructor = new GeneratorAdapter(this.classWriter.visitMethod(1, "<init>", "()V", null, null), 1, "<init>", "()V");
        publicConstructor.loadThis();
        publicConstructor.push(this.beanType);
        publicConstructor.getStatic(this.beanDefinitionType, FIELD_CONSTRUCTOR, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodOrFieldReference.class));
        publicConstructor.invokeConstructor(this.superBeanDefinition ? this.superType : this.beanDefinitionType, PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR);
        publicConstructor.visitInsn(177);
        publicConstructor.visitMaxs(5, 1);
        publicConstructor.visitEnd();
        if (!this.superBeanDefinition) {
            GeneratorAdapter protectedConstructor = new GeneratorAdapter(this.classWriter.visitMethod(4, PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR.getName(), PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR.getDescriptor(), null, null), 4, PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR.getName(), PROTECTED_ABSTRACT_BEAN_DEFINITION_CONSTRUCTOR.getDescriptor());
            AnnotationMetadata annotationMetadata = this.annotationMetadata != null ? this.annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
            protectedConstructor.loadThis();
            protectedConstructor.loadArg(0);
            protectedConstructor.loadArg(1);
            if (this.annotationMetadata == null) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.getStatic(BeanDefinitionWriter.getTypeReferenceForName(this.getBeanDefinitionReferenceClassName(), new String[0]), "$ANNOTATION_METADATA", io.micronaut.asm.Type.getType(AnnotationMetadata.class));
            }
            if (this.allMethodVisits.isEmpty()) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.getStatic(this.beanDefinitionType, FIELD_INJECTION_METHODS, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference[].class));
            }
            if (this.fieldInjectionPoints.isEmpty()) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.getStatic(this.beanDefinitionType, FIELD_INJECTION_FIELDS, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference[].class));
            }
            if (this.annotationInjectionPoints.isEmpty()) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.getStatic(this.beanDefinitionType, FIELD_ANNOTATION_INJECTIONS, io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference[].class));
            }
            if (this.executableMethodsDefinitionWriter == null) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.newInstance(this.executableMethodsDefinitionWriter.getClassType());
                protectedConstructor.dup();
                protectedConstructor.invokeConstructor(this.executableMethodsDefinitionWriter.getClassType(), METHOD_DEFAULT_CONSTRUCTOR);
            }
            if (!this.hasTypeArguments()) {
                protectedConstructor.push((String)null);
            } else {
                protectedConstructor.getStatic(this.beanDefinitionType, FIELD_TYPE_ARGUMENTS, io.micronaut.asm.Type.getType(Map.class));
            }
            String scope = annotationMetadata.getAnnotationNameByStereotype("javax.inject.Scope").orElse(null);
            if (scope != null) {
                protectedConstructor.push(scope);
                protectedConstructor.invokeStatic(TYPE_OPTIONAL, METHOD_OPTIONAL_OF);
            } else {
                protectedConstructor.invokeStatic(TYPE_OPTIONAL, METHOD_OPTIONAL_EMPTY);
            }
            protectedConstructor.push(this.isAbstract);
            protectedConstructor.push(annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Provided.class));
            protectedConstructor.push(this.isIterable(annotationMetadata));
            protectedConstructor.push(this.isSingleton(scope));
            protectedConstructor.push(annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Primary.class));
            protectedConstructor.push(this.isConfigurationProperties);
            protectedConstructor.push(this.isContainerType());
            protectedConstructor.push(this.preprocessMethods);
            protectedConstructor.invokeConstructor(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION : this.superType, BEAN_DEFINITION_CLASS_CONSTRUCTOR);
            protectedConstructor.visitInsn(177);
            protectedConstructor.visitMaxs(20, 1);
            protectedConstructor.visitEnd();
        }
    }

    private boolean isContainerType() {
        return this.beanTypeElement.isArray() || DefaultArgument.CONTAINER_TYPES.stream().map(Class::getName).anyMatch(c -> c.equals(this.beanFullClassName));
    }

    private boolean isConfigurationProperties(AnnotationMetadata annotationMetadata) {
        return this.isIterable(annotationMetadata) || annotationMetadata.hasStereotype((Class<? extends Annotation>)ConfigurationReader.class);
    }

    private boolean isIterable(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)EachProperty.class) || annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)EachBean.class);
    }

    private void pushNewMethodReference(GeneratorAdapter staticInit, io.micronaut.asm.Type beanType, MethodElement methodElement, boolean requiresReflection, boolean isPostConstructMethod, boolean isPreDestroyMethod) {
        for (ParameterElement value : methodElement.getParameters()) {
            DefaultAnnotationMetadata.contributeDefaults(this.annotationMetadata, value.getAnnotationMetadata());
            DefaultAnnotationMetadata.contributeRepeatable(this.annotationMetadata, value.getGenericType());
        }
        staticInit.newInstance(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference.class));
        staticInit.dup();
        staticInit.push(beanType);
        staticInit.push(methodElement.getName());
        if (!methodElement.hasParameters()) {
            staticInit.visitInsn(1);
        } else {
            BeanDefinitionWriter.pushBuildArgumentsForMethod(this.beanFullClassName, this.beanDefinitionType, this.classWriter, staticInit, Arrays.asList(methodElement.getParameters()), this.defaultsStorage, this.loadTypeMethods);
        }
        this.pushAnnotationMetadata(staticInit, methodElement.getAnnotationMetadata());
        staticInit.push(requiresReflection);
        if (isPreDestroyMethod || isPostConstructMethod) {
            staticInit.push(isPostConstructMethod);
            staticInit.push(isPreDestroyMethod);
            staticInit.invokeConstructor(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference.class), METHOD_REFERENCE_CONSTRUCTOR_POST_PRE);
        } else {
            staticInit.invokeConstructor(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.MethodReference.class), METHOD_REFERENCE_CONSTRUCTOR);
        }
    }

    private void pushNewFieldReference(GeneratorAdapter staticInit, io.micronaut.asm.Type declaringType, FieldElement fieldElement, boolean requiresReflection) {
        staticInit.newInstance(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference.class));
        staticInit.dup();
        staticInit.push(declaringType);
        BeanDefinitionWriter.pushCreateArgument(this.beanFullClassName, this.beanDefinitionType, this.classWriter, staticInit, fieldElement.getName(), fieldElement.getGenericType(), fieldElement.getAnnotationMetadata(), fieldElement.getGenericType().getTypeArguments(), this.defaultsStorage, this.loadTypeMethods);
        staticInit.push(requiresReflection);
        staticInit.invokeConstructor(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.FieldReference.class), FIELD_REFERENCE_CONSTRUCTOR);
    }

    private void pushNewAnnotationReference(GeneratorAdapter staticInit, io.micronaut.asm.Type referencedType) {
        staticInit.newInstance(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference.class));
        staticInit.dup();
        staticInit.push(referencedType);
        BeanDefinitionWriter.invokeInterfaceStaticMethod(staticInit, Argument.class, Method.getMethod(ReflectionUtils.getRequiredInternalMethod(Argument.class, "of", Class.class)));
        staticInit.invokeConstructor(io.micronaut.asm.Type.getType(AbstractInitializableBeanDefinition.AnnotationReference.class), ANNOTATION_REFERENCE_CONSTRUCTOR);
    }

    private void pushAnnotationMetadata(GeneratorAdapter staticInit, AnnotationMetadata annotationMetadata) {
        if (annotationMetadata == AnnotationMetadata.EMPTY_METADATA || annotationMetadata.isEmpty()) {
            staticInit.push((String)null);
        } else if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataWriter.instantiateNewMetadataHierarchy(this.beanDefinitionType, this.classWriter, staticInit, (AnnotationMetadataHierarchy)annotationMetadata, this.defaultsStorage, this.loadTypeMethods);
        } else if (annotationMetadata instanceof DefaultAnnotationMetadata) {
            AnnotationMetadataWriter.instantiateNewMetadata(this.beanDefinitionType, this.classWriter, staticInit, (DefaultAnnotationMetadata)annotationMetadata, this.defaultsStorage, this.loadTypeMethods);
        } else {
            staticInit.push((String)null);
        }
    }

    private String generateBeanDefSig(io.micronaut.asm.Type typeParameter) {
        if (this.beanTypeElement.isPrimitive()) {
            typeParameter = this.beanTypeElement.isArray() ? JavaModelUtils.getTypeReference(this.beanTypeElement) : ClassUtils.getPrimitiveType(typeParameter.getClassName()).map(ReflectionUtils::getWrapperType).map(io.micronaut.asm.Type::getType).orElseThrow(() -> new IllegalStateException("Not a primitive type: " + this.beanFullClassName));
        }
        ArrayAwareSignatureWriter sv = new ArrayAwareSignatureWriter();
        this.visitSuperTypeParameters(sv, typeParameter);
        for (Class interfaceType : this.interfaceTypes) {
            io.micronaut.asm.Type param = ProxyBeanDefinition.class == interfaceType || AdvisedBeanType.class == interfaceType ? this.getInterceptedType().orElse(typeParameter) : typeParameter;
            SignatureVisitor bfi = ((SignatureVisitor)sv).visitInterface();
            bfi.visitClassType(io.micronaut.asm.Type.getInternalName(interfaceType));
            SignatureVisitor iisv = bfi.visitTypeArgument('=');
            this.visitTypeParameter(param, iisv);
            bfi.visitEnd();
        }
        return ((Object)sv).toString();
    }

    private void visitSuperTypeParameters(SignatureVisitor sv, io.micronaut.asm.Type ... typeParameters) {
        SignatureVisitor psv = sv.visitSuperclass();
        psv.visitClassType(this.isSuperFactory ? TYPE_ABSTRACT_BEAN_DEFINITION.getInternalName() : this.superType.getInternalName());
        if (this.superType == TYPE_ABSTRACT_BEAN_DEFINITION || this.isSuperFactory) {
            for (io.micronaut.asm.Type typeParameter : typeParameters) {
                SignatureVisitor ppsv = psv.visitTypeArgument('=');
                this.visitTypeParameter(typeParameter, ppsv);
            }
        }
        psv.visitEnd();
    }

    private void visitTypeParameter(io.micronaut.asm.Type typeParameter, SignatureVisitor ppsv) {
        boolean isArray = typeParameter.getSort() == 9;
        boolean isPrimitiveArray = false;
        if (isArray) {
            for (int i2 = 0; i2 < typeParameter.getDimensions(); ++i2) {
                ppsv.visitArrayType();
            }
            io.micronaut.asm.Type elementType = typeParameter.getElementType();
            while (elementType.getSort() == 9) {
                elementType = elementType.getElementType();
            }
            if (elementType.getSort() == 10) {
                ppsv.visitClassType(elementType.getInternalName());
            } else {
                ppsv.visitBaseType(elementType.getInternalName().charAt(0));
                isPrimitiveArray = true;
            }
        } else {
            ppsv.visitClassType(typeParameter.getInternalName());
        }
        if (isPrimitiveArray && ppsv instanceof ArrayAwareSignatureWriter) {
            ((ArrayAwareSignatureWriter)ppsv).visitEndArray();
        } else {
            ppsv.visitEnd();
        }
    }

    private static java.lang.reflect.Method getBeanLookupMethod(String methodName, boolean requiresGenericType) {
        if (requiresGenericType) {
            return ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, methodName, BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Argument.class, Qualifier.class);
        }
        return ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, methodName, BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Qualifier.class);
    }

    private static java.lang.reflect.Method getBeanLookupMethodForArgument(String methodName, boolean requiresGenericType) {
        if (requiresGenericType) {
            return ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, methodName, BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE, Argument.class, Qualifier.class);
        }
        return ReflectionUtils.getRequiredInternalMethod(AbstractInitializableBeanDefinition.class, methodName, BeanResolutionContext.class, BeanContext.class, Integer.TYPE, Integer.TYPE, Qualifier.class);
    }

    @Override
    public String getName() {
        return this.beanDefinitionName;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public Object getNativeType() {
        return this;
    }

    @Override
    public Collection<Element> getInjectionPoints() {
        if (this.fieldInjectionPoints.isEmpty() && this.methodInjectionPoints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MemberElement> injectionPoints = new ArrayList<MemberElement>();
        for (FieldVisitData fieldInjectionPoint : this.fieldInjectionPoints) {
            injectionPoints.add(fieldInjectionPoint.fieldElement);
        }
        for (MethodVisitData methodInjectionPoint : this.methodInjectionPoints) {
            injectionPoints.add(methodInjectionPoint.methodElement);
        }
        return Collections.unmodifiableCollection(injectionPoints);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public <T extends Annotation> Element annotate(String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        this.beanProducingElement.annotate(annotationType, consumer);
        return this;
    }

    @Override
    public Element removeAnnotation(String annotationType) {
        this.beanProducingElement.removeAnnotation(annotationType);
        return this;
    }

    @Override
    public <T extends Annotation> Element removeAnnotationIf(Predicate<AnnotationValue<T>> predicate) {
        this.beanProducingElement.removeAnnotationIf(predicate);
        return this;
    }

    @Override
    public Element removeStereotype(String annotationType) {
        this.beanProducingElement.removeStereotype(annotationType);
        return this;
    }

    @Override
    public ClassElement getDeclaringClass() {
        Element beanProducingElement = this.beanProducingElement;
        return this.getDeclaringType(beanProducingElement);
    }

    private ClassElement getDeclaringType(Element beanProducingElement) {
        if (beanProducingElement instanceof ClassElement) {
            return (ClassElement)beanProducingElement;
        }
        if (beanProducingElement instanceof MemberElement) {
            return ((MemberElement)beanProducingElement).getDeclaringType();
        }
        if (beanProducingElement instanceof BeanElementBuilder) {
            return ((BeanElementBuilder)beanProducingElement).getDeclaringElement();
        }
        return this.beanTypeElement;
    }

    @Override
    public Element getProducingElement() {
        return this.beanProducingElement;
    }

    @Override
    public Set<ClassElement> getBeanTypes() {
        Object[] types = this.annotationMetadata.stringValues(Bean.class, "typed");
        if (ArrayUtils.isNotEmpty(types)) {
            HashSet classElements = new HashSet();
            for (Object type : types) {
                this.visitorContext.getClassElement((String)type).ifPresent(classElements::add);
            }
            return Collections.unmodifiableSet(classElements);
        }
        Optional<ClassElement> superType = this.beanTypeElement.getSuperType();
        Collection<ClassElement> interfaces = this.beanTypeElement.getInterfaces();
        if (superType.isPresent() || !interfaces.isEmpty()) {
            HashSet<ClassElement> beanTypes = new HashSet<ClassElement>();
            beanTypes.add(this.beanTypeElement);
            this.populateBeanTypes(new HashSet<String>(), beanTypes, superType.orElse(null), interfaces);
            return Collections.unmodifiableSet(beanTypes);
        }
        return Collections.singleton(this.beanTypeElement);
    }

    private void populateBeanTypes(Set<String> processedTypes, Set<ClassElement> beanTypes, ClassElement superType, Collection<ClassElement> interfaces) {
        String n;
        for (ClassElement anInterface : interfaces) {
            String n2 = anInterface.getName();
            if (processedTypes.contains(n2)) continue;
            processedTypes.add(n2);
            beanTypes.add(anInterface);
            this.populateBeanTypes(processedTypes, beanTypes, null, anInterface.getInterfaces());
        }
        if (superType != null && !processedTypes.contains(n = superType.getName())) {
            processedTypes.add(n);
            beanTypes.add(superType);
            ClassElement next = superType.getSuperType().orElse(null);
            this.populateBeanTypes(processedTypes, beanTypes, next, superType.getInterfaces());
        }
    }

    @Override
    public Optional<String> getScope() {
        return this.annotationMetadata.getAnnotationNameByStereotype("javax.inject.Scope");
    }

    @Override
    public Collection<String> getQualifiers() {
        return Collections.unmodifiableList(this.annotationMetadata.getAnnotationNamesByStereotype("javax.inject.Qualifier"));
    }

    @Override
    public BeanElementBuilder addAssociatedBean(ClassElement type, VisitorContext visitorContext) {
        if (visitorContext instanceof BeanElementVisitorContext) {
            Element[] originatingElements = this.getOriginatingElements();
            return ((BeanElementVisitorContext)visitorContext).addAssociatedBean(originatingElements[0], type);
        }
        return BeanElement.super.addAssociatedBean(type, visitorContext);
    }

    @Override
    public Element[] getOriginatingElements() {
        return this.originatingElements.getOriginatingElements();
    }

    private class InnerClassDef {
        private final ClassWriter innerClassWriter;
        private final String constructorInternalName;
        private final io.micronaut.asm.Type innerClassType;
        private final String innerClassName;

        public InnerClassDef(String interceptedConstructorWriterName, ClassWriter innerClassWriter, String constructorInternalName, io.micronaut.asm.Type innerClassType) {
            this.innerClassName = interceptedConstructorWriterName;
            this.innerClassWriter = innerClassWriter;
            this.constructorInternalName = constructorInternalName;
            this.innerClassType = innerClassType;
        }
    }

    private class FactoryMethodDef {
        private final io.micronaut.asm.Type factoryType;
        private final Element factoryMethod;
        private final String methodDescriptor;
        private final int factoryVar;

        public FactoryMethodDef(io.micronaut.asm.Type factoryType, Element factoryMethod, String methodDescriptor, int factoryVar) {
            this.factoryType = factoryType;
            this.factoryMethod = factoryMethod;
            this.methodDescriptor = methodDescriptor;
            this.factoryVar = factoryVar;
        }
    }

    @Internal
    public static final class MethodVisitData {
        private final TypedElement beanType;
        private final boolean requiresReflection;
        private final MethodElement methodElement;
        private final boolean postConstruct;
        private final boolean preDestroy;

        MethodVisitData(TypedElement beanType, MethodElement methodElement, boolean requiresReflection) {
            this.beanType = beanType;
            this.requiresReflection = requiresReflection;
            this.methodElement = methodElement;
            this.postConstruct = false;
            this.preDestroy = false;
        }

        MethodVisitData(TypedElement beanType, MethodElement methodElement, boolean requiresReflection, boolean postConstruct, boolean preDestroy) {
            this.beanType = beanType;
            this.requiresReflection = requiresReflection;
            this.methodElement = methodElement;
            this.postConstruct = postConstruct;
            this.preDestroy = preDestroy;
        }

        public MethodElement getMethodElement() {
            return this.methodElement;
        }

        public TypedElement getBeanType() {
            return this.beanType;
        }

        public boolean isRequiresReflection() {
            return this.requiresReflection;
        }

        public boolean isPostConstruct() {
            return this.postConstruct;
        }

        public boolean isPreDestroy() {
            return this.preDestroy;
        }
    }

    @Internal
    private static final class FieldVisitData {
        final TypedElement beanType;
        final FieldElement fieldElement;
        final boolean requiresReflection;

        FieldVisitData(TypedElement beanType, FieldElement fieldElement, boolean requiresReflection) {
            this.beanType = beanType;
            this.fieldElement = fieldElement;
            this.requiresReflection = requiresReflection;
        }
    }

    @Internal
    private static final class AnnotationVisitData {
        final TypedElement memberBeanType;
        final String memberPropertyName;
        final MethodElement memberPropertyGetter;
        final String requiredValue;
        final String notEqualsValue;

        public AnnotationVisitData(TypedElement memberBeanType, String memberPropertyName, MethodElement memberPropertyGetter, @Nullable String requiredValue, @Nullable String notEqualsValue) {
            this.memberBeanType = memberBeanType;
            this.memberPropertyName = memberPropertyName;
            this.memberPropertyGetter = memberPropertyGetter;
            this.requiredValue = requiredValue;
            this.notEqualsValue = notEqualsValue;
        }
    }
}

