/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractMessageSource;
import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class StaticMessageSource
extends AbstractMessageSource {
    private final Map<AbstractMessageSource.MessageKey, String> messageMap = new ConcurrentHashMap<AbstractMessageSource.MessageKey, String>(40);

    @NonNull
    public StaticMessageSource addMessage(@NonNull String code, @NonNull String message) {
        if (StringUtils.isNotEmpty(code) && StringUtils.isNotEmpty(message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(Locale.getDefault(), code), message);
        }
        return this;
    }

    @NonNull
    public StaticMessageSource addMessage(@NonNull Locale locale, @NonNull String code, @NonNull String message) {
        ArgumentUtils.requireNonNull("locale", locale);
        if (StringUtils.isNotEmpty(code) && StringUtils.isNotEmpty(message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(locale, code), message);
        }
        return this;
    }

    @Override
    @NonNull
    public Optional<String> getRawMessage(@NonNull String code, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull("code", code);
        ArgumentUtils.requireNonNull("context", context);
        String msg = this.messageMap.get(new AbstractMessageSource.MessageKey(context.getLocale(), code));
        if (msg != null) {
            return Optional.of(msg);
        }
        return Optional.ofNullable(this.messageMap.get(new AbstractMessageSource.MessageKey(Locale.getDefault(), code)));
    }
}

