/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.util;

import io.micronaut.core.annotation.NonNull;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.grails.forge.options.JdkVersion;

public class VersionInfo {
    private static final Properties VERSIONS = new Properties();

    public static String getVersion() {
        String implementationVersion;
        Package aPackage = VersionInfo.class.getPackage();
        if (aPackage != null && (implementationVersion = aPackage.getImplementationVersion()) != null) {
            return implementationVersion;
        }
        return VersionInfo.getGrailsVersion();
    }

    public static boolean isSnapshot() {
        return VersionInfo.getVersion().endsWith("-SNAPSHOT");
    }

    public static boolean isGrailsSnapshot() {
        return VersionInfo.getGrailsVersion().endsWith("-SNAPSHOT");
    }

    public static String getGrailsVersion() {
        Object grailsVersion = VERSIONS.get("grails.version");
        if (grailsVersion != null) {
            return grailsVersion.toString();
        }
        return "6.0.0-M4";
    }

    public static String getDocumentationVersion() {
        return VersionInfo.isGrailsSnapshot() ? "snapshot" : VersionInfo.getGrailsVersion();
    }

    public static Map<String, String> getDependencyVersions() {
        LinkedHashMap map = new LinkedHashMap();
        VERSIONS.entrySet().stream().sorted(Comparator.comparing(o -> o.getKey().toString())).forEach(entry -> map.put(entry.getKey().toString(), entry.getValue().toString()));
        return Collections.unmodifiableMap(map);
    }

    @NonNull
    public static String getBomVersion(String id) {
        String key = id + ".version";
        Object version = VERSIONS.get(key);
        if (version != null) {
            return version.toString();
        }
        throw new IllegalArgumentException("Could not get version for ID " + id);
    }

    @NonNull
    public static Map.Entry<String, String> getDependencyVersion(String id) {
        final String key = id + ".version";
        final Object version = VERSIONS.get(key);
        if (version != null) {
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public String getValue() {
                    return version.toString();
                }

                @Override
                public String setValue(String value) {
                    throw new UnsupportedOperationException("Cannot set version");
                }
            };
        }
        throw new IllegalArgumentException("Could not get version for ID " + id);
    }

    public static JdkVersion getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return JdkVersion.valueOf(Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : version.length()))));
    }

    public static String toJdkVersion(int javaVersion) {
        String jdkVersion = String.valueOf(javaVersion);
        return javaVersion <= 8 ? "1." + jdkVersion : jdkVersion;
    }

    static {
        URL resource = VersionInfo.class.getResource("/grails-versions.properties");
        if (resource != null) {
            try (InputStreamReader reader = new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8);){
                VERSIONS.load(reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

