/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature;

import io.micronaut.core.annotation.NonNull;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.feature.AvailableFeatures;
import org.grails.forge.feature.Feature;

public class BaseAvailableFeatures
implements AvailableFeatures {
    private final Map<String, Feature> features;

    public BaseAvailableFeatures(List<Feature> features, ApplicationType applicationType) {
        this.features = features.stream().filter(f -> f.supports(applicationType)).collect(Collectors.toMap(Feature::getName, Function.identity(), (u, v) -> {
            throw new IllegalArgumentException("Duplicate feature found " + u.getName());
        }, LinkedHashMap::new));
    }

    @Override
    public Iterator<String> iterator() {
        return this.getFeatures().map(Feature::getName).iterator();
    }

    @Override
    public Optional<Feature> findFeature(@NonNull String name) {
        return this.findFeature(name, false);
    }

    @Override
    public Optional<Feature> findFeature(@NonNull String name, boolean ignoreVisibility) {
        Feature feature = this.features.get(name);
        if (feature != null && (ignoreVisibility || feature.isVisible())) {
            return Optional.of(feature);
        }
        return Optional.empty();
    }

    @Override
    public Stream<Feature> getFeatures() {
        return this.getAllFeatures().filter(Feature::isVisible);
    }

    @Override
    public Stream<Feature> getAllFeatures() {
        return this.features.values().stream();
    }
}

